/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.ui.plugin.tools;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.feature.AttributeType;
import com.vividsolutions.jump.feature.BasicFeature;
import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.feature.FeatureCollectionWrapper;
import com.vividsolutions.jump.feature.FeatureSchema;
import com.vividsolutions.jump.task.TaskMonitor;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.FeatureEventType;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.model.UndoableCommand;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.plugin.MultiEnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.AttributeTypeFilter;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import com.vividsolutions.jump.workbench.ui.MenuNames;
import com.vividsolutions.jump.workbench.ui.MultiInputDialog;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.CompoundBorder;
import org.openjump.core.ui.plugin.AbstractThreadedUiPlugIn;
import org.openjump.core.ui.plugin.tools.AutoAssignAttributePlugIn;

public class UpdateWithJoinPlugIn
extends AbstractThreadedUiPlugIn {
    private static final String DESCRIPTION = I18N.getInstance().get("org.openjump.core.ui.plugin.tools.UpdateWithJoinPlugIn.Description");
    private static final String REFERENCE_LAYER = I18N.getInstance().get("org.openjump.core.ui.plugin.tools.UpdateWithJoinPlugIn.Reference-layer-to-update");
    private static final String JOIN_LAYER = I18N.getInstance().get("org.openjump.core.ui.plugin.tools.UpdateWithJoinPlugIn.Join-layer");
    private static final String REFERENCE_LAYER_EXT_ID = I18N.getInstance().get("org.openjump.core.ui.plugin.tools.UpdateWithJoinPlugIn.Reference-layer-ext-id");
    private static final String JOIN_LAYER_ID = I18N.getInstance().get("org.openjump.core.ui.plugin.tools.UpdateWithJoinPlugIn.Join-layer-id");
    private static final String LEFT_JOIN = I18N.getInstance().get("org.openjump.core.ui.plugin.tools.UpdateWithJoinPlugIn.Left-join");
    private static final String LEFT_JOIN_TT = I18N.getInstance().get("org.openjump.core.ui.plugin.tools.UpdateWithJoinPlugIn.Left-join-tooltip");
    private static final String RIGHT_JOIN = I18N.getInstance().get("org.openjump.core.ui.plugin.tools.UpdateWithJoinPlugIn.Right-join");
    private static final String RIGHT_JOIN_TT = I18N.getInstance().get("org.openjump.core.ui.plugin.tools.UpdateWithJoinPlugIn.Right-join-tooltip");
    private static final String MAP_ATTRIBUTES = I18N.getInstance().get("org.openjump.core.ui.plugin.tools.UpdateWithJoinPlugIn.Map-attributes");
    private static final String DO_NOT_JOIN = I18N.getInstance().get("org.openjump.core.ui.plugin.tools.UpdateWithJoinPlugIn.Do-not-join");
    private static final String UNDEFINED_MAPPING = I18N.getInstance().get("org.openjump.core.ui.plugin.tools.UpdateWithJoinPlugIn.Attributes-mapping-is-not-defined");
    private static final String JOIN_NOT_UNIQUE = I18N.getInstance().get("org.openjump.core.ui.plugin.tools.UpdateWithJoinPlugIn.Join-layer-id-is-not-unique");
    private Layer referenceLayer = null;
    private Layer joinLayer = null;
    private String referenceLayerExtId = "";
    private String joinLayerId = "";
    private boolean left = true;
    private boolean right = false;
    private boolean add_attributes = false;
    private boolean attributesChoosen;
    private Map<String, String> attributesMapping = new HashMap<String, String>();

    @Override
    public void initialize(PlugInContext context) throws Exception {
        context.getFeatureInstaller().addMainMenuPlugin(this, new String[]{MenuNames.TOOLS, MenuNames.TOOLS_EDIT_ATTRIBUTES}, this.getName() + "...", false, null, UpdateWithJoinPlugIn.createEnableCheck(context.getWorkbenchContext()), -1);
    }

    public static MultiEnableCheck createEnableCheck(WorkbenchContext workbenchContext) {
        EnableCheckFactory checkFactory = EnableCheckFactory.getInstance(workbenchContext);
        return new MultiEnableCheck().add(checkFactory.createWindowWithAssociatedTaskFrameMustBeActiveCheck()).add(checkFactory.createAtLeastNLayersMustExistCheck(2));
    }

    @Override
    public boolean execute(PlugInContext context) throws Exception {
        this.attributesChoosen = false;
        MultiInputDialog dialog = this.initDialog(context);
        GUIUtil.centreOnWindow(dialog);
        dialog.setVisible(true);
        if (!dialog.wasOKPressed()) {
            return false;
        }
        if (!this.attributesChoosen) {
            throw new Exception(UNDEFINED_MAPPING);
        }
        this.getDialogValues(dialog);
        return true;
    }

    @Override
    public void run(TaskMonitor monitor, PlugInContext context) throws Exception {
        monitor.allowCancellationRequests();
        this.reportNothingToUndoYet(context);
        FeatureCollectionWrapper joinFC = this.joinLayer.getFeatureCollectionWrapper();
        int joinLayerAttributeIndex = joinFC.getFeatureSchema().getAttributeIndex(this.joinLayerId);
        HashMap<String, Feature> joinMap = new HashMap<String, Feature>();
        for (Feature f : joinFC.getFeatures()) {
            Object joinId = f.getAttribute(joinLayerAttributeIndex);
            if (joinId == null) continue;
            if (joinMap.get(joinId.toString()) != null) {
                throw new Exception(JOIN_NOT_UNIQUE);
            }
            joinMap.put(joinId.toString(), f);
        }
        if (!this.add_attributes) {
            this.updateLayer(monitor, context, joinMap);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateLayer(TaskMonitor monitor, PlugInContext context, Map<String, Feature> joinMap) {
        final HashMap<Integer, Feature> oldFeatures = new HashMap<Integer, Feature>();
        final HashMap<Integer, Feature> newFeatures = new HashMap<Integer, Feature>();
        final ArrayList<BasicFeature> added = new ArrayList<BasicFeature>();
        final ArrayList<Feature> removed = new ArrayList<Feature>();
        for (Feature f : this.referenceLayer.getFeatureCollectionWrapper().getFeatures()) {
            Object extKey = f.getAttribute(this.referenceLayerExtId);
            if (extKey == null) {
                if (this.left) continue;
                removed.add(f);
                continue;
            }
            Feature joinedFeature = joinMap.get(extKey.toString());
            if (joinedFeature == null) {
                if (this.left) continue;
                removed.add(f);
                continue;
            }
            Feature newFeature = f.clone(true);
            boolean modified = false;
            for (int i = 0; i < f.getSchema().getAttributeCount(); ++i) {
                String joinName;
                String name = f.getSchema().getAttributeName(i);
                if (name.equals(this.referenceLayerExtId) || (joinName = this.attributesMapping.get(name)).equals(DO_NOT_JOIN)) continue;
                int joinIndex = joinedFeature.getSchema().getAttributeIndex(joinName);
                if (Objects.equals(f.getAttribute(name), joinedFeature.getAttribute(joinIndex))) continue;
                AttributeType type = f.getSchema().getAttributeType(i);
                if (type == AttributeType.STRING) {
                    newFeature.setAttribute(i, (Object)joinedFeature.getString(joinIndex));
                } else if (type == AttributeType.DOUBLE) {
                    newFeature.setAttribute(i, (Object)joinedFeature.getDouble(joinIndex));
                } else if (type == AttributeType.INTEGER) {
                    newFeature.setAttribute(i, (Object)joinedFeature.getInteger(joinIndex));
                } else if (type == AttributeType.GEOMETRY) {
                    newFeature.setGeometry(joinedFeature.getGeometry());
                } else {
                    newFeature.setAttribute(i, joinedFeature.getAttribute(joinIndex));
                }
                modified = true;
            }
            if (!modified) continue;
            oldFeatures.put(f.getID(), f.clone(true));
            newFeatures.put(f.getID(), newFeature);
        }
        if (this.right) {
            for (Feature f : this.joinLayer.getFeatureCollectionWrapper().getFeatures()) {
                Object key = f.getAttribute(this.referenceLayerExtId);
                if (key != null && joinMap.containsKey(key.toString())) continue;
                BasicFeature bf = new BasicFeature(this.referenceLayer.getFeatureCollectionWrapper().getFeatureSchema());
                bf.setGeometry(f.getGeometry());
                for (int i = 0; i < bf.getSchema().getAttributeCount(); ++i) {
                    int joinIndex;
                    String name = bf.getSchema().getAttributeName(i);
                    String joinName = this.attributesMapping.get(name);
                    if (name.equals(this.referenceLayerExtId)) {
                        joinName = this.joinLayerId;
                    }
                    if (joinName.equals(DO_NOT_JOIN) || f.getAttribute(joinIndex = f.getSchema().getAttributeIndex(joinName)) == null) continue;
                    AttributeType type = bf.getSchema().getAttributeType(i);
                    if (type == AttributeType.STRING) {
                        bf.setAttribute(i, (Object)f.getString(joinIndex));
                        continue;
                    }
                    if (type == AttributeType.DOUBLE) {
                        bf.setAttribute(i, (Object)f.getDouble(joinIndex));
                        continue;
                    }
                    if (type == AttributeType.INTEGER) {
                        bf.setAttribute(i, (Object)f.getInteger(joinIndex));
                        continue;
                    }
                    if (type == AttributeType.GEOMETRY) {
                        bf.setGeometry(f.getGeometry());
                        continue;
                    }
                    bf.setAttribute(i, f.getAttribute(joinIndex));
                }
                added.add(bf);
            }
        }
        this.referenceLayer.getLayerManager().getUndoableEditReceiver().startReceiving();
        try {
            UndoableCommand command = new UndoableCommand(I18N.getInstance().get(AutoAssignAttributePlugIn.class.getName())){

                @Override
                public void execute() {
                    for (Feature f : UpdateWithJoinPlugIn.this.referenceLayer.getFeatureCollectionWrapper().getFeatures()) {
                        Feature newFeature = (Feature)newFeatures.get(f.getID());
                        if (newFeature == null) continue;
                        f.setAttributes(newFeature.getAttributes());
                    }
                    for (Feature f : removed) {
                        UpdateWithJoinPlugIn.this.referenceLayer.getFeatureCollectionWrapper().remove(f);
                    }
                    for (Feature f : added) {
                        UpdateWithJoinPlugIn.this.referenceLayer.getFeatureCollectionWrapper().add(f);
                    }
                    UpdateWithJoinPlugIn.this.referenceLayer.getLayerManager().fireFeaturesAttChanged(newFeatures.values(), FeatureEventType.ATTRIBUTES_MODIFIED, UpdateWithJoinPlugIn.this.referenceLayer, oldFeatures.values());
                    UpdateWithJoinPlugIn.this.referenceLayer.getLayerManager().fireFeaturesChanged(added, FeatureEventType.ADDED, UpdateWithJoinPlugIn.this.referenceLayer);
                    UpdateWithJoinPlugIn.this.referenceLayer.getLayerManager().fireFeaturesChanged(removed, FeatureEventType.DELETED, UpdateWithJoinPlugIn.this.referenceLayer);
                }

                @Override
                public void unexecute() {
                    for (Feature f : UpdateWithJoinPlugIn.this.referenceLayer.getFeatureCollectionWrapper().getFeatures()) {
                        Feature oldFeature = (Feature)oldFeatures.get(f.getID());
                        if (oldFeature == null) continue;
                        f.setAttributes(oldFeature.getAttributes());
                    }
                    for (Feature f : removed) {
                        UpdateWithJoinPlugIn.this.referenceLayer.getFeatureCollectionWrapper().add(f);
                    }
                    for (Feature f : added) {
                        UpdateWithJoinPlugIn.this.referenceLayer.getFeatureCollectionWrapper().remove(f);
                    }
                    UpdateWithJoinPlugIn.this.referenceLayer.getLayerManager().fireFeaturesAttChanged(oldFeatures.values(), FeatureEventType.ATTRIBUTES_MODIFIED, UpdateWithJoinPlugIn.this.referenceLayer, newFeatures.values());
                    UpdateWithJoinPlugIn.this.referenceLayer.getLayerManager().fireFeaturesChanged(removed, FeatureEventType.ADDED, UpdateWithJoinPlugIn.this.referenceLayer);
                    UpdateWithJoinPlugIn.this.referenceLayer.getLayerManager().fireFeaturesChanged(added, FeatureEventType.DELETED, UpdateWithJoinPlugIn.this.referenceLayer);
                }
            };
            command.execute();
            this.referenceLayer.getLayerManager().getUndoableEditReceiver().receive(command.toUndoableEdit());
        }
        finally {
            this.referenceLayer.getLayerManager().getUndoableEditReceiver().stopReceiving();
        }
    }

    private MultiInputDialog initDialog(final PlugInContext context) {
        final MultiInputDialog dialog = new MultiInputDialog(context.getWorkbenchFrame(), this.getName(), true);
        dialog.setSideBarDescription(DESCRIPTION);
        if (this.referenceLayer == null || !context.getLayerManager().getLayers().contains(this.referenceLayer)) {
            this.referenceLayer = context.getCandidateLayer(0);
        }
        final JComboBox<Layer> jcbBaseLayer = dialog.addLayerComboBox(REFERENCE_LAYER, this.referenceLayer, null, context.getLayerManager());
        List<String> baseLayerAttributeList = AttributeTypeFilter.NUMSTRING_FILTER.filter(this.referenceLayer);
        String valBaseAttribute = baseLayerAttributeList.size() > 0 ? baseLayerAttributeList.get(0) : null;
        final JComboBox<String> jcbBaseLayerId = dialog.addComboBox(REFERENCE_LAYER_EXT_ID, valBaseAttribute, baseLayerAttributeList, REFERENCE_LAYER_EXT_ID);
        jcbBaseLayerId.setEnabled(baseLayerAttributeList.size() > 0);
        dialog.addSeparator();
        if (this.joinLayer == null || !context.getLayerManager().getLayers().contains(this.joinLayer)) {
            this.joinLayer = context.getCandidateLayer(1);
        }
        final JComboBox<Layer> jcbJoinLayer = dialog.addLayerComboBox(JOIN_LAYER, this.joinLayer, null, context.getLayerManager());
        List<String> joinLayerAttributeList = AttributeTypeFilter.NUMSTRING_FILTER.filter(this.joinLayer);
        String valJoinAttribute = joinLayerAttributeList.size() > 0 ? joinLayerAttributeList.get(0) : null;
        final JComboBox<String> jcbJoinLayerId = dialog.addComboBox(JOIN_LAYER_ID, valJoinAttribute, joinLayerAttributeList, JOIN_LAYER_ID);
        jcbJoinLayerId.setEnabled(joinLayerAttributeList.size() > 0);
        dialog.addSeparator();
        dialog.addCheckBox(LEFT_JOIN, this.left, LEFT_JOIN_TT);
        dialog.addCheckBox(RIGHT_JOIN, this.right, RIGHT_JOIN_TT);
        jcbBaseLayer.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (jcbBaseLayer.getSelectedItem() == UpdateWithJoinPlugIn.this.referenceLayer) {
                    return;
                }
                UpdateWithJoinPlugIn.this.attributesChoosen = false;
                UpdateWithJoinPlugIn.this.referenceLayer = (Layer)jcbBaseLayer.getSelectedItem();
                List<String> baseLayerAttributeList = AttributeTypeFilter.NUMSTRING_FILTER.filter(UpdateWithJoinPlugIn.this.referenceLayer);
                jcbBaseLayerId.setModel(new DefaultComboBoxModel<String>(baseLayerAttributeList.toArray(new String[0])));
                jcbBaseLayerId.setEnabled(baseLayerAttributeList.size() > 0);
            }
        });
        jcbBaseLayerId.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!jcbBaseLayerId.getSelectedItem().equals(UpdateWithJoinPlugIn.this.referenceLayerExtId)) {
                    UpdateWithJoinPlugIn.this.attributesChoosen = false;
                }
            }
        });
        jcbJoinLayer.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (jcbJoinLayer.getSelectedItem() == UpdateWithJoinPlugIn.this.joinLayer) {
                    return;
                }
                UpdateWithJoinPlugIn.this.attributesChoosen = false;
                UpdateWithJoinPlugIn.this.joinLayer = (Layer)jcbJoinLayer.getSelectedItem();
                List<String> joinLayerAttributeList = AttributeTypeFilter.NUMSTRING_FILTER.filter(UpdateWithJoinPlugIn.this.joinLayer);
                jcbJoinLayerId.setModel(new DefaultComboBoxModel<String>(joinLayerAttributeList.toArray(new String[0])));
                jcbJoinLayerId.setEnabled(joinLayerAttributeList.size() > 0);
            }
        });
        jcbJoinLayerId.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!jcbJoinLayerId.getSelectedItem().equals(UpdateWithJoinPlugIn.this.joinLayerId)) {
                    UpdateWithJoinPlugIn.this.attributesChoosen = false;
                }
            }
        });
        JButton mapAttributesButton = dialog.addButton(MAP_ATTRIBUTES);
        mapAttributesButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MultiInputDialog mid = UpdateWithJoinPlugIn.this.initMappingDialog(context.getWorkbenchFrame(), dialog.getLayer(REFERENCE_LAYER), dialog.getLayer(JOIN_LAYER), dialog.getText(REFERENCE_LAYER_EXT_ID));
                GUIUtil.centreOnWindow(mid);
                mid.setVisible(true);
                if (mid.wasOKPressed()) {
                    UpdateWithJoinPlugIn.this.getMapping(mid);
                    UpdateWithJoinPlugIn.this.attributesChoosen = true;
                }
            }
        });
        return dialog;
    }

    private void getDialogValues(MultiInputDialog dialog) {
        this.referenceLayer = dialog.getLayer(REFERENCE_LAYER);
        this.joinLayer = dialog.getLayer(JOIN_LAYER);
        this.referenceLayerExtId = dialog.getText(REFERENCE_LAYER_EXT_ID);
        this.joinLayerId = dialog.getText(JOIN_LAYER_ID);
        this.left = dialog.getBoolean(LEFT_JOIN);
        this.right = dialog.getBoolean(RIGHT_JOIN);
    }

    private MultiInputDialog initMappingDialog(JFrame parent, Layer baseLayer, Layer joinLayer, String baseId) {
        MultiInputDialog dialog = new MultiInputDialog(parent, "", true){

            @Override
            protected void setMainComponent() {
                this.currentPanel = new JPanel(new GridBagLayout());
                this.mainComponent = new JScrollPane(this.currentPanel);
                CompoundBorder mainComponentBorder = BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(), BorderFactory.createEmptyBorder(5, 5, 5, 5));
                this.currentPanel.setBorder(mainComponentBorder);
            }
        };
        dialog.setPreferredSize(new Dimension(480, 320));
        for (String name : baseLayer.getFeatureCollectionWrapper().getFeatureSchema().getAttributeNames()) {
            if (name.equals(baseId)) continue;
            AttributeType type = baseLayer.getFeatureCollectionWrapper().getFeatureSchema().getAttributeType(name);
            AttributeTypeFilter filter = AttributeTypeFilter.ALL_FILTER;
            if (type != AttributeType.STRING) {
                if (type == AttributeType.GEOMETRY) {
                    filter = AttributeTypeFilter.GEOMETRY_FILTER;
                }
                if (type == AttributeType.DOUBLE) {
                    filter = AttributeTypeFilter.DOUBLE_FILTER;
                }
                if (type == AttributeType.INTEGER) {
                    filter = AttributeTypeFilter.NUMERIC_FILTER;
                }
                if (type == AttributeType.LONG) {
                    filter = AttributeTypeFilter.NUMERIC_FILTER;
                }
                if (type == AttributeType.DOUBLE) {
                    filter = AttributeTypeFilter.NUMERIC_FILTER;
                }
                if (type == AttributeType.DATE) {
                    filter = AttributeTypeFilter.DATE_FILTER;
                }
                if (type == AttributeType.BOOLEAN) {
                    filter = AttributeTypeFilter.BOOLEAN_FILTER;
                }
            }
            List<String> candidates = filter.filter(joinLayer);
            candidates.add(0, DO_NOT_JOIN);
            candidates.remove(this.joinLayerId);
            dialog.addComboBox(name, candidates.contains(name) && type != AttributeType.GEOMETRY ? name : DO_NOT_JOIN, candidates, "");
        }
        return dialog;
    }

    private void getMapping(MultiInputDialog dialog) {
        FeatureSchema schema = this.referenceLayer.getFeatureCollectionWrapper().getFeatureSchema();
        for (int i = 0; i < schema.getAttributeCount(); ++i) {
            if (dialog.getText(schema.getAttributeName(i)).equals("")) continue;
            this.attributesMapping.put(schema.getAttributeName(i), dialog.getText(schema.getAttributeName(i)));
        }
    }
}

