/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.ui.plugin.tools;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.feature.AttributeType;
import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.feature.FeatureSchema;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.FeatureEventType;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.model.UndoableCommand;
import com.vividsolutions.jump.workbench.plugin.EnableCheck;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.plugin.MultiEnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.AttributeTypeFilter;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import com.vividsolutions.jump.workbench.ui.MenuNames;
import com.vividsolutions.jump.workbench.ui.MultiInputDialog;
import com.vividsolutions.jump.workbench.ui.OKCancelDialog;
import com.vividsolutions.jump.workbench.ui.plugin.FeatureInstaller;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Random;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import org.openjump.core.ui.plugin.AbstractUiPlugIn;
import org.openjump.core.ui.plugin.tools.AutoAssignAttributePlugIn;

public class GenerateRandomNumberPlugIn
extends AbstractUiPlugIn {
    private static String LAYER = I18N.getInstance().get("ui.GenericNames.select-layer");
    private static String ATTRIBUTE = I18N.getInstance().get("ui.GenericNames.select-attribute");
    private static String RANDOM = I18N.getInstance().get("org.openjump.core.ui.plugin.tools.GenerateRandom");
    private static String MIN = I18N.getInstance().get("org.openjump.core.ui.plugin.tools.GenerateRandomNumberPlugIn.min-value");
    private static String MAX = I18N.getInstance().get("org.openjump.core.ui.plugin.tools.GenerateRandomNumberPlugIn.max-value");
    private static String NO_CANDIDATE = I18N.getInstance().get("org.openjump.core.ui.plugin.tools.GenerateRandomNumberPlugIn.no-editable-layer-with-numeric-attribute");
    private static String NON_EMPTY_ATT = I18N.getInstance().get("org.openjump.core.ui.plugin.tools.GenerateRandomStringPlugIn.non-empty-attribute");
    private static String OVERWRITE_PROMPT = I18N.getInstance().get("org.openjump.core.ui.plugin.tools.GenerateRandomStringPlugIn.overwrite-prompt");
    private Layer layer;
    private String attribute;
    private double min;
    private double max;

    @Override
    public void initialize(PlugInContext context) throws Exception {
        FeatureInstaller featureInstaller = context.getFeatureInstaller();
        featureInstaller.addMainMenuPlugin(this, new String[]{MenuNames.TOOLS, MenuNames.TOOLS_EDIT_ATTRIBUTES, RANDOM}, this.getName() + "...", false, null, GenerateRandomNumberPlugIn.createEnableCheck(context.getWorkbenchContext()));
    }

    public static MultiEnableCheck createEnableCheck(final WorkbenchContext workbenchContext) {
        EnableCheckFactory checkFactory = EnableCheckFactory.getInstance(workbenchContext);
        return new MultiEnableCheck().add(checkFactory.createAtLeastNLayersMustExistCheck(1)).add(checkFactory.createAtLeastNLayersMustBeEditableCheck(1)).add(new EnableCheck(){

            @Override
            public String check(JComponent component) {
                if (AttributeTypeFilter.NUMERIC_FILTER.filter(workbenchContext.getLayerManager().getEditableLayers()).size() == 0) {
                    return NO_CANDIDATE;
                }
                return null;
            }
        });
    }

    @Override
    public boolean execute(PlugInContext context) throws Exception {
        this.reportNothingToUndoYet(context);
        MultiInputDialog dialog = new MultiInputDialog(context.getWorkbenchFrame(), this.getName(), true);
        this.setDialogValues(dialog, context);
        GUIUtil.centreOnWindow(dialog);
        dialog.setVisible(true);
        if (!dialog.wasOKPressed()) {
            return false;
        }
        this.getDialogValues(dialog);
        boolean empty = this.checkAttributeEmpty();
        if (!empty) {
            JLabel label = new JLabel();
            label.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            label.setText("<html><body>" + NON_EMPTY_ATT + "<br/>" + OVERWRITE_PROMPT + "</body></html>");
            OKCancelDialog okCancelDialog = new OKCancelDialog(dialog, NON_EMPTY_ATT, true, (Component)label, new OKCancelDialog.Validator(){

                @Override
                public String validateInput(Component component) {
                    return null;
                }
            });
            okCancelDialog.setVisible(true);
            if (!okCancelDialog.wasOKPressed()) {
                return false;
            }
        }
        this.computeRandomValues(context);
        return true;
    }

    private boolean checkAttributeEmpty() {
        for (Feature f : this.layer.getFeatureCollectionWrapper().getFeatures()) {
            if (f.getAttribute(this.attribute) == null) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void computeRandomValues(PlugInContext context) {
        Random rdm = new Random();
        FeatureSchema schema = this.layer.getFeatureCollectionWrapper().getFeatureSchema();
        AttributeType type = schema.getAttributeType(this.attribute);
        final ArrayList<Feature> oldFeatures = new ArrayList<Feature>();
        final ArrayList<Feature> newFeatures = new ArrayList<Feature>();
        this.reportNothingToUndoYet(context);
        for (Feature f : this.layer.getFeatureCollectionWrapper().getFeatures()) {
            oldFeatures.add(f.clone(true, true));
            f = f.clone(true, true);
            if (type == AttributeType.DOUBLE) {
                f.setAttribute(this.attribute, (Object)(this.min + rdm.nextDouble() * (this.max - this.min)));
            } else if (type == AttributeType.INTEGER) {
                f.setAttribute(this.attribute, (Object)((int)this.min + rdm.nextInt((int)(this.max - this.min))));
            } else if (type == AttributeType.LONG) {
                f.setAttribute(this.attribute, (Object)((long)this.min + (long)rdm.nextInt((int)(this.max - this.min))));
            }
            newFeatures.add(f);
        }
        context.getLayerManager().getUndoableEditReceiver().startReceiving();
        try {
            UndoableCommand command = new UndoableCommand(I18N.getInstance().get(AutoAssignAttributePlugIn.class.getName())){

                @Override
                public void execute() {
                    Iterator newFeatIterator = newFeatures.iterator();
                    for (Feature f : GenerateRandomNumberPlugIn.this.layer.getFeatureCollectionWrapper().getFeatures()) {
                        f.setAttribute(GenerateRandomNumberPlugIn.this.attribute, ((Feature)newFeatIterator.next()).getAttribute(GenerateRandomNumberPlugIn.this.attribute));
                    }
                    GenerateRandomNumberPlugIn.this.layer.getLayerManager().fireFeaturesAttChanged(newFeatures, FeatureEventType.ATTRIBUTES_MODIFIED, GenerateRandomNumberPlugIn.this.layer, oldFeatures);
                }

                @Override
                public void unexecute() {
                    Iterator oldFeatIterator = oldFeatures.iterator();
                    for (Feature f : GenerateRandomNumberPlugIn.this.layer.getFeatureCollectionWrapper().getFeatures()) {
                        f.setAttribute(GenerateRandomNumberPlugIn.this.attribute, ((Feature)oldFeatIterator.next()).getAttribute(GenerateRandomNumberPlugIn.this.attribute));
                    }
                    GenerateRandomNumberPlugIn.this.layer.getLayerManager().fireFeaturesAttChanged(GenerateRandomNumberPlugIn.this.layer.getFeatureCollectionWrapper().getFeatures(), FeatureEventType.ATTRIBUTES_MODIFIED, GenerateRandomNumberPlugIn.this.layer, newFeatures);
                }
            };
            command.execute();
            this.layer.getLayerManager().getUndoableEditReceiver().receive(command.toUndoableEdit());
        }
        finally {
            this.layer.getLayerManager().getUndoableEditReceiver().stopReceiving();
        }
    }

    private void setDialogValues(MultiInputDialog dialog, PlugInContext context) {
        this.layer = context.getLayerableNamePanel().chooseEditableLayer();
        dialog.addLayerComboBox(LAYER, this.layer, null, AttributeTypeFilter.NUMERIC_FILTER.filter(context.getLayerManager().getEditableLayers()));
        dialog.addAttributeComboBox(ATTRIBUTE, LAYER, AttributeTypeFilter.NUMERIC_FILTER, null);
        dialog.addDoubleField(MIN, 0.0, 12, null);
        dialog.addDoubleField(MAX, 0.0, 12, null);
    }

    private void getDialogValues(MultiInputDialog dialog) {
        this.layer = dialog.getLayer(LAYER);
        this.attribute = dialog.getText(ATTRIBUTE);
        this.min = dialog.getDouble(MIN);
        this.max = dialog.getDouble(MAX);
        if (this.max == this.min) {
            this.max += 1.0;
        }
    }
}

