/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.ui.plugin.tools;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.feature.AttributeType;
import com.vividsolutions.jump.feature.BasicFeature;
import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.feature.FeatureDataset;
import com.vividsolutions.jump.feature.FeatureSchema;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.Category;
import com.vividsolutions.jump.workbench.model.LayerManager;
import com.vividsolutions.jump.workbench.model.StandardCategoryNames;
import com.vividsolutions.jump.workbench.plugin.AbstractPlugIn;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.plugin.MultiEnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.MenuNames;
import com.vividsolutions.jump.workbench.ui.MultiInputDialog;
import com.vividsolutions.jump.workbench.ui.images.IconLoader;
import java.util.Collection;
import org.locationtech.jts.geom.CoordinateFilter;
import org.locationtech.jts.geom.CoordinateList;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.util.UniqueCoordinateArrayFilter;
import org.openjump.core.geomutils.GeoUtils;

public class ConvexHullPlugIn
extends AbstractPlugIn {
    private String TOLERANCE = I18N.getInstance().get("org.openjump.core.ui.plugin.tools.ConvexHullPlugIn.Tolerance");
    private MultiInputDialog dialog;
    private final double blendTolerance = 0.1;
    private final boolean exceptionThrown = false;
    private String sConvexHull = I18N.getInstance().get("org.openjump.core.ui.plugin.tools.ConvexHullPlugIn.Convex-Hull");

    @Override
    public void initialize(PlugInContext context) throws Exception {
        super.initialize(context);
        context.getFeatureInstaller().addMainMenuPlugin(this, new String[]{MenuNames.TOOLS, MenuNames.TOOLS_ANALYSIS}, this.getName(), false, IconLoader.icon("convex_hull2.png"), this.createEnableCheck(context.getWorkbenchContext()));
    }

    @Override
    public String getName() {
        return this.sConvexHull;
    }

    @Override
    public boolean execute(PlugInContext context) throws Exception {
        this.TOLERANCE = I18N.getInstance().get("org.openjump.core.ui.plugin.tools.ConvexHullPlugIn.Tolerance");
        this.sConvexHull = I18N.getInstance().get("org.openjump.core.ui.plugin.tools.ConvexHullPlugIn.Convex-Hull");
        this.reportNothingToUndoYet(context);
        Collection<Feature> selectedFeatures = context.getLayerViewPanel().getSelectionManager().getFeaturesWithSelectedItems();
        Collection<Category> selectedCategories = context.getLayerNamePanel().getSelectedCategories();
        LayerManager layerManager = context.getLayerManager();
        FeatureSchema featureSchema = new FeatureSchema();
        featureSchema.addAttribute("GEOMETRY", AttributeType.GEOMETRY);
        CoordinateList coords = new CoordinateList();
        for (Feature f : selectedFeatures) {
            Geometry geo = f.getGeometry();
            UniqueCoordinateArrayFilter filter = new UniqueCoordinateArrayFilter();
            geo.apply((CoordinateFilter)filter);
            coords.add(filter.getCoordinates(), false);
        }
        CoordinateList convexHullCoords = GeoUtils.ConvexHullWrap(coords);
        Polygon convexHull = new GeometryFactory().createPolygon(convexHullCoords.toCoordinateArray());
        BasicFeature newFeature = new BasicFeature(featureSchema);
        newFeature.setGeometry((Geometry)convexHull);
        FeatureDataset newFeatures = new FeatureDataset(featureSchema);
        newFeatures.add(newFeature);
        layerManager.addLayer(selectedCategories.isEmpty() ? StandardCategoryNames.RESULT : ((Object)selectedCategories.iterator().next()).toString(), layerManager.uniqueLayerName(this.sConvexHull), newFeatures);
        layerManager.getLayer(0).setFeatureCollectionModified(true);
        layerManager.getLayer(0).setEditable(true);
        return true;
    }

    public MultiEnableCheck createEnableCheck(WorkbenchContext workbenchContext) {
        EnableCheckFactory checkFactory = EnableCheckFactory.getInstance(workbenchContext);
        return new MultiEnableCheck().add(checkFactory.createWindowWithLayerViewPanelMustBeActiveCheck()).add(checkFactory.createAtLeastNFeaturesMustHaveSelectedItemsCheck(1));
    }
}

