/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.ui.plugin.raster;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.plugin.AbstractPlugIn;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.plugin.MultiEnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.MenuNames;
import com.vividsolutions.jump.workbench.ui.cursortool.OrCompositeTool;
import com.vividsolutions.jump.workbench.ui.cursortool.QuasimodeTool;
import com.vividsolutions.jump.workbench.ui.images.IconLoader;
import javax.swing.Icon;
import org.openjump.core.rasterimage.RasterImageLayer;
import org.openjump.core.ui.plugin.raster.RasterQueryCursorTool;
import org.openjump.core.ui.plugin.raster.RasterQueryDragTool;

public class RasterQueryPlugIn
extends AbstractPlugIn {
    private static final String sErrorSeeOutputWindow = I18N.getInstance().get("org.openjump.core.ui.plugin.tools.MeasureM_FPlugIn.Error-see-output-window");

    @Override
    public void initialize(PlugInContext context) throws Exception {
        super.initialize(context);
        context.getFeatureInstaller().addMainMenuPlugin(this, new String[]{MenuNames.RASTER}, this.getName(), false, this.getIcon(), this.createEnableCheck(context.getWorkbenchContext()));
    }

    @Override
    public String getName() {
        return I18N.getInstance().get("org.openjump.core.ui.plugin.raster.RasterQueryPlugIn");
    }

    @Override
    public boolean execute(PlugInContext context) throws Exception {
        try {
            context.getLayerViewPanel().setCurrentCursorTool(QuasimodeTool.createWithDefaults(new OrCompositeTool(){

                @Override
                public String getName() {
                    return "Test dragging to retrive a set of values";
                }
            }.add(new RasterQueryCursorTool(context.getWorkbenchContext())).add(new RasterQueryDragTool(context.getWorkbenchContext()))));
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            context.getWorkbenchFrame().warnUser(sErrorSeeOutputWindow);
            context.getWorkbenchFrame().getOutputFrame().createNewDocument();
            context.getWorkbenchFrame().getOutputFrame().addText("MeasureM_FPlugIn Exception:" + e.toString());
            return false;
        }
    }

    @Override
    public Icon getIcon() {
        return IconLoader.icon("grid_info.png");
    }

    public MultiEnableCheck createEnableCheck(WorkbenchContext workbenchContext) {
        EnableCheckFactory checkFactory = EnableCheckFactory.getInstance(workbenchContext);
        return new MultiEnableCheck().add(checkFactory.createTaskWindowMustBeActiveCheck()).add(checkFactory.createAtLeastNLayerablesMustBeSelectedCheck(1, RasterImageLayer.class));
    }
}

