/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.ui.plugin.raster;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.task.TaskMonitor;
import com.vividsolutions.jump.util.FileUtil;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.Category;
import com.vividsolutions.jump.workbench.plugin.EnableCheck;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.plugin.MultiEnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.plugin.ThreadedBasePlugIn;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import com.vividsolutions.jump.workbench.ui.MultiInputDialog;
import com.vividsolutions.jump.workbench.ui.images.IconLoader;
import it.betastudio.adbtoolbox.libs.FileOperations;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import org.openjump.core.apitools.LayerTools;
import org.openjump.core.rasterimage.RasterImageLayer;
import org.openjump.core.rasterimage.algorithms.KernelAlgorithm;
import org.openjump.core.ui.io.file.FileNameExtensionFilter;
import org.saig.core.gui.swing.sldeditor.util.FormUtils;

public class KernelAnalysisPlugIn
extends ThreadedBasePlugIn {
    public static String dimension = I18N.getInstance().get("org.openjump.core.ui.plugin.raster.RasterImageLayerPropertiesPlugIn.dimension");
    private final String CLAYER = I18N.getInstance().get("ui.GenericNames.Source-Layer");
    private final String OUTPUT_FILE = I18N.getInstance().get("driver.DriverManager.file-to-save");
    private final String CHECK = I18N.getInstance().get("ui.GenericNames.check-field");
    private final String KernelAnalysis = I18N.getInstance().get("ui.plugin.raster.KernelAnalysisPlugIn.Name");
    private final String defaultKernels = I18N.getInstance().get("ui.plugin.raster.KernelAnalysisPlugIn.default-kernels");
    private final String PROCESSING = I18N.getInstance().get("jump.plugin.edit.NoderPlugIn.processing");
    private final String NO_OVERWRITE = I18N.getInstance().get("ui.GenericNames.cannot-overwrite-input-layer");
    private JComboBox<RasterImageLayer> layerableComboBox = new JComboBox();
    private RasterImageLayer rLayer;
    private final ImageIcon icon16 = IconLoader.icon("fugue/folder-horizontal-open_16.png");
    List<RasterImageLayer> fLayers = new ArrayList<RasterImageLayer>();
    private JComboBox<String> kernelComboBox = new JComboBox();
    JTextField jTextField_RasterOut = new JTextField();
    private MultiInputDialog dialog;
    private JScrollPane jScrollPane1;
    private JTable jTable;
    private DefaultTableModel dtm = null;
    FileNameExtensionFilter filter;
    private String path;
    private String nameKernel;
    public float[] array1d;
    public float[][] array2d;
    final KernelAlgorithm fil = new KernelAlgorithm();
    String hmKey = new String();
    LinkedHashMap<String, float[]> Map = new LinkedHashMap();
    LinkedHashMap<String, String> Map2 = new LinkedHashMap();
    private final EnableCheck[] saveCheck = new EnableCheck[]{new EnableCheck(){

        @Override
        public String check(JComponent component) {
            KernelAnalysisPlugIn.this.rLayer = (RasterImageLayer)KernelAnalysisPlugIn.this.dialog.getLayerable(KernelAnalysisPlugIn.this.CLAYER);
            return KernelAnalysisPlugIn.this.jTextField_RasterOut.getText().equals(KernelAnalysisPlugIn.this.rLayer.getImageFileName()) ? KernelAnalysisPlugIn.this.NO_OVERWRITE : null;
        }
    }, new EnableCheck(){

        @Override
        public String check(JComponent component) {
            return KernelAnalysisPlugIn.this.jTextField_RasterOut.getText().isEmpty() ? KernelAnalysisPlugIn.this.CHECK.concat(KernelAnalysisPlugIn.this.OUTPUT_FILE) : null;
        }
    }};
    private final EnableCheck[] fillCheck = new EnableCheck[]{new EnableCheck(){

        @Override
        public String check(JComponent component) {
            int nTabRows = KernelAnalysisPlugIn.this.jTable.getRowCount();
            int nTabCols = KernelAnalysisPlugIn.this.jTable.getColumnCount();
            for (int r = 0; r < nTabRows; ++r) {
                int c = 0;
                if (c >= nTabCols) continue;
                return KernelAnalysisPlugIn.this.jTable.getValueAt(r, c).equals("") || KernelAnalysisPlugIn.this.jTable.getValueAt(r, c).equals(null) || !KernelAnalysisPlugIn.isNumeric(KernelAnalysisPlugIn.this.jTable.getValueAt(r, c).toString()) ? KernelAnalysisPlugIn.this.CHECK.concat("Table") : null;
            }
            return KernelAnalysisPlugIn.this.CHECK;
        }
    }};

    @Override
    public String getName() {
        return this.KernelAnalysis;
    }

    private void setDialogValues(final MultiInputDialog dialog, PlugInContext context) throws IOException {
        dialog.setSideBarDescription(this.KernelAnalysis);
        this.rLayer = !context.getLayerNamePanel().selectedNodes(RasterImageLayer.class).isEmpty() ? (RasterImageLayer)LayerTools.getSelectedLayerable(context, RasterImageLayer.class) : context.getTask().getLayerManager().getLayerables(RasterImageLayer.class).get(0);
        this.fLayers = context.getTask().getLayerManager().getLayerables(RasterImageLayer.class);
        this.layerableComboBox = dialog.addLayerableComboBox(this.CLAYER, this.rLayer, "", this.fLayers);
        this.layerableComboBox.setSize(200, this.layerableComboBox.getPreferredSize().height);
        ArrayList<String> srsArray = new ArrayList<String>();
        this.Map = this.fil.createDataMap();
        this.Map2 = this.fil.createTextMap();
        Iterator<Map.Entry<String, float[]>> itr = this.Map.entrySet().iterator();
        while (itr.hasNext()) {
            srsArray.add(itr.next().getKey());
        }
        this.kernelComboBox = dialog.addComboBox(this.defaultKernels, (String)srsArray.get(0), srsArray, null);
        this.kernelComboBox.setSize(200, this.kernelComboBox.getPreferredSize().height);
        this.kernelComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                KernelAnalysisPlugIn.this.fixTable(dialog);
                KernelAnalysisPlugIn.this.jTable.setVisible(true);
            }
        });
        this.jTable = new JTable();
        this.jScrollPane1 = new JScrollPane();
        this.jTable.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}));
        GUIUtil.chooseGoodColumnWidths(this.jTable);
        this.jScrollPane1.setViewportView(this.jTable);
        dialog.addRow("Table", this.jScrollPane1, this.fillCheck, null);
        this.filter = new FileNameExtensionFilter("TIFF", "tif");
        dialog.addRow("Save", this.createOutputFilePanel(this.filter), this.saveCheck, null);
        this.fixComponents(dialog);
    }

    private void fixComponents(MultiInputDialog dialog) {
        String test = this.fil.S_gradientEast;
        this.array1d = this.Map.get(test);
        String description = this.Map2.get(test);
        Double dim = Math.sqrt(this.array1d.length);
        int val = dim.intValue();
        this.array2d = new float[val][val];
        for (int i = 0; i < val; ++i) {
            System.arraycopy(this.array1d, i * val, this.array2d[i], 0, val);
        }
        int columns = this.array2d[0].length;
        this.dtm = new DefaultTableModel(0, columns){
            private static final long serialVersionUID = 1L;

            public Class getColumnClass(int column) {
                return Float.class;
            }
        };
        for (float[] rowData : this.array2d) {
            Vector<Float> row = new Vector<Float>(columns);
            for (float element : rowData) {
                row.addElement(new Float(element));
            }
            this.dtm.addRow(row);
        }
        this.path = this.getOutputFilePath();
        int it = this.path.lastIndexOf(46);
        if (it > 0) {
            this.path = this.path.substring(0, this.path.length() - this.path.length() + it);
        }
        dialog.setSideBarDescription(description);
        this.jTable.setModel(this.dtm);
    }

    private void fixTable(MultiInputDialog dialog) {
        String test = dialog.getText(this.defaultKernels);
        this.array1d = this.Map.get(test);
        String description = this.Map2.get(test);
        Double dim = Math.sqrt(this.array1d.length);
        int val = dim.intValue();
        this.array2d = new float[val][val];
        for (int i = 0; i < val; ++i) {
            System.arraycopy(this.array1d, i * val, this.array2d[i], 0, val);
        }
        int columns = this.array2d[0].length;
        this.dtm = new DefaultTableModel(0, columns){
            private static final long serialVersionUID = 1L;

            public Class getColumnClass(int column) {
                return Float.class;
            }
        };
        for (float[] rowData : this.array2d) {
            Vector<Float> row = new Vector<Float>(columns);
            for (float element : rowData) {
                row.addElement(new Float(element));
            }
            this.dtm.addRow(row);
        }
        this.path = this.getOutputFilePath();
        int it = this.path.lastIndexOf(46);
        if (it > 0) {
            this.path = this.path.substring(0, this.path.length() - this.path.length() + it);
        }
        dialog.setSideBarDescription(description);
        this.jTable.setModel(this.dtm);
    }

    public float[][] getTableData(JTable table) {
        TableModel dtm = table.getModel();
        int nRow = dtm.getRowCount();
        int nCol = dtm.getColumnCount();
        float[][] tableData = new float[nRow][nCol];
        for (int i = 0; i < nRow; ++i) {
            for (int j = 0; j < nCol; ++j) {
                tableData[i][j] = ((Float)dtm.getValueAt(i, j)).floatValue();
            }
        }
        return tableData;
    }

    private void getDialogValues(MultiInputDialog dialog) {
        this.rLayer = (RasterImageLayer)dialog.getLayerable(this.CLAYER);
        this.nameKernel = dialog.getText(this.defaultKernels);
        float[][] fl2d = this.getTableData(this.jTable);
        int rows = fl2d.length;
        int cols = fl2d[0].length;
        float[] mono = new float[rows * cols];
        for (int i = 0; i < rows; ++i) {
            System.arraycopy(fl2d[i], 0, mono, i * cols, cols);
        }
        this.array1d = mono;
        this.path = this.getOutputFilePath();
        int it = this.path.lastIndexOf(46);
        if (it > 0) {
            this.path = this.path.substring(0, this.path.length() - this.path.length() + it);
        }
    }

    @Override
    public boolean execute(PlugInContext context) throws Exception {
        this.reportNothingToUndoYet(context);
        this.dialog = new MultiInputDialog(context.getWorkbenchFrame(), this.KernelAnalysis, true);
        this.setDialogValues(this.dialog, context);
        if (this.fLayers.isEmpty()) {
            return false;
        }
        GUIUtil.centreOnWindow(this.dialog);
        this.dialog.setVisible(true);
        if (!this.dialog.wasOKPressed()) {
            return false;
        }
        if (this.dialog.wasOKPressed()) {
            this.getDialogValues(this.dialog);
            return true;
        }
        return false;
    }

    @Override
    public void run(TaskMonitor monitor, PlugInContext context) throws Exception {
        monitor.report(this.PROCESSING);
        this.reportNothingToUndoYet(context);
        File outFile = FileUtil.addExtensionIfNone(new File(this.path), "tif");
        this.fil.filterRaster(outFile, this.rLayer, this.array1d);
        String catName = this.KernelAnalysis;
        try {
            catName = ((Category)context.getLayerNamePanel().getSelectedCategories().toArray()[0]).getName();
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        this.fil.load(outFile, this.nameKernel, catName);
    }

    public static boolean isNumeric(String str) {
        return str.matches("-?\\d+(\\.\\d+)?");
    }

    public JPanel createOutputFilePanel(final FileNameExtensionFilter filter) {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel = new JPanel();
        JLabel jLabel3 = new JLabel();
        this.jTextField_RasterOut = new JTextField();
        JButton jButton_Dir = new JButton();
        this.jTextField_RasterOut.setText("");
        jButton_Dir.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                File outputPathFile = null;
                GUIUtil.FileChooserWithOverwritePrompting chooser = new GUIUtil.FileChooserWithOverwritePrompting();
                chooser.setDialogTitle(KernelAnalysisPlugIn.this.getName());
                chooser.setFileSelectionMode(0);
                ((JFileChooser)chooser).setSelectedFile(FileOperations.lastVisitedFolder);
                chooser.setDialogType(1);
                GUIUtil.removeChoosableFileFilters(chooser);
                chooser.setFileFilter(filter);
                int ret = chooser.showOpenDialog(null);
                if (ret == 0) {
                    outputPathFile = FileUtil.removeExtensionIfAny(((JFileChooser)chooser).getSelectedFile());
                    KernelAnalysisPlugIn.this.jTextField_RasterOut.setText(outputPathFile.getPath().concat(".tif"));
                    FileOperations.lastVisitedFolder = outputPathFile;
                }
            }
        });
        jLabel3.setText(this.OUTPUT_FILE);
        this.jTextField_RasterOut.setEditable(true);
        jButton_Dir.setIcon(this.icon16);
        this.jTextField_RasterOut.setPreferredSize(new Dimension(250, 20));
        FormUtils.addRowInGBL((JComponent)jPanel, 3, 0, this.OUTPUT_FILE, (JComponent)this.jTextField_RasterOut);
        FormUtils.addRowInGBL(jPanel, 3, 2, jButton_Dir);
        return jPanel;
    }

    public String getOutputFilePath() {
        return this.jTextField_RasterOut.getText();
    }

    public static MultiEnableCheck createEnableCheck(WorkbenchContext workbenchContext) {
        EnableCheckFactory checkFactory = EnableCheckFactory.getInstance(workbenchContext);
        return new MultiEnableCheck().add(checkFactory.createWindowWithAssociatedTaskFrameMustBeActiveCheck()).add(checkFactory.createAtLeastNLayerablesOfTypeMustExistCheck(1, RasterImageLayer.class));
    }
}

