/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.ui.plugin.raster;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.feature.FeatureUtil;
import com.vividsolutions.jump.task.TaskMonitor;
import com.vividsolutions.jump.util.FileUtil;
import com.vividsolutions.jump.workbench.JUMPWorkbench;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.Category;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.model.Layerable;
import com.vividsolutions.jump.workbench.model.StandardCategoryNames;
import com.vividsolutions.jump.workbench.model.WMSLayer;
import com.vividsolutions.jump.workbench.plugin.EnableCheck;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.plugin.MultiEnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.plugin.ThreadedBasePlugIn;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import com.vividsolutions.jump.workbench.ui.MultiInputDialog;
import com.vividsolutions.jump.workbench.ui.SelectionManager;
import com.vividsolutions.jump.workbench.ui.SelectionManagerProxy;
import com.vividsolutions.jump.workbench.ui.Viewport;
import com.vividsolutions.jump.workbench.ui.WorkbenchFrame;
import com.vividsolutions.jump.workbench.ui.images.IconLoader;
import it.betastudio.adbtoolbox.libs.FileOperations;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.openjump.core.apitools.LayerTools;
import org.openjump.core.rasterimage.RasterImageLayer;
import org.openjump.core.rasterimage.algorithms.GenericRasterAlgorithm;
import org.openjump.core.ui.io.file.FileNameExtensionFilter;
import org.openjump.core.ui.plugin.raster.RasterMenuNames;
import org.saig.core.gui.swing.sldeditor.util.FormUtils;

public class CropWarpPlugIn
extends ThreadedBasePlugIn {
    private final String SELECTED = I18N.getInstance().get("jump.plugin.edit.PolygonizerPlugIn.Use-selected-features-only");
    private final String VIEW = I18N.getInstance().get("ui.MenuNames.VIEW");
    private final String LAYER = I18N.getInstance().get("ui.MenuNames.LAYER");
    private final String PROCESSING = I18N.getInstance().get("jump.plugin.edit.NoderPlugIn.processing");
    private final String CLAYER = I18N.getInstance().get("ui.GenericNames.Source-Layer");
    private final String OUTPUT_FILE = I18N.getInstance().get("driver.DriverManager.file-to-save");
    private final ImageIcon icon16 = IconLoader.icon("fugue/folder-horizontal-open_16.png");
    private JLabel cutLayerLabel;
    private JLabel cutObjectLabel;
    JTextField jTextField_RasterOut = new JTextField();
    JTextField jTextField_RasterIn = new JTextField();
    private JPanel cropPanel;
    private JComboBox<String> comboBox = new JComboBox();
    private JComboBox<String> cropComboBox = new JComboBox();
    private JComboBox<Object> layerComboBox = new JComboBox();
    private String ACTION;
    private String CROP;
    private String path;
    Envelope envWanted = new Envelope();
    Envelope fix = new Envelope();
    private MultiInputDialog dialog;
    public static WorkbenchFrame frame = JUMPWorkbench.getInstance().getFrame();
    private RasterImageLayer rLayer;
    private final String NAME = I18N.getInstance().get("ui.plugin.raster.CropWarpPlugIn.Name");
    private final String Target_OBJECT = I18N.getInstance().get("ui.plugin.raster.CropWarpPlugIn.target-object");
    private final String CROP_RASTER = I18N.getInstance().get("ui.plugin.raster.CropWarpPlugIn.crop-raster");
    private final String CROP_RASTER_TIP = I18N.getInstance().get("ui.plugin.raster.CropWarpPlugIn.crop-raster-tip");
    private final String WARP_RASTER = I18N.getInstance().get("ui.plugin.raster.CropWarpPlugIn.warp-raster");
    private final String WARP_RASTER_TIP = I18N.getInstance().get("ui.plugin.raster.CropWarpPlugIn.warp-raster-tip");
    private final String TARGET_LAYER = I18N.getInstance().get("ui.plugin.raster.CropWarpPlugIn.target-layer");
    private final String CHECK = RasterMenuNames.Check_field;
    private final String NO_OVERWRITE = I18N.getInstance().get("ui.GenericNames.cannot-overwrite-input-layer");
    private final String ACTION_LABEL = RasterMenuNames.Choose_an_action;
    private final EnableCheck[] saveCheck = new EnableCheck[]{new EnableCheck(){

        @Override
        public String check(JComponent component) {
            CropWarpPlugIn.this.rLayer = (RasterImageLayer)CropWarpPlugIn.this.dialog.getLayerable(CropWarpPlugIn.this.CLAYER);
            return CropWarpPlugIn.this.jTextField_RasterOut.getText().equals(CropWarpPlugIn.this.rLayer.getImageFileName()) ? CropWarpPlugIn.this.NO_OVERWRITE : null;
        }
    }, new EnableCheck(){

        @Override
        public String check(JComponent component) {
            return CropWarpPlugIn.this.jTextField_RasterOut.getText().isEmpty() ? CropWarpPlugIn.this.CHECK.concat(CropWarpPlugIn.this.OUTPUT_FILE) : null;
        }
    }};

    private void updateGUI1(ActionEvent evt, MultiInputDialog dialog) {
        switch (this.cropComboBox.getSelectedIndex()) {
            case 0: {
                this.cutLayerLabel.setEnabled(true);
                this.layerComboBox.setEnabled(true);
                break;
            }
            case 1: {
                this.cutLayerLabel.setEnabled(false);
                this.layerComboBox.setEnabled(false);
                break;
            }
            case 2: {
                this.cutLayerLabel.setEnabled(false);
                this.layerComboBox.setEnabled(false);
            }
        }
    }

    private JPanel jBasePanel() {
        this.cropPanel = new JPanel(new GridBagLayout());
        ArrayList<String> array = new ArrayList<String>();
        array.add(this.LAYER);
        array.add(this.SELECTED);
        array.add(this.VIEW);
        this.cropComboBox = new JComboBox(new Vector(array));
        this.cropComboBox.setSelectedItem(array.get(0));
        this.cropComboBox.setSize(200, this.cropComboBox.getPreferredSize().height);
        this.cropComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CropWarpPlugIn.this.updateGUI1(e, CropWarpPlugIn.this.dialog);
                CropWarpPlugIn.this.dialog.pack();
                CropWarpPlugIn.this.dialog.repaint();
            }
        });
        this.cutObjectLabel = new JLabel(this.Target_OBJECT);
        FormUtils.addRowInGBL((JComponent)this.cropPanel, 1, 0, this.cutObjectLabel, this.cropComboBox);
        List<Layerable> layerables = JUMPWorkbench.getInstance().getContext().getLayerManager().getLayerables(Layerable.class);
        this.layerComboBox = new JComboBox<Layerable>(new Vector<Layerable>(layerables));
        this.layerComboBox.setSelectedItem(layerables.get(0));
        this.layerComboBox.setSize(200, this.layerComboBox.getPreferredSize().height);
        this.cutLayerLabel = new JLabel(this.TARGET_LAYER);
        FormUtils.addRowInGBL((JComponent)this.cropPanel, 2, 0, this.cutLayerLabel, this.layerComboBox);
        return this.cropPanel;
    }

    private void setDialogValues(PlugInContext context) throws IOException {
        this.dialog.setSideBarDescription(this.CROP_RASTER_TIP);
        this.rLayer = !context.getLayerNamePanel().selectedNodes(RasterImageLayer.class).isEmpty() ? (RasterImageLayer)LayerTools.getSelectedLayerable(context, RasterImageLayer.class) : context.getTask().getLayerManager().getLayerables(RasterImageLayer.class).get(0);
        List<RasterImageLayer> fLayers = context.getTask().getLayerManager().getLayerables(RasterImageLayer.class);
        JComboBox<RasterImageLayer> layerableComboBox = this.dialog.addLayerableComboBox(this.CLAYER, this.rLayer, "", fLayers);
        layerableComboBox.setSize(200, layerableComboBox.getPreferredSize().height);
        layerableComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CropWarpPlugIn.this.dialog.pack();
                CropWarpPlugIn.this.dialog.repaint();
            }
        });
        ArrayList<String> srsArray = new ArrayList<String>();
        srsArray.add(this.CROP_RASTER);
        srsArray.add(this.WARP_RASTER);
        this.comboBox = this.dialog.addComboBox(this.ACTION_LABEL, (String)srsArray.get(0), srsArray, null);
        this.comboBox.setSize(200, this.comboBox.getPreferredSize().height);
        this.comboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CropWarpPlugIn.this.updateGUI(e, CropWarpPlugIn.this.dialog);
                CropWarpPlugIn.this.dialog.pack();
                CropWarpPlugIn.this.dialog.repaint();
            }
        });
        this.dialog.addRow("base", this.jBasePanel(), null, null);
        FileNameExtensionFilter filter = new FileNameExtensionFilter("TIF", "tif");
        this.dialog.addRow("Save", new JLabel(this.OUTPUT_FILE + ":"), this.createOutputFilePanel(filter), this.saveCheck, null);
    }

    private void getDialogValues(MultiInputDialog dialog) {
        this.rLayer = (RasterImageLayer)dialog.getLayerable(this.CLAYER);
        this.ACTION = dialog.getText(this.ACTION_LABEL);
        this.CROP = this.cropComboBox.getSelectedItem().toString();
        this.getCroppedEnvelope();
        this.path = this.getOutputFilePath();
        int i = this.path.lastIndexOf(46);
        if (i > 0) {
            this.path = this.path.substring(0, i);
        }
    }

    @Override
    public boolean execute(PlugInContext context) throws Exception {
        this.reportNothingToUndoYet(context);
        this.dialog = new MultiInputDialog(context.getWorkbenchFrame(), this.NAME, true);
        this.setDialogValues(context);
        GUIUtil.centreOnWindow(this.dialog);
        this.dialog.setVisible(true);
        this.dialog.setDefaultCloseOperation(2);
        if (!this.dialog.wasOKPressed()) {
            return false;
        }
        if (this.dialog.wasOKPressed()) {
            this.getDialogValues(this.dialog);
            return true;
        }
        return false;
    }

    @Override
    public void run(TaskMonitor monitor, PlugInContext context) throws Exception {
        monitor.report(this.PROCESSING);
        this.reportNothingToUndoYet(context);
        File outFile = FileUtil.addExtensionIfNone(new File(this.path), "tif");
        GenericRasterAlgorithm IO = new GenericRasterAlgorithm();
        if (this.ACTION.equals(this.CROP_RASTER)) {
            IO.save_CropToEnvelope(outFile, this.rLayer, this.fix);
        } else if (this.ACTION.equals(this.WARP_RASTER)) {
            IO.save_WarpToEnvelope(outFile, this.rLayer, this.envWanted);
        }
        String catName = StandardCategoryNames.WORKING;
        try {
            catName = ((Category)context.getLayerNamePanel().getSelectedCategories().toArray()[0]).getName();
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        IO.load(outFile, catName);
    }

    private void getCroppedEnvelope() {
        this.envWanted = new Envelope();
        this.fix = new Envelope();
        RasterImageLayer rLayer = (RasterImageLayer)this.dialog.getLayerable(this.CLAYER);
        if (this.CROP.equals(this.LAYER)) {
            Layerable slayer = (Layerable)this.layerComboBox.getSelectedItem();
            if (slayer instanceof WMSLayer) {
                this.envWanted.expandToInclude(((WMSLayer)slayer).getEnvelope());
            } else if (slayer instanceof Layer) {
                this.envWanted.expandToInclude(((Layer)slayer).getFeatureCollectionWrapper().getEnvelope());
            } else if (slayer instanceof RasterImageLayer) {
                this.envWanted.expandToInclude(((RasterImageLayer)slayer).getWholeImageEnvelope());
            }
            this.fix = this.envWanted.intersection(rLayer.getWholeImageEnvelope());
        } else if (this.CROP.equals(this.SELECTED)) {
            SelectionManager smgr = ((SelectionManagerProxy)((Object)frame.getActiveInternalFrame())).getSelectionManager();
            Collection<Feature> features = smgr.getFeaturesWithSelectedItems();
            Feature feature = features.iterator().next().clone();
            GeometryFactory factory = new GeometryFactory();
            feature.setGeometry((Geometry)factory.createGeometryCollection(FeatureUtil.toGeometries(features).toArray(new Geometry[features.size()])));
            this.envWanted = feature.getGeometry().getEnvelopeInternal();
            this.fix = this.envWanted.intersection(rLayer.getWholeImageEnvelope());
        } else if (this.CROP.equals(this.VIEW)) {
            Viewport viewport = frame.getContext().getLayerViewPanel().getViewport();
            this.envWanted = viewport.getEnvelopeInModelCoordinates();
            this.fix = this.envWanted.intersection(rLayer.getWholeImageEnvelope());
        }
    }

    private void updateGUI(ActionEvent evt, MultiInputDialog dialog) {
        switch (this.comboBox.getSelectedIndex()) {
            case 0: {
                dialog.setSideBarDescription(this.CROP_RASTER_TIP);
                this.cutObjectLabel.setText(this.Target_OBJECT);
                break;
            }
            case 1: {
                dialog.setSideBarDescription(this.WARP_RASTER_TIP);
                this.cutObjectLabel.setText(this.Target_OBJECT);
            }
        }
    }

    public JPanel createOutputFilePanel(final FileNameExtensionFilter filter) {
        JPanel jPanel = new JPanel();
        this.jTextField_RasterOut = new JTextField();
        JButton jButton_Dir = new JButton();
        this.jTextField_RasterOut.setText("");
        jButton_Dir.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GUIUtil.FileChooserWithOverwritePrompting chooser = new GUIUtil.FileChooserWithOverwritePrompting();
                chooser.setDialogTitle(CropWarpPlugIn.this.getName());
                chooser.setFileSelectionMode(0);
                ((JFileChooser)chooser).setSelectedFile(FileOperations.lastVisitedFolder);
                chooser.setDialogType(1);
                GUIUtil.removeChoosableFileFilters(chooser);
                chooser.setFileFilter(filter);
                int ret = chooser.showOpenDialog(null);
                if (ret == 0) {
                    File outputPathFile = FileUtil.removeExtensionIfAny(((JFileChooser)chooser).getSelectedFile());
                    CropWarpPlugIn.this.jTextField_RasterOut.setText(outputPathFile.getPath().concat(".tif"));
                    FileOperations.lastVisitedFolder = outputPathFile;
                }
            }
        });
        this.jTextField_RasterOut.setEditable(true);
        jButton_Dir.setIcon(this.icon16);
        this.jTextField_RasterOut.setPreferredSize(new Dimension(250, 20));
        FormUtils.addRowInGBL(jPanel, 3, 0, this.jTextField_RasterOut);
        FormUtils.addRowInGBL(jPanel, 3, 1, jButton_Dir);
        return jPanel;
    }

    public String getOutputFilePath() {
        return this.jTextField_RasterOut.getText();
    }

    @Override
    public String getName() {
        return this.NAME;
    }

    public static MultiEnableCheck createEnableCheck(WorkbenchContext workbenchContext) {
        EnableCheckFactory checkFactory = EnableCheckFactory.getInstance(workbenchContext);
        return new MultiEnableCheck().add(checkFactory.createWindowWithAssociatedTaskFrameMustBeActiveCheck()).add(checkFactory.createAtLeastNLayerablesOfTypeMustExistCheck(1, RasterImageLayer.class));
    }
}

