/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.ui.plugin.layer.pirolraster;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.feature.AttributeType;
import com.vividsolutions.jump.feature.BasicFeature;
import com.vividsolutions.jump.feature.FeatureDataset;
import com.vividsolutions.jump.feature.FeatureSchema;
import com.vividsolutions.jump.workbench.plugin.AbstractPlugIn;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import org.locationtech.jts.geom.Geometry;
import org.openjump.core.apitools.LayerTools;
import org.openjump.core.apitools.objecttyperoles.RoleOutline;
import org.openjump.core.rasterimage.RasterImageLayer;

public class ExportEnvelopeAsGeometryPlugIn
extends AbstractPlugIn {
    protected static FeatureSchema defaultSchema = null;

    public ExportEnvelopeAsGeometryPlugIn() {
        if (defaultSchema == null) {
            defaultSchema = new FeatureSchema();
            defaultSchema.addAttribute("geometry", AttributeType.GEOMETRY);
        }
    }

    public String getIconString() {
        return null;
    }

    @Override
    public String getName() {
        return I18N.getInstance().get("org.openjump.core.ui.plugin.layer.pirolraster.ExportEnvelopeAsGeometryPlugIn.Export-Envelope-As-Geometry");
    }

    @Override
    public void initialize(PlugInContext context) throws Exception {
        super.initialize(context);
    }

    @Override
    public boolean execute(PlugInContext context) throws Exception {
        RasterImageLayer rLayer = (RasterImageLayer)LayerTools.getSelectedLayerable(context, RasterImageLayer.class);
        if (rLayer == null) {
            context.getWorkbenchFrame().warnUser(I18N.getInstance().get("pirol.plugIns.EditAttributeByFormulaPlugIn.no-layer-selected"));
            return false;
        }
        Geometry geom = rLayer.getWholeImageEnvelopeAsGeometry();
        if (geom == null) {
            return false;
        }
        FeatureDataset newFeaturecollection = new FeatureDataset(defaultSchema.clone());
        BasicFeature feature = new BasicFeature(defaultSchema.clone());
        feature.setAttribute("geometry", (Object)geom);
        newFeaturecollection.add(feature);
        LayerTools.addStandardResultLayer(I18N.getInstance().get("org.openjump.core.ui.plugin.layer.pirolraster.ExportEnvelopeAsGeometryPlugIn.Geometry") + "-" + rLayer.getName(), newFeaturecollection, context, new RoleOutline());
        return false;
    }
}

