/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.ui.plugin.layer;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.model.Category;
import com.vividsolutions.jump.workbench.model.Layerable;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import javax.swing.ImageIcon;
import org.openjump.core.ui.plugin.layer.SortCategoryAbstractPlugIn;

public class SortCategoryByNamePlugIn
extends SortCategoryAbstractPlugIn
implements ActionListener {
    private static final ImageIcon ICON = null;
    private String submenuLabel = "By Name";
    private String descending = "Descending";
    private String ascending = "Ascending";

    @Override
    protected void addMenuOptions(PlugInContext context) {
        this.submenuLabel = I18N.getInstance().get("org.openjump.core.ui.plugin.layer.SortCategoryByNamePlugIn.By-Name");
        this.descending = I18N.getInstance().get("org.openjump.core.ui.plugin.layer.SortCategoryByNamePlugIn.Descending");
        this.ascending = I18N.getInstance().get("org.openjump.core.ui.plugin.layer.SortCategoryByNamePlugIn.Ascending");
        context.getFeatureInstaller().addMainMenuItem(this, this.getMenuLocation(this.submenuLabel), this.ascending, false, ICON, SortCategoryByNamePlugIn.createEnableCheck(context.getWorkbenchContext()));
        context.getFeatureInstaller().addMainMenuItem(this, this.getMenuLocation(this.submenuLabel), this.descending, false, ICON, SortCategoryByNamePlugIn.createEnableCheck(context.getWorkbenchContext()));
    }

    @Override
    protected String getSubMenuLabel() {
        return this.submenuLabel;
    }

    @Override
    ArrayList<Layerable> getOrderedLayersInCategory(Category category, String sortLabel) {
        ArrayList<Layerable> layers = this.getCategoryArrayList(category);
        if (sortLabel.equals(this.ascending)) {
            Collections.sort(layers, new LayerableNameSort());
        } else if (sortLabel.equals(this.descending)) {
            Collections.sort(layers, Collections.reverseOrder(new LayerableNameSort()));
        } else {
            throw new IllegalStateException();
        }
        return layers;
    }

    class LayerableNameSort
    implements Comparator<Layerable> {
        LayerableNameSort() {
        }

        @Override
        public int compare(Layerable layer1, Layerable layer2) {
            return layer2.getName().compareTo(layer1.getName());
        }
    }
}

