/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.ui.plugin.help;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.model.Category;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.model.WMSLayer;
import com.vividsolutions.jump.workbench.plugin.AbstractPlugIn;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import com.vividsolutions.jump.workbench.ui.LayerViewPanel;
import com.vividsolutions.jump.workbench.ui.MenuNames;
import com.vividsolutions.jump.workbench.ui.SuggestTreeComboBox;
import com.vividsolutions.jump.workbench.ui.WorkbenchToolBar;
import com.vividsolutions.jump.workbench.ui.cursortool.editing.EditingPlugIn;
import com.vividsolutions.jump.workbench.ui.images.IconLoader;
import com.vividsolutions.jump.workbench.ui.plugin.analysis.GeometryFunction;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JDialog;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.MenuElement;
import org.openjump.core.rasterimage.RasterImageLayer;

public class SearchCommandPlugIn
extends AbstractPlugIn {
    static final String VIEW_POPUP = I18N.getInstance().get("ui.MenuNames.LAYERVIEWPANEL_POPUP");
    static final String LAYER_POPUP = I18N.getInstance().get("ui.MenuNames.LAYERNAMEPANEL_LAYER_POPUP");
    static final String CATEGORY_POPUP = I18N.getInstance().get("ui.MenuNames.LAYERNAMEPANEL_CATEGORY_POPUP");

    @Override
    public void initialize(PlugInContext context) throws Exception {
        super.initialize(context);
        context.getFeatureInstaller().addMainMenuPlugin(this, new String[]{MenuNames.HELP}, this.getName() + "...", false, IconLoader.icon("search.png"), null);
    }

    @Override
    public boolean execute(PlugInContext context) throws Exception {
        ArrayList<String> commands = new ArrayList<String>();
        this.getMenus(context.getWorkbenchFrame().getJMenuBar(), new ArrayList<String>(), commands);
        Map<Class<?>, JPopupMenu> map = context.getWorkbenchFrame().getNodeClassToPopupMenuMap();
        this.getMenus(map.get(Category.class), Arrays.asList(CATEGORY_POPUP), commands);
        this.getMenus(map.get(Layer.class), Arrays.asList(LAYER_POPUP), commands);
        this.getMenus(map.get(WMSLayer.class), Arrays.asList(LAYER_POPUP), commands);
        this.getMenus(map.get(RasterImageLayer.class), Arrays.asList(LAYER_POPUP), commands);
        this.getMenus(LayerViewPanel.popupMenu(), Arrays.asList(VIEW_POPUP), commands);
        for (String string : GeometryFunction.getNames()) {
            commands.add(string + " [" + I18N.getInstance().get("ui.MenuNames.TOOLS") + ">" + I18N.getInstance().get("ui.MenuNames.TOOLS.ANALYSIS") + ">" + I18N.getInstance().get("com.vividsolutions.jump.workbench.ui.plugin.analysis.GeometryFunctionPlugIn") + "]");
        }
        EditingPlugIn editingPlugIn = (EditingPlugIn)context.getWorkbenchContext().getBlackboard().getProperties().get("com.vividsolutions.jump.workbench.ui.cursortool.editing.EditingPlugIn");
        for (AbstractButton abstractButton : editingPlugIn.getToolbox().getButtons()) {
            commands.add(abstractButton.getToolTipText() + " [" + I18N.getInstance().get("ui.cursortool.editing.EditingPlugIn.editing-toolbox") + "]");
        }
        WorkbenchToolBar workbenchToolBar = context.getWorkbenchFrame().getToolBar();
        for (Component component : workbenchToolBar.getComponents()) {
            AbstractButton b;
            if (!(component instanceof AbstractButton) || (b = (AbstractButton)component).getToolTipText() == null) continue;
            commands.add(b.getToolTipText() + " [" + I18N.getInstance().get("Toolbar") + "]");
        }
        SuggestTreeComboBox suggestTreeComboBox = new SuggestTreeComboBox(commands.toArray(new String[0]), 64);
        JDialog dialog = new JDialog((Frame)context.getWorkbenchFrame(), this.getName());
        dialog.add(suggestTreeComboBox);
        dialog.setPreferredSize(new Dimension(480, 64));
        dialog.pack();
        GUIUtil.centre(dialog, context.getWorkbenchFrame());
        dialog.setVisible(true);
        return true;
    }

    private void getMenus(MenuElement me, List<String> list, List<String> commands) {
        if (me instanceof JMenuBar) {
            for (MenuElement m : me.getSubElements()) {
                this.getMenus(m, new ArrayList<String>(), commands);
            }
        } else if (me instanceof JPopupMenu) {
            for (MenuElement m : me.getSubElements()) {
                this.getMenus(m, list, commands);
            }
        } else if (me instanceof JMenu) {
            ArrayList<String> mlist = new ArrayList<String>(list);
            mlist.add(((JMenu)me).getText());
            for (MenuElement m : me.getSubElements()) {
                this.getMenus(m, mlist, commands);
            }
        } else if (me instanceof JMenuItem) {
            commands.add(((JMenuItem)me).getActionCommand() + " " + list.toString().replaceAll(", ", " > "));
        } else if (me instanceof JCheckBoxMenuItem) {
            commands.add(((JCheckBoxMenuItem)me).getActionCommand() + " " + list.toString().replaceAll(", ", " > "));
        } else if (me instanceof JRadioButtonMenuItem) {
            commands.add(((JRadioButtonMenuItem)me).getActionCommand() + " " + list.toString().replaceAll(", ", " > "));
        }
    }
}

