/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.ui.plugin.edittoolbox;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.plugin.AbstractPlugIn;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.OptionsDialog;
import com.vividsolutions.jump.workbench.ui.cursortool.CursorTool;
import com.vividsolutions.jump.workbench.ui.cursortool.editing.EditingPlugIn;
import com.vividsolutions.jump.workbench.ui.toolbox.ToolboxDialog;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import org.openjump.core.ui.plugin.edittoolbox.cursortools.DrawConstrainedPolygonTool;
import org.openjump.core.ui.plugin.edittoolbox.tab.ConstraintsOptionsPanel;

public class DrawConstrainedPolygonPlugIn
extends AbstractPlugIn {
    private boolean polygonButtonAdded = false;
    static final String constraints = I18N.getInstance().get("org.openjump.core.ui.plugin.edittoolbox.DrawConstrainedPolygonPlugIn.Constraints");
    static final String errorSeeOutputWindow = I18N.getInstance().get("org.openjump.core.ui.plugin.edittoolbox.DrawConstrainedPolygonPlugIn.Error-See-Output-Window");

    @Override
    public void initialize(final PlugInContext context) throws Exception {
        super.initialize(context);
        OptionsDialog.instance(context.getWorkbenchContext().getWorkbench()).addTab(constraints, new ConstraintsOptionsPanel(context.getWorkbenchContext()));
        context.getWorkbenchContext().getWorkbench().getFrame().addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent e) {
                ToolboxDialog toolBox = ((EditingPlugIn)context.getWorkbenchContext().getBlackboard().get(EditingPlugIn.KEY)).getToolbox(context.getWorkbenchContext());
                toolBox.addComponentListener(new ComponentAdapter(){

                    @Override
                    public void componentShown(ComponentEvent e) {
                        DrawConstrainedPolygonPlugIn.this.addButton(context);
                    }

                    @Override
                    public void componentHidden(ComponentEvent e) {
                    }
                });
            }
        });
    }

    @Override
    public boolean execute(PlugInContext context) throws Exception {
        try {
            CursorTool polyTool = DrawConstrainedPolygonTool.create(context.getWorkbenchContext());
            context.getLayerViewPanel().setCurrentCursorTool(polyTool);
            return true;
        }
        catch (Exception e) {
            context.getWorkbenchFrame().warnUser(errorSeeOutputWindow);
            context.getWorkbenchFrame().getOutputFrame().createNewDocument();
            context.getWorkbenchFrame().getOutputFrame().addText("DrawConstrainedPolygonPlugIn Exception:" + e.toString());
            return false;
        }
    }

    public void addButton(PlugInContext context) {
        if (!this.polygonButtonAdded) {
            ToolboxDialog toolbox = ((EditingPlugIn)context.getWorkbenchContext().getBlackboard().get(EditingPlugIn.KEY)).getToolbox(context.getWorkbenchContext());
            toolbox.addToolBar();
            toolbox.add(DrawConstrainedPolygonTool.create(toolbox.getContext()), null);
            toolbox.finishAddingComponents();
            toolbox.validate();
            this.polygonButtonAdded = true;
        }
    }
}

