/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.ui.io.file;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.coordsys.CoordinateSystemRegistry;
import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.feature.FeatureCollection;
import com.vividsolutions.jump.feature.FeatureDataset;
import com.vividsolutions.jump.io.CompressedFile;
import com.vividsolutions.jump.io.datasource.Connection;
import com.vividsolutions.jump.io.datasource.DataSource;
import com.vividsolutions.jump.io.datasource.DataSourceQuery;
import com.vividsolutions.jump.task.TaskMonitor;
import com.vividsolutions.jump.util.LangUtil;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.imagery.ImageryLayerDataset;
import com.vividsolutions.jump.workbench.imagery.ReferencedImageFactoryFileLayerLoader;
import com.vividsolutions.jump.workbench.imagery.ReferencedImageStyle;
import com.vividsolutions.jump.workbench.model.Category;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.model.LayerManager;
import com.vividsolutions.jump.workbench.plugin.Macro;
import com.vividsolutions.jump.workbench.plugin.PlugInManager;
import com.vividsolutions.jump.workbench.plugin.Recordable;
import com.vividsolutions.jump.workbench.ui.HTMLFrame;
import com.vividsolutions.jump.workbench.ui.WorkbenchFrame;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openjump.core.ccordsys.srid.SRIDStyle;
import org.openjump.core.ccordsys.utils.ProjUtils;
import org.openjump.core.ui.io.file.AbstractFileLayerLoader;
import org.openjump.core.ui.util.ExceptionUtil;
import org.openjump.core.ui.util.TaskUtil;
import org.openjump.util.UriUtil;

public class DataSourceFileLayerLoader
extends AbstractFileLayerLoader
implements Recordable {
    private static final String DATASOURCE_CLASSNAME = "DataSourceClassName";
    private static final String URI = "Uri";
    private Map<String, Object> parameters;
    private Class dataSourceClass;
    private WorkbenchContext workbenchContext;

    public void addParameter(String name, Object value) {
        if (this.parameters == null) {
            this.parameters = new HashMap<String, Object>();
        }
        this.parameters.put(name, value);
    }

    public Object getParameter(String name) {
        if (this.parameters == null) {
            return null;
        }
        return this.parameters.get(name);
    }

    public Boolean getBooleanParam(String name) {
        if (this.parameters == null) {
            return null;
        }
        return (Boolean)this.parameters.get(name);
    }

    public Integer getIntegerParam(String name) {
        if (this.parameters == null) {
            return null;
        }
        return (Integer)this.parameters.get(name);
    }

    public Double getDoubleParam(String name) {
        if (this.parameters == null) {
            return null;
        }
        return (Double)this.parameters.get(name);
    }

    public String getStringParam(String name) {
        if (this.parameters == null) {
            return null;
        }
        return (String)this.parameters.get(name);
    }

    @Override
    public void setParameters(Map<String, Object> map) {
        this.parameters = map;
    }

    public Map<String, Object> getParameters() {
        return this.parameters;
    }

    public void resetParameters() {
        this.parameters = new HashMap<String, Object>();
    }

    public DataSourceFileLayerLoader() {
    }

    public void setContext(WorkbenchContext context) {
        this.workbenchContext = context;
    }

    public DataSourceFileLayerLoader(WorkbenchContext workbenchContext, Class dataSourceClass, String description, List<String> extensions) {
        super(description, extensions);
        this.workbenchContext = workbenchContext;
        this.dataSourceClass = dataSourceClass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object process(TaskMonitor monitor) throws ClassNotFoundException, URISyntaxException {
        ArrayList<Throwable> exceptions;
        DataSourceQuery dataSourceQuery;
        block9: {
            PlugInManager plugInManager = this.workbenchContext.getWorkbench().getPlugInManager();
            ClassLoader pluginClassLoader = plugInManager.getClassLoader();
            Class<?> datasourceClass = pluginClassLoader.loadClass(this.getStringParam(DATASOURCE_CLASSNAME));
            DataSource dataSource = (DataSource)LangUtil.newInstance(datasourceClass);
            Map<String, Object> properties = this.getParameters();
            dataSource.setProperties(properties);
            URI uri = new URI(this.getStringParam(URI));
            String filename = UriUtil.getFileName(uri);
            String layerName = CompressedFile.createLayerName(uri);
            dataSourceQuery = new DataSourceQuery(dataSource, null, layerName);
            exceptions = new ArrayList<Throwable>();
            monitor.report(I18N.getInstance().get("datasource.LoadDatasetPlugIn.loading") + " " + layerName + "...");
            try (Connection connection = dataSourceQuery.getDataSource().getConnection();){
                LayerManager layerManager = this.workbenchContext.getLayerManager();
                layerName = layerManager.uniqueLayerName(layerName);
                FeatureCollection dataset = dataSourceQuery.getDataSource().installCoordinateSystem(connection.executeQuery(dataSourceQuery.getQuery(), exceptions, monitor), CoordinateSystemRegistry.instance(this.workbenchContext.getBlackboard()));
                boolean layer_changed = false;
                if (dataset == null) break block9;
                Layer layer = null;
                for (Feature f : dataset.getFeatures()) {
                    FeatureDataset img_fs = new FeatureDataset(ImageryLayerDataset.SCHEMA);
                    if (!ImageryLayerDataset.isImageFeature(f)) continue;
                    if (layer == null) {
                        layerManager.setFiringEvents(false);
                        layer = ReferencedImageFactoryFileLayerLoader.createLayer(layerManager, uri);
                        layer.setFeatureCollection(img_fs);
                        layerManager.setFiringEvents(true);
                    }
                    ReferencedImageStyle irs = (ReferencedImageStyle)layer.getStyle(ReferencedImageStyle.class);
                    ImageryLayerDataset ilds = irs.getImageryLayerDataset();
                    layer_changed = layer_changed || ImageryLayerDataset.isOldImageFeature(f);
                    Feature img_f = ReferencedImageFactoryFileLayerLoader.createImageFeature(f, ilds);
                    img_fs.add(img_f);
                }
                if (layer == null) {
                    layer = new Layer(layerName, layerManager.generateLayerFillColor(), dataset, layerManager);
                }
                Category category = TaskUtil.getSelectedCategoryName(this.workbenchContext);
                layerManager.addLayerable(category.getName(), layer);
                layer.setName(layerName);
                layer.setDataSourceQuery(dataSourceQuery);
                layer.setFeatureCollectionModified(layer_changed);
                SRIDStyle sridStyle = (SRIDStyle)layer.getStyle(SRIDStyle.class);
                int prjSRID = 0;
                try {
                    String prjSRIDString = ProjUtils.getSRSInfoFromLayerStyleOrSource(layer).getCode();
                    prjSRID = prjSRIDString.matches("\\d+") ? Integer.parseInt(prjSRIDString) : 0;
                }
                catch (Exception e) {
                    prjSRID = 0;
                }
                sridStyle.setSRID(prjSRID);
                sridStyle.updateSRIDs(layer);
            }
        }
        if (!exceptions.isEmpty()) {
            WorkbenchFrame workbenchFrame = this.workbenchContext.getWorkbench().getFrame();
            HTMLFrame outputFrame = workbenchFrame.getOutputFrame();
            outputFrame.createNewDocument();
            ExceptionUtil.reportExceptions(exceptions, dataSourceQuery, workbenchFrame, outputFrame);
            workbenchFrame.warnUser(I18N.getInstance().get("datasource.LoadDatasetPlugIn.problems-were-encountered"));
            return false;
        }
        return true;
    }

    @Override
    public boolean open(TaskMonitor monitor, URI uri, Map<String, Object> options) {
        this.resetParameters();
        this.addParameter(DATASOURCE_CLASSNAME, this.dataSourceClass.getName());
        this.addParameter(URI, uri.toString());
        Map<String, Object> properties = this.toProperties(uri, options);
        for (String key : properties.keySet()) {
            this.addParameter(key, properties.get(key));
        }
        try {
            boolean ret = (Boolean)this.process(monitor);
            if (this.workbenchContext.getBlackboard().get("MacroStarted", false)) {
                DataSourceFileLayerLoader clone = new DataSourceFileLayerLoader();
                clone.setParameters(this.getParameters());
                ((Macro)this.workbenchContext.getBlackboard().get("Macro")).addProcess(clone);
            }
            return ret;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    protected Map<String, Object> toProperties(URI uri, Map<String, Object> options) {
        File file;
        HashMap<String, Object> properties = new HashMap<String, Object>();
        if (uri.getScheme().equals("zip")) {
            file = UriUtil.getZipFile(uri);
            String compressedFile = UriUtil.getZipEntryName(uri);
            properties.put("CompressedFile", compressedFile);
        } else {
            file = new File(uri);
        }
        String filePath = file.getAbsolutePath();
        properties.put("File", filePath);
        properties.putAll(options);
        return properties;
    }
}

