/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.rasterimage.styler;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.awt.image.Raster;
import org.openjump.core.rasterimage.RasterImageLayer;
import org.openjump.core.rasterimage.RasterSymbology;

public class StylePlugger {
    private final RasterImageLayer rasterImageLayer;

    public StylePlugger(RasterImageLayer rasterImageLayer) {
        this.rasterImageLayer = rasterImageLayer;
    }

    public void plug(RasterSymbology rasterSymbolizer, Raster raster) {
        int width = raster.getWidth();
        int height = raster.getHeight();
        BufferedImage newImage = new BufferedImage(width, height, 6);
        for (int row = 0; row < height; ++row) {
            for (int col = 0; col < width; ++col) {
                Double value = raster.getSampleDouble(col, row, 0);
                Color newColor = rasterSymbolizer.getColor(value);
                if (newColor == null) {
                    newImage.setRGB(col, row, 3);
                    continue;
                }
                newImage.setRGB(col, row, newColor.getRGB());
            }
        }
        this.rasterImageLayer.setImage(newImage);
        this.rasterImageLayer.setTransparencyLevel(rasterSymbolizer.getTransparency());
    }
}

