/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.rasterimage.sextante.rasterWrappers;

import java.awt.geom.Point2D;
import org.openjump.core.rasterimage.sextante.ISextanteRasterLayer;
import org.openjump.core.rasterimage.sextante.rasterWrappers.GridExtent;

public abstract class GridWrapper {
    public static final int INTERPOLATION_NearestNeighbour = 0;
    public static final int INTERPOLATION_Bilinear = 1;
    public static final int INTERPOLATION_InverseDistance = 2;
    public static final int INTERPOLATION_BicubicSpline = 3;
    public static final int INTERPOLATION_BSpline = 4;
    protected ISextanteRasterLayer m_Layer;
    protected int m_iOffsetX;
    protected int m_iOffsetY;
    private int m_iInterpolationMethod = 4;
    private Point2D.Double m_dCellSize;
    protected GridExtent m_WindowExtent;
    private int m_iNXLayer;
    private int m_iNYLayer;

    public GridWrapper(ISextanteRasterLayer layer, GridExtent windowExtent) {
        this.m_Layer = layer;
        this.m_WindowExtent = windowExtent;
        this.m_dCellSize = layer.getLayerCellSize();
        GridExtent layerExtent = layer.getLayerGridExtent();
        this.m_iNXLayer = layerExtent.getNX();
        this.m_iNYLayer = layerExtent.getNY();
    }

    public abstract byte getCellValueAsByte(int var1, int var2);

    public abstract byte getCellValueAsByte(int var1, int var2, int var3);

    public abstract short getCellValueAsShort(int var1, int var2);

    public abstract short getCellValueAsShort(int var1, int var2, int var3);

    public abstract int getCellValueAsInt(int var1, int var2);

    public abstract int getCellValueAsInt(int var1, int var2, int var3);

    public abstract float getCellValueAsFloat(int var1, int var2);

    public abstract float getCellValueAsFloat(int var1, int var2, int var3);

    public abstract double getCellValueAsDouble(int var1, int var2);

    public abstract double getCellValueAsDouble(int var1, int var2, int var3);

    protected double getCellValueInLayerCoords(int x, int y, int band) {
        if (this.isInLayer(x, y, band)) {
            return this.m_Layer.getCellValueInLayerCoords(x, y, band);
        }
        return this.getNoDataValue();
    }

    public boolean isNoDataValue(double dValue) {
        return dValue == this.m_Layer.getNoDataValue() || Double.isNaN(dValue);
    }

    public double getNoDataValue() {
        return this.m_Layer.getNoDataValue();
    }

    public int getNY() {
        return this.m_WindowExtent.getNY();
    }

    public int getNX() {
        return this.m_WindowExtent.getNX();
    }

    public Point2D.Double getCellSize() {
        return this.m_WindowExtent.getCellSize();
    }

    public GridExtent getGridExtent() {
        return this.m_WindowExtent;
    }

    protected boolean isInLayer(int x, int y, int iBand) {
        return x >= 0 && x < this.m_iNXLayer && y >= 0 && y < this.m_iNYLayer && iBand < this.m_Layer.getBandsCount();
    }

    public double getValueAt(double xPosition, double yPosition, int band) {
        int y;
        int x = (int)Math.floor(xPosition = (xPosition - this.m_Layer.getLayerGridExtent().getXMin()) / this.m_dCellSize.x);
        double dValue = this.getCellValueInLayerCoords(x, y = (int)Math.floor(yPosition = (this.m_Layer.getLayerGridExtent().getYMax() - yPosition) / this.m_dCellSize.y), band);
        if (!this.isNoDataValue(dValue)) {
            double dx = xPosition - (double)x;
            double dy = yPosition - (double)y;
            switch (this.m_iInterpolationMethod) {
                case 0: {
                    dValue = this.getValueNearestNeighbour(x, y, dx, dy, band);
                    break;
                }
                case 1: {
                    dValue = this.getValueBiLinear(x, y, dx, dy, band);
                    break;
                }
                case 2: {
                    dValue = this.getValueInverseDistance(x, y, dx, dy, band);
                    break;
                }
                case 3: {
                    dValue = this.getValueBiCubicSpline(x, y, dx, dy, band);
                    break;
                }
                case 4: {
                    dValue = this.getValueBSpline(x, y, dx, dy, band);
                }
            }
        } else {
            dValue = this.getNoDataValue();
        }
        return dValue;
    }

    private double getValueNearestNeighbour(int x, int y, double dx, double dy, int band) {
        return this.getCellValueInLayerCoords(x += (int)(0.5 + dx), y += (int)(0.5 + dy), band);
    }

    private double getValueBiLinear(int x, int y, double dx, double dy, int band) {
        double d;
        double z = 0.0;
        double n = 0.0;
        double dValue = this.getCellValueInLayerCoords(x, y, band);
        if (!this.isNoDataValue(dValue)) {
            d = (1.0 - dx) * (1.0 - dy);
            z += d * dValue;
            n += d;
        }
        if (!this.isNoDataValue(dValue = this.getCellValueInLayerCoords(x + 1, y, band))) {
            d = dx * (1.0 - dy);
            z += d * dValue;
            n += d;
        }
        if (!this.isNoDataValue(dValue = this.getCellValueInLayerCoords(x, y + 1, band))) {
            d = (1.0 - dx) * dy;
            z += d * dValue;
            n += d;
        }
        if (!this.isNoDataValue(dValue = this.getCellValueInLayerCoords(x + 1, y + 1, band))) {
            d = dx * dy;
            z += d * dValue;
            n += d;
        }
        if (n > 0.0) {
            return z / n;
        }
        return this.getNoDataValue();
    }

    private double getValueInverseDistance(int x, int y, double dx, double dy, int band) {
        double z = 0.0;
        double n = 0.0;
        if (dx > 0.0 || dy > 0.0) {
            double d;
            double dValue = this.getCellValueInLayerCoords(x, y, band);
            if (!this.isNoDataValue(dValue)) {
                d = 1.0 / Math.sqrt(dx * dx + dy * dy);
                z += d * dValue;
                n += d;
            }
            if (!this.isNoDataValue(dValue = this.getCellValueInLayerCoords(x + 1, y, band))) {
                d = 1.0 / Math.sqrt((1.0 - dx) * (1.0 - dx) + dy * dy);
                z += d * dValue;
                n += d;
            }
            if (!this.isNoDataValue(dValue = this.getCellValueInLayerCoords(x, y + 1, band))) {
                d = 1.0 / Math.sqrt(dx * dx + (1.0 - dy) * (1.0 - dy));
                z += d * dValue;
                n += d;
            }
            if (!this.isNoDataValue(dValue = this.getCellValueInLayerCoords(x + 1, y + 1, band))) {
                d = 1.0 / Math.sqrt((1.0 - dx) * (1.0 - dx) + (1.0 - dy) * (1.0 - dy));
                z += d * dValue;
                n += d;
            }
            if (n > 0.0) {
                return z / n;
            }
        } else {
            return this.getCellValueInLayerCoords(x, y, band);
        }
        return this.getNoDataValue();
    }

    private double getValueBiCubicSpline(int x, int y, double dx, double dy, int band) {
        double[] c = new double[4];
        double[][] z_xy = new double[4][4];
        if (this.get4x4Submatrix(x, y, z_xy, band)) {
            double b3;
            double b2;
            double b1;
            double a3;
            double a2;
            double a0;
            for (int i = 0; i < 4; ++i) {
                a0 = z_xy[0][i] - z_xy[1][i];
                a2 = z_xy[2][i] - z_xy[1][i];
                a3 = z_xy[3][i] - z_xy[1][i];
                b1 = -a0 / 3.0 + a2 - a3 / 6.0;
                b2 = a0 / 2.0 + a2 / 2.0;
                b3 = -a0 / 6.0 - a2 / 2.0 + a3 / 6.0;
                c[i] = z_xy[1][i] + b1 * dx + b2 * dx * dx + b3 * dx * dx * dx;
            }
            a0 = c[0] - c[1];
            a2 = c[2] - c[1];
            a3 = c[3] - c[1];
            b1 = -a0 / 3.0 + a2 - a3 / 6.0;
            b2 = a0 / 2.0 + a2 / 2.0;
            b3 = -a0 / 6.0 - a2 / 2.0 + a3 / 6.0;
            return c[1] + b1 * dy + b2 * dy * dy + b3 * dy * dy * dy;
        }
        return this.getValueBiLinear(x, y, dx, dy, band);
    }

    private double getValueBSpline(int x, int y, double dx, double dy, int band) {
        double[] Rx = new double[4];
        double[] Ry = new double[4];
        double[][] z_xy = new double[4][4];
        if (this.get4x4Submatrix(x, y, z_xy, band)) {
            double z;
            int i = 0;
            double px = -1.0 - dx;
            double py = -1.0 - dy;
            while (i < 4) {
                double d;
                double d2;
                double d3;
                double d4;
                double d5;
                double d6;
                double d7;
                double d8;
                Rx[i] = 0.0;
                Ry[i] = 0.0;
                z = px + 2.0;
                if (d8 > 0.0) {
                    int n = i;
                    Rx[n] = Rx[n] + z * z * z;
                }
                z = px + 1.0;
                if (d7 > 0.0) {
                    int n = i;
                    Rx[n] = Rx[n] + -4.0 * z * z * z;
                }
                z = px + 0.0;
                if (d6 > 0.0) {
                    int n = i;
                    Rx[n] = Rx[n] + 6.0 * z * z * z;
                }
                z = px - 1.0;
                if (d5 > 0.0) {
                    int n = i;
                    Rx[n] = Rx[n] + -4.0 * z * z * z;
                }
                z = py + 2.0;
                if (d4 > 0.0) {
                    int n = i;
                    Ry[n] = Ry[n] + z * z * z;
                }
                z = py + 1.0;
                if (d3 > 0.0) {
                    int n = i;
                    Ry[n] = Ry[n] + -4.0 * z * z * z;
                }
                z = py + 0.0;
                if (d2 > 0.0) {
                    int n = i;
                    Ry[n] = Ry[n] + 6.0 * z * z * z;
                }
                z = py - 1.0;
                if (d > 0.0) {
                    int n = i;
                    Ry[n] = Ry[n] + -4.0 * z * z * z;
                }
                int n = i;
                Rx[n] = Rx[n] / 6.0;
                int n2 = i++;
                Ry[n2] = Ry[n2] / 6.0;
                px += 1.0;
                py += 1.0;
            }
            z = 0.0;
            for (int iy = 0; iy < 4; ++iy) {
                for (int ix = 0; ix < 4; ++ix) {
                    z += z_xy[ix][iy] * Rx[ix] * Ry[iy];
                }
            }
            return z;
        }
        return this.getValueBiLinear(x, y, dx, dy, band);
    }

    private boolean get4x4Submatrix(int x, int y, double[][] z_xy, int band) {
        int iy = 0;
        int py = y - 1;
        while (iy < 4) {
            int ix = 0;
            int px = x - 1;
            while (ix < 4) {
                double dValue = this.getCellValueInLayerCoords(px, py, band);
                if (this.isNoDataValue(dValue)) {
                    return false;
                }
                z_xy[ix][iy] = dValue;
                ++ix;
                ++px;
            }
            ++iy;
            ++py;
        }
        return true;
    }

    public void setInterpolationMethod(int iMethod) {
        this.m_iInterpolationMethod = iMethod;
    }
}

