/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.rasterimage.algorithms;

import com.vividsolutions.jump.feature.AttributeType;
import com.vividsolutions.jump.feature.BasicFeature;
import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.feature.FeatureCollection;
import com.vividsolutions.jump.feature.FeatureDataset;
import com.vividsolutions.jump.feature.FeatureSchema;
import com.vividsolutions.jump.workbench.Logger;
import com.vividsolutions.jump.workbench.ui.WorkbenchFrame;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.geom.util.AffineTransformation;
import org.locationtech.jts.operation.linemerge.LineMerger;
import org.locationtech.jts.operation.polygonize.Polygonizer;
import org.locationtech.jts.operation.union.CascadedPolygonUnion;
import org.locationtech.jts.simplify.DouglasPeuckerSimplifier;
import org.openjump.core.rasterimage.sextante.OpenJUMPSextanteRasterLayer;
import org.openjump.core.rasterimage.sextante.rasterWrappers.GridWrapperNotInterpolated;

public class VectorizeAlgorithm {
    public static WorkbenchFrame frame;
    static GeometryFactory gf;
    private static int[][] m_Lock;
    private static char[][] m_Area;
    private static int m_iNX;
    private static int m_iNY;
    private char[][] m_Row;
    private char[][] m_Col;
    private final OpenJUMPSextanteRasterLayer m_Visited = new OpenJUMPSextanteRasterLayer();
    private final OpenJUMPSextanteRasterLayer m_Visited2 = new OpenJUMPSextanteRasterLayer();
    private final GeometryFactory m_GF = new GeometryFactory();
    private boolean removeZeroCells = false;
    static int iNX;
    static int iNY;
    private static int m_iLine;
    private final int[] m_iOffsetX = new int[]{0, 1, 0, -1};
    private final int[] m_iOffsetY = new int[]{-1, 0, 1, 0};
    private final int[] m_iOffsetXDiag = new int[]{-1, 1, 1, -1};
    private final int[] m_iOffsetYDiag = new int[]{-1, -1, 1, 1};

    public static FeatureCollection toPolygonsAdbToolBox(GridWrapperNotInterpolated gwrapper, boolean explodeMultipolygons, String attributeName, int band) {
        double xCellSize = gwrapper.getGridExtent().getCellSize().x;
        double yCellSize = gwrapper.getGridExtent().getCellSize().y;
        double xllCorner = gwrapper.getGridExtent().getXMin();
        double yllCorner = gwrapper.getGridExtent().getYMin();
        double noData = gwrapper.getNoDataValue();
        Map<Double, List<Polygon>> uniqueVals = VectorizeAlgorithm.findUniqueVals(gwrapper, noData, band);
        GeometryFactory geomFactory = new GeometryFactory();
        int nCols = gwrapper.getGridExtent().getNX();
        int nRows = gwrapper.getGridExtent().getNY();
        for (int r = 0; r <= nRows + 1; ++r) {
            double oldVal = noData;
            int cStart = 0;
            for (int c = 0; c <= nCols + 1; ++c) {
                double val = gwrapper.getCellValueAsDouble(c, r, band);
                if (VectorizeAlgorithm.sameAs(val, oldVal, noData)) continue;
                if (!VectorizeAlgorithm.isNoData(oldVal, noData)) {
                    Polygon polygon = (Polygon)geomFactory.toGeometry(new Envelope(xllCorner + (double)cStart * xCellSize, xllCorner + (double)c * xCellSize, yllCorner + (double)(nRows - r - 1) * yCellSize, yllCorner + (double)(nRows - r) * yCellSize));
                    uniqueVals.get(oldVal).add(polygon);
                }
                oldVal = val;
                cStart = c;
            }
        }
        FeatureSchema featSchema = new FeatureSchema();
        featSchema.addAttribute("GEOMETRY", AttributeType.GEOMETRY);
        featSchema.addAttribute("ID", AttributeType.INTEGER);
        featSchema.addAttribute(attributeName, AttributeType.DOUBLE);
        int ID = 1;
        FeatureDataset featColl = new FeatureDataset(featSchema);
        for (Map.Entry<Double, List<Polygon>> entry : uniqueVals.entrySet()) {
            BasicFeature feature;
            Geometry geom = CascadedPolygonUnion.union((Collection)entry.getValue());
            geom = DouglasPeuckerSimplifier.simplify((Geometry)geom, (double)0.0);
            if (explodeMultipolygons) {
                for (int g = 0; g < geom.getNumGeometries(); ++g) {
                    feature = new BasicFeature(featSchema);
                    feature.setGeometry(geom.getGeometryN(g));
                    feature.setAttribute(1, (Object)ID);
                    feature.setAttribute(2, (Object)entry.getKey());
                    featColl.add(feature);
                    ++ID;
                }
                continue;
            }
            feature = new BasicFeature(featSchema);
            feature.setAttribute(1, (Object)ID);
            feature.setGeometry(geom);
            feature.setAttribute(2, (Object)entry.getKey());
            featColl.add(feature);
            ++ID;
        }
        return featColl;
    }

    private static boolean sameAs(double a, double b, double noData) {
        boolean aIsNaN = VectorizeAlgorithm.isNoData(a, noData);
        boolean bIsNaN = VectorizeAlgorithm.isNoData(b, noData);
        return aIsNaN && bIsNaN || !aIsNaN && !bIsNaN && a == b;
    }

    private static boolean isNoData(double a, double noData) {
        return Double.isNaN(a) || !Double.isNaN(noData) && a == noData;
    }

    private static Map<Double, List<Polygon>> findUniqueVals(GridWrapperNotInterpolated gwrapper, double noData, int band) {
        TreeMap<Double, List<Polygon>> map = new TreeMap<Double, List<Polygon>>();
        int nx = gwrapper.getNX();
        int ny = gwrapper.getNY();
        for (int x = 0; x < nx; ++x) {
            for (int y = 0; y < ny; ++y) {
                double value = gwrapper.getCellValueAsDouble(x, y, band);
                if (VectorizeAlgorithm.isNoData(value, noData)) continue;
                map.computeIfAbsent(value, a -> new ArrayList());
            }
        }
        return map;
    }

    public static FeatureCollection toPolygonsMikeToolBox(GridWrapperNotInterpolated gwrapper, boolean simplify, String attributeName, int band) {
        double val;
        int c;
        int r;
        int width = gwrapper.getGridExtent().getNX();
        int height = gwrapper.getGridExtent().getNY();
        double noData = gwrapper.getNoDataValue();
        ArrayList<Face> faces = new ArrayList<Face>();
        double xCellSize = gwrapper.getGridExtent().getCellSize().x;
        double yCellSize = gwrapper.getGridExtent().getCellSize().y;
        double xllCorner = gwrapper.getGridExtent().getXMin();
        double yllCorner = gwrapper.getGridExtent().getYMin();
        AffineTransformation transform = new AffineTransformation(xCellSize, 0.0, xllCorner, 0.0, -yCellSize, yllCorner + (double)height * yCellSize);
        BooleanMatrix m = new BooleanMatrix(width, height);
        for (r = 0; r < height; ++r) {
            for (c = 0; c < width; ++c) {
                val = gwrapper.getCellValueAsDouble(c, r, band);
                if (!VectorizeAlgorithm.isNoData(val, noData)) continue;
                m.set(r, c);
            }
        }
        for (r = 0; r < height; ++r) {
            for (c = 0; c < width; ++c) {
                if (m.isSet(r, c)) continue;
                val = gwrapper.getCellValueAsDouble(c, r, band);
                Face face = new Face(val);
                faces.add(face);
                face.cells.add(new Cell(c, r));
                VectorizeAlgorithm.iterativeExpansion(face, band, gwrapper, m);
            }
        }
        FeatureSchema featSchema = new FeatureSchema();
        featSchema.addAttribute("GEOMETRY", AttributeType.GEOMETRY);
        featSchema.addAttribute("ID", AttributeType.INTEGER);
        featSchema.addAttribute(attributeName, AttributeType.DOUBLE);
        FeatureDataset featColl = new FeatureDataset(featSchema);
        int ID = 1;
        for (Face face : faces) {
            LineMerger merger = new LineMerger();
            merger.add((Collection)face.limits.stream().map(it -> it.toGeometry(gf)).collect(Collectors.toList()));
            Polygonizer polygonizer = new Polygonizer();
            polygonizer.add(merger.getMergedLineStrings());
            Collection polygons = polygonizer.getPolygons();
            Geometry geom = null;
            if (polygons.size() > 1) {
                Polygon poly;
                Iterator iterator = polygons.iterator();
                if (iterator.hasNext() && (poly = (Polygon)iterator.next()).getNumInteriorRing() > 0) {
                    geom = poly;
                }
            } else {
                geom = (Geometry)polygons.iterator().next();
            }
            if (geom == null) {
                Logger.warn("Merge/Polygonization gave an unexpected result " + polygons);
            }
            geom = transform.transform(geom);
            if (simplify) {
                geom = DouglasPeuckerSimplifier.simplify((Geometry)geom, (double)0.0);
            }
            BasicFeature feature = new BasicFeature(featSchema);
            feature.setAttribute(1, (Object)ID);
            feature.setGeometry(geom);
            feature.setAttribute(2, (Object)face.value);
            featColl.add(feature);
            ++ID;
        }
        System.out.println("end " + new Date());
        return featColl;
    }

    static void iterativeExpansion(Face face, int band, GridWrapperNotInterpolated grid, BooleanMatrix m) {
        HashSet<Cell> exp = new HashSet<Cell>();
        while (!face.cells.isEmpty()) {
            exp.clear();
            Iterator<Cell> it = face.cells.iterator();
            while (it.hasNext()) {
                Cell cell = it.next();
                int col = cell.col;
                int row = cell.row;
                it.remove();
                m.set(row, col);
                if (col + 1 < m.width && !m.isSet(row, col + 1) && grid.getCellValueAsDouble(col + 1, row, band) == face.value) {
                    exp.add(new Cell(col + 1, row));
                } else if (col + 1 >= m.width || grid.getCellValueAsDouble(col + 1, row, band) != face.value) {
                    face.limits.add(new Segment(col + 1, row, col + 1, row + 1));
                }
                if (row + 1 < m.height && !m.isSet(row + 1, col) && grid.getCellValueAsDouble(col, row + 1, band) == face.value) {
                    exp.add(new Cell(col, row + 1));
                } else if (row + 1 >= m.height || grid.getCellValueAsDouble(col, row + 1, band) != face.value) {
                    face.limits.add(new Segment(col, row + 1, col + 1, row + 1));
                }
                if (col - 1 > -1 && !m.isSet(row, col - 1) && grid.getCellValueAsDouble(col - 1, row, band) == face.value) {
                    exp.add(new Cell(col - 1, row));
                } else if (col - 1 < 0 || grid.getCellValueAsDouble(col - 1, row, band) != face.value) {
                    face.limits.add(new Segment(col, row, col, row + 1));
                }
                if (row - 1 > -1 && !m.isSet(row - 1, col) && grid.getCellValueAsDouble(col, row - 1, band) == face.value) {
                    exp.add(new Cell(col, row - 1));
                    continue;
                }
                if (row - 1 >= 0 && grid.getCellValueAsDouble(col, row - 1, band) == face.value) continue;
                face.limits.add(new Segment(col, row, col + 1, row));
            }
            face.cells.addAll(exp);
        }
    }

    public static FeatureCollection toPolygonsSextante(GridWrapperNotInterpolated gwrapper, String attributeName, int band) {
        FeatureSchema featSchema = new FeatureSchema();
        featSchema.addAttribute("GEOMETRY", AttributeType.GEOMETRY);
        featSchema.addAttribute("ID", AttributeType.INTEGER);
        featSchema.addAttribute(attributeName, AttributeType.DOUBLE);
        FeatureDataset featColl = new FeatureDataset(featSchema);
        m_iNX = gwrapper.getNX();
        m_iNY = gwrapper.getNY();
        m_Lock = new int[m_iNY][m_iNX];
        m_Area = new char[m_iNY + 1][m_iNX + 1];
        int ID = 1;
        for (int y = 0; y < m_iNY; ++y) {
            for (int x = 0; x < m_iNX; ++x) {
                double dValue = gwrapper.getCellValueAsDouble(x, y, band);
                if (gwrapper.isNoDataValue(dValue) || m_Lock[y][x] != 0) continue;
                VectorizeAlgorithm.Discrete_Lock(gwrapper, x, y, ID, band);
                featColl.add(VectorizeAlgorithm.Discrete_Area(gwrapper, featSchema, attributeName, x, y, ID, band));
                ++ID;
            }
        }
        System.gc();
        return featColl;
    }

    private static void Discrete_Lock(GridWrapperNotInterpolated gwrapper, int x, int y, int ID, int band) {
        int ix;
        int iy;
        int[] xTo = new int[]{0, 1, 0, -1};
        int[] yTo = new int[]{1, 0, -1, 0};
        char[] goDir = new char[]{'\u0001', '\u0002', '\u0004', '\b'};
        char goTemp = '\u0000';
        char[] goStack = new char[50];
        int[] xStack = new int[50];
        int[] yStack = new int[50];
        int iStack = 0;
        double dValue = gwrapper.getCellValueAsDouble(x, y, band);
        for (iy = 0; iy <= m_iNY; ++iy) {
            for (ix = 0; ix <= m_iNX; ++ix) {
                VectorizeAlgorithm.m_Area[iy][ix] = '\u0000';
            }
        }
        do {
            int i;
            if (m_Lock[y][x] == 0) {
                if (goStack.length <= iStack) {
                    char[] cAux = new char[goStack.length + 50];
                    System.arraycopy(goStack, 0, cAux, 0, goStack.length);
                    goStack = cAux;
                    int[] iAux = new int[xStack.length + 50];
                    System.arraycopy(xStack, 0, iAux, 0, xStack.length);
                    xStack = iAux;
                    iAux = new int[yStack.length + 50];
                    System.arraycopy(yStack, 0, iAux, 0, yStack.length);
                    yStack = iAux;
                }
                goStack[iStack] = '\u0000';
                VectorizeAlgorithm.m_Lock[y][x] = ID;
                block9: for (i = 0; i < 4; ++i) {
                    ix = x + xTo[i];
                    iy = y + yTo[i];
                    boolean isBorder = true;
                    double dValue2 = gwrapper.getCellValueAsDouble(ix, iy, band);
                    if (ix >= 0 && ix < m_iNX && iy >= 0 && iy < m_iNY && dValue == dValue2) {
                        isBorder = false;
                        if (m_Lock[iy][ix] == 0) {
                            int n = iStack;
                            goStack[n] = (char)(goStack[n] | goDir[i]);
                        }
                    }
                    if (!isBorder) continue;
                    switch (i) {
                        case 0: {
                            char[] cArray = m_Area[y + 1];
                            int n = x;
                            cArray[n] = (char)(cArray[n] + '\u0001');
                            char[] cArray2 = m_Area[y + 1];
                            int n2 = x + 1;
                            cArray2[n2] = (char)(cArray2[n2] + '\u0001');
                            continue block9;
                        }
                        case 1: {
                            char[] cArray = m_Area[y];
                            int n = x + 1;
                            cArray[n] = (char)(cArray[n] + '\u0001');
                            char[] cArray3 = m_Area[y + 1];
                            int n3 = x + 1;
                            cArray3[n3] = (char)(cArray3[n3] + '\u0001');
                            continue block9;
                        }
                        case 2: {
                            char[] cArray = m_Area[y];
                            int n = x;
                            cArray[n] = (char)(cArray[n] + '\u0001');
                            char[] cArray4 = m_Area[y];
                            int n4 = x + 1;
                            cArray4[n4] = (char)(cArray4[n4] + '\u0001');
                            continue block9;
                        }
                        case 3: {
                            char[] cArray = m_Area[y];
                            int n = x;
                            cArray[n] = (char)(cArray[n] + '\u0001');
                            char[] cArray5 = m_Area[y + 1];
                            int n5 = x;
                            cArray5[n5] = (char)(cArray5[n5] + '\u0001');
                        }
                    }
                }
            }
            boolean doRecurse = false;
            for (i = 0; i < 4; ++i) {
                if ((goStack[iStack] & goDir[i]) == 0) continue;
                if (doRecurse) {
                    goTemp = (char)(goTemp | goDir[i]);
                    continue;
                }
                goTemp = '\u0000';
                doRecurse = true;
                xStack[iStack] = x;
                yStack[iStack] = y;
                x += xTo[i];
                y += yTo[i];
            }
            if (doRecurse) {
                goStack[iStack++] = goTemp;
                continue;
            }
            if (iStack <= 0) continue;
            x = xStack[--iStack];
            y = yStack[iStack];
        } while (iStack > 0);
    }

    private static Feature Discrete_Area(GridWrapperNotInterpolated gwrapper, FeatureSchema featSchema, String attributeName, int x, int y, int ID, int band) {
        int i;
        boolean bContinue;
        int[] xTo = new int[]{0, 1, 0, -1};
        int[] yTo = new int[]{1, 0, -1, 0};
        int[] xLock = new int[]{0, 0, -1, -1};
        int[] yLock = new int[]{0, -1, -1, 0};
        double xMin = gwrapper.getGridExtent().getXMin();
        double yMax = gwrapper.getGridExtent().getYMax();
        double dCellSizeX = gwrapper.getCellSize().x;
        double dCellSizeY = gwrapper.getCellSize().y;
        double xFirst = 0.0;
        double yFirst = 0.0;
        ArrayList<Coordinate> coordinates = new ArrayList<Coordinate>();
        BasicFeature feature = new BasicFeature(featSchema);
        feature.setAttribute(1, (Object)ID);
        feature.setAttribute(2, (Object)gwrapper.getCellValueAsDouble(x, y, band));
        xFirst = xMin + (double)x * dCellSizeX;
        yFirst = yMax - (double)y * dCellSizeY;
        coordinates.add(new Coordinate(xFirst, yFirst));
        int iStart = 0;
        boolean bStart = true;
        block0: do {
            int iy1;
            int ix1;
            int iy;
            int ix;
            coordinates.add(new Coordinate(xMin + (double)x * dCellSizeX, yMax - (double)y * dCellSizeY));
            VectorizeAlgorithm.m_Area[y][x] = '\u0000';
            bContinue = false;
            if (bStart) {
                for (i = 0; i < 4; ++i) {
                    ix = x + xTo[i];
                    iy = y + yTo[i];
                    if (ix < 0 || ix > m_iNX || iy < 0 || iy > m_iNY || m_Area[iy][ix] <= '\u0000') continue;
                    ix1 = x + xLock[i];
                    iy1 = y + yLock[i];
                    if (ix1 < 0 || ix1 > m_iNX || iy1 < 0 || iy1 > m_iNY || m_Lock[iy1][ix1] != ID) continue;
                    x = ix;
                    y = iy;
                    iStart = (i + 3) % 4;
                    bContinue = true;
                    bStart = false;
                    continue block0;
                }
            } else {
                for (i = iStart; i < iStart + 4; ++i) {
                    int dir = i % 4;
                    ix = x + xTo[dir];
                    iy = y + yTo[dir];
                    if (ix < 0 || ix > m_iNX || iy < 0 || iy > m_iNY || m_Area[iy][ix] <= '\u0000') continue;
                    if (i < iStart + 3) {
                        ix1 = x + xLock[dir];
                        iy1 = y + yLock[dir];
                        if (ix1 < 0 || ix1 > m_iNX || iy1 < 0 || iy1 > m_iNY || m_Lock[iy1][ix1] != ID) continue;
                        x = ix;
                        y = iy;
                        iStart = (i + 3) % 4;
                        bContinue = true;
                        continue block0;
                    }
                    x = ix;
                    y = iy;
                    bContinue = true;
                    iStart = (i + 3) % 4;
                    continue block0;
                }
            }
        } while (bContinue);
        coordinates.add(new Coordinate(xFirst, yFirst));
        Coordinate[] coords = new Coordinate[coordinates.size()];
        for (i = 0; i < coords.length; ++i) {
            coords[i] = (Coordinate)coordinates.get(i);
        }
        GeometryFactory gf = new GeometryFactory();
        if (coords.length > 1) {
            LinearRing ring = gf.createLinearRing(coords);
            Polygon polyg = gf.createPolygon(ring, null);
            feature.setGeometry((Geometry)polyg);
        }
        return feature;
    }

    public FeatureCollection toContours(GridWrapperNotInterpolated gwrapper, double zMin, double zMax, double dDistance, String attributeName, int band) {
        FeatureDataset featColl = new FeatureDataset(VectorizeAlgorithm.schema(attributeName));
        int iNX = gwrapper.getGridExtent().getNX();
        int iNY = gwrapper.getGridExtent().getNY();
        this.m_Row = new char[iNY][iNX];
        this.m_Col = new char[iNY][iNX];
        if (dDistance <= 0.0) {
            dDistance = 1.0;
        }
        int ID = 0;
        for (double dZ = zMin; dZ <= zMax; dZ += dDistance) {
            int x;
            int y;
            for (y = 0; y < iNY - 1; ++y) {
                for (x = 0; x < iNX - 1; ++x) {
                    double dValue = gwrapper.getCellValueAsDouble(x, y, band);
                    if (dValue >= dZ) {
                        this.m_Row[y][x] = (char)(gwrapper.getCellValueAsDouble(x + 1, y, band) < dZ ? 1 : 0);
                        this.m_Col[y][x] = (char)(gwrapper.getCellValueAsDouble(x, y + 1, band) < dZ ? 1 : 0);
                        continue;
                    }
                    this.m_Row[y][x] = (char)(gwrapper.getCellValueAsDouble(x + 1, y, band) >= dZ ? 1 : 0);
                    this.m_Col[y][x] = (char)(gwrapper.getCellValueAsDouble(x, y + 1, band) >= dZ ? 1 : 0);
                }
            }
            for (y = 0; y < iNY - 1; ++y) {
                for (x = 0; x < iNX - 1; ++x) {
                    Feature feat;
                    int i;
                    if (this.m_Row[y][x] != '\u0000') {
                        for (i = 0; i < 2; ++i) {
                            if (!(feat = this.findContour(gwrapper, x, y, dZ, true, ID++, attributeName, band)).getGeometry().getGeometryType().equals("LineString") && !feat.getGeometry().getGeometryType().equals("LineString")) continue;
                            featColl.add(feat);
                        }
                        this.m_Row[y][x] = '\u0000';
                    }
                    if (this.m_Col[y][x] == '\u0000') continue;
                    for (i = 0; i < 2; ++i) {
                        if (!(feat = this.findContour(gwrapper, x, y, dZ, false, ID++, attributeName, band)).getGeometry().getGeometryType().equals("LineString") && !feat.getGeometry().getGeometryType().equals("LineString")) continue;
                        featColl.add(feat);
                    }
                    this.m_Col[y][x] = '\u0000';
                }
            }
        }
        System.gc();
        return featColl;
    }

    public FeatureCollection toLines(GridWrapperNotInterpolated gwrapper, String attributeName) {
        int x;
        int y;
        FeatureSchema featSchema = new FeatureSchema();
        featSchema.addAttribute("GEOMETRY", AttributeType.GEOMETRY);
        featSchema.addAttribute(attributeName, AttributeType.DOUBLE);
        FeatureDataset featColl = new FeatureDataset(featSchema);
        this.m_Visited.create("a", "a", gwrapper.getGridExtent(), 5, 1, null, frame.getContext().getLayerManager());
        this.m_Visited2.create("b", "b", gwrapper.getGridExtent(), 5, 1, null, frame.getContext().getLayerManager());
        int iNX = gwrapper.getGridExtent().getNX();
        int iNY = gwrapper.getGridExtent().getNY();
        for (y = 0; y < m_iNY; ++y) {
            for (x = 0; x < m_iNX; ++x) {
                double dValue = gwrapper.getCellValueAsDouble(x, y);
                if (gwrapper.isNoDataValue(dValue) || dValue == 0.0) {
                    this.m_Visited.setCellValue(x, y, 0.0);
                    continue;
                }
                this.m_Visited.setCellValue(x, y, 1.0);
            }
        }
        for (y = 0; y < iNY; ++y) {
            for (x = 0; x < iNX; ++x) {
                double byValue = this.m_Visited.getCellValueAsDouble(x, y);
                if (byValue != 1.0) continue;
                Feature feat = this.createLine(x, y, this.m_Visited.getWindowGridExtent().getWorldCoordsFromGridCoords(x, y), gwrapper, featSchema);
                featColl.add(feat);
            }
        }
        return featColl;
    }

    private Feature createLine(int x, int y, Point2D pt2d2, GridWrapperNotInterpolated gwrapper, FeatureSchema featSchema) {
        GeometryFactory m_GeometryFactory = new GeometryFactory();
        boolean bContinue = false;
        boolean bIsNotNull = false;
        Object[] values = new Object[1];
        BasicFeature feature = new BasicFeature(featSchema);
        ArrayList<Coordinate> coordinates = new ArrayList<Coordinate>();
        coordinates.add(new Coordinate(pt2d2.getX(), pt2d2.getY()));
        pt2d2 = this.m_Visited.getWindowGridExtent().getWorldCoordsFromGridCoords(x, y);
        coordinates.add(new Coordinate(pt2d2.getX(), pt2d2.getY()));
        do {
            int i;
            java.awt.Point pt;
            LineString line;
            Coordinate[] coords;
            this.m_Visited.setCellValue(x, y, 0, 0.0);
            ArrayList<java.awt.Point> cells = this.getSurroundingLineCells(x, y, gwrapper);
            this.m_Visited2.setCellValue(x, y, 0, cells.size());
            if (cells.size() == 0) {
                coords = new Coordinate[coordinates.size()];
                for (int i2 = 0; i2 < coords.length; ++i2) {
                    coords[i2] = (Coordinate)coordinates.get(i2);
                }
                line = m_GeometryFactory.createLineString(coords);
                values[0] = m_iLine++;
                feature.setGeometry((Geometry)line);
                feature.setAttribute(1, values[0]);
                bContinue = false;
                continue;
            }
            if (cells.size() == 1) {
                pt = cells.get(0);
                pt2d2 = this.m_Visited.getWindowGridExtent().getWorldCoordsFromGridCoords(pt.x, pt.y);
                coordinates.add(new Coordinate(pt2d2.getX(), pt2d2.getY()));
                x = pt.x;
                y = pt.y;
                bContinue = true;
                bIsNotNull = true;
                continue;
            }
            if (bIsNotNull) {
                coords = new Coordinate[coordinates.size()];
                for (int i3 = 0; i3 < coords.length; ++i3) {
                    coords[i3] = (Coordinate)coordinates.get(i3);
                }
                line = m_GeometryFactory.createLineString(coords);
                values[0] = m_iLine++;
                feature.setGeometry((Geometry)line);
                feature.setAttribute(1, values[0]);
            }
            for (i = 0; i < cells.size(); ++i) {
                pt = cells.get(i);
                this.m_Visited.setCellValue(pt.x, pt.y, 0, 0.0);
            }
            for (i = 0; i < cells.size(); ++i) {
                pt = cells.get(i);
                pt2d2 = this.m_Visited.getWindowGridExtent().getWorldCoordsFromGridCoords(x, y);
                this.createLine(pt.x, pt.y, pt2d2, gwrapper, featSchema);
            }
        } while (bContinue);
        return feature;
    }

    private ArrayList<java.awt.Point> getSurroundingLineCells(int x, int y, GridWrapperNotInterpolated gwrapper) {
        int i;
        ArrayList<java.awt.Point> cells = new ArrayList<java.awt.Point>();
        boolean[] bBlocked = new boolean[4];
        for (i = 0; i < 4; ++i) {
            if (this.m_Visited.getCellValueAsByte(x + this.m_iOffsetX[i], y + this.m_iOffsetY[i]) != 1) continue;
            cells.add(new java.awt.Point(x + this.m_iOffsetX[i], y + this.m_iOffsetY[i]));
            bBlocked[i] = true;
            bBlocked[(i + 1) % 4] = true;
        }
        for (i = 0; i < 4; ++i) {
            if (this.m_Visited.getCellValueAsByte(x + this.m_iOffsetXDiag[i], y + this.m_iOffsetYDiag[i]) != 1 || bBlocked[i]) continue;
            cells.add(new java.awt.Point(x + this.m_iOffsetXDiag[i], y + this.m_iOffsetYDiag[i]));
        }
        return cells;
    }

    private Feature findContour(GridWrapperNotInterpolated gwrapper, int x, int y, double z, boolean doRow, int ID, String attribueName, int band) {
        BasicFeature feature = new BasicFeature(VectorizeAlgorithm.schema(attribueName));
        boolean doContinue = true;
        int zx = doRow ? x + 1 : x;
        int zy = doRow ? y : y + 1;
        double xMin = gwrapper.getGridExtent().getXMin();
        double yMax = gwrapper.getGridExtent().getYMax();
        Object[] values = new Object[1];
        NextContourInfo info = new NextContourInfo();
        ArrayList<Coordinate> coords = new ArrayList<Coordinate>();
        info.x = x;
        info.y = y;
        info.iDir = 0;
        info.doRow = doRow;
        do {
            double d = gwrapper.getCellValueAsDouble(info.x, info.y, band);
            d = (d - z) / (d - gwrapper.getCellValueAsDouble(zx, zy, band));
            double xPos = xMin + gwrapper.getGridExtent().getCellSize().x * ((double)info.x + d * (double)(zx - info.x) + 0.5);
            double yPos = yMax - gwrapper.getGridExtent().getCellSize().y * ((double)info.y + d * (double)(zy - info.y) + 0.5);
            coords.add(new Coordinate(xPos, yPos));
            if (!this.findNextContour(info)) {
                doContinue = this.findNextContour(info);
            }
            info.iDir = (info.iDir + 5) % 8;
            if (info.doRow) {
                this.m_Row[info.y][info.x] = '\u0000';
                zx = info.x + 1;
                zy = info.y;
                continue;
            }
            this.m_Col[info.y][info.x] = '\u0000';
            zx = info.x;
            zy = info.y + 1;
        } while (doContinue);
        values[0] = z;
        Coordinate[] coordinates = new Coordinate[coords.size()];
        for (int i = 0; i < coordinates.length; ++i) {
            coordinates[i] = (Coordinate)coords.get(i);
        }
        if (coordinates.length > 1) {
            LineString line = this.m_GF.createLineString(coordinates);
            feature.setGeometry((Geometry)line);
            feature.setAttribute(1, values[0]);
        } else if (coordinates.length == 1) {
            Point point = this.m_GF.createPoint(coordinates[0]);
            feature.setGeometry((Geometry)point);
            feature.setAttribute(1, values[0]);
        } else if (coordinates.length == 0) {
            GeometryCollection gc = this.m_GF.createGeometryCollection(new Geometry[0]);
            feature.setGeometry((Geometry)gc);
            feature.setAttribute(1, values[0]);
        }
        return feature;
    }

    private static FeatureSchema schema(String attributeName) {
        FeatureSchema featSchema = new FeatureSchema();
        featSchema.addAttribute("GEOMETRY", AttributeType.GEOMETRY);
        featSchema.addAttribute(attributeName, AttributeType.DOUBLE);
        return featSchema;
    }

    private boolean findNextContour(NextContourInfo info) {
        boolean doContinue;
        if (info.doRow) {
            switch (info.iDir) {
                case 0: {
                    if (this.m_Row[info.y + 1][info.x] != '\u0000') {
                        ++info.y;
                        info.iDir = 0;
                        doContinue = true;
                        break;
                    }
                }
                case 1: {
                    if (this.m_Col[info.y][info.x + 1] != '\u0000') {
                        ++info.x;
                        info.iDir = 1;
                        info.doRow = false;
                        doContinue = true;
                        break;
                    }
                }
                case 2: 
                case 3: {
                    if (info.y - 1 >= 0 && this.m_Col[info.y - 1][info.x + 1] != '\u0000') {
                        ++info.x;
                        --info.y;
                        info.doRow = false;
                        info.iDir = 3;
                        doContinue = true;
                        break;
                    }
                }
                case 4: {
                    if (info.y - 1 >= 0 && this.m_Row[info.y - 1][info.x] != '\u0000') {
                        --info.y;
                        info.iDir = 4;
                        doContinue = true;
                        break;
                    }
                }
                case 5: {
                    if (info.y - 1 >= 0 && this.m_Col[info.y - 1][info.x] != '\u0000') {
                        --info.y;
                        info.doRow = false;
                        info.iDir = 5;
                        doContinue = true;
                        break;
                    }
                }
                case 6: 
                case 7: {
                    if (this.m_Col[info.y][info.x] != '\u0000') {
                        info.doRow = false;
                        info.iDir = 7;
                        doContinue = true;
                        break;
                    }
                }
                default: {
                    info.iDir = 0;
                    doContinue = false;
                    break;
                }
            }
        } else {
            switch (info.iDir) {
                case 0: 
                case 1: {
                    if (this.m_Row[info.y + 1][info.x] != '\u0000') {
                        ++info.y;
                        info.doRow = true;
                        info.iDir = 1;
                        doContinue = true;
                        break;
                    }
                }
                case 2: {
                    if (this.m_Col[info.y][info.x + 1] != '\u0000') {
                        ++info.x;
                        info.iDir = 2;
                        doContinue = true;
                        break;
                    }
                }
                case 3: {
                    if (this.m_Row[info.y][info.x] != '\u0000') {
                        info.doRow = true;
                        info.iDir = 3;
                        doContinue = true;
                        break;
                    }
                }
                case 4: 
                case 5: {
                    if (info.x - 1 >= 0 && this.m_Row[info.y][info.x - 1] != '\u0000') {
                        --info.x;
                        info.doRow = true;
                        info.iDir = 5;
                        doContinue = true;
                        break;
                    }
                }
                case 6: {
                    if (info.x - 1 >= 0 && this.m_Col[info.y][info.x - 1] != '\u0000') {
                        --info.x;
                        info.iDir = 6;
                        doContinue = true;
                        break;
                    }
                }
                case 7: {
                    if (info.x - 1 >= 0 && this.m_Row[info.y + 1][info.x - 1] != '\u0000') {
                        --info.x;
                        ++info.y;
                        info.doRow = true;
                        info.iDir = 7;
                        doContinue = true;
                        break;
                    }
                }
                default: {
                    info.iDir = 0;
                    doContinue = false;
                }
            }
        }
        return doContinue;
    }

    public FeatureCollection toGridPoint(GridWrapperNotInterpolated gwrapper, int numBands) {
        FeatureSchema fs = new FeatureSchema();
        fs.addAttribute("geometry", AttributeType.GEOMETRY);
        fs.addAttribute("cellid_x", AttributeType.INTEGER);
        fs.addAttribute("cellid_y", AttributeType.INTEGER);
        for (int i = 0; i < numBands; ++i) {
            fs.addAttribute("band_" + i, AttributeType.DOUBLE);
        }
        FeatureDataset fd = new FeatureDataset(fs);
        int nx = gwrapper.getGridExtent().getNX();
        int ny = gwrapper.getGridExtent().getNY();
        for (int x = 0; x < nx; ++x) {
            for (int y = 0; y < ny; ++y) {
                BasicFeature ftemp = new BasicFeature(fs);
                Point2D pt = gwrapper.getGridExtent().getWorldCoordsFromGridCoords(x, y);
                Point centerPoint = this.m_GF.createPoint(new Coordinate(pt.getX(), pt.getY()));
                ftemp.setGeometry((Geometry)centerPoint);
                for (int i = 0; i < numBands; ++i) {
                    double value = gwrapper.getCellValueAsDouble(x, y, i);
                    ftemp.setAttribute("band_" + i, (Object)value);
                }
                ftemp.setAttribute("cellid_x", (Object)x);
                ftemp.setAttribute("cellid_y", (Object)y);
                fd.add(ftemp);
            }
        }
        return fd;
    }

    public FeatureCollection toPoint(GridWrapperNotInterpolated gwrapper, int band) {
        FeatureSchema fs = new FeatureSchema();
        fs.addAttribute("geometry", AttributeType.GEOMETRY);
        fs.addAttribute("value", AttributeType.DOUBLE);
        FeatureDataset fd = new FeatureDataset(fs);
        int nx = gwrapper.getGridExtent().getNX();
        int ny = gwrapper.getGridExtent().getNY();
        double noData = gwrapper.getNoDataValue();
        for (int x = 0; x < nx; ++x) {
            for (int y = 0; y < ny; ++y) {
                double value = gwrapper.getCellValueAsDouble(x, y, band);
                if (value == noData) continue;
                BasicFeature ftemp = new BasicFeature(fs);
                Point2D pt = gwrapper.getGridExtent().getWorldCoordsFromGridCoords(x, y);
                Point centerPoint = this.m_GF.createPoint(new Coordinate(pt.getX(), pt.getY()));
                ftemp.setGeometry((Geometry)centerPoint);
                fd.add(ftemp);
            }
        }
        return fd;
    }

    public FeatureCollection toGridPolygon(GridWrapperNotInterpolated gwrapper, int maxCells, int numBands) {
        FeatureSchema fs = new FeatureSchema();
        fs.addAttribute("geometry", AttributeType.GEOMETRY);
        for (int i = 0; i < numBands; ++i) {
            fs.addAttribute("band_" + i, AttributeType.DOUBLE);
        }
        FeatureDataset fd = new FeatureDataset(fs);
        int nx = gwrapper.getGridExtent().getNX();
        int ny = gwrapper.getGridExtent().getNY();
        double halfCellDimX = 0.5 * gwrapper.getGridExtent().getCellSize().x;
        double halfCellDimY = 0.5 * gwrapper.getGridExtent().getCellSize().y;
        for (int x = 0; x < nx; ++x) {
            for (int y = 0; y < ny; ++y) {
                Coordinate[] coords;
                BasicFeature ftemp = new BasicFeature(fs);
                Point2D pt = gwrapper.getGridExtent().getWorldCoordsFromGridCoords(x, y);
                coords = new Coordinate[]{new Coordinate(pt.getX() - halfCellDimX, pt.getY() + halfCellDimY), new Coordinate(pt.getX() + halfCellDimX, pt.getY() + halfCellDimY), new Coordinate(pt.getX() + halfCellDimX, pt.getY() - halfCellDimY), new Coordinate(pt.getX() - halfCellDimX, pt.getY() - halfCellDimY), (Coordinate)coords[0].clone()};
                LinearRing lr = this.m_GF.createLinearRing(coords);
                Polygon poly = this.m_GF.createPolygon(lr, null);
                ftemp.setGeometry((Geometry)poly);
                double sumvalue = 0.0;
                for (int i = 0; i < numBands; ++i) {
                    double value = gwrapper.getCellValueAsDouble(x, y, i);
                    ftemp.setAttribute("band_" + i, (Object)value);
                    sumvalue += value;
                }
                if (this.removeZeroCells) {
                    if (!(sumvalue > 0.0)) continue;
                    fd.add(ftemp);
                    continue;
                }
                fd.add(ftemp);
            }
        }
        return fd;
    }

    public static FeatureCollection toPolygons(GridWrapperNotInterpolated gwrapper, boolean explodeMultipolygons, String attributeName, int band) {
        FeatureSchema featSchema = new FeatureSchema();
        featSchema.addAttribute("GEOMETRY", AttributeType.GEOMETRY);
        featSchema.addAttribute("ID", AttributeType.INTEGER);
        featSchema.addAttribute(attributeName, AttributeType.DOUBLE);
        return VectorizeAlgorithm.toPolygonsAdbToolBox(gwrapper, explodeMultipolygons, attributeName, band);
    }

    public static void main(String[] args) {
        int r;
        int c;
        BooleanMatrix m = new BooleanMatrix(640, 480);
        for (c = 0; c < 640; ++c) {
            for (r = 0; r < 480; ++r) {
                if (!m.isSet(r, c)) continue;
                System.out.println("ERROR");
            }
        }
        m.set(37, 19);
        m.unset(37, 19);
        for (c = 0; c < 640; ++c) {
            for (r = 0; r < 480; ++r) {
                if (!m.isSet(r, c)) continue;
                System.out.println("" + r + " - " + c);
            }
        }
    }

    static {
        gf = new GeometryFactory();
        m_iLine = 1;
    }

    private static class NextContourInfo {
        public int iDir;
        public int x;
        public int y;
        public boolean doRow;

        private NextContourInfo() {
        }
    }

    static class BooleanMatrix {
        int width;
        int height;
        long[] array;

        BooleanMatrix(int width, int height) {
            this.width = width;
            this.height = height;
            double length = Math.ceil((double)width * (double)height / 64.0);
            this.array = new long[(int)length];
        }

        void set(int row, int col) {
            long index = (long)row * (long)this.width + (long)col;
            int n = (int)(index / 64L);
            this.array[n] = this.array[n] | 1L << (int)(index % 64L);
        }

        void unset(int row, int col) {
            long index = (long)row * (long)this.width + (long)col;
            int n = (int)(index / 64L);
            this.array[n] = this.array[n] & (1L << (int)(index % 64L) ^ 0xFFFFFFFFFFFFFFFFL);
        }

        boolean isSet(int row, int col) {
            long index = (long)row * (long)this.width + (long)col;
            return (this.array[(int)(index / 64L)] & 1L << (int)(index % 64L)) == 1L << (int)(index % 64L);
        }
    }

    static class Segment {
        double x0;
        double y0;
        double x1;
        double y1;

        Segment(double x0, double y0, double x1, double y1) {
            this.x0 = x0;
            this.y0 = y0;
            this.x1 = x1;
            this.y1 = y1;
        }

        Geometry toGeometry(GeometryFactory gf) {
            return gf.createLineString(new Coordinate[]{new Coordinate(this.x0, this.y0), new Coordinate(this.x1, this.y1)});
        }

        public boolean equals(Object o) {
            if (o instanceof Segment) {
                Segment s = (Segment)o;
                return this.x0 == s.x0 && this.y0 == s.y0 && this.x1 == s.x1 && this.y1 == s.y1;
            }
            return false;
        }

        public int hashCode() {
            int result = 17;
            result = 37 * result + Coordinate.hashCode((double)this.x0);
            result = 37 * result + Coordinate.hashCode((double)this.y0);
            result = 37 * result + Coordinate.hashCode((double)this.x1);
            result = 37 * result + Coordinate.hashCode((double)this.y1);
            return result;
        }
    }

    static class Cell {
        public int col;
        public int row;

        Cell(int col, int row) {
            this.col = col;
            this.row = row;
        }

        public boolean equals(Object o) {
            if (o instanceof Cell) {
                Cell cell = (Cell)o;
                return this.col == cell.col && this.row == cell.row;
            }
            return false;
        }

        public int hashCode() {
            int result = 17;
            result = 37 * result + this.col;
            result = 37 * result + this.row;
            return result;
        }

        public String toString() {
            return "(" + this.col + "," + this.row + ")";
        }
    }

    static class Face {
        double value;
        Set<Segment> limits;
        Set<Cell> cells;

        Face(double value) {
            this.value = value;
            this.cells = new HashSet<Cell>();
            this.limits = new HashSet<Segment>();
        }
    }
}

