/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.rasterimage;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.util.Blackboard;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.datasource.LoadFileDataSourceQueryChooser;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import com.vividsolutions.jump.workbench.ui.InputChangedListener;
import com.vividsolutions.jump.workbench.ui.plugin.PersistentBlackboardPlugIn;
import com.vividsolutions.jump.workbench.ui.wizard.WizardDialog;
import com.vividsolutions.jump.workbench.ui.wizard.WizardPanel;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.filechooser.FileFilter;
import org.openjump.core.ui.plugin.file.open.JFCWithEnterAction;
import org.openjump.swing.listener.InvokeMethodActionListener;

public class SelectRasterImageFilesPanel
extends JFCWithEnterAction
implements WizardPanel {
    public static final String KEY = SelectRasterImageFilesPanel.class.getName();
    public static final String FILE_CHOOSER_DIRECTORY_KEY = LoadFileDataSourceQueryChooser.class.getName() + " - FILE CHOOSER DIRECTORY";
    public static final String TITLE = I18N.getInstance().get("org.openjump.core.rasterimage.SelectRasterImageFilesPanel.Select-Raster-Image");
    public static final String INSTRUCTIONS = I18N.getInstance().get("org.openjump.core.ui.plugin.file.open.SelectFileOptionsPanel.instructions");
    public static final String ALL_FILES = I18N.getInstance().get("org.openjump.core.ui.plugin.file.open.SelectFilesPanel.all-files");
    private final Set<InputChangedListener> listeners = new LinkedHashSet<InputChangedListener>();
    private Blackboard blackboard;
    private ActionListener dialogActionListener;

    public SelectRasterImageFilesPanel(final WorkbenchContext context) {
        this.setDialogType(0);
        if (PersistentBlackboardPlugIn.get(context).get(FILE_CHOOSER_DIRECTORY_KEY) != null) {
            this.setCurrentDirectory(new File((String)PersistentBlackboardPlugIn.get(context).get(FILE_CHOOSER_DIRECTORY_KEY)));
        }
        this.setFileSelectionMode(0);
        this.setMultiSelectionEnabled(true);
        GUIUtil.removeChoosableFileFilters(this);
        FileFilter JAI_IMAGE_FILE_FILTER = GUIUtil.createFileFilter(I18N.getInstance().get("org.openjump.core.rasterimage.SelectRasterImageFilesPanel.supported-raster-image-formats"), new String[]{"tif", "tiff", "gif", "jpg", "jp2", "png", "flt", "bmp", "asc", "txt"});
        this.addChoosableFileFilter(JAI_IMAGE_FILE_FILTER);
        this.addChoosableFileFilter(GUIUtil.ALL_FILES_FILTER);
        this.setFileFilter(JAI_IMAGE_FILE_FILTER);
        this.setControlButtonsAreShown(false);
        this.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                PersistentBlackboardPlugIn.get(context).put(FILE_CHOOSER_DIRECTORY_KEY, SelectRasterImageFilesPanel.this.getCurrentDirectory().toString());
                SelectRasterImageFilesPanel.this.fireInputChanged();
            }
        });
    }

    public void setDialog(WizardDialog dialog) {
        this.removeActionListener(this.dialogActionListener);
        this.dialogActionListener = new InvokeMethodActionListener(dialog, "next");
        this.addActionListener(this.dialogActionListener);
    }

    public void enteredFromLeft(Map dataMap) {
        this.rescanCurrentDirectory();
    }

    @Override
    public void exitingToRight() throws Exception {
    }

    @Override
    public String getID() {
        return this.getClass().getName();
    }

    @Override
    public String getInstructions() {
        return INSTRUCTIONS;
    }

    @Override
    public String getNextID() {
        return null;
    }

    @Override
    public String getTitle() {
        return TITLE;
    }

    @Override
    public boolean isInputValid() {
        return this.getSelectedFile() != null;
    }

    @Override
    public void add(InputChangedListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void remove(InputChangedListener listener) {
        this.listeners.remove(listener);
    }

    private void fireInputChanged() {
        for (InputChangedListener listener : this.listeners) {
            listener.inputChanged();
        }
    }
}

