/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.rasterimage;

import com.sun.media.jai.codec.FileSeekableStream;
import com.sun.media.jai.codec.ImageEncodeParam;
import com.sun.media.jai.codec.SeekableStream;
import com.sun.media.jai.codec.TIFFDirectory;
import com.sun.media.jai.codec.TIFFEncodeParam;
import com.sun.media.jai.codec.TIFFField;
import com.sun.media.jai.codecimpl.TIFFCodec;
import com.sun.media.jai.codecimpl.TIFFImageEncoder;
import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.ui.Viewport;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferFloat;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.awt.image.renderable.ParameterBlock;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.imageio.ImageIO;
import javax.media.jai.JAI;
import javax.media.jai.PlanarImage;
import javax.media.jai.RasterFactory;
import javax.media.jai.RenderedOp;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import org.apache.commons.imaging.Imaging;
import org.apache.commons.imaging.ImagingException;
import org.apache.commons.imaging.formats.tiff.TiffField;
import org.apache.commons.imaging.formats.tiff.fieldtypes.FieldTypeAscii;
import org.apache.commons.imaging.formats.tiff.fieldtypes.FieldTypeDouble;
import org.apache.commons.imaging.formats.tiff.fieldtypes.FieldTypeFloat;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.openjump.core.ccordsys.utils.SRSInfo;
import org.openjump.core.rasterimage.GDALPamDataset;
import org.openjump.core.rasterimage.GridAscii;
import org.openjump.core.rasterimage.GridFloat;
import org.openjump.core.rasterimage.ImageAndMetadata;
import org.openjump.core.rasterimage.Metadata;
import org.openjump.core.rasterimage.Resolution;
import org.openjump.core.rasterimage.Stats;
import org.openjump.core.rasterimage.TiffTags;
import org.openjump.core.rasterimage.TiffUtilsV2;
import org.openjump.core.rasterimage.WorldFileHandler;
import org.xml.sax.SAXException;

public class RasterImageIO {
    public ImageAndMetadata loadImage(String fileNameOrURL, Stats stats, Envelope viewPortEnvelope, Resolution requestedRes) throws Exception {
        if (fileNameOrURL.toLowerCase().endsWith(".jpg") || fileNameOrURL.toLowerCase().endsWith(".gif") || fileNameOrURL.toLowerCase().endsWith(".png") || fileNameOrURL.toLowerCase().endsWith(".bmp") || fileNameOrURL.toLowerCase().endsWith(".jp2")) {
            BufferedImage bImage;
            try {
                bImage = ImageIO.read(new File(fileNameOrURL));
            }
            catch (Exception ex) {
                bImage = JAI.create((String)"fileload", (Object)fileNameOrURL).getAsBufferedImage();
            }
            if (stats == null) {
                int b;
                ParameterBlock pb = new ParameterBlock();
                pb.addSource(bImage);
                pb.add(null);
                pb.add(1);
                pb.add(1);
                RenderedOp meanImage = JAI.create((String)"mean", (ParameterBlock)pb, null);
                double[] mean = (double[])meanImage.getProperty("mean");
                int nCols = bImage.getWidth();
                int nRows = bImage.getHeight();
                int nBands = bImage.getData().getNumBands();
                long nCells = nCols * nRows;
                double[] stdDev = new double[nBands];
                DataBuffer dataBuffer = bImage.getData().getDataBuffer();
                for (int r = 0; r < nRows; ++r) {
                    for (int c = 0; c < nCols; ++c) {
                        b = 0;
                        while (b < nBands) {
                            double val = Math.pow(dataBuffer.getElemDouble(b) - mean[b], 2.0);
                            int n = b++;
                            stdDev[n] = stdDev[n] + val;
                        }
                    }
                }
                for (int b2 = 0; b2 < nBands; ++b2) {
                    stdDev[b2] = Math.sqrt(stdDev[b2] / (double)nCells);
                }
                pb = new ParameterBlock();
                pb.addSource(bImage);
                RenderedOp op = JAI.create((String)"extrema", (ParameterBlock)pb);
                double[][] extrema = (double[][])op.getProperty("extrema");
                stats = new Stats(nBands);
                for (b = 0; b < nBands; ++b) {
                    stats.setStatsForBand(b, extrema[0][b], extrema[1][b], mean[b], stdDev[b]);
                }
            }
            Envelope envelope = RasterImageIO.getGeoReferencing(fileNameOrURL, true, new Point(bImage.getWidth(), bImage.getHeight()));
            double cellSize = (envelope.getMaxX() - envelope.getMinX()) / (double)bImage.getWidth();
            return new ImageAndMetadata(bImage, new Metadata(envelope, envelope, new Point(bImage.getWidth(), bImage.getHeight()), new Point(bImage.getWidth(), bImage.getHeight()), cellSize, cellSize, Double.NaN, stats));
        }
        if (fileNameOrURL.toLowerCase().endsWith(".tif") || fileNameOrURL.toLowerCase().endsWith(".tiff")) {
            File tiffFile = new File(fileNameOrURL);
            return TiffUtilsV2.readImageAndMetadata(tiffFile, viewPortEnvelope, requestedRes, stats);
        }
        if (fileNameOrURL.toLowerCase().endsWith(".flt")) {
            GridFloat gf = new GridFloat(fileNameOrURL);
            gf.readGrid(null);
            Envelope imageEnvelope = new Envelope(gf.getXllCorner(), gf.getXllCorner() + (double)gf.getnCols() * gf.getCellSize(), gf.getYllCorner(), gf.getYllCorner() + (double)gf.getnRows() * gf.getCellSize());
            stats = new Stats(1);
            stats.setStatsForBand(0, gf.getMinVal(), gf.getMaxVal(), gf.getMeanVal(), gf.getStDevVal());
            return new ImageAndMetadata(gf.getBufferedImage(), new Metadata(imageEnvelope, imageEnvelope, new Point(gf.getnCols(), gf.getnRows()), new Point(gf.getnCols(), gf.getnRows()), gf.getCellSize(), gf.getCellSize(), gf.getNoData(), stats));
        }
        if (fileNameOrURL.toLowerCase().endsWith(".asc") || fileNameOrURL.toLowerCase().endsWith(".txt")) {
            GridAscii ga = new GridAscii(fileNameOrURL);
            ga.readGrid(null);
            Envelope imageEnvelope = new Envelope(ga.getXllCorner(), ga.getXllCorner() + (double)ga.getnCols() * ga.getCellSize(), ga.getYllCorner(), ga.getYllCorner() + (double)ga.getnRows() * ga.getCellSize());
            BufferedImage pImage = ga.getBufferedImage();
            stats = new Stats(1);
            stats.setStatsForBand(0, ga.getMinVal(), ga.getMaxVal(), ga.getMeanVal(), ga.getStDevVal());
            return new ImageAndMetadata(pImage, new Metadata(imageEnvelope, imageEnvelope, new Point(ga.getnCols(), ga.getnRows()), new Point(ga.getnCols(), ga.getnRows()), ga.getCellSize(), ga.getCellSize(), ga.getNoData(), stats));
        }
        return null;
    }

    public static Raster loadRasterData(String filenameOrURL, Rectangle subset) throws IOException {
        if (filenameOrURL.toLowerCase().endsWith(".gif") || filenameOrURL.toLowerCase().endsWith(".png")) {
            RenderedOp renderedOp = JAI.create((String)"fileload", (Object)filenameOrURL);
            return renderedOp.getAsBufferedImage(subset, null).getData();
        }
        if (filenameOrURL.toLowerCase().endsWith(".tif") || filenameOrURL.toLowerCase().endsWith(".tiff")) {
            return TiffUtilsV2.getRenderedOp(new File(filenameOrURL)).getAsBufferedImage(subset, null).getData();
        }
        if (filenameOrURL.toLowerCase().endsWith(".jpg") || filenameOrURL.toLowerCase().endsWith(".bmp") || filenameOrURL.toLowerCase().endsWith(".jp2")) {
            BufferedImage bImage;
            try {
                bImage = ImageIO.read(new File(filenameOrURL));
            }
            catch (Exception ex) {
                bImage = JAI.create((String)"fileload", (Object)filenameOrURL).getAsBufferedImage();
            }
            if (subset != null) {
                BufferedImage clipping = new BufferedImage(subset.width, subset.height, bImage.getType());
                Graphics2D area = (Graphics2D)clipping.getGraphics().create();
                area.drawImage(bImage, 0, 0, clipping.getWidth(), clipping.getHeight(), subset.x, subset.y, subset.x + subset.width, subset.y + subset.height, null);
                area.dispose();
                return clipping.getData();
            }
            return bImage.getData();
        }
        if (filenameOrURL.toLowerCase().endsWith(".flt")) {
            GridFloat gf = new GridFloat(filenameOrURL);
            gf.readGrid(subset);
            DataBufferFloat dataBuffer = new DataBufferFloat(gf.getFloatArray(), gf.getFloatArray().length);
            int nCols = gf.getnCols();
            int nRows = gf.getnRows();
            if (subset != null) {
                nCols = subset.width;
                nRows = subset.height;
            }
            return Raster.createWritableRaster(RasterFactory.createBandedSampleModel((int)4, (int)nCols, (int)nRows, (int)1), dataBuffer, new Point(0, 0));
        }
        if (filenameOrURL.toLowerCase().endsWith(".asc") || filenameOrURL.toLowerCase().endsWith(".txt")) {
            GridAscii ga = new GridAscii(filenameOrURL);
            ga.readGrid(subset);
            int nCols = ga.getnCols();
            int nRows = ga.getnRows();
            if (subset != null) {
                nCols = subset.width;
                nRows = subset.height;
            }
            DataBufferFloat dataBuffer = new DataBufferFloat(ga.getFloatArray(), ga.getFloatArray().length);
            return Raster.createWritableRaster(RasterFactory.createBandedSampleModel((int)4, (int)nCols, (int)nRows, (int)1), dataBuffer, new Point(0, 0));
        }
        return null;
    }

    public static Double readCellValue(String fileNameOrURL, Coordinate coordinate, int band) throws Exception {
        Point imageDims = RasterImageIO.getImageDimensions(fileNameOrURL);
        Envelope envelope = RasterImageIO.getGeoReferencing(fileNameOrURL, true, new Point(imageDims.x, imageDims.y));
        double cellSizeX = (envelope.getMaxX() - envelope.getMinX()) / (double)imageDims.x;
        double cellSizeY = (envelope.getMaxY() - envelope.getMinY()) / (double)imageDims.y;
        Point colRow = RasterImageIO.fromCoordinateToCell(coordinate, new Coordinate(envelope.getMinX(), envelope.getMinY()), imageDims.y, cellSizeX, cellSizeY);
        return RasterImageIO.readCellValue(fileNameOrURL, colRow.x, colRow.y, band);
    }

    public static Double readCellValue(String filenameOrURL, int col, int row, int band) throws IOException {
        Rectangle rectangle = new Rectangle(col, row, 1, 1);
        if (filenameOrURL.toLowerCase().endsWith(".gif") || filenameOrURL.toLowerCase().endsWith(".png")) {
            RenderedOp renderedOp = JAI.create((String)"fileload", (Object)filenameOrURL);
            return renderedOp.getData(rectangle).getSampleDouble(col, row, band);
        }
        if (filenameOrURL.toLowerCase().endsWith(".tif") || filenameOrURL.toLowerCase().endsWith(".tiff")) {
            RenderedOp renderedOp = TiffUtilsV2.getRenderedOp(new File(filenameOrURL));
            return renderedOp.getData(rectangle).getSampleDouble(col, row, band);
        }
        if (filenameOrURL.toLowerCase().endsWith(".jpg")) {
            RenderedOp renderedOp = JAI.create((String)"fileload", (Object)filenameOrURL);
            return renderedOp.getData(rectangle).getSampleDouble(col, row, band);
        }
        if (filenameOrURL.toLowerCase().endsWith(".bmp")) {
            BufferedImage image = ImageIO.read(new File(filenameOrURL));
            PlanarImage pimage = PlanarImage.wrapRenderedImage((RenderedImage)image);
            return pimage.copyData().getSampleDouble(col, row, 0);
        }
        if (filenameOrURL.toLowerCase().endsWith(".jp2")) {
            BufferedImage image = ImageIO.read(new File(filenameOrURL));
            PlanarImage pimage = PlanarImage.wrapRenderedImage((RenderedImage)image);
            return pimage.copyData().getSampleDouble(col, row, 0);
        }
        if (filenameOrURL.toLowerCase().endsWith(".flt")) {
            GridFloat gf = new GridFloat(filenameOrURL);
            return gf.readCellVal(col, row);
        }
        if (filenameOrURL.toLowerCase().endsWith(".asc") || filenameOrURL.toLowerCase().endsWith(".txt")) {
            GridAscii ga = new GridAscii(filenameOrURL);
            return ga.readCellValue(col, row);
        }
        return null;
    }

    public static Point getImageDimensions(String filenameOrURL) throws IOException {
        if (filenameOrURL.toLowerCase().endsWith(".gif") || filenameOrURL.toLowerCase().endsWith(".png")) {
            RenderedOp pImage = JAI.create((String)"fileload", (Object)filenameOrURL);
            if (pImage != null) {
                return new Point(pImage.getWidth(), pImage.getHeight());
            }
        } else {
            if (filenameOrURL.toLowerCase().endsWith(".jpg") || filenameOrURL.toLowerCase().endsWith(".jpeg")) {
                try {
                    Dimension dimension = Imaging.getImageSize((File)new File(filenameOrURL));
                    return new Point((int)dimension.getWidth(), (int)dimension.getHeight());
                }
                catch (ImagingException e) {
                    throw new IOException(e);
                }
            }
            if (filenameOrURL.toLowerCase().endsWith(".tif") || filenameOrURL.toLowerCase().endsWith(".tiff")) {
                RenderedOp renderedOp = TiffUtilsV2.getRenderedOp(new File(filenameOrURL));
                if (renderedOp != null) {
                    return new Point(renderedOp.getWidth(), renderedOp.getHeight());
                }
            } else {
                if (filenameOrURL.toLowerCase().endsWith(".flt")) {
                    GridFloat gf = new GridFloat(filenameOrURL);
                    return new Point(gf.getnCols(), gf.getnRows());
                }
                if (filenameOrURL.toLowerCase().endsWith(".asc") || filenameOrURL.toLowerCase().endsWith(".txt")) {
                    GridAscii ga = new GridAscii(filenameOrURL);
                    return new Point(ga.getnCols(), ga.getnRows());
                }
                System.out.println("Filename " + filenameOrURL);
                BufferedImage image = ImageIO.read(new File(filenameOrURL));
                return new Point(image.getWidth(), image.getHeight());
            }
        }
        return null;
    }

    public static Envelope getGeoReferencing(String fileName, boolean alwaysLookForTFWExtension, Point imageDimensions) throws Exception {
        Envelope env = null;
        WorldFileHandler worldFileHandler = new WorldFileHandler(fileName, alwaysLookForTFWExtension);
        if (imageDimensions == null) {
            throw new Exception(I18N.getInstance().get("org.openjump.core.rasterimage.AddRasterImageLayerWizard.can-not-determine-image-dimensions"));
        }
        if (worldFileHandler.isWorldFileExistentForImage() != null) {
            env = worldFileHandler.readWorldFile(imageDimensions.x, imageDimensions.y);
        }
        if (env == null) {
            boolean isGeoTiff = false;
            if (fileName.toLowerCase().endsWith(".tif") || fileName.toLowerCase().endsWith(".tiff")) {
                TIFFField[] availTags;
                Coordinate tiePoint = null;
                Coordinate pixelOffset = null;
                Coordinate pixelScale = null;
                FileSeekableStream fileSeekableStream = new FileSeekableStream(fileName);
                TIFFDirectory tiffDirectory = new TIFFDirectory((SeekableStream)fileSeekableStream, 0);
                for (TIFFField availTag : availTags = tiffDirectory.getFields()) {
                    double[] doubles;
                    if (availTag.getTag() == 33922) {
                        doubles = availTag.getAsDoubles();
                        if (doubles.length != 6) {
                            throw new Exception("unsupported value for ModelTiepointTag (33922)");
                        }
                        if (doubles[0] != 0.0 || doubles[1] != 0.0 || doubles[2] != 0.0) {
                            pixelOffset = doubles[2] == 0.0 ? new Coordinate(doubles[0], doubles[1]) : new Coordinate(doubles[0], doubles[1], doubles[2]);
                        }
                        if (doubles[5] == 0.0) {
                            tiePoint = new Coordinate(doubles[3], doubles[4]);
                            continue;
                        }
                        tiePoint = new Coordinate(doubles[3], doubles[4], doubles[5]);
                        continue;
                    }
                    if (availTag.getTag() != 33550) continue;
                    doubles = availTag.getAsDoubles();
                    pixelScale = doubles[2] == 0.0 ? new Coordinate(doubles[0], doubles[1]) : new Coordinate(doubles[0], doubles[1], doubles[2]);
                }
                fileSeekableStream.close();
                if (tiePoint != null && pixelScale != null) {
                    isGeoTiff = true;
                    Coordinate upperLeft = pixelOffset == null ? tiePoint : new Coordinate(tiePoint.x - pixelOffset.x * pixelScale.x, tiePoint.y - pixelOffset.y * pixelScale.y);
                    Coordinate lowerRight = new Coordinate(upperLeft.x + (double)imageDimensions.x * pixelScale.x, upperLeft.y - (double)imageDimensions.y * pixelScale.y);
                    env = new Envelope(upperLeft, lowerRight);
                }
            } else if (fileName.toLowerCase().endsWith(".flt")) {
                isGeoTiff = true;
                GridFloat gf = new GridFloat(fileName);
                Coordinate upperLeft = new Coordinate(gf.getXllCorner(), gf.getYllCorner() + (double)gf.getnRows() * gf.getCellSize());
                Coordinate lowerRight = new Coordinate(gf.getXllCorner() + (double)gf.getnCols() * gf.getCellSize(), gf.getYllCorner());
                env = new Envelope(upperLeft, lowerRight);
            } else if (fileName.toLowerCase().endsWith(".asc") || fileName.toLowerCase().endsWith(".txt")) {
                isGeoTiff = true;
                GridAscii ga = new GridAscii(fileName);
                Coordinate upperLeft = new Coordinate(ga.getXllCorner(), ga.getYllCorner() + (double)ga.getnRows() * ga.getCellSize());
                Coordinate lowerRight = new Coordinate(ga.getXllCorner() + (double)ga.getnCols() * ga.getCellSize(), ga.getYllCorner());
                env = new Envelope(upperLeft, lowerRight);
            }
            if (!isGeoTiff || env == null) {
                throw new Exception(I18N.getInstance().get("org.openjump.core.rasterimage.AddRasterImageLayerWizard.no-worldfile-found"));
            }
        }
        return env;
    }

    public static CellSizeXY getCellSize(String fileNameOrURL) throws Exception {
        Point imageDims = RasterImageIO.getImageDimensions(fileNameOrURL);
        Envelope envelope = RasterImageIO.getGeoReferencing(fileNameOrURL, true, new Point(imageDims.x, imageDims.y));
        double cellSizeX = (envelope.getMaxX() - envelope.getMinX()) / (double)imageDims.x;
        double cellSizeY = (envelope.getMaxY() - envelope.getMinY()) / (double)imageDims.y;
        return new RasterImageIO().new CellSizeXY(cellSizeX, cellSizeY);
    }

    public static Double getNoData(String fileNameOrURL) throws IOException {
        if (fileNameOrURL.toLowerCase().endsWith(".asc") || fileNameOrURL.toLowerCase().endsWith(".txt")) {
            GridAscii gridAscii = new GridAscii(fileNameOrURL);
            gridAscii.readHeader();
            return gridAscii.getNoData();
        }
        if (fileNameOrURL.toLowerCase().endsWith(".flt")) {
            GridFloat gf = new GridFloat(fileNameOrURL);
            return gf.getNoData();
        }
        if (fileNameOrURL.toLowerCase().endsWith(".tif")) {
            TiffField field = TiffTags.readField(new File(fileNameOrURL), 42113);
            if (field.getFieldType() instanceof FieldTypeDouble) {
                return field.getDoubleValue();
            }
            if (field.getFieldType() instanceof FieldTypeFloat) {
                return field.getDoubleValue();
            }
            if (field.getFieldType() instanceof FieldTypeAscii) {
                return Double.parseDouble(field.getStringValue());
            }
        }
        return null;
    }

    public static Envelope getViewingEnvelope(Viewport viewport) throws NoninvertibleTransformException {
        Rectangle visible = viewport.getPanel().getVisibleRect();
        int visibleX1 = visible.x;
        int visibleY1 = visible.y;
        int visibleX2 = visibleX1 + visible.width;
        int visibleY2 = visibleY1 + visible.height;
        Coordinate upperLeftVisible = viewport.toModelCoordinate(new Point(visibleX1, visibleY1));
        Coordinate lowerRightVisible = viewport.toModelCoordinate(new Point(visibleX2, visibleY2));
        return new Envelope(upperLeftVisible, lowerRightVisible);
    }

    public static Rectangle getDrawingRectangle(int imgWidth, int imgHeight, Envelope wholeImageEnvelope, Envelope viewportEnvelope, Resolution subsetResolution) throws NoninvertibleTransformException {
        Rectangle rect = null;
        if (viewportEnvelope == null || viewportEnvelope.contains(wholeImageEnvelope)) {
            rect = new Rectangle(0, 0, imgWidth, imgHeight);
        } else if (viewportEnvelope.intersects(wholeImageEnvelope)) {
            Coordinate upperLeftVisible = new Coordinate(viewportEnvelope.getMinX(), viewportEnvelope.getMaxY());
            Coordinate lowerRightVisible = new Coordinate(viewportEnvelope.getMaxX(), viewportEnvelope.getMinY());
            Point upperLeft = RasterImageIO.fromCoordinateToCell(upperLeftVisible, new Coordinate(wholeImageEnvelope.getMinX(), wholeImageEnvelope.getMinY()), imgHeight, subsetResolution.getX(), subsetResolution.getY());
            Point lowerRight = RasterImageIO.fromCoordinateToCell(lowerRightVisible, new Coordinate(wholeImageEnvelope.getMinX(), wholeImageEnvelope.getMinY()), imgHeight, subsetResolution.getX(), subsetResolution.getY());
            int xOffset = Math.max(0, upperLeft.x);
            int yOffset = Math.max(0, upperLeft.y);
            int width = lowerRight.x - upperLeft.x;
            int height = lowerRight.y - upperLeft.y;
            rect = new Rectangle(xOffset, yOffset, width, height);
        }
        return rect;
    }

    protected Rectangle getVisibleImageCoordinatesOfImage(double imgWidth, double imgHeight, Envelope visible, Envelope imageEnv) {
        double minVisibleX = Math.max(visible.getMinX(), imageEnv.getMinX());
        double minVisibleY = Math.max(visible.getMinY(), imageEnv.getMinY());
        double maxVisibleX = Math.min(visible.getMaxX(), imageEnv.getMaxX());
        double maxVisibleY = Math.min(visible.getMaxY(), imageEnv.getMaxY());
        double offset2VisibleX = imageEnv.getMinX() - visible.getMinX();
        double offset2VisibleY = visible.getMaxY() - imageEnv.getMaxY();
        double scaleX = imgWidth / imageEnv.getWidth();
        double scaleY = imgHeight / imageEnv.getHeight();
        int xOffset = offset2VisibleX >= 0.0 ? 0 : (int)(-offset2VisibleX * scaleX);
        int yOffset = offset2VisibleY >= 0.0 ? 0 : (int)(-offset2VisibleY * scaleY);
        int width = (int)((maxVisibleX - minVisibleX) * scaleX);
        int height = (int)((maxVisibleY - minVisibleY) * scaleY);
        if ((double)width < imgWidth && (double)height < imgHeight) {
            ++width;
            ++height;
        }
        if (width <= 0 || height <= 0) {
            return null;
        }
        return new Rectangle(xOffset, yOffset, width, height);
    }

    public static Point fromCoordinateToCell(Coordinate coord, Coordinate lowerLeftCoord, int rowCount, double cellSizeX, double cellSizeY) {
        Point point = new Point();
        point.x = (int)Math.floor((coord.x - lowerLeftCoord.x) / cellSizeX);
        point.y = rowCount - (int)Math.floor((coord.y - lowerLeftCoord.y) / cellSizeY) - 1;
        return point;
    }

    public static Coordinate fromCellToCoordinate(Point cell, Coordinate lowerLeftCoord, double cellSize, int rowCount) {
        Coordinate coord = new Coordinate();
        coord.x = lowerLeftCoord.x + (double)cell.x * cellSize + 0.5 * cellSize;
        coord.y = lowerLeftCoord.y + (double)(rowCount - cell.y) * cellSize - 0.5 * cellSize;
        return coord;
    }

    public void writeImage(File outFile, Raster raster, Envelope envelope, CellSizeXY cellSize, double noData) throws IOException {
        File auxXmlFile = new File(outFile.getParent(), outFile.getName() + ".aux.xml");
        if (auxXmlFile.exists() && auxXmlFile.canWrite()) {
            try {
                auxXmlFile.delete();
            }
            catch (Exception ex) {
                ex.printStackTrace(System.out);
            }
        }
        SampleModel sm = raster.getSampleModel();
        ColorModel colorModel = PlanarImage.createColorModel((SampleModel)sm);
        BufferedImage image = new BufferedImage(colorModel, (WritableRaster)raster, false, null);
        TIFFEncodeParam param = new TIFFEncodeParam();
        param.setCompression(1);
        TIFFField[] tiffFields = new TIFFField[3];
        tiffFields[0] = new TIFFField(33550, 12, 2, (Object)new double[]{cellSize.cellSizeX, cellSize.cellSizeY});
        String noDataS = Double.toString(noData);
        byte[] bytes = noDataS.getBytes();
        tiffFields[1] = new TIFFField(42113, 1, noDataS.length(), (Object)bytes);
        tiffFields[2] = new TIFFField(33922, 12, 6, (Object)new double[]{0.0, 0.0, 0.0, envelope.getMinX(), envelope.getMaxY(), 0.0});
        param.setExtraFields(tiffFields);
        FileOutputStream tifOut = new FileOutputStream(outFile);
        TIFFImageEncoder encoder = (TIFFImageEncoder)TIFFCodec.createImageEncoder((String)"tiff", (OutputStream)tifOut, (ImageEncodeParam)param);
        encoder.encode((RenderedImage)image);
        tifOut.close();
        WorldFileHandler worldFileHandler = new WorldFileHandler(outFile.getAbsolutePath(), false);
        worldFileHandler.writeWorldFile(envelope, image.getWidth(), image.getHeight());
    }

    public void writeImage(File outFile, Raster raster, Envelope envelope, double cellSizeX, double cellSizeY, double noData, SRSInfo srsInfo) throws IOException, TransformerConfigurationException, ParserConfigurationException, TransformerException, SAXException {
        SampleModel sm = raster.getSampleModel();
        ColorModel colorModel = PlanarImage.createColorModel((SampleModel)sm);
        BufferedImage bufferedImage = new BufferedImage(colorModel, (WritableRaster)raster, false, null);
        TIFFEncodeParam param = new TIFFEncodeParam();
        param.setCompression(1);
        TIFFField[] tiffFields = new TIFFField[3];
        tiffFields[0] = new TIFFField(33550, 12, 2, (Object)new double[]{cellSizeX, cellSizeY});
        String noDataS = Double.toString(noData);
        byte[] bytes = noDataS.getBytes();
        tiffFields[1] = new TIFFField(42113, 1, noDataS.length(), (Object)bytes);
        tiffFields[2] = new TIFFField(33922, 12, 6, (Object)new double[]{0.0, 0.0, 0.0, envelope.getMinX(), envelope.getMaxY(), 0.0});
        param.setExtraFields(tiffFields);
        FileOutputStream tifOut = new FileOutputStream(outFile);
        TIFFImageEncoder encoder = (TIFFImageEncoder)TIFFCodec.createImageEncoder((String)"tiff", (OutputStream)tifOut, (ImageEncodeParam)param);
        encoder.encode((RenderedImage)bufferedImage);
        tifOut.close();
        int bandCount = bufferedImage.getRaster().getNumBands();
        double[] minValue = new double[bandCount];
        double[] maxValue = new double[bandCount];
        double[] sum = new double[bandCount];
        double[] sumSquare = new double[bandCount];
        long[] cellsCount = new long[bandCount];
        for (int b = 0; b < bandCount; ++b) {
            minValue[b] = Double.MAX_VALUE;
            maxValue[b] = -1.7976931348623157E308;
        }
        for (int r = 0; r < bufferedImage.getHeight(); ++r) {
            Raster raster2 = bufferedImage.getData(new Rectangle(0, r, bufferedImage.getWidth(), 1));
            for (int c = 0; c < bufferedImage.getWidth(); ++c) {
                for (int b = 0; b < bandCount; ++b) {
                    double value = raster2.getSampleDouble(c, r, b);
                    if (value == noData || (float)value == (float)noData || Double.isNaN(value) || Double.isInfinite(value)) continue;
                    if (value < minValue[b]) {
                        minValue[b] = value;
                    }
                    if (value > maxValue[b]) {
                        maxValue[b] = value;
                    }
                    int n = b;
                    cellsCount[n] = cellsCount[n] + 1L;
                    int n2 = b;
                    sum[n2] = sum[n2] + value;
                    int n3 = b;
                    sumSquare[n3] = sumSquare[n3] + value * value;
                }
            }
        }
        Stats stats = new Stats(bandCount);
        for (int b = 0; b < bandCount; ++b) {
            double meanValue = sum[b] / (double)cellsCount[b];
            double stdDevValue = Math.sqrt(sumSquare[b] / (double)cellsCount[b] - meanValue * meanValue);
            stats.setStatsForBand(b, minValue[b], maxValue[b], meanValue, stdDevValue);
        }
        File auxXmlFile = new File(outFile.getParent(), outFile.getName() + ".aux.xml");
        GDALPamDataset gPam = new GDALPamDataset();
        gPam.writeStatisticsAndSRS(auxXmlFile, srsInfo, stats);
    }

    public static Resolution calcRequestedResolution(Viewport viewport) {
        double xRes = viewport.getEnvelopeInModelCoordinates().getWidth() / (double)viewport.getPanel().getVisibleRect().width;
        double yRes = viewport.getEnvelopeInModelCoordinates().getHeight() / (double)viewport.getPanel().getVisibleRect().height;
        return new Resolution(xRes, yRes);
    }

    public class CellSizeXY {
        private final double cellSizeX;
        private final double cellSizeY;

        public CellSizeXY(double cellSizeX, double cellSizeY) {
            this.cellSizeX = cellSizeX;
            this.cellSizeY = cellSizeY;
        }

        public double getCellSizeX() {
            return this.cellSizeX;
        }

        public double getCellSizeY() {
            return this.cellSizeY;
        }

        public double getAverageCellSize() {
            return (this.cellSizeX + this.cellSizeY) * 0.5;
        }
    }
}

