/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.rasterimage;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.task.TaskMonitor;
import com.vividsolutions.jump.task.TaskMonitorV2Util;
import com.vividsolutions.jump.workbench.Logger;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.Category;
import com.vividsolutions.jump.workbench.model.Layerable;
import com.vividsolutions.jump.workbench.model.StandardCategoryNames;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import com.vividsolutions.jump.workbench.ui.Viewport;
import com.vividsolutions.jump.workbench.ui.images.IconLoader;
import com.vividsolutions.jump.workbench.ui.wizard.WizardDialog;
import com.vividsolutions.jump.workbench.ui.wizard.WizardPanel;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.openjump.core.ccordsys.utils.ProjUtils;
import org.openjump.core.ccordsys.utils.SRSInfo;
import org.openjump.core.rasterimage.GridAscii;
import org.openjump.core.rasterimage.GridFloat;
import org.openjump.core.rasterimage.RasterImageIO;
import org.openjump.core.rasterimage.RasterImageLayer;
import org.openjump.core.rasterimage.RasterSymbology;
import org.openjump.core.rasterimage.SelectRasterImageFilesPanel;
import org.openjump.core.rasterimage.TiffUtilsV2;
import org.openjump.core.rasterimage.WorldFileHandler;
import org.openjump.core.rasterimage.styler.SLDHandler;
import org.openjump.core.ui.plugin.file.OpenRecentPlugIn;
import org.openjump.core.ui.plugin.layer.pirolraster.RasterImageWizardPanel;
import org.openjump.core.ui.swing.wizard.AbstractWizardGroup;
import org.openjump.io.PropertiesHandler;
import org.openjump.util.UriUtil;
import org.openjump.util.metaData.MetaInformationHandler;

public class AddRasterImageLayerWizard
extends AbstractWizardGroup {
    public static final String KEY = AddRasterImageLayerWizard.class.getName();
    private final WorkbenchContext workbenchContext;
    private SelectRasterImageFilesPanel selectFilesPanel;
    private File[] files;
    protected PropertiesHandler properties = null;
    protected WorldFileHandler worldFileHandler = null;
    protected static String propertiesFile = "RasterImage.properties";
    protected String KEY_ALWAYS_ACCEPT_TWF_EXT = "alwaysCheckForTWFExtension";
    protected String KEY_ZOOM_TO_INSERTED_IMAGE = "zoomToImage";
    protected boolean alwaysLookForTFWExtension = true;
    protected boolean zoomToInsertedImage = false;
    private String imageFileName = "";
    private String cachedLayer = "default-layer-name";

    public AddRasterImageLayerWizard(WorkbenchContext workbenchContext) {
        super(I18N.getInstance().get("org.openjump.core.rasterimage.AddRasterImageLayerWizard.Sextante-Raster-Image"), IconLoader.icon("mapSv2_13.png"), SelectRasterImageFilesPanel.KEY);
        this.workbenchContext = workbenchContext;
    }

    public AddRasterImageLayerWizard(WorkbenchContext workbenchContext, File[] files) {
        this.workbenchContext = workbenchContext;
        this.files = files;
    }

    @Override
    public void initialize(WorkbenchContext workbenchContext, WizardDialog dialog) {
        this.initPanels(workbenchContext);
        this.selectFilesPanel.setDialog(dialog);
    }

    private void initPanels(WorkbenchContext workbenchContext) {
        if (this.selectFilesPanel == null) {
            this.selectFilesPanel = new SelectRasterImageFilesPanel(workbenchContext);
            this.addPanel(this.selectFilesPanel);
        }
    }

    @Override
    public void run(WizardDialog dialog, TaskMonitor monitor) {
        TaskMonitorV2Util.setTitle(monitor, I18N.getInstance().get("org.openjump.core.rasterimage.AddRasterImageLayerWizard.Sextante-Raster-Image"));
        this.properties = new PropertiesHandler(propertiesFile);
        if (this.files == null) {
            File[] selectedFiles = this.selectFilesPanel.getSelectedFiles();
            this.open(selectedFiles, monitor);
        } else {
            this.open(this.files, monitor);
        }
    }

    private void open(File[] files, TaskMonitor monitor) {
        monitor.allowCancellationRequests();
        for (int i = 0; i < files.length && !TaskMonitorV2Util.isCancelRequested(monitor); ++i) {
            File file = files[i];
            TaskMonitorV2Util.report(monitor, i + 1, files.length, " - " + file.getName());
            this.open(file, monitor);
        }
    }

    private void open(File file, TaskMonitor monitor) {
        try {
            String selectedFilename;
            this.properties.setProperty("path", file.getPath());
            this.properties.store(" " + this.KEY_ZOOM_TO_INSERTED_IMAGE + I18N.getInstance().get("RasterImagePlugIn.28") + this.KEY_ALWAYS_ACCEPT_TWF_EXT + I18N.getInstance().get("RasterImagePlugIn.29") + "path" + I18N.getInstance().get("RasterImagePlugIn.30"));
            this.imageFileName = selectedFilename = file.getPath();
            this.cachedLayer = selectedFilename.substring(selectedFilename.lastIndexOf(File.separator) + 1, selectedFilename.lastIndexOf("."));
            Point imageDimensions = RasterImageIO.getImageDimensions(selectedFilename);
            Envelope env = this.getGeoReferencing(selectedFilename, this.alwaysLookForTFWExtension, imageDimensions, this.workbenchContext);
            if (env != null) {
                this.addImage(this.workbenchContext, env, imageDimensions);
            }
            OpenRecentPlugIn.get(this.workbenchContext).addRecentFile(file);
        }
        catch (Exception e) {
            monitor.report(e);
        }
    }

    private void addImage(WorkbenchContext context, Envelope envelope, Point imageDimensions) {
        String sldFileName;
        File sldFile;
        if (context.getTask() == null) {
            context.getWorkbench().getFrame().addTaskFrame();
        }
        String newLayerName = context.getLayerManager().uniqueLayerName(this.cachedLayer);
        String catName = StandardCategoryNames.WORKING;
        if (!context.createPlugInContext().getLayerNamePanel().getSelectedCategories().isEmpty()) {
            try {
                catName = ((Category)context.createPlugInContext().getLayerNamePanel().getSelectedCategories().toArray()[0]).getName();
            }
            catch (RuntimeException e1) {
                Logger.warn("AddRasterImageLayerWizard.addImage: error trying to get the name of the currently selected category", e1);
            }
        } else {
            Logger.warn("AddRasterImageLayerWizard.addImage: a category must be selected");
        }
        int layersAsideImage = context.getLayerManager().getLayerables(Layerable.class).size();
        RasterImageLayer rLayer = new RasterImageLayer(newLayerName, context.getLayerManager(), this.imageFileName, null, envelope);
        try {
            SRSInfo srsInfo = ProjUtils.getSRSInfoFromLayerSource(rLayer);
            srsInfo.complete();
            rLayer.setSrsInfo(srsInfo);
        }
        catch (Exception e) {
            Logger.error(e);
        }
        if (rLayer.getNumBands() == 1 && (sldFile = new File(sldFileName = UriUtil.removeExtension(this.imageFileName) + ".sld")).exists() && !sldFile.isDirectory()) {
            try {
                RasterSymbology finalRasterSymbolizer = SLDHandler.read(sldFile);
                rLayer.setSymbology(finalRasterSymbolizer);
            }
            catch (Exception e) {
                Logger.error("cannot decode sld file: " + e);
            }
        }
        MetaInformationHandler mih = new MetaInformationHandler(rLayer);
        mih.addMetaInformation("file-name", this.imageFileName);
        mih.addMetaInformation("resolution", imageDimensions.x + " (px) x " + imageDimensions.y + " (px)");
        mih.addMetaInformation("real-world-width", envelope.getWidth());
        mih.addMetaInformation("real-world-height", envelope.getHeight());
        mih.addMetaInformation("srid", rLayer.getSrsInfo().getCode());
        mih.addMetaInformation("srid-location", rLayer.getSrsInfo().getSource());
        context.getLayerManager().addLayerable(catName, rLayer);
        if (this.zoomToInsertedImage || layersAsideImage == 0) {
            try {
                context.getLayerViewPanel().getViewport().zoom(envelope);
            }
            catch (NoninvertibleTransformException noninvertibleTransformException) {
                // empty catch block
            }
        }
    }

    protected Envelope getGeoReferencing(String fileName, boolean alwaysLookForTFWExtension, Point imageDimensions, WorkbenchContext context) throws IOException, NoninvertibleTransformException {
        Envelope env = null;
        this.worldFileHandler = new WorldFileHandler(fileName, alwaysLookForTFWExtension);
        if (imageDimensions == null) {
            context.getWorkbench().getFrame().warnUser(I18N.getInstance().get("org.openjump.core.rasterimage.AddRasterImageLayerWizard.can-not-determine-image-dimensions"));
            return null;
        }
        if (this.worldFileHandler.isWorldFileExistentForImage() != null) {
            env = this.worldFileHandler.readWorldFile(imageDimensions.x, imageDimensions.y);
        }
        if (env == null) {
            Coordinate lowerRight;
            Coordinate upperLeft;
            boolean isGeoTiff = false;
            if (fileName.toLowerCase().endsWith(".tif") || fileName.toLowerCase().endsWith(".tiff")) {
                env = TiffUtilsV2.getEnvelope(new File(fileName));
                isGeoTiff = env.getWidth() != imageDimensions.getX() || env.getHeight() != imageDimensions.getY();
            } else if (fileName.toLowerCase().endsWith(".flt")) {
                isGeoTiff = true;
                GridFloat gf = new GridFloat(fileName);
                upperLeft = new Coordinate(gf.getXllCorner(), gf.getYllCorner() + (double)gf.getnRows() * gf.getCellSize());
                lowerRight = new Coordinate(gf.getXllCorner() + (double)gf.getnCols() * gf.getCellSize(), gf.getYllCorner());
                env = new Envelope(upperLeft, lowerRight);
            } else if (fileName.toLowerCase().endsWith(".asc") || fileName.toLowerCase().endsWith(".txt")) {
                isGeoTiff = true;
                GridAscii ga = new GridAscii(fileName);
                upperLeft = new Coordinate(ga.getXllCorner(), ga.getYllCorner() + (double)ga.getnRows() * ga.getCellSize());
                lowerRight = new Coordinate(ga.getXllCorner() + (double)ga.getnCols() * ga.getCellSize(), ga.getYllCorner());
                env = new Envelope(upperLeft, lowerRight);
            }
            if (!isGeoTiff) {
                Viewport viewport = context.getLayerViewPanel().getViewport();
                Rectangle visibleRect = viewport.getPanel().getVisibleRect();
                File fil = new File(fileName);
                BufferedImage bufImg = ImageIO.read(fil);
                int width = bufImg.getWidth();
                int height = bufImg.getHeight();
                int visibleX1 = visibleRect.x;
                int visibleY1 = visibleRect.y;
                int visibleX2 = visibleX1 + width;
                int visibleY2 = visibleY1 + height;
                int visibleX3 = visibleX1 + visibleRect.width;
                int visibleY3 = visibleY1 + visibleRect.height;
                Coordinate upperLeftVisible = viewport.toModelCoordinate(new Point(0, 0));
                Coordinate lowerRightVisible1 = viewport.toModelCoordinate(new Point(visibleX2, visibleY2));
                Coordinate lowerRightVisible2 = viewport.toModelCoordinate(new Point(visibleX3, visibleY3));
                context.getWorkbench().getFrame().warnUser(I18N.getInstance().get("org.openjump.core.rasterimage.AddRasterImageLayerWizard.no-worldfile-found"));
                WizardDialog d = new WizardDialog((Frame)context.getWorkbench().getFrame(), I18N.getInstance().get("org.openjump.core.rasterimage.AddRasterImageLayerWizard.no-worldfile-found-message", fil.getName()), context.getErrorHandler());
                d.init(new WizardPanel[]{new RasterImageWizardPanel()});
                RasterImageWizardPanel.minxTextField.setText(Double.toString(upperLeftVisible.x));
                RasterImageWizardPanel.maxxTextField.setText(Double.toString(lowerRightVisible1.x));
                RasterImageWizardPanel.minyTextField.setText(Double.toString(upperLeftVisible.y));
                RasterImageWizardPanel.maxyTextField.setText(Double.toString(lowerRightVisible1.y));
                d.setSize(700, 350);
                GUIUtil.centreOnWindow(d);
                d.setVisible(true);
                if (!d.wasFinishPressed()) {
                    return null;
                }
                try {
                    if (RasterImageWizardPanel.warpCheckBox.isSelected()) {
                        env = new Envelope(upperLeftVisible.x, lowerRightVisible2.x, upperLeftVisible.y, lowerRightVisible2.y);
                    } else {
                        double minx = Double.parseDouble((String)d.getData(RasterImageWizardPanel.MINX_KEY));
                        double maxx = Double.parseDouble((String)d.getData(RasterImageWizardPanel.MAXX_KEY));
                        double miny = Double.parseDouble((String)d.getData(RasterImageWizardPanel.MINY_KEY));
                        double maxy = Double.parseDouble((String)d.getData(RasterImageWizardPanel.MAXY_KEY));
                        env = new Envelope(minx, maxx, miny, maxy);
                    }
                }
                catch (NumberFormatException e) {
                    env = new Envelope(upperLeftVisible.x, lowerRightVisible1.x, upperLeftVisible.y, lowerRightVisible1.y);
                }
            }
            this.worldFileHandler = new WorldFileHandler(fileName, this.alwaysLookForTFWExtension);
            this.worldFileHandler.writeWorldFile(env, imageDimensions.x, imageDimensions.y);
            File fil = new File(fileName);
            String MSG = I18N.getInstance().get("org.openjump.core.rasterimage.AddRasterImageLayerWizard.message", fil.getName());
            context.getWorkbench().getFrame().setStatusMessage(MSG);
        }
        return env;
    }
}

