/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.feature;

import bsh.EvalError;
import bsh.Interpreter;
import com.vividsolutions.jump.feature.AttributeType;
import com.vividsolutions.jump.feature.BasicFeature;
import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.feature.FeatureSchema;
import com.vividsolutions.jump.feature.Operation;
import com.vividsolutions.jump.util.FlexibleDateParser;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import java.text.ParseException;
import java.util.Date;
import java.util.HashSet;

public class BeanshellAttributeOperation
implements Operation {
    private static final FlexibleDateParser DATE_PARSER = new FlexibleDateParser();
    private PlugInContext context;
    private AttributeType type;
    private String bshExpression;
    private Interpreter interpreter;

    public BeanshellAttributeOperation(PlugInContext context, AttributeType type, String bshExpression) throws EvalError {
        this.context = context;
        this.type = type;
        this.bshExpression = bshExpression;
        this.interpreter = this.initInterpreter(context);
    }

    @Override
    public Object invoke(Feature feature) throws Exception {
        return this.evaluate((BasicFeature)feature);
    }

    public Object evaluate(BasicFeature f) throws EvalError, NumberFormatException, IllegalArgumentException, ParseException {
        FeatureSchema schema = f.getSchema();
        HashSet<Integer> evaluatedAttributes = (HashSet<Integer>)f.getUserData("evaluatedAttributes");
        if (evaluatedAttributes == null) {
            evaluatedAttributes = new HashSet<Integer>();
            f.setUserData("evaluatedAttributes", evaluatedAttributes);
        }
        for (int i = 0; i < schema.getAttributeCount(); ++i) {
            if (schema.getOperation(i) == this) {
                evaluatedAttributes.add(i);
                continue;
            }
            if (schema.isOperation(i) && evaluatedAttributes.contains(i)) continue;
            try {
                this.interpreter.set(BeanshellAttributeOperation.normalizeVarName(schema.getAttributeName(i)), f.getAttribute(i));
                evaluatedAttributes.add(i);
                continue;
            }
            catch (EvalError e) {
                this.context.getWorkbenchFrame().warnUser(e.toString());
                throw e;
            }
        }
        f.removeUserData("evaluatedAttributes");
        try {
            this.interpreter.set("geometry", (Object)f.getGeometry());
            this.interpreter.set("Geometry", (Object)f.getGeometry());
            this.interpreter.set("GEOMETRY", (Object)f.getGeometry());
            this.interpreter.set("feature", (Object)f);
            this.interpreter.set("Feature", (Object)f);
            this.interpreter.set("FEATURE", (Object)f);
            Object obj = this.interpreter.eval(this.bshExpression);
            if (obj == null) {
                return null;
            }
            if (this.type == AttributeType.STRING) {
                if (obj instanceof String) {
                    return obj;
                }
                return obj.toString();
            }
            if (this.type == AttributeType.DOUBLE) {
                if (obj instanceof Double) {
                    return obj;
                }
                return Double.valueOf(obj.toString());
            }
            if (this.type == AttributeType.INTEGER) {
                if (obj instanceof Integer) {
                    return obj;
                }
                return Integer.valueOf(obj.toString());
            }
            if (this.type == AttributeType.DATE) {
                if (obj instanceof Date) {
                    return obj;
                }
                return DATE_PARSER.parse(obj.toString(), true);
            }
            return obj;
        }
        catch (EvalError e) {
            this.context.getWorkbenchFrame().warnUser(e.toString());
            throw e;
        }
        catch (NumberFormatException e) {
            this.context.getWorkbenchFrame().warnUser(e.toString());
            throw e;
        }
        catch (IllegalArgumentException e) {
            this.context.getWorkbenchFrame().warnUser(e.toString());
            throw e;
        }
    }

    public String toString() {
        return this.getClass().getName() + "\n" + this.bshExpression;
    }

    public Object clone() throws CloneNotSupportedException {
        try {
            return new BeanshellAttributeOperation(this.context, this.type, this.bshExpression);
        }
        catch (EvalError e) {
            e.printStackTrace();
            return null;
        }
    }

    private Interpreter initInterpreter(PlugInContext context) throws EvalError {
        Interpreter interpreter = new Interpreter();
        interpreter.setClassLoader(context.getWorkbenchContext().getWorkbench().getPlugInManager().getClassLoader());
        interpreter.set("wc", (Object)context.getWorkbenchContext());
        interpreter.eval("setAccessibility(true)");
        interpreter.eval("import org.locationtech.jts.geom.*");
        interpreter.eval("import com.vividsolutions.jump.feature.*");
        interpreter.eval("import org.locationtech.jts.operation.union.UnaryUnionOp");
        interpreter.eval("selection() {return wc.layerViewPanel.selectionManager.featuresWithSelectedItems;}");
        interpreter.eval("dataset(String layerName) {return wc.layerManager.getLayer(layerName).getFeatureCollectionWrapper().features;}");
        interpreter.eval("intersects(Feature feature, Collection features) {for (f : features) {if (feature.geometry.intersects(f.geometry) && feature.ID!=f.ID) return true;}return false;}");
        interpreter.eval("distance(Feature feature, Collection features) {min = Double.MAX_VALUE;for (f : features) {min = Math.min(min,feature.geometry.distance(f.geometry));}return min == Double.MAX_VALUE ? null : min;}");
        interpreter.eval("round(double d, int i) { p10 = Math.pow(10.0,(double)i); return Math.rint(d*p10)/p10;}");
        return interpreter;
    }

    public static String normalizeVarName(String s) {
        StringBuffer sb = new StringBuffer(s);
        for (int i = 0; i < s.length(); ++i) {
            if (Character.isJavaIdentifierPart(sb.charAt(i))) continue;
            sb.setCharAt(i, '_');
        }
        return sb.toString();
    }
}

