/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.ccordsys.utils;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.text.Normalizer;
import java.util.Scanner;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openjump.core.ccordsys.Unit;
import org.openjump.core.ccordsys.utils.ProjUtils;
import org.openjump.core.ccordsys.utils.SRSInfo;

public class SridLookupTable {
    private static final Pattern pattern = Pattern.compile("<([^<>]*)>\\s*;\\s*<([^<>]*)>\\s*;\\s*\\[([^\\[\\]]*)\\]");

    public static void main(String[] args) {
        System.out.println("4326       -> " + SridLookupTable.getSrsAndUnitFromCode("4326"));
        System.out.println("WGS 84     -> " + SridLookupTable.getSrsAndUnitFromName("WGS 84"));
        System.out.println("LAMB93     -> " + SridLookupTable.getSrsAndUnitFromCode("LAMB93"));
        System.out.println("Lambert 93 -> " + SridLookupTable.getSrsAndUnitFromName("Lambert 93"));
        System.out.println("Geoportail - Reunion -> " + SridLookupTable.getSrsAndUnitFromName("Geoportail - Reunion"));
        System.out.println("4326       -> " + SridLookupTable.getSrsNameFromCode("4326"));
        System.out.println("WGS 84     -> " + SridLookupTable.getSrsCodeFromName("WGS 84"));
        System.out.println("4326       -> " + (Object)((Object)SridLookupTable.getUnitFromCode("4326")));
        System.out.println("WGS 84     -> " + (Object)((Object)SridLookupTable.getUnitFromName("WGS 84")));
    }

    private static Scanner getScanner() {
        Scanner scanner = null;
        InputStream is = ProjUtils.class.getResourceAsStream("srid.txt");
        InputStreamReader isr = new InputStreamReader(is, StandardCharsets.UTF_8);
        scanner = new Scanner(isr);
        scanner.useDelimiter("\\n");
        return scanner;
    }

    public static SRSInfo getSrsAndUnitFromCode(String code) {
        SRSInfo srsInfo = new SRSInfo();
        if (code == null || code.isEmpty() || code.equals("0")) {
            return srsInfo;
        }
        try (Scanner scanner = SridLookupTable.getScanner();){
            while (scanner.hasNextLine()) {
                String line = scanner.nextLine().trim();
                Matcher m = pattern.matcher(line);
                if (!m.matches() || !m.group(1).equals(code)) continue;
                srsInfo.setCode(m.group(1)).setDescription(m.group(2)).setUnit(Unit.find(m.group(3)));
            }
            SRSInfo sRSInfo = srsInfo;
            return sRSInfo;
        }
    }

    public static SRSInfo getSrsAndUnitFromName(String name) {
        SRSInfo srsInfo = new SRSInfo();
        if (name == null || name.isEmpty()) {
            return srsInfo;
        }
        try (Scanner scanner = SridLookupTable.getScanner();){
            while (scanner.hasNextLine()) {
                String line = scanner.nextLine().trim();
                Matcher m = pattern.matcher(line);
                if (!m.matches() || !SridLookupTable.normalize(m.group(2)).equals(SridLookupTable.normalize(name))) continue;
                srsInfo.setCode(m.group(1)).setDescription(m.group(2)).setUnit(Unit.find(m.group(3)));
            }
            SRSInfo sRSInfo = srsInfo;
            return sRSInfo;
        }
    }

    public static SRSInfo getSrsAndUnitFromCodeOrName(String codeOrName) {
        SRSInfo srsInfo = new SRSInfo();
        if (codeOrName == null || codeOrName.isEmpty() || codeOrName.equals("0")) {
            return srsInfo;
        }
        try (Scanner scanner = SridLookupTable.getScanner();){
            while (scanner.hasNextLine()) {
                String line = scanner.nextLine().trim();
                Matcher m = pattern.matcher(line);
                if (!m.matches() || !m.group(1).equals(codeOrName) && !SridLookupTable.normalize(m.group(2)).equals(SridLookupTable.normalize(codeOrName))) continue;
                srsInfo.setCode(m.group(1)).setDescription(m.group(2)).setUnit(Unit.find(m.group(3)));
            }
            SRSInfo sRSInfo = srsInfo;
            return sRSInfo;
        }
    }

    public static String getSrsCodeFromName(String name) {
        SRSInfo srsInfo = SridLookupTable.getSrsAndUnitFromName(name);
        return srsInfo == null ? null : srsInfo.getCode();
    }

    public static String getSrsNameFromCode(String code) {
        SRSInfo srsInfo = SridLookupTable.getSrsAndUnitFromCode(code);
        return srsInfo == null ? null : srsInfo.getDescription();
    }

    public static Unit getUnitFromName(String name) {
        SRSInfo srsInfo = SridLookupTable.getSrsAndUnitFromName(name);
        return srsInfo == null ? null : srsInfo.getUnit();
    }

    public static Unit getUnitFromCode(String code) {
        SRSInfo srsInfo = SridLookupTable.getSrsAndUnitFromCode(code);
        return srsInfo == null ? null : srsInfo.getUnit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getOGCWKTFromWkidCode(String code) throws URISyntaxException, IOException {
        InputStream is = ProjUtils.class.getResourceAsStream("srid2prj.txt");
        InputStreamReader isr = new InputStreamReader(is);
        String OGCWKT = "";
        String search = "<" + code.toLowerCase() + ">";
        Scanner scanner = null;
        try {
            scanner = new Scanner(isr);
            while (scanner.hasNextLine()) {
                scanner.useDelimiter("\\n");
                String line = scanner.nextLine();
                if (!line.toLowerCase().contains(search)) continue;
                OGCWKT = line.replaceAll(search, "");
                break;
            }
        }
        finally {
            try {
                if (scanner != null) {
                    scanner.close();
                }
            }
            catch (Exception e) {
                System.err.println("Exception while closing scanner " + e.toString());
            }
        }
        return OGCWKT;
    }

    private static String normalize(String name) {
        name = Normalizer.normalize(name, Normalizer.Form.NFD);
        name = name.replaceAll("\\p{M}", "");
        return name.toLowerCase();
    }
}

