/*
 * Decompiled with CFR 0.152.
 */
package org.libtiff.jai.codecimpl;

import java.awt.Rectangle;
import org.libtiff.jai.codec.XTIFFTileCodec;
import org.libtiff.jai.codec.XTIFFTileCodecImpl;
import org.libtiff.jai.util.JaiI18N;

public class XTIFFPackTileCodec
extends XTIFFTileCodecImpl {
    @Override
    public XTIFFTileCodec create() {
        return new XTIFFPackTileCodec();
    }

    @Override
    public boolean canEncode() {
        return false;
    }

    @Override
    public void register() {
        this.register(32773);
    }

    @Override
    public int encodeTilePixels(int[] pixels, Rectangle newRect, byte[] bpixels) {
        return 0;
    }

    @Override
    public void decodeTilePixels(byte[] input, Rectangle newRect, byte[] bdata) {
        if (this.bitsPerSample[0] == '\b') {
            this.decodePackbits(input, this.unitsInThisTile, bdata);
        } else if (this.bitsPerSample[0] == '\u0004') {
            int bytesInThisTile = newRect.width % 8 == 0 ? newRect.width / 2 * newRect.height : (newRect.width / 2 + 1) * newRect.height;
            this.decodePackbits(input, bytesInThisTile, bdata);
        }
    }

    @Override
    public void decodeTilePixels(byte[] input, Rectangle newRect, short[] sdata) {
        int bytesInThisTile = this.unitsInThisTile * 2;
        byte[] byteArray = new byte[bytesInThisTile];
        this.decodePackbits(input, bytesInThisTile, byteArray);
        this.unpackShorts(byteArray, sdata, this.unitsInThisTile);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Lifted jumps to return sites
     */
    private byte[] decodePackbits(byte[] data, int arraySize, byte[] dst) {
        if (dst == null) {
            dst = new byte[arraySize];
        }
        int srcCount = 0;
        int dstCount = 0;
        try {
            block2: while (dstCount < arraySize) {
                int i;
                byte b;
                if ((b = data[srcCount++]) >= 0 && b <= 127) {
                    i = 0;
                    while (true) {
                        if (i >= b + 1) continue block2;
                        dst[dstCount++] = data[srcCount++];
                        ++i;
                    }
                }
                if (b <= -1 && b >= -127) {
                    byte repeat = data[srcCount++];
                    i = 0;
                    while (true) {
                        if (i >= -b + 1) continue block2;
                        dst[dstCount++] = repeat;
                        ++i;
                    }
                }
                ++srcCount;
            }
            return dst;
        }
        catch (ArrayIndexOutOfBoundsException ae) {
            throw new RuntimeException(JaiI18N.getString("XTIFFImageDecoder10"));
        }
    }
}

