/*
 * Decompiled with CFR 0.152.
 */
package org.libtiff.jai.codecimpl;

import com.sun.media.jai.codecimpl.TIFFLZWDecoder;
import java.awt.Rectangle;
import org.libtiff.jai.codec.XTIFFField;
import org.libtiff.jai.codec.XTIFFTileCodec;
import org.libtiff.jai.codec.XTIFFTileCodecImpl;
import org.libtiff.jai.util.JaiI18N;

public class XTIFFLZWTileCodec
extends XTIFFTileCodecImpl {
    private TIFFLZWDecoder lzwDecoder = null;
    int predictor;
    int samplesPerPixel;

    @Override
    public XTIFFTileCodec create() {
        return new XTIFFLZWTileCodec();
    }

    @Override
    public void register() {
        this.register(5);
    }

    @Override
    public void initializeDecoding() {
        XTIFFField sfield = this.directory.getField(277);
        this.samplesPerPixel = sfield == null ? 1 : (int)sfield.getAsLong(0);
        XTIFFField predictorField = this.directory.getField(317);
        if (predictorField == null) {
            this.predictor = 1;
        } else {
            this.predictor = predictorField.getAsInt(0);
            if (this.predictor != 1 && this.predictor != 2) {
                throw new RuntimeException(JaiI18N.getString("XTIFFImageDecoder16"));
            }
            if (this.predictor == 2 && this.bitsPerSample[0] != '\b') {
                throw new RuntimeException(this.bitsPerSample[0] + JaiI18N.getString("XTIFFImageDecoder17"));
            }
        }
        this.lzwDecoder = new TIFFLZWDecoder(this.tileWidth, this.predictor, this.samplesPerPixel);
    }

    @Override
    public void decodeTilePixels(byte[] input, Rectangle newRect, byte[] bdata) {
        this.lzwDecoder.decode(input, bdata, newRect.height);
    }

    @Override
    public void decodeTilePixels(byte[] input, Rectangle newRect, short[] sdata) {
        byte[] byteArray = new byte[this.unitsInThisTile * 2];
        this.lzwDecoder.decode(input, byteArray, newRect.height);
        this.unpackShorts(byteArray, sdata, this.unitsInThisTile);
    }
}

