/*
 * Decompiled with CFR 0.152.
 */
package de.latlon.deejump.plugin.style;

import com.vividsolutions.jump.util.Blackboard;
import com.vividsolutions.jump.workbench.ui.images.IconLoader;
import com.vividsolutions.jump.workbench.ui.renderer.style.WKTFillPattern;
import de.latlon.deejump.plugin.style.BitmapVertexStyle;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import javax.imageio.ImageIO;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class XSLUtility {
    public static String toHexColor(Node colorNode) {
        String value = "#000000";
        if (colorNode == null) {
            return value;
        }
        try {
            if (colorNode.getFirstChild() == null) {
                return value;
            }
            String nodeVal = colorNode.getFirstChild().getNodeValue();
            String[] components = nodeVal.split(", ");
            StringBuffer sb = new StringBuffer(100);
            sb.append("#");
            for (int i = 0; i < components.length - 1; ++i) {
                String uglyHack = Integer.toHexString(Integer.parseInt(components[i]));
                uglyHack = uglyHack.length() == 1 ? "0" + uglyHack : uglyHack;
                sb.append(uglyHack);
            }
            value = sb.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return value;
    }

    public static String toAlphaValue(Node node) {
        String value = "1";
        if (node == null || node.getFirstChild() == null) {
            return value;
        }
        try {
            String nodeVal = node.getFirstChild().getNodeValue();
            value = String.valueOf(Double.parseDouble(nodeVal) / 255.0);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (value.length() > 6) {
            value = value.substring(0, 5);
        }
        return value;
    }

    public static String toFontFamily(Node node) {
        String value = "Dialog";
        try {
            String nodeVal = node.getFirstChild().getNodeValue();
            String[] components = nodeVal.split(", ");
            value = components[0];
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return value;
    }

    public static String toFontStyle(Node fontNode) {
        String[] styles = new String[]{"normal", "normal", "italic"};
        String value = styles[0];
        try {
            String nodeVal = fontNode.getFirstChild().getNodeValue();
            String[] components = nodeVal.split(", ");
            value = styles[Integer.parseInt(components[1])];
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return value;
    }

    public static String toWellKnowName(Node vertexStyleNode) {
        if (vertexStyleNode == null) {
            return "";
        }
        String value = "square";
        try {
            NamedNodeMap atts = vertexStyleNode.getAttributes();
            String nodeVal = atts.getNamedItem("class").getNodeValue();
            if (nodeVal.indexOf("Square") <= -1) {
                if (nodeVal.indexOf("Circle") > -1) {
                    value = "circle";
                } else if (nodeVal.indexOf("Cross") > -1) {
                    value = "cross";
                } else if (nodeVal.indexOf("Star") > -1) {
                    value = "star";
                } else if (nodeVal.indexOf("Triangle") > -1) {
                    value = "triangle";
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return value;
    }

    public static String getImageURL(String filename, Node fill, Node stroke, int size) throws IOException {
        if (filename.toLowerCase().endsWith(".svg")) {
            File file = File.createTempFile("ojp", "pti.png");
            ImageIO.write((RenderedImage)BitmapVertexStyle.getUpdatedSVGImage(filename, XSLUtility.toHexColor(stroke), XSLUtility.toHexColor(fill), size), "png", file);
            return file.toURI().toURL().toExternalForm();
        }
        return XSLUtility.fileToURL(filename);
    }

    public static String fileToURL(String filename) {
        File f = new File(filename);
        try {
            return f.toURI().toURL().toString();
        }
        catch (MalformedURLException e) {
            return filename;
        }
    }

    public static String replaceComma(Node node) {
        if (node.getFirstChild().getTextContent() == null) {
            return "";
        }
        String[] ss = node.getFirstChild().getTextContent().split(",");
        if (ss.length == 1) {
            return ss[0] + " " + ss[0];
        }
        return ss[0] + " " + ss[1];
    }

    public static String getIconURL(String icon) {
        return IconLoader.class.getResource(icon).toExternalForm();
    }

    public static String createPatternImage(int width, int extent, String pattern, String color) throws IOException {
        File file = File.createTempFile("ojp", "pti.png");
        WKTFillPattern pat = new WKTFillPattern(width, extent, pattern);
        Blackboard b = pat.getProperties();
        Color c = Color.decode(color);
        b.put("COLOR", c);
        BufferedImage img = pat.createImage(pat.getProperties());
        ImageIO.write((RenderedImage)img, "png", file);
        return file.toURI().toURL().toExternalForm();
    }
}

