/*
 * Decompiled with CFR 0.152.
 */
package de.fho.jump.pirol.utilities.debugOutput;

import de.fho.jump.pirol.utilities.debugOutput.PersonalLogger;
import de.fho.jump.pirol.utilities.settings.PirolPlugInSettings;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Calendar;
import org.openjump.io.PropertiesHandler;

@Deprecated
public final class GenericDebugLogger {
    private static GenericDebugLogger logger = null;
    private static final String loggerUserId = "GenericDebugLogger";
    private static final String userFlagPrefix = "showMessagesOf_";
    protected PropertiesHandler properties = null;
    protected static final String propertiesFile = "debugging.properties";
    protected int logLevel = 1;
    protected static final String KEY_LOGLEVEL = "logLevel";
    public static final int SEVERITY_DEBUG = 0;
    public static final int SEVERITY_WARNING = 1;
    public static final int SEVERITY_MINORERROR = 2;
    public static final int SEVERITY_ERROR = 3;
    public static final int SEVERITY_SEVEREERROR = 4;
    protected static final String[] severityLevels = new String[]{"DEBUG", "WARNING", "MIN.ERROR", "ERROR", "SEV.ERROR"};
    protected boolean eclipseFriendlyOutput = true;
    protected static final String KEY_ECLIPSEFRIENDLYOUTPUT = "eclipseFriendlyOutput";
    protected boolean printTimeStamp = false;
    protected static final String KEY_PRINTTIMESTAMPS = "printTimeStamps";
    protected boolean printFileAndLine = true;
    protected static final String KEY_PRINTFILEANDLINE = "printFileAndLineNumber";
    protected boolean printNewLineFirst = false;
    protected static final String KEY_PRINTNEWLINEFIRST = "printNewLineFirst";
    protected boolean printShortClassNames = true;
    protected static final String KEY_PRINTSHORTCLASSNAMES = "printShortClassNames";
    protected boolean printUserNames = false;
    protected static final String KEY_PRINTUSERNAMES = "printUserNames";
    protected PrintStream stdOut;
    protected PrintStream stdErr;
    protected File logFile = null;
    protected boolean useLogFile = true;
    protected static final String KEY_USELOGFILE = "useLogFile";

    private GenericDebugLogger() {
        this.setOutputStream(System.out);
        this.setErrorStream(System.err);
        try {
            this.loadProperties();
        }
        catch (FileNotFoundException e) {
            this.printMinorError(loggerUserId, e.getMessage());
        }
        catch (IOException e) {
            this.printMinorError(loggerUserId, e.getMessage());
        }
        if (this.useLogFile) {
            this.logFile = new File(PirolPlugInSettings.tempDirectory().getPath() + File.separator + "session.log");
            FileOutputStream fos = null;
            try {
                if (!this.logFile.exists()) {
                    try {
                        this.logFile.createNewFile();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                fos = new FileOutputStream(this.logFile);
                PrintStream logFileStream = new PrintStream(fos);
                this.setOutputStream(logFileStream);
                this.setErrorStream(logFileStream);
            }
            catch (FileNotFoundException e) {
                this.printWarning(loggerUserId, "Problems using a log file: " + e.getMessage());
            }
        }
    }

    protected final void loadProperties() throws IOException {
        this.properties = new PropertiesHandler(propertiesFile);
        this.properties.load();
        this.logLevel = this.properties.getPropertyAsInt(KEY_LOGLEVEL, this.logLevel);
        this.printTimeStamp = this.properties.getPropertyAsBoolean(KEY_PRINTTIMESTAMPS, this.printTimeStamp);
        this.printFileAndLine = this.properties.getPropertyAsBoolean(KEY_PRINTFILEANDLINE, this.printFileAndLine);
        this.printNewLineFirst = this.properties.getPropertyAsBoolean(KEY_PRINTNEWLINEFIRST, this.printNewLineFirst);
        this.printShortClassNames = this.properties.getPropertyAsBoolean(KEY_PRINTSHORTCLASSNAMES, this.printShortClassNames);
        this.printUserNames = this.properties.getPropertyAsBoolean(KEY_PRINTUSERNAMES, this.printUserNames);
        this.useLogFile = this.properties.getPropertyAsBoolean(KEY_USELOGFILE, this.useLogFile);
        this.eclipseFriendlyOutput = this.properties.getPropertyAsBoolean(KEY_ECLIPSEFRIENDLYOUTPUT, this.eclipseFriendlyOutput);
        this.properties.store(null);
    }

    protected final boolean showMessagesOfUser(String user) {
        if (user.equals(loggerUserId)) {
            return true;
        }
        String userString = userFlagPrefix + user.toLowerCase();
        boolean allowMessagesFromUser = false;
        allowMessagesFromUser = this.properties.getPropertyAsBoolean(userString, allowMessagesFromUser);
        try {
            this.properties.store();
        }
        catch (IOException e) {
            this.printMinorError(loggerUserId, e.getMessage());
        }
        return allowMessagesFromUser;
    }

    static GenericDebugLogger getInstance() {
        if (logger == null) {
            logger = new GenericDebugLogger();
        }
        return logger;
    }

    protected final void printMessage(String user, int severity, String message) {
        if (this.properties == null) {
            try {
                this.loadProperties();
            }
            catch (IOException e) {
                this.printError(loggerUserId, "still can not load properties!");
                return;
            }
        }
        if (severity >= this.logLevel || this.showMessagesOfUser(user)) {
            String outputString = this.printUserNames ? "(" + user + ") " : "";
            outputString = outputString + severityLevels[severity] + " in " + this.getCallerString(new Throwable());
            if (this.printTimeStamp) {
                Calendar date = Calendar.getInstance();
                outputString = outputString + "(" + date.get(11) + ":" + date.get(12) + ":" + date.get(13) + "," + date.get(14) + ")";
            }
            outputString = outputString + ": " + (this.eclipseFriendlyOutput ? "\n\t" : "") + message;
            if (this.printNewLineFirst) {
                this.stdOut.println("---");
            }
            if (severity < 2) {
                this.stdOut.println(outputString);
            } else {
                this.stdErr.println(outputString);
            }
        }
    }

    protected final String getCallerString(Throwable t) {
        String caller = "";
        String FileAndNumberSep = ":";
        StackTraceElement[] elements = t.getStackTrace();
        for (int i = 0; i < elements.length; ++i) {
            if (elements[i].getClassName().equals(GenericDebugLogger.class.getName()) || elements[i].getClassName().equals(PersonalLogger.class.getName())) continue;
            caller = this.printShortClassNames && elements[i].getClassName().indexOf(".") > -1 && !this.eclipseFriendlyOutput ? elements[i].getClassName().substring(elements[i].getClassName().lastIndexOf(".") + 1) : elements[i].getClassName();
            caller = caller + "." + elements[i].getMethodName();
            if (!this.eclipseFriendlyOutput) {
                caller = caller + "()";
                FileAndNumberSep = ",";
            }
            if (!this.printFileAndLine && !this.eclipseFriendlyOutput) break;
            caller = caller + "(" + elements[i].getFileName() + FileAndNumberSep + elements[i].getLineNumber() + ") ";
            break;
        }
        if (caller.length() == 0) {
            caller = "???";
        }
        return caller;
    }

    protected final void printDebug(String user, String message) {
        this.printMessage(user, 0, message);
    }

    protected final void printWarning(String user, String message) {
        this.printMessage(user, 1, message);
    }

    protected final void printMinorError(String user, String message) {
        this.printMessage(user, 2, message);
    }

    protected final void printError(String user, String message) {
        this.printMessage(user, 3, message);
    }

    protected final void printSevereError(String user, String message) {
        this.printMessage(user, 4, message);
    }

    public final int getLogLevel() {
        return this.logLevel;
    }

    public final void setLogLevel(int logLevel) {
        this.logLevel = logLevel;
        this.properties.setProperty(KEY_LOGLEVEL, new Integer(logLevel).toString());
        try {
            this.properties.store();
        }
        catch (IOException e) {
            this.printError(loggerUserId, e.getMessage());
        }
    }

    public final boolean isPrintFileAndLine() {
        return this.printFileAndLine;
    }

    public final boolean isPrintNewLineFirst() {
        return this.printNewLineFirst;
    }

    public final boolean isPrintTimeStamp() {
        return this.printTimeStamp;
    }

    public final String getPropertiesFile() {
        return propertiesFile;
    }

    public final void setOutputStream(PrintStream out) {
        this.stdOut = out;
        this.stdOut.print("\n");
    }

    public final void setErrorStream(PrintStream err) {
        this.stdErr = err;
        this.stdErr.print("\n");
    }
}

