/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.wms;

import com.vividsolutions.jump.workbench.Logger;
import com.vividsolutions.jump.workbench.model.WMSLayer;
import com.vividsolutions.wms.AbstractWMSRequest;
import com.vividsolutions.wms.BoundingBox;
import java.awt.geom.Point2D;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.List;
import org.locationtech.jts.geom.Envelope;
import org.openjump.util.UriUtil;

public class FeatureInfoRequest
extends AbstractWMSRequest {
    private WMSLayer wmsLayer;
    private Point2D point;
    private BoundingBox bbox;
    private int height;
    private int width;

    public FeatureInfoRequest(WMSLayer layer) throws IOException {
        super(layer.getService());
        this.wmsLayer = layer;
    }

    public void setPoint(Point2D point) {
        this.point = point;
    }

    public void setBbox(Envelope bbox) {
        this.bbox = new BoundingBox(this.wmsLayer.getSRS(), bbox);
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    @Override
    public URL getURL() throws MalformedURLException {
        String featInfoUrl = UriUtil.urlMakeAppendSafe(this.service.getCapabilities().getFeatureInfoURL());
        if ("1.0.0".equals(this.version)) {
            featInfoUrl = featInfoUrl + "REQUEST=feature_info&WMTVER=1.0.0";
        } else if ("1.1.0".equals(this.version) || "1.1.1".equals(this.version) || "1.3.0".equals(this.version)) {
            featInfoUrl = featInfoUrl + "REQUEST=GetFeatureInfo&SERVICE=WMS&VERSION=" + this.version;
        }
        String names = this.getWmsLayerNames(this.wmsLayer);
        featInfoUrl = featInfoUrl + "&QUERY_LAYERS=" + names + "&LAYERS=" + names;
        featInfoUrl = "1.3.0".equals(this.version) ? featInfoUrl + "&CRS=" + this.wmsLayer.getSRS() + "&I=" + (int)this.point.getX() + "&J=" + (int)this.point.getY() : featInfoUrl + "&SRS=" + this.wmsLayer.getSRS() + "&X=" + (int)this.point.getX() + "&Y=" + (int)this.point.getY();
        featInfoUrl = featInfoUrl + "&WIDTH=" + this.width + "&HEIGHT=" + this.height + "&STYLES=&FORMAT=" + this.wmsLayer.getFormat();
        if (this.bbox != null) {
            featInfoUrl = featInfoUrl + "&" + this.bbox.getBBox(this.version);
        }
        if (!"1.0.0".equals(this.version)) {
            try {
                featInfoUrl = featInfoUrl + "&INFO_FORMAT=" + this.wmsLayer.getService().getCapabilities().getInfoFormat();
            }
            catch (IOException e) {
                featInfoUrl = featInfoUrl + "&INFO_FORMAT=text/plain";
            }
        }
        featInfoUrl = featInfoUrl.concat("&FEATURE_COUNT=10 ");
        Logger.trace(featInfoUrl);
        return new URL(featInfoUrl);
    }

    private String getWmsLayerNames(WMSLayer selLayer) {
        String names = "";
        List<String> layerNames = selLayer.getLayerNames();
        for (int i = 0; i < layerNames.size(); ++i) {
            String name = layerNames.get(i);
            try {
                name = URLEncoder.encode(name, "UTF-8");
            }
            catch (Exception exception) {
                // empty catch block
            }
            names = names + name;
            if (i >= layerNames.size() - 1) continue;
            names = names + ",";
        }
        return names;
    }
}

