/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.wizard;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.ui.InputChangedListener;
import com.vividsolutions.jump.workbench.ui.wizard.WizardPanelV2;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.JPanel;

public class AbstractWizardPanel
extends JPanel
implements WizardPanelV2 {
    private Set<InputChangedListener> listeners = new LinkedHashSet<InputChangedListener>();
    private String id;
    private String nextId;
    private String instructions;
    private String title;
    private Map data;

    public AbstractWizardPanel() {
        this.id = this.getClass().getName();
        this.title = I18N.getInstance().get(this.id);
        this.instructions = I18N.getInstance().get(this.id + ".instructions");
    }

    public AbstractWizardPanel(String id, String title, String instructions) {
        this.id = id;
        this.title = title;
        this.instructions = instructions;
    }

    public AbstractWizardPanel(String id, String nextId, String title, String instructions) {
        this.id = id;
        this.nextId = nextId;
        this.title = title;
        this.instructions = instructions;
    }

    @Override
    public void add(InputChangedListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void remove(InputChangedListener listener) {
        this.listeners.remove(listener);
    }

    protected void fireInputChanged() {
        for (InputChangedListener listener : this.listeners) {
            listener.inputChanged();
        }
    }

    public void enteredFromLeft(Map data) {
        this.data = data;
    }

    @Override
    public void enteredFromRight() throws Exception {
    }

    public Map getData() {
        return this.data;
    }

    @Override
    public void exitingToRight() throws Exception {
    }

    @Override
    public void exitingToLeft() {
    }

    @Override
    public String getID() {
        return this.id;
    }

    @Override
    public String getInstructions() {
        return this.instructions;
    }

    @Override
    public String getNextID() {
        return this.nextId;
    }

    protected void setNextID(String nextId) {
        this.nextId = nextId;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public boolean isInputValid() {
        return true;
    }
}

