/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.warp;

import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.geom.EnvelopeUtil;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.AbstractVectorLayerFinder;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.model.LayerManagerProxy;
import com.vividsolutions.jump.workbench.model.UndoableCommand;
import com.vividsolutions.jump.workbench.ui.cursortool.Animations;
import com.vividsolutions.jump.workbench.ui.cursortool.SpecifyFeaturesTool;
import java.awt.geom.NoninvertibleTransformException;
import java.util.ArrayList;
import java.util.Collection;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.util.Assert;

public abstract class AbstractDeleteVectorTool
extends SpecifyFeaturesTool {
    public AbstractDeleteVectorTool(WorkbenchContext context) {
        super(context);
        this.setViewClickBuffer(6);
    }

    void showAnimation(Collection vectorFeatures) {
        try {
            Animations.drawExpandingRings(this.getPanel().getViewport().toViewPoints(this.centres(vectorFeatures)), true, this.getColor(), this.getPanel(), new float[]{15.0f, 15.0f});
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {
            // empty catch block
        }
    }

    Collection centres(Collection vectorFeatures) {
        ArrayList<Coordinate> centers = new ArrayList<Coordinate>();
        for (Feature vectorFeature : vectorFeatures) {
            Envelope envelope = vectorFeature.getGeometry().getEnvelopeInternal();
            if (envelope.isNull()) continue;
            centers.add(EnvelopeUtil.centre(envelope));
        }
        return centers;
    }

    protected abstract AbstractVectorLayerFinder createVectorLayerFinder(LayerManagerProxy var1);

    @Override
    protected void gestureFinished() throws Exception {
        this.reportNothingToUndoYet();
        AbstractVectorLayerFinder finder = this.createVectorLayerFinder(this.getPanel());
        Layer layer = finder.getLayer();
        if (layer == null) {
            return;
        }
        boolean oldVisible = layer.isVisible();
        layer.setVisible(true);
        if (!this.layerToSpecifiedFeaturesMap().containsKey(finder.getLayer())) {
            return;
        }
        layer.setVisible(oldVisible);
        this.execute(this.createCommand());
    }

    protected UndoableCommand createCommand() throws NoninvertibleTransformException {
        final AbstractVectorLayerFinder finder = this.createVectorLayerFinder(this.getPanel());
        Layer layer = finder.getLayer();
        boolean oldVisible = layer.isVisible();
        layer.setVisible(true);
        final Collection vectorFeaturesToDelete = this.layerToSpecifiedFeaturesMap().get(layer);
        layer.setVisible(oldVisible);
        Assert.isTrue((vectorFeaturesToDelete != null ? 1 : 0) != 0);
        Assert.isTrue((!vectorFeaturesToDelete.isEmpty() ? 1 : 0) != 0);
        return new UndoableCommand(this.getName()){

            @Override
            public void execute() {
                finder.getLayer().getFeatureCollectionWrapper().removeAll(vectorFeaturesToDelete);
                AbstractDeleteVectorTool.this.showAnimation(vectorFeaturesToDelete);
            }

            @Override
            public void unexecute() {
                finder.getLayer().getFeatureCollectionWrapper().addAll(vectorFeaturesToDelete);
            }
        };
    }
}

