/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.toolbox;

import com.vividsolutions.jump.feature.FeatureCollection;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.model.LayerManagerProxy;
import com.vividsolutions.jump.workbench.model.LayerStyleUtil;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.plugin.ThreadedBasePlugIn;
import java.awt.Color;
import java.awt.Component;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;

public abstract class MainButtonPlugIn
extends ThreadedBasePlugIn {
    public static final String GENERATED_KEY = MainButtonPlugIn.class.getName() + " - GENERATED";
    private String taskMonitorTitle;
    private Component toolboxPanel;

    public MainButtonPlugIn(String taskMonitorTitle, Component toolboxPanel) {
        this.taskMonitorTitle = taskMonitorTitle;
        this.toolboxPanel = toolboxPanel;
    }

    @Override
    public String getName() {
        return this.taskMonitorTitle;
    }

    protected Layer generateLayer(String name, String category, Color color, LayerManagerProxy proxy, FeatureCollection featureCollection, String description) {
        return this.generateLayer(false, name, category, color, proxy, featureCollection, description);
    }

    protected Layer generateLineLayer(String name, String category, Color color, LayerManagerProxy proxy, FeatureCollection featureCollection, String description) {
        return this.generateLayer(true, name, category, color, proxy, featureCollection, description);
    }

    private Layer generateLayer(boolean line, String name, String category, Color color, LayerManagerProxy proxy, FeatureCollection featureCollection, String description) {
        Layer layer = proxy.getLayerManager().getLayer(name);
        if (layer == null) {
            layer = new Layer(name, color, featureCollection, proxy.getLayerManager());
            proxy.getLayerManager().addLayer(category, layer);
            layer.setVisible(false);
            if (line) {
                LayerStyleUtil.setLinearStyle(layer, color, 2, 4);
            }
        } else {
            layer.setFeatureCollection(featureCollection);
        }
        layer.setDescription(description);
        layer.getBlackboard().put(GENERATED_KEY, new Object());
        return layer;
    }

    @Override
    public boolean execute(PlugInContext context) throws Exception {
        if (this.validateInput() != null) {
            this.reportValidationError(this.validateInput());
        }
        return this.validateInput() == null;
    }

    private void reportValidationError(String errorMessage) {
        JOptionPane.showMessageDialog(SwingUtilities.windowForComponent(this.toolboxPanel), errorMessage, "JUMP", 0);
    }

    protected void removeAndDisposeLayer(String name, PlugInContext context) {
        Layer layer = context.getLayerManager().getLayer(name);
        if (layer == null) {
            return;
        }
        context.getLayerManager().remove(layer);
        layer.dispose();
    }

    public abstract String validateInput();
}

