/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.style;

import com.vividsolutions.jump.feature.AttributeType;
import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.feature.FeatureCollection;
import com.vividsolutions.jump.feature.FeatureSchema;
import com.vividsolutions.jump.feature.FeatureUtil;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.model.LayerManager;
import com.vividsolutions.jump.workbench.ui.LayerViewPanel;
import com.vividsolutions.jump.workbench.ui.LayerViewPanelContext;
import com.vividsolutions.jump.workbench.ui.Viewport;
import com.vividsolutions.jump.workbench.ui.renderer.style.BasicStyle;
import com.vividsolutions.jump.workbench.ui.renderer.style.LineStringStyle;
import com.vividsolutions.jump.workbench.ui.renderer.style.Style;
import com.vividsolutions.jump.workbench.ui.renderer.style.VertexStyle;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.io.ParseException;
import org.locationtech.jts.io.WKTReader;
import org.locationtech.jts.util.Assert;
import org.openjump.core.ui.util.LayerableUtil;

public class LegendPanel
extends JPanel {
    private final Layer layer;
    private final BasicStyle style;
    private final FeatureCollection featureCollection;
    private static final long serialVersionUID = 1L;
    private final LayerViewPanel dummyLayerViewPanel;
    private final Viewport viewport;

    public LegendPanel(Layer layer, BasicStyle style, FeatureCollection featureCollection) {
        this.setBackground(new Color(0, 0, 0, 0));
        this.setBorder(BorderFactory.createEmptyBorder());
        this.setMaximumSize(new Dimension(120, 40));
        this.setMinimumSize(new Dimension(120, 40));
        this.setPreferredSize(new Dimension(120, 40));
        this.dummyLayerViewPanel = new LayerViewPanel(new LayerManager(), new LayerViewPanelContext(){

            @Override
            public void setStatusMessage(String message) {
            }

            @Override
            public void warnUser(String warning) {
            }

            @Override
            public void handleThrowable(Throwable t) {
            }
        });
        this.viewport = new Viewport(this.dummyLayerViewPanel){
            private final AffineTransform transform;
            {
                this.transform = new AffineTransform();
            }

            @Override
            public Envelope getEnvelopeInModelCoordinates() {
                return new Envelope(0.0, 120.0, 0.0, 40.0);
            }

            @Override
            public AffineTransform getModelToViewTransform() {
                return this.transform;
            }

            @Override
            public Point2D toViewPoint(Coordinate modelCoordinate) {
                return new Point2D.Double(modelCoordinate.x, modelCoordinate.y);
            }
        };
        this.layer = layer;
        this.style = style;
        this.featureCollection = featureCollection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void paint(Style style, Graphics2D g) {
        Stroke originalStroke = g.getStroke();
        if (this.layer.getVertexStyle().getSize() > 40) {
            this.setPreferredSize(new Dimension(120, this.layer.getVertexStyle().getSize()));
        }
        try {
            if (LayerableUtil.isLinealLayer(this.featureCollection)) {
                style.paint(this.lineFeature(), g, this.viewport);
            } else if (LayerableUtil.isPointLayer(this.featureCollection)) {
                style.paint(this.pointFeature(), g, this.viewport);
            } else if (LayerableUtil.isPolygonalLayer(this.featureCollection)) {
                style.paint(this.polygonFeature(), g, this.viewport);
            } else {
                style.paint(this.multiGeometriesFeature(), g, this.viewport);
            }
        }
        catch (Exception e) {
            try {
                style.paint(this.multiGeometriesFeature(), g, this.viewport);
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        }
        finally {
            g.setStroke(originalStroke);
        }
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.paint(this.style, (Graphics2D)g);
        for (Style element : this.layer.getStyles()) {
            Style item = element;
            if (item instanceof LineStringStyle) {
                LineStringStyle lineStyle = (LineStringStyle)item.clone();
                this.paint(lineStyle, (Graphics2D)g);
                continue;
            }
            if (!(item instanceof VertexStyle & this.layer.getVertexStyle().isEnabled())) continue;
            VertexStyle vertexStyle = (VertexStyle)item;
            this.paint(vertexStyle, (Graphics2D)g);
        }
    }

    private Feature polygonFeature() {
        try {
            Feature feat = FeatureUtil.toFeature(new WKTReader().read("POLYGON ((10 10, 110 10, 110 30, 10 30, 10 10))"), new FeatureSchema(){
                private static final long serialVersionUID = -8627306219650589202L;
                {
                    this.addAttribute("GEOMETRY", AttributeType.GEOMETRY);
                }
            });
            return feat;
        }
        catch (ParseException e) {
            Assert.shouldNeverReachHere();
            return null;
        }
    }

    private Feature lineFeature() {
        try {
            Feature feat = FeatureUtil.toFeature(new WKTReader().read("LINESTRING (10 20.05, 110 19.95)"), new FeatureSchema(){
                private static final long serialVersionUID = -8627306219650589202L;
                {
                    this.addAttribute("GEOMETRY", AttributeType.GEOMETRY);
                }
            });
            return feat;
        }
        catch (ParseException e) {
            Assert.shouldNeverReachHere();
            return null;
        }
    }

    private Feature pointFeature() {
        try {
            Feature feat = FeatureUtil.toFeature(new WKTReader().read("POINT (60 20)"), new FeatureSchema(){
                private static final long serialVersionUID = -8627306219650589202L;
                {
                    this.addAttribute("GEOMETRY", AttributeType.GEOMETRY);
                }
            });
            return feat;
        }
        catch (ParseException e) {
            Assert.shouldNeverReachHere();
            return null;
        }
    }

    private Feature multiGeometriesFeature() {
        try {
            Feature feat = FeatureUtil.toFeature(new WKTReader().read("GEOMETRYCOLLECTION (POLYGON ((10 10, 55 10, 55 30, 10 30, 10 10)), POINT (85 15), LINESTRING (65 25.05, 110 24.95))"), new FeatureSchema(){
                private static final long serialVersionUID = -8627306219650589202L;
                {
                    this.addAttribute("GEOMETRY", AttributeType.GEOMETRY);
                }
            });
            return feat;
        }
        catch (ParseException e) {
            Assert.shouldNeverReachHere();
            return null;
        }
    }
}

