/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.style;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.plugin.AbstractPlugIn;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.plugin.MultiEnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.images.IconLoader;
import com.vividsolutions.jump.workbench.ui.renderer.style.Style;
import java.util.Collection;
import javax.swing.ImageIcon;

public class CopyStylesPlugIn
extends AbstractPlugIn {
    static Collection<Style> stylesBuffer = null;
    static boolean isScaleDependentRenderingEnabled = false;
    static double minScale = 1.0;
    static double maxScale = 1.0;

    @Override
    public String getName() {
        return I18N.getInstance().get("ui.style.CopyStylesPlugIn.copy-styles");
    }

    @Override
    public ImageIcon getIcon() {
        return IconLoader.icon("Palette_copy.png");
    }

    public static MultiEnableCheck createEnableCheck(WorkbenchContext workbenchContext) {
        EnableCheckFactory checkFactory = EnableCheckFactory.getInstance(workbenchContext);
        return new MultiEnableCheck().add(checkFactory.createWindowWithLayerNamePanelMustBeActiveCheck()).add(checkFactory.createExactlyNLayersMustBeSelectedCheck(1));
    }

    @Override
    public void initialize(PlugInContext context) throws Exception {
        super.initialize(context);
    }

    @Override
    public boolean execute(PlugInContext context) throws Exception {
        this.reportNothingToUndoYet(context);
        Layer layer = context.getSelectedLayer(0);
        stylesBuffer = layer.cloneStyles();
        isScaleDependentRenderingEnabled = layer.isScaleDependentRenderingEnabled();
        minScale = layer.getMinScale() == null ? 1.0 : layer.getMinScale();
        maxScale = layer.getMaxScale() == null ? 1.0 : layer.getMaxScale();
        return true;
    }
}

