/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.snap;

import com.vividsolutions.jump.geom.CoordUtil;
import com.vividsolutions.jump.util.Blackboard;
import com.vividsolutions.jump.workbench.ui.LayerViewPanel;
import com.vividsolutions.jump.workbench.ui.cursortool.MultiClickTool;
import com.vividsolutions.jump.workbench.ui.snap.SnapManager;
import com.vividsolutions.jump.workbench.ui.snap.SnapPolicy;
import java.util.ArrayList;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;

public class SnapToLineStringBeingEditedPolicy
implements SnapPolicy {
    private GeometryFactory factory = new GeometryFactory();
    private MultiClickTool cursor;
    private Blackboard blackboard;
    public static final String ENABLED_KEY = SnapToLineStringBeingEditedPolicy.class.getName() + " - ENABLED";

    public SnapToLineStringBeingEditedPolicy(Blackboard blackboard, MultiClickTool cursor) {
        this.blackboard = blackboard;
        this.cursor = cursor;
    }

    @Override
    public Coordinate snap(LayerViewPanel panel, Coordinate originalPoint) {
        if (!this.blackboard.get(ENABLED_KEY, false)) {
            return null;
        }
        Geometry bufferedCursorLocation = this.factory.createPoint(originalPoint).buffer((double)SnapManager.getToleranceInPixels(this.blackboard) / panel.getViewport().getScale());
        ArrayList<Coordinate> vertices = new ArrayList<Coordinate>();
        for (Coordinate c : this.cursor.getCoordinates()) {
            if (!bufferedCursorLocation.intersects((Geometry)bufferedCursorLocation.getFactory().createPoint(c))) continue;
            vertices.add(c);
        }
        if (vertices.isEmpty()) {
            return null;
        }
        return CoordUtil.closest(vertices, originalPoint);
    }
}

