/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.renderer.style;

import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.ui.Viewport;
import com.vividsolutions.jump.workbench.ui.images.IconLoader;
import com.vividsolutions.jump.workbench.ui.renderer.style.Style;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.Point2D;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.util.Assert;

public class PinEqualCoordinatesStyle
implements Style {
    private boolean enabled = true;
    private Color color;
    private static Image image = IconLoader.icon("GreenPinPushedIn.gif").getImage();

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void initialize(Layer layer) {
    }

    @Override
    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            Assert.shouldNeverReachHere();
            return null;
        }
    }

    @Override
    public void paint(Feature f, Graphics2D g, Viewport viewport) throws Exception {
        this.paintGeometry(f.getGeometry(), g, viewport);
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public PinEqualCoordinatesStyle() {
        this(Color.black);
    }

    public PinEqualCoordinatesStyle(Color color) {
        this.setColor(color);
    }

    protected void paintGeometry(Geometry geometry, Graphics2D graphics, Viewport viewport) throws Exception {
        if (geometry.isEmpty()) {
            return;
        }
        if (!PinEqualCoordinatesStyle.coordinatesEqual(geometry)) {
            return;
        }
        graphics.setColor(this.color);
        Point2D viewCentre = viewport.toViewPoint(geometry.getCoordinate());
        graphics.drawImage(image, (int)viewCentre.getX() - 9, (int)viewCentre.getY() - 19, null);
    }

    public static boolean coordinatesEqual(Geometry geometry) {
        Coordinate[] coordinates = geometry.getCoordinates();
        for (int i = 1; i < coordinates.length; ++i) {
            if (coordinates[i].equals((Object)coordinates[0])) continue;
            return false;
        }
        return true;
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
    }
}

