/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.renderer.style;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.feature.AttributeType;
import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.feature.FeatureSchema;
import com.vividsolutions.jump.util.CollectionUtil;
import com.vividsolutions.jump.util.Range;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.model.LayerManager;
import com.vividsolutions.jump.workbench.plugin.AbstractPlugIn;
import com.vividsolutions.jump.workbench.plugin.EnableCheck;
import com.vividsolutions.jump.workbench.plugin.MultiEnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.ColorPanel;
import com.vividsolutions.jump.workbench.ui.EnableableToolBar;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import com.vividsolutions.jump.workbench.ui.OKCancelPanel;
import com.vividsolutions.jump.workbench.ui.images.IconLoader;
import com.vividsolutions.jump.workbench.ui.plugin.PersistentBlackboardPlugIn;
import com.vividsolutions.jump.workbench.ui.renderer.style.BasicStyle;
import com.vividsolutions.jump.workbench.ui.renderer.style.BasicStyleListCellRenderer;
import com.vividsolutions.jump.workbench.ui.renderer.style.ColorScheme;
import com.vividsolutions.jump.workbench.ui.renderer.style.ColorSchemeListCellRenderer;
import com.vividsolutions.jump.workbench.ui.renderer.style.ColorThemingStyle;
import com.vividsolutions.jump.workbench.ui.renderer.style.ColorThemingTableModel;
import com.vividsolutions.jump.workbench.ui.renderer.style.DiscreteColorThemingState;
import com.vividsolutions.jump.workbench.ui.renderer.style.Style;
import com.vividsolutions.jump.workbench.ui.renderer.style.XBasicStyle;
import com.vividsolutions.jump.workbench.ui.renderer.style.attributeclassifications.JenksBreaksColorThemingState;
import com.vividsolutions.jump.workbench.ui.renderer.style.attributeclassifications.MaximalBreaksColorThemingState;
import com.vividsolutions.jump.workbench.ui.renderer.style.attributeclassifications.MeanSTDevColorThemingState;
import com.vividsolutions.jump.workbench.ui.renderer.style.attributeclassifications.QuantileColorThemingState;
import com.vividsolutions.jump.workbench.ui.renderer.style.attributeclassifications.RangeColorThemingState;
import com.vividsolutions.jump.workbench.ui.style.StylePanel;
import de.latlon.deejump.plugin.style.DeeRenderingStylePanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;

public class ColorThemingStylePanel
extends JPanel
implements StylePanel {
    private static final String CUSTOM_ENTRY = I18N.getInstance().get("ui.renderer.style.ColorThemingPanel.custom");
    public static final String TITLE = I18N.getInstance().get("ui.renderer.style.ColorThemingPanel.colour-theming");
    private static final String COLOR_SCHEME_KEY = ColorThemingStylePanel.class.getName() + " - COLOR SCHEME";
    private static final Dimension SLIDER_DIMENSION = new Dimension(130, 28);
    private static final int SLIDER_TEXT_FIELD_COLUMNS = 3;
    private WorkbenchContext workbenchContext;
    private Layer layer;
    private final JPanel jPanel1 = new JPanel();
    private final JCheckBox enableColorThemingCheckBox = new JCheckBox();
    private final JLabel attributeLabel = new JLabel();
    private final JComboBox attributeNameComboBox = new JComboBox();
    private String lastAttributeName;
    private final JLabel classificationLabel = new JLabel(I18N.getInstance().get("ui.renderer.style.ColorThemingStylePanel.Classification-Method"));
    private final JComboBox classificationComboBox = new JComboBox();
    private final JLabel colorSchemeLabel = new JLabel();
    private final JComboBox colorSchemeComboBox = new JComboBox();
    private final JPanel jPanel2 = new JPanel();
    private final JScrollPane scrollPane = new JScrollPane();
    private final JLabel transparencyLabel = new JLabel();
    private final JCheckBox transparencyCheckBox = new JCheckBox();
    private final JSlider transparencySlider = new JSlider();
    private final JLabel lineWidthLabel = new JLabel();
    private final JCheckBox lineWidthCheckBox = new JCheckBox();
    private final JSlider lineWidthSlider = new JSlider();
    private final JLabel vertexStyleLabel = new JLabel(I18N.getInstance().get("ui.renderer.style.ColorThemingStylePanel.display-vertices"));
    private final JCheckBox vertexStyleEnableCheckBox = new JCheckBox();
    private final DefaultTableCellRenderer allOtherValuesRenderer = new DefaultTableCellRenderer();
    private final JTable table = new JTable(){

        @Override
        public TableCellRenderer getCellRenderer(int row, int column) {
            TableCellRenderer renderer = this.getCellRendererProper(row, column);
            if (renderer instanceof JComponent) {
                ColorThemingStylePanel.this.updateBackground((JComponent)((Object)renderer));
            }
            return renderer;
        }

        private TableCellRenderer getCellRendererProper(int row, int column) {
            if (row == 0 && column == ColorThemingStylePanel.this.attributeColumn()) {
                return ColorThemingStylePanel.this.allOtherValuesRenderer;
            }
            if (row == 0 && column == ColorThemingStylePanel.this.labelColumn()) {
                return ColorThemingStylePanel.this.allOtherValuesRenderer;
            }
            TableCellRenderer renderer = super.getCellRenderer(row, column);
            if (renderer instanceof JLabel) {
                ((JLabel)((Object)renderer)).setHorizontalAlignment(2);
            }
            return renderer;
        }
    };
    private final JLabel statusLabel = new JLabel(){

        @Override
        public void setText(String text) {
            super.setText(text);
            this.setToolTipText(text);
        }
    };
    private final EnableableToolBar toolBar = new EnableableToolBar();
    private boolean updatingComponents = false;
    private boolean initializing = true;
    private final BasicStyleListCellRenderer basicStyleListCellRenderer = new BasicStyleListCellRenderer();
    private DeeRenderingStylePanel deeRenderingStylePanel;
    private final TableCellEditor basicStyleTableCellEditor = new TableCellEditor(){
        private final DefaultComboBoxModel comboBoxModel = new DefaultComboBoxModel();
        private BasicStyle originalStyle;
        private final DefaultCellEditor editor;
        private final JComboBox comboBox = new JComboBox(this.comboBoxModel){

            @Override
            public void setSelectedItem(Object anObject) {
                if (anObject != CUSTOM_ENTRY) {
                    super.setSelectedItem(anObject);
                    return;
                }
                this.hidePopup();
                BasicStyle style = ColorThemingStylePanel.this.promptBasicStyle(originalStyle);
                if (style == null) {
                    return;
                }
                comboBox.addItem(style);
                super.setSelectedItem(style);
            }
        };
        {
            this.comboBox.setRenderer(ColorThemingStylePanel.this.basicStyleListCellRenderer);
            this.editor = new DefaultCellEditor(this.comboBox);
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            this.originalStyle = (BasicStyle)value;
            this.comboBoxModel.removeAllElements();
            this.comboBoxModel.addElement(CUSTOM_ENTRY);
            this.comboBoxModel.addElement(value);
            for (Color color : ColorScheme.create((String)ColorThemingStylePanel.this.colorSchemeComboBox.getSelectedItem()).getColors()) {
                XBasicStyle xbs = new XBasicStyle(ColorThemingStylePanel.this.getLayer().getBasicStyle(), ColorThemingStylePanel.this.getLayer().getVertexStyle());
                xbs.setFillColor(color);
                xbs.setLineColor(color.darker());
                if (this.originalStyle instanceof XBasicStyle) {
                    xbs.getVertexStyle().setFillColor(color);
                    xbs.getVertexStyle().setFillColor(color.darker());
                    xbs.getVertexStyle().setEnabled(((XBasicStyle)this.originalStyle).getVertexStyle().isEnabled());
                }
                this.comboBoxModel.addElement(xbs);
            }
            this.comboBoxModel.setSelectedItem(value);
            return this.editor.getTableCellEditorComponent(table, value, isSelected, row, column);
        }

        @Override
        public Object getCellEditorValue() {
            return this.editor.getCellEditorValue();
        }

        @Override
        public boolean isCellEditable(EventObject anEvent) {
            return this.editor.isCellEditable(anEvent);
        }

        @Override
        public boolean shouldSelectCell(EventObject anEvent) {
            return this.editor.shouldSelectCell(anEvent);
        }

        @Override
        public boolean stopCellEditing() {
            return this.editor.stopCellEditing();
        }

        @Override
        public void cancelCellEditing() {
            this.editor.cancelCellEditing();
        }

        @Override
        public void addCellEditorListener(CellEditorListener l) {
            this.editor.addCellEditorListener(l);
        }

        @Override
        public void removeCellEditorListener(CellEditorListener l) {
            this.editor.removeCellEditorListener(l);
        }
    };
    private ColorScheme colorSchemeForInserts = null;
    private final MyPlugIn insertPlugIn = new MyPlugIn(){

        @Override
        public String getName() {
            return I18N.getInstance().get("ui.renderer.style.ColorThemingPanel.insert-row");
        }

        @Override
        public Icon getIcon() {
            return GUIUtil.toSmallIcon(IconLoader.icon("Plus.gif"));
        }

        @Override
        public boolean execute(PlugInContext context) throws Exception {
            this.reportNothingToUndoYet(context);
            ColorThemingStylePanel.this.stopCellEditing();
            ColorThemingStylePanel.this.tableModel().insertAttributeValue(ColorThemingStylePanel.this.table.getSelectedRowCount() > 0 ? ColorThemingStylePanel.this.table.getSelectedRows()[0] : ColorThemingStylePanel.this.table.getRowCount(), ColorThemingStylePanel.this.getColorSchemeForInserts());
            if (ColorThemingStylePanel.this.table.getSelectedRowCount() == 0) {
                ColorThemingStylePanel.this.table.scrollRectToVisible(ColorThemingStylePanel.this.table.getCellRect(ColorThemingStylePanel.this.table.getRowCount() - 1, 0, true));
            }
            if (ColorThemingStylePanel.this.table.getSelectedRowCount() != 0) {
                int firstSelectedRow = ColorThemingStylePanel.this.table.getSelectedRows()[0];
                ColorThemingStylePanel.this.table.clearSelection();
                ColorThemingStylePanel.this.table.addRowSelectionInterval(firstSelectedRow, firstSelectedRow);
            }
            return true;
        }
    };
    private final MyPlugIn deletePlugIn = new MyPlugIn(){

        @Override
        public String getName() {
            return I18N.getInstance().get("ui.renderer.style.ColorThemingPanel.delete-row");
        }

        @Override
        public Icon getIcon() {
            return GUIUtil.toSmallIcon(IconLoader.icon("Delete.gif"));
        }

        @Override
        public boolean execute(PlugInContext context) throws Exception {
            this.reportNothingToUndoYet(context);
            ColorThemingStylePanel.this.stopCellEditing();
            ColorThemingStylePanel.this.tableModel().removeAttributeValues(ColorThemingStylePanel.this.table.getSelectedRows());
            return true;
        }
    };
    private final HashSet<ErrorMessage> errorMessages = new HashSet();
    private final DiscreteColorThemingState discreteColorThemingState = new DiscreteColorThemingState(this.table);
    private RangeColorThemingState rangeColorThemingState;
    private QuantileColorThemingState quantileColorThemingState;
    private MeanSTDevColorThemingState meanSTDevColorThemingState;
    private MaximalBreaksColorThemingState maxBreaksColorThemingState;
    private JenksBreaksColorThemingState jenksColorThemingState;
    private State state = this.discreteColorThemingState;
    private final ActionClassification classificationListener = new ActionClassification();
    private static final int UNIQUE_VALUE = 0;
    private static final int EQUAL_INTERVAL = 1;
    private static final int QUANTILE = 2;
    private static final int MEAN_STDEV = 3;
    private static final int MAX_BREAKS = 4;
    private static final int JENKS = 5;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ColorThemingStylePanel(Layer layer, WorkbenchContext workbenchContext) {
        try {
            this.deeRenderingStylePanel = new DeeRenderingStylePanel(workbenchContext.getWorkbench().getBlackboard(), layer, PersistentBlackboardPlugIn.get(workbenchContext));
            this.layer = layer;
            this.workbenchContext = workbenchContext;
            this.rangeColorThemingState = new RangeColorThemingState(this);
            this.quantileColorThemingState = new QuantileColorThemingState(this);
            this.meanSTDevColorThemingState = new MeanSTDevColorThemingState(this);
            this.maxBreaksColorThemingState = new MaximalBreaksColorThemingState(this);
            this.jenksColorThemingState = new JenksBreaksColorThemingState(this);
            this.initAttributeNameComboBox(layer);
            this.jbInit();
            this.state = this.colorThemingStyleHasRanges(this.getLayer()) ? this.rangeColorThemingState : this.discreteColorThemingState;
            this.classificationComboBox.removeItemListener(this.classificationListener);
            this.classificationComboBox.setSelectedIndex(this.colorThemingStyleHasRanges(this.getLayer()) ? 1 : 0);
            this.classificationComboBox.addItemListener(this.classificationListener);
            this.initTable(layer);
            this.setState(this.state);
            this.initColorSchemeComboBox(layer.getLayerManager());
            this.initGlobalTransparency(layer);
            this.initTransparencySlider(layer);
            this.deeRenderingStylePanel.getTransparencySlider().setEnabled(!this.isGlobalTransparencyEnabled());
            this.initGlobalLineWidth(layer);
            this.initLineWidthSlider(layer);
            this.deeRenderingStylePanel.getLineWidthSlider().setEnabled(!this.isGlobalLineWidthEnabled());
            this.initVertexStyleEnabled(layer);
            this.initToolBar();
            this.enableColorThemingCheckBox.setSelected(ColorThemingStyle.get(layer).isEnabled());
            this.vertexStyleEnableCheckBox.setSelected(ColorThemingStyle.get(layer).isVertexStyleEnabled());
            this.updateComponents();
            this.deeRenderingStylePanel.setSynchronizingLineColor(layer.isSynchronizingLineColor());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            this.initializing = false;
        }
    }

    private void updateBackground(JComponent component) {
        component.setBackground(this.enableColorThemingCheckBox.isSelected() ? Color.white : this.jPanel1.getBackground());
    }

    private int attributeColumn() {
        return this.table.convertColumnIndexToView(1);
    }

    private int labelColumn() {
        return this.table.convertColumnIndexToView(2);
    }

    private int colorColumn() {
        return this.table.convertColumnIndexToView(0);
    }

    @Override
    public String getTitle() {
        return TITLE;
    }

    @Override
    public void updateStyles() {
        boolean firingEvents = this.layer.getLayerManager().isFiringEvents();
        this.layer.getLayerManager().setFiringEvents(false);
        try {
            this.layer.removeStyle(ColorThemingStyle.get(this.layer));
            this.layer.addStyle(new ColorThemingStyle(this.getAttributeName(), this.state.toExternalFormat(this.tableModel().getAttributeValueToBasicStyleMap()), this.state.toExternalFormat(this.tableModel().getAttributeValueToLabelMap()), this.tableModel().getDefaultStyle()));
            ColorThemingStyle.get(this.layer).setGlobalTransparencyEnabled(this.transparencyCheckBox.isSelected());
            ColorThemingStyle.get(this.layer).setGlobalLineWidthEnabled(this.lineWidthCheckBox.isSelected());
            ColorThemingStyle.get(this.layer).setAlpha(this.getAlpha());
            ColorThemingStyle.get(this.layer).setLineWidth(this.getLineWidth());
            ColorThemingStyle.get(this.layer).setVertexStyleEnabled(this.isVertexStyleEnabled());
            ColorThemingStyle.get(this.layer).setEnabled(this.enableColorThemingCheckBox.isSelected());
            this.layer.getBasicStyle().setEnabled(!this.enableColorThemingCheckBox.isSelected());
            this.layer.getVertexStyle().setEnabled(this.layer.getVertexStyle().isEnabled() && !this.enableColorThemingCheckBox.isSelected());
        }
        finally {
            this.layer.getLayerManager().setFiringEvents(firingEvents);
        }
        this.layer.fireAppearanceChanged();
    }

    private String getAttributeName() {
        return (String)this.attributeNameComboBox.getSelectedItem();
    }

    private AttributeType getAttributeType() {
        return this.layer.getFeatureCollectionWrapper().getFeatureSchema().getAttributeType(this.getAttributeName());
    }

    private void stopCellEditing() {
        if (this.table.getCellEditor() instanceof DefaultCellEditor) {
            this.table.getCellEditor().stopCellEditing();
        }
    }

    public JCheckBox getSynchronizeCheckBox() {
        return this.deeRenderingStylePanel.getSynchronizeCheckBox();
    }

    public Layer getLayer() {
        return this.layer;
    }

    private void initGlobalTransparency(Layer layer) {
        Style style = layer.getStyle(ColorThemingStyle.class);
        if (style != null) {
            this.transparencyCheckBox.setSelected(((ColorThemingStyle)style).isGlobalTransparencyEnabled());
        }
    }

    private void initTransparencySlider(Layer layer) {
        ColorThemingStyle style = ColorThemingStyle.get(layer);
        if (style != null && style.isGlobalTransparencyEnabled()) {
            this.transparencySlider.setValue(this.transparencySlider.getMaximum() - style.getDefaultStyle().getAlpha());
        }
        this.basicStyleListCellRenderer.setAlpha(this.getAlpha());
    }

    private void initGlobalLineWidth(Layer layer) {
        ColorThemingStyle style = ColorThemingStyle.get(layer);
        if (style != null) {
            this.lineWidthCheckBox.setSelected(style.isGlobalLineWidthEnabled());
        }
    }

    private void initLineWidthSlider(Layer layer) {
        ColorThemingStyle style = ColorThemingStyle.get(layer);
        if (style != null && style.isGlobalLineWidthEnabled()) {
            this.lineWidthSlider.setValue(style.getDefaultStyle().getLineWidth());
        }
        this.basicStyleListCellRenderer.setLineWidth(this.getLineWidth());
    }

    private void initVertexStyleEnabled(Layer layer) {
        this.vertexStyleEnableCheckBox.setSelected(ColorThemingStyle.get(layer).isVertexStyleEnabled());
    }

    private boolean colorThemingStyleHasRanges(Layer layer) {
        return !ColorThemingStyle.get(layer).getAttributeValueToBasicStyleMap().isEmpty() && ColorThemingStyle.get(layer).getAttributeValueToBasicStyleMap().keySet().iterator().next() instanceof Range;
    }

    private void initToolBar() {
        EnableCheck atLeast1RowMustBeSelectedCheck = new EnableCheck(){

            @Override
            public String check(JComponent component) {
                return ColorThemingStylePanel.this.table.getSelectedRowCount() == 0 ? I18N.getInstance().get("ui.renderer.style.ColorThemingPanel.at-least-1-row-must-be-selected") : null;
            }
        };
        EnableCheck layerMustHaveAtLeast1AttributeCheck = new EnableCheck(){

            @Override
            public String check(JComponent component) {
                return ColorThemingStylePanel.this.attributeNameComboBox.getItemCount() == 0 ? I18N.getInstance().get("ui.renderer.style.ColorThemingPanel.layer-must-have-at-least-1-attribute") : null;
            }
        };
        EnableCheck colorThemingMustBeEnabledCheck = new EnableCheck(){

            @Override
            public String check(JComponent component) {
                return !ColorThemingStylePanel.this.enableColorThemingCheckBox.isSelected() ? I18N.getInstance().get("ui.renderer.style.ColorThemingPanel.colour-theming-must-be-enabled") : null;
            }
        };
        this.addPlugIn(this.insertPlugIn, new MultiEnableCheck().add(layerMustHaveAtLeast1AttributeCheck).add(colorThemingMustBeEnabledCheck));
        this.addPlugIn(this.deletePlugIn, new MultiEnableCheck().add(layerMustHaveAtLeast1AttributeCheck).add(atLeast1RowMustBeSelectedCheck).add(colorThemingMustBeEnabledCheck));
    }

    private void addPlugIn(MyPlugIn plugIn, EnableCheck enableCheck) {
        JButton button = new JButton();
        this.toolBar.add(button, plugIn.getName(), plugIn.getIcon(), AbstractPlugIn.toActionListener(plugIn, this.workbenchContext, null), enableCheck);
    }

    private void updateComponents() {
        if (this.updatingComponents) {
            return;
        }
        this.updatingComponents = true;
        try {
            this.attributeLabel.setEnabled(this.enableColorThemingCheckBox.isSelected());
            this.attributeNameComboBox.setEnabled(this.enableColorThemingCheckBox.isSelected());
            this.state.getPanel().setEnabled(this.enableColorThemingCheckBox.isSelected() && this.attributeNameComboBox.getItemCount() > 0);
            this.classificationLabel.setEnabled(this.enableColorThemingCheckBox.isSelected() && this.attributeNameComboBox.getItemCount() > 0 && (this.getAttributeType() == AttributeType.INTEGER || this.getAttributeType() == AttributeType.DOUBLE));
            this.classificationComboBox.setEnabled(this.enableColorThemingCheckBox.isSelected() && this.attributeNameComboBox.getItemCount() > 0 && (this.getAttributeType() == AttributeType.INTEGER || this.getAttributeType() == AttributeType.DOUBLE));
            this.colorSchemeLabel.setEnabled(this.enableColorThemingCheckBox.isSelected() && this.attributeNameComboBox.getItemCount() > 0);
            this.colorSchemeComboBox.setEnabled(this.enableColorThemingCheckBox.isSelected() && this.attributeNameComboBox.getItemCount() > 0);
            this.table.setEnabled(this.enableColorThemingCheckBox.isSelected() && this.attributeNameComboBox.getItemCount() > 0);
            this.scrollPane.setEnabled(this.enableColorThemingCheckBox.isSelected() && this.attributeNameComboBox.getItemCount() > 0);
            this.transparencySlider.setEnabled(this.enableColorThemingCheckBox.isSelected() && this.attributeNameComboBox.getItemCount() > 0 && this.transparencyCheckBox.isSelected());
            this.lineWidthSlider.setEnabled(this.enableColorThemingCheckBox.isSelected() && this.attributeNameComboBox.getItemCount() > 0 && this.lineWidthCheckBox.isSelected());
            this.statusLabel.setEnabled(this.enableColorThemingCheckBox.isSelected());
            this.toolBar.updateEnabledState();
            if (!this.setErrorMessage(new ErrorMessage(I18N.getInstance().get("ui.renderer.style.ColorThemingPanel.cannot-colour-theme-layer-with-no-attributes")), this.attributeNameComboBox.getItemCount() == 0)) {
                this.setErrorMessage(new ErrorMessage(I18N.getInstance().get("ui.renderer.style.ColorThemingPanel.table-must-not-be-empty")), this.table.getRowCount() == 0);
            }
            this.updateErrorDisplay();
            if (this.table.getColumnCount() > 0) {
                this.table.getColumnModel().getColumn(this.table.convertColumnIndexToView(1)).setHeaderValue(this.state.getAttributeValueColumnTitle());
            }
        }
        finally {
            this.updatingComponents = false;
        }
    }

    private BasicStyle promptBasicStyle(BasicStyle basicStyle) {
        int originalTransparencySliderValue = this.transparencyCheckBox.isSelected() ? this.transparencySlider.getValue() : this.transparencySlider.getMaximum() - basicStyle.getAlpha();
        int originalLineWidthSliderValue = this.lineWidthCheckBox.isSelected() ? this.lineWidthSlider.getValue() : basicStyle.getLineWidth();
        this.deeRenderingStylePanel.setBasicStyle(basicStyle);
        this.deeRenderingStylePanel.getTransparencySlider().setValue(originalTransparencySliderValue);
        this.deeRenderingStylePanel.getTransparencySlider().setEnabled(!this.isGlobalTransparencyEnabled());
        this.deeRenderingStylePanel.getLineWidthSlider().setValue(originalLineWidthSliderValue);
        this.deeRenderingStylePanel.getLineWidthSlider().setEnabled(!this.isGlobalLineWidthEnabled());
        OKCancelPanel okCancelPanel = new OKCancelPanel();
        final JDialog dialog = new JDialog((JDialog)SwingUtilities.windowForComponent(this), I18N.getInstance().get("ui.renderer.style.ColorThemingPanel.custom"), true);
        dialog.getContentPane().setLayout(new BorderLayout());
        dialog.getContentPane().add((Component)this.deeRenderingStylePanel, "Center");
        dialog.getContentPane().add((Component)okCancelPanel, "South");
        okCancelPanel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                dialog.setVisible(false);
            }
        });
        dialog.pack();
        GUIUtil.centreOnWindow(dialog);
        dialog.setVisible(true);
        if (!okCancelPanel.wasOKPressed()) {
            this.transparencySlider.setValue(originalTransparencySliderValue);
            this.lineWidthSlider.setValue(originalLineWidthSliderValue);
        }
        return okCancelPanel.wasOKPressed() ? new XBasicStyle(this.deeRenderingStylePanel.getBasicStyle(), this.deeRenderingStylePanel.getVertexStyle()) : null;
    }

    private void initTable(Layer layer) {
        BasicStyle defaultStyle;
        BasicStyle basicStyle = defaultStyle = this.colorThemingStyleHasRanges(this.getLayer()) ? ColorThemingStyle.get(layer).getDefaultStyle() : new XBasicStyle(layer.getBasicStyle(), layer.getVertexStyle());
        assert (defaultStyle instanceof XBasicStyle) : "defaultStyle is not an instance of XBasicStyle";
        this.table.setModel(new ColorThemingTableModel(defaultStyle, ColorThemingStyle.get(layer).getAttributeName(), this.attributeValueToBasicStyleMap(layer), this.attributeValueToLabelMap(layer), layer.getFeatureCollectionWrapper().getFeatureSchema()){

            @Override
            public Object getValueAt(int rowIndex, int columnIndex) {
                if (rowIndex == 0 && columnIndex == 1) {
                    return ColorThemingStylePanel.this.state.getAllOtherValuesDescription();
                }
                if (rowIndex == 0 && columnIndex == 2) {
                    return "";
                }
                return super.getValueAt(rowIndex, columnIndex);
            }
        });
        this.table.createDefaultColumnsFromModel();
        this.table.setRowSelectionAllowed(true);
        this.table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                ColorThemingStylePanel.this.updateComponents();
            }
        });
        this.table.getTableHeader().addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (SwingUtilities.isLeftMouseButton(e) && e.getClickCount() == 1 && ColorThemingStylePanel.this.table.isEnabled()) {
                    ColorThemingStylePanel.this.tableModel().sort();
                }
            }
        });
        this.table.getColumnModel().getColumn(this.colorColumn()).setCellRenderer(new TableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                JComponent renderer = (JComponent)ColorThemingStylePanel.this.basicStyleListCellRenderer.getListCellRendererComponent(new JList(), value, row, isSelected, hasFocus);
                if (!isSelected) {
                    ColorThemingStylePanel.this.updateBackground(renderer);
                }
                return renderer;
            }
        });
        this.table.getColumnModel().getColumn(this.colorColumn()).setCellEditor(this.basicStyleTableCellEditor);
        this.table.getModel().addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                ColorThemingStylePanel.this.updateComponents();
                Object duplicateAttributeValue = ColorThemingStylePanel.this.tableModel().findDuplicateAttributeValue();
                ColorThemingStylePanel.this.setErrorMessage(new ErrorMessage(I18N.getInstance().get("ui.renderer.style.ColorThemingPanel.table-must-not-have-duplicate-attribute-values"), "(" + duplicateAttributeValue + ")"), duplicateAttributeValue != null);
                ColorThemingStylePanel.this.setErrorMessage(new ErrorMessage(I18N.getInstance().get("ui.renderer.style.ColorThemingPanel.table-must-not-have-null-attribute-values")), ColorThemingStylePanel.this.tableModel().containsNullAttributeValues());
            }
        });
        int colorWidth = 10 + (int)this.basicStyleListCellRenderer.getListCellRendererComponent(new JList(), layer.getBasicStyle(), 0, false, false).getPreferredSize().getWidth();
        this.table.getColumnModel().getColumn(this.colorColumn()).setPreferredWidth(colorWidth);
        this.table.getColumnModel().getColumn(this.colorColumn()).setMinWidth(colorWidth);
        this.table.getColumnModel().getColumn(this.colorColumn()).setMaxWidth(colorWidth);
    }

    private Map attributeValueToBasicStyleMap(Layer layer) {
        if (!this.colorThemingAttributeValid(layer)) {
            return new TreeMap();
        }
        return this.state.fromExternalFormat(ColorThemingStyle.get(layer).getAttributeValueToBasicStyleMap());
    }

    private Map attributeValueToLabelMap(Layer layer) {
        if (!this.colorThemingAttributeValid(layer)) {
            return new TreeMap();
        }
        return this.state.fromExternalFormat(ColorThemingStyle.get(layer).getAttributeValueToLabelMap());
    }

    private boolean colorThemingAttributeValid(Layer layer) {
        if (ColorThemingStyle.get(layer).getAttributeName() == null) {
            return false;
        }
        return layer.getFeatureCollectionWrapper().getFeatureSchema().hasAttribute(ColorThemingStyle.get(layer).getAttributeName());
    }

    private void initColorSchemeComboBox(LayerManager layerManager) {
        this.colorSchemeComboBox.setRenderer(new ColorSchemeListCellRenderer(){

            @Override
            protected void color(ColorPanel colorPanel, Color fillColor, Color lineColor) {
                super.color(colorPanel, GUIUtil.alphaColor(fillColor, ColorThemingStylePanel.this.getAlpha()), GUIUtil.alphaColor(lineColor, ColorThemingStylePanel.this.getAlpha()));
            }

            @Override
            protected ColorScheme colorScheme(String name) {
                return ColorThemingStylePanel.this.state.filterColorScheme(super.colorScheme(name));
            }
        });
    }

    private int getAlpha() {
        return this.transparencySlider.getMaximum() - this.transparencySlider.getValue();
    }

    private int getLineWidth() {
        return this.lineWidthSlider.getValue();
    }

    private boolean isGlobalTransparencyEnabled() {
        return this.transparencyCheckBox.isSelected();
    }

    private boolean isGlobalLineWidthEnabled() {
        return this.lineWidthCheckBox.isSelected();
    }

    private boolean isVertexStyleEnabled() {
        return this.vertexStyleEnableCheckBox.isSelected();
    }

    private void initAttributeNameComboBox(Layer layer) {
        DefaultComboBoxModel<String> model = new DefaultComboBoxModel<String>();
        FeatureSchema schema = layer.getFeatureCollectionWrapper().getFeatureSchema();
        for (int i = 0; i < schema.getAttributeCount(); ++i) {
            if (i == schema.getGeometryIndex() || schema.getAttributeName(i).equals("R_G_B")) continue;
            String attributeName = schema.getAttributeName(i);
            model.addElement(attributeName);
        }
        this.attributeNameComboBox.setModel(model);
        if (model.getSize() > 0) {
            if (model.getIndexOf(this.lastAttributeName) >= 0) {
                this.attributeNameComboBox.setSelectedItem(this.lastAttributeName);
            } else if (ColorThemingStyle.get(layer).getAttributeName() == null) {
                this.attributeNameComboBox.setSelectedIndex(0);
                this.lastAttributeName = this.getAttributeName();
            } else {
                this.attributeNameComboBox.setSelectedItem(ColorThemingStyle.get(layer).getAttributeName());
                this.lastAttributeName = this.getAttributeName();
            }
        }
    }

    private void jbInit() {
        this.setLayout(new GridBagLayout());
        this.jPanel1.setLayout(new GridBagLayout());
        this.jPanel2.setLayout(new GridBagLayout());
        this.enableColorThemingCheckBox.setText(I18N.getInstance().get("ui.renderer.style.ColorThemingPanel.enable-colour-theming"));
        this.attributeLabel.setText(I18N.getInstance().get("ui.renderer.style.ColorThemingPanel.attribute") + " ");
        this.statusLabel.setBorder(BorderFactory.createLoweredBevelBorder());
        this.statusLabel.setText(" ");
        this.colorSchemeLabel.setText(I18N.getInstance().get("ui.renderer.style.ColorThemingPanel.colour-scheme") + " ");
        this.attributeNameComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ColorThemingStylePanel.this.attributeNameComboBox_actionPerformed(e);
            }
        });
        this.colorSchemeComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ColorThemingStylePanel.this.colorSchemeComboBox_actionPerformed(e);
            }
        });
        this.enableColorThemingCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (ColorThemingStylePanel.this.enableColorThemingCheckBox.isSelected()) {
                    ColorThemingStylePanel.this.enableColorThemingCheckBox_actionPerformed(e);
                } else {
                    ColorThemingStylePanel.this.layer.getVertexStyle().setEnabled(ColorThemingStyle.get(ColorThemingStylePanel.this.layer).isVertexStyleEnabled());
                }
            }
        });
        this.initClassificationComboBox(this.getAttributeType());
        this.transparencyLabel.setText(I18N.getInstance().get("ui.style.BasicStylePanel.transparency"));
        this.transparencyCheckBox.setSelected(false);
        this.transparencySlider.setMaximum(255);
        this.transparencySlider.setPreferredSize(SLIDER_DIMENSION);
        this.transparencySlider.setMinimumSize(SLIDER_DIMENSION);
        this.transparencySlider.setToolTipText(I18N.getInstance().get("ui.renderer.style.ColorThemingPanel.transparency"));
        this.transparencySlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (ColorThemingStylePanel.this.isGlobalTransparencyEnabled()) {
                    for (Object obj : ColorThemingStylePanel.this.tableModel().getAttributeValueToBasicStyleMap().values()) {
                        ((BasicStyle)obj).setAlpha(ColorThemingStylePanel.this.getAlpha());
                    }
                    ColorThemingStylePanel.this.tableModel().getDefaultStyle().setAlpha(ColorThemingStylePanel.this.getAlpha());
                    ColorThemingStylePanel.this.basicStyleListCellRenderer.setAlpha(ColorThemingStylePanel.this.getAlpha());
                    ColorThemingStylePanel.this.transparencySlider_stateChanged(e);
                }
            }
        });
        this.transparencySlider.setEnabled(false);
        this.lineWidthLabel.setText(I18N.getInstance().get("ui.style.BasicStylePanel.line-width"));
        this.lineWidthCheckBox.setSelected(false);
        this.lineWidthSlider.setMajorTickSpacing(5);
        this.lineWidthSlider.setMinorTickSpacing(1);
        this.lineWidthSlider.setMaximum(30);
        this.lineWidthSlider.setPreferredSize(SLIDER_DIMENSION);
        this.lineWidthSlider.setMinimumSize(SLIDER_DIMENSION);
        this.lineWidthSlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (ColorThemingStylePanel.this.isGlobalLineWidthEnabled()) {
                    for (Object obj : ColorThemingStylePanel.this.tableModel().getAttributeValueToBasicStyleMap().values()) {
                        ((BasicStyle)obj).setLineWidth(ColorThemingStylePanel.this.getLineWidth());
                    }
                    ColorThemingStylePanel.this.tableModel().getDefaultStyle().setLineWidth(ColorThemingStylePanel.this.getLineWidth());
                    ColorThemingStylePanel.this.basicStyleListCellRenderer.setLineWidth(ColorThemingStylePanel.this.getLineWidth());
                    ColorThemingStylePanel.this.lineWidthSlider_stateChanged(e);
                }
            }
        });
        this.lineWidthSlider.setEnabled(false);
        this.transparencyCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                ColorThemingStylePanel.this.transparencyCheckBoxEnabled_stateChanged(e);
            }
        });
        this.lineWidthCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                ColorThemingStylePanel.this.lineWidthCheckBoxEnabled_stateChanged(e);
            }
        });
        this.vertexStyleEnableCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                ColorThemingStylePanel.this.vertexStyleEnabled_stateChanged(e);
            }
        });
        this.add((Component)this.jPanel1, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel1.add((Component)this.enableColorThemingCheckBox, new GridBagConstraints(0, 0, 4, 1, 0.0, 0.0, 17, 0, new Insets(2, 2, 2, 2), 0, 0));
        this.jPanel1.add((Component)this.attributeLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 2, 2, 2), 0, 0));
        this.jPanel1.add((Component)this.attributeNameComboBox, new GridBagConstraints(1, 1, 3, 1, 0.0, 0.0, 17, 0, new Insets(2, 2, 2, 2), 0, 0));
        this.jPanel1.add((Component)this.classificationLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 2, 2, 2), 0, 0));
        this.jPanel1.add((Component)this.classificationComboBox, new GridBagConstraints(1, 2, 3, 1, 0.0, 0.0, 17, 0, new Insets(2, 2, 2, 2), 0, 0));
        this.jPanel1.add((Component)this.colorSchemeLabel, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 2, 2, 2), 0, 0));
        this.jPanel1.add((Component)this.colorSchemeComboBox, new GridBagConstraints(1, 4, 3, 1, 1.0, 0.0, 17, 2, new Insets(2, 2, 2, 2), 0, 0));
        this.add((Component)this.scrollPane, new GridBagConstraints(0, 4, 1, 1, 1.0, 1.0, 10, 1, new Insets(2, 2, 2, 2), 0, 0));
        this.add((Component)this.jPanel2, new GridBagConstraints(0, 5, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel2.add((Component)this.statusLabel, new GridBagConstraints(1, 0, 3, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel2.add((Component)this.toolBar, new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel2.add((Component)this.transparencyCheckBox, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel2.add((Component)this.transparencyLabel, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel2.add((Component)this.transparencySlider, new GridBagConstraints(3, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel2.add((Component)GUIUtil.createSyncdTextField(this.transparencySlider, 3), new GridBagConstraints(4, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel2.add((Component)this.lineWidthCheckBox, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel2.add((Component)this.lineWidthLabel, new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel2.add((Component)this.lineWidthSlider, new GridBagConstraints(3, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel2.add((Component)GUIUtil.createSyncdTextField(this.lineWidthSlider, 3), new GridBagConstraints(4, 2, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel2.add((Component)this.vertexStyleEnableCheckBox, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel2.add((Component)this.vertexStyleLabel, new GridBagConstraints(2, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.scrollPane.getViewport().add(this.table);
    }

    protected void enableColorThemingCheckBox_actionPerformed(ActionEvent e) {
        if (this.table.getRowCount() == 1) {
            this.populateTable();
        }
        this.updateComponents();
    }

    void attributeNameComboBox_actionPerformed(ActionEvent e) {
        try {
            if (this.initializing) {
                return;
            }
            if (this.attributeNameComboBox.getItemCount() == 0) {
                return;
            }
            Object selectedItem = this.attributeNameComboBox.getSelectedItem();
            if (selectedItem != null && selectedItem.equals(this.lastAttributeName)) {
                return;
            }
            this.initClassificationComboBox(this.getAttributeType());
            this.updateComponents();
            this.stopCellEditing();
            this.populateTable();
        }
        finally {
            this.lastAttributeName = this.getAttributeName();
            if (this.table.getModel() instanceof ColorThemingTableModel) {
                this.tableModel().setAttributeName(this.getAttributeName());
            }
        }
    }

    public ColorThemingTableModel tableModel() {
        return (ColorThemingTableModel)this.table.getModel();
    }

    private SortedSet<Object> getNonNullAttributeValues() {
        TreeSet<Object> values = new TreeSet<Object>();
        for (Feature obj : this.layer.getFeatureCollectionWrapper().getFeatures()) {
            Feature feature = obj;
            if (feature.getAttribute(this.getAttributeName()) == null) continue;
            values.add(ColorThemingStyle.trimIfString(feature.getAttribute(this.getAttributeName())));
        }
        return values;
    }

    public void populateTable() {
        if (!this.enableColorThemingCheckBox.isSelected() || this.attributeNameComboBox.getItemCount() <= 0) {
            return;
        }
        this.stopCellEditing();
        this.tableModel().clear();
        Collection<Object> filteredAttributeValues = this.filteredAttributeValues();
        this.tableModel().setMaps(this.toAttributeValueToBasicStyleMap(filteredAttributeValues), this.toAttributeValueToLabelMap(filteredAttributeValues));
        this.tableModel().sort(this.tableModel().wasLastSortAscending());
        this.applyColorScheme();
    }

    private Collection<Object> filteredAttributeValues() {
        return this.state.filterAttributeValues(this.getNonNullAttributeValues());
    }

    private Map<Object, String> toAttributeValueToLabelMap(Collection<Object> attributeValues) {
        Map<Object, Object> attributeValueToValueMap = new TreeMap<Object, Object>();
        for (Object value : attributeValues) {
            attributeValueToValueMap.put(value, value);
        }
        attributeValueToValueMap = CollectionUtil.inverse(this.state.toExternalFormat(attributeValueToValueMap));
        HashMap<Object, String> attributeValueToLabelMap = new HashMap<Object, String>();
        for (Object value : attributeValueToValueMap.keySet()) {
            attributeValueToLabelMap.put(value, attributeValueToValueMap.get(value).toString());
        }
        return attributeValueToLabelMap;
    }

    private Map<Object, BasicStyle> toAttributeValueToBasicStyleMap(Collection<Object> attributeValues) {
        TreeMap<Object, BasicStyle> attributeValueToBasicStyleMap = new TreeMap<Object, BasicStyle>();
        XBasicStyle style = new XBasicStyle(this.getLayer().getBasicStyle(), this.getLayer().getVertexStyle());
        for (Object value : attributeValues) {
            attributeValueToBasicStyleMap.put(value, style);
        }
        return attributeValueToBasicStyleMap;
    }

    void colorSchemeComboBox_actionPerformed(ActionEvent e) {
        if (this.initializing) {
            return;
        }
        this.stopCellEditing();
        this.layer.getLayerManager().getBlackboard().put(COLOR_SCHEME_KEY, this.colorSchemeComboBox.getSelectedItem());
        this.applyColorScheme();
        this.colorSchemeForInserts = null;
    }

    private ColorScheme getColorSchemeForInserts() {
        if (this.colorSchemeForInserts == null || !this.colorSchemeForInserts.getName().equalsIgnoreCase((String)this.colorSchemeComboBox.getSelectedItem())) {
            this.colorSchemeForInserts = ColorScheme.create((String)this.colorSchemeComboBox.getSelectedItem());
        }
        return this.colorSchemeForInserts;
    }

    public void applyColorScheme() {
        this.stopCellEditing();
        this.state.applyColorScheme(this.state.filterColorScheme(ColorScheme.create((String)this.colorSchemeComboBox.getSelectedItem())));
    }

    private void cancelCellEditing() {
        if (this.table.getCellEditor() instanceof DefaultCellEditor) {
            this.table.getCellEditor().cancelCellEditing();
        }
    }

    @Override
    public String validateInput() {
        this.stopCellEditing();
        return this.internalValidateInput();
    }

    private String internalValidateInput() {
        if (!this.enableColorThemingCheckBox.isSelected()) {
            return null;
        }
        if (this.errorMessages.isEmpty()) {
            return null;
        }
        return this.errorMessages.iterator().next().toString();
    }

    private boolean setErrorMessage(ErrorMessage message, boolean enabled) {
        this.errorMessages.remove(message);
        if (enabled) {
            this.errorMessages.add(message);
        }
        this.updateErrorDisplay();
        return enabled;
    }

    private void updateErrorDisplay() {
        String errorMessage = this.internalValidateInput();
        if (errorMessage != null) {
            this.statusLabel.setText(errorMessage);
            this.statusLabel.setIcon(GUIUtil.toSmallIcon(IconLoader.icon("Delete.gif")));
        } else {
            this.statusLabel.setText(" ");
            this.statusLabel.setIcon(null);
        }
    }

    private void setState(State state) {
        this.state.deactivate();
        this.jPanel1.remove(this.state.getPanel());
        this.state = state;
        this.jPanel1.add((Component)state.getPanel(), new GridBagConstraints(0, 3, 4, 1, 0.0, 0.0, 17, 0, new Insets(2, 2, 2, 2), 0, 0));
        this.initializing = true;
        try {
            this.colorSchemeComboBox.setModel(new DefaultComboBoxModel<String>(new Vector<String>(state.getColorSchemeNames())));
            this.colorSchemeComboBox.setSelectedItem(this.layer.getLayerManager().getBlackboard().get(COLOR_SCHEME_KEY, this.colorSchemeComboBox.getItemAt(0)));
        }
        finally {
            this.initializing = false;
        }
        this.updateComponents();
        this.state.activate();
        this.jPanel1.repaint();
    }

    void transparencySlider_stateChanged(ChangeEvent e) {
        this.repaint();
    }

    void lineWidthSlider_stateChanged(ChangeEvent e) {
        this.repaint();
    }

    void transparencyCheckBoxEnabled_stateChanged(ItemEvent e) {
        this.getTransparencySlider().setEnabled(this.transparencyCheckBox.isSelected());
        if (this.transparencyCheckBox.isSelected()) {
            for (Object obj : this.tableModel().getAttributeValueToBasicStyleMap().values()) {
                ((BasicStyle)obj).setAlpha(this.getAlpha());
            }
            this.tableModel().getDefaultStyle().setAlpha(this.getAlpha());
        }
    }

    void lineWidthCheckBoxEnabled_stateChanged(ItemEvent e) {
        this.getLineWidthSlider().setEnabled(this.lineWidthCheckBox.isSelected());
        if (this.lineWidthCheckBox.isSelected()) {
            for (Object obj : this.tableModel().getAttributeValueToBasicStyleMap().values()) {
                ((BasicStyle)obj).setLineWidth(this.getLineWidth());
            }
            this.tableModel().getDefaultStyle().setLineWidth(this.getLineWidth());
        }
    }

    void vertexStyleEnabled_stateChanged(ItemEvent e) {
        for (Object obj : this.tableModel().getAttributeValueToBasicStyleMap().values()) {
            if (!(obj instanceof XBasicStyle)) continue;
            ((XBasicStyle)obj).getVertexStyle().setEnabled(this.vertexStyleEnableCheckBox.isSelected());
            ((XBasicStyle)obj).setRenderingVertices(!this.vertexStyleEnableCheckBox.isSelected());
        }
        if (this.tableModel().getDefaultStyle() instanceof XBasicStyle) {
            ((XBasicStyle)this.tableModel().getDefaultStyle()).getVertexStyle().setEnabled(this.vertexStyleEnableCheckBox.isSelected());
            this.tableModel().getDefaultStyle().setRenderingVertices(!this.vertexStyleEnableCheckBox.isSelected());
        }
    }

    public JSlider getTransparencySlider() {
        return this.transparencySlider;
    }

    public JSlider getLineWidthSlider() {
        return this.lineWidthSlider;
    }

    public JTable getTable() {
        return this.table;
    }

    public SortedMap<Object, Integer> getAttributeValuesCount() {
        TreeMap<Object, Integer> values = new TreeMap<Object, Integer>();
        for (Feature obj : this.layer.getFeatureCollectionWrapper().getFeatures()) {
            Feature feature = obj;
            if (feature.getAttribute(this.getAttributeName()) == null) continue;
            Object key = ColorThemingStyle.trimIfString(feature.getAttribute(this.getAttributeName()));
            Integer count = values.get(key);
            if (count == null) {
                values.put(key, 1);
                continue;
            }
            values.put(key, count + 1);
        }
        return values;
    }

    private void initClassificationComboBox(AttributeType type) {
        this.classificationComboBox.removeItemListener(this.classificationListener);
        this.classificationComboBox.removeAllItems();
        this.classificationComboBox.addItem(I18N.getInstance().get("ui.renderer.style.ColorThemingStylePanel.Unique-value"));
        if (type == AttributeType.INTEGER || type == AttributeType.DOUBLE) {
            this.classificationComboBox.addItem(I18N.getInstance().get("ui.renderer.style.ColorThemingStylePanel.Equal-Interval"));
            this.classificationComboBox.addItem(I18N.getInstance().get("ui.renderer.style.ColorThemingStylePanel.Quantile-Equal-Number"));
            this.classificationComboBox.addItem(I18N.getInstance().get("ui.renderer.style.ColorThemingStylePanel.Mean-Standard-Deviation"));
            this.classificationComboBox.addItem(I18N.getInstance().get("ui.renderer.style.ColorThemingStylePanel.Maximal-Breaks"));
            this.classificationComboBox.addItem(I18N.getInstance().get("ui.renderer.style.ColorThemingStylePanel.Jenks-Optimal-Method"));
        }
        this.classificationComboBox.addItemListener(this.classificationListener);
        if (this.classificationComboBox.getItemCount() == 1 && this.state != this.discreteColorThemingState) {
            this.setState(this.discreteColorThemingState);
        }
    }

    private class ActionClassification
    implements ItemListener {
        private ActionClassification() {
        }

        @Override
        public void itemStateChanged(ItemEvent arg0) {
            switch (ColorThemingStylePanel.this.classificationComboBox.getSelectedIndex()) {
                case 0: {
                    ColorThemingStylePanel.this.setState(ColorThemingStylePanel.this.discreteColorThemingState);
                    break;
                }
                case 1: {
                    ColorThemingStylePanel.this.setState(ColorThemingStylePanel.this.rangeColorThemingState);
                    break;
                }
                case 2: {
                    ColorThemingStylePanel.this.setState(ColorThemingStylePanel.this.quantileColorThemingState);
                    break;
                }
                case 3: {
                    ColorThemingStylePanel.this.setState(ColorThemingStylePanel.this.meanSTDevColorThemingState);
                    break;
                }
                case 4: {
                    ColorThemingStylePanel.this.setState(ColorThemingStylePanel.this.maxBreaksColorThemingState);
                    break;
                }
                case 5: {
                    ColorThemingStylePanel.this.setState(ColorThemingStylePanel.this.jenksColorThemingState);
                }
            }
            ColorThemingStylePanel.this.populateTable();
            ColorThemingStylePanel.this.applyColorScheme();
        }
    }

    private class ErrorMessage {
        private final String commonPart;
        private final String specificPart;

        public ErrorMessage(String commonPart) {
            this(commonPart, "");
        }

        public ErrorMessage(String commonPart, String specificPart) {
            this.commonPart = commonPart;
            this.specificPart = specificPart;
        }

        public int hashCode() {
            return this.commonPart.hashCode();
        }

        public boolean equals(Object obj) {
            return obj instanceof ErrorMessage && this.commonPart.equals(((ErrorMessage)obj).commonPart);
        }

        public String toString() {
            return this.commonPart + this.specificPart;
        }
    }

    private abstract class MyPlugIn
    extends AbstractPlugIn {
        private MyPlugIn() {
        }

        @Override
        public abstract Icon getIcon();
    }

    public static interface State {
        public String getAllOtherValuesDescription();

        public ColorScheme filterColorScheme(ColorScheme var1);

        public void activate();

        public void deactivate();

        public Collection<String> getColorSchemeNames();

        public void applyColorScheme(ColorScheme var1);

        public Collection<Object> filterAttributeValues(SortedSet<Object> var1);

        public String getAttributeValueColumnTitle();

        public JComponent getPanel();

        public Map toExternalFormat(Map var1);

        public Map fromExternalFormat(Map var1);
    }
}

