/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.renderer;

import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.ui.LayerViewPanel;
import com.vividsolutions.jump.workbench.ui.renderer.AbstractSelectionRenderer;
import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.locationtech.jts.geom.Geometry;

public class SelectionBackgroundRenderer
extends AbstractSelectionRenderer {
    public static final String CONTENT_ID = "SELECTION_BACKGROUND";

    public SelectionBackgroundRenderer(LayerViewPanel panel) {
        super(CONTENT_ID, panel, Color.yellow, false, true);
    }

    @Override
    protected Map<Feature, List<Geometry>> featureToSelectedItemsMap(Layer layer) {
        HashSet<Feature> featuresNeedingBackground = new HashSet<Feature>();
        featuresNeedingBackground.addAll(this.panel.getSelectionManager().getPartSelection().getFeaturesWithSelectedItems(layer));
        featuresNeedingBackground.addAll(this.panel.getSelectionManager().getLineStringSelection().getFeaturesWithSelectedItems(layer));
        HashMap<Feature, List<Geometry>> map = new HashMap<Feature, List<Geometry>>();
        for (Feature feature : featuresNeedingBackground) {
            ArrayList<Geometry> list = (ArrayList<Geometry>)map.get(feature);
            if (list == null) {
                list = new ArrayList<Geometry>(1);
                map.put(feature, list);
            }
            list.add(feature.getGeometry());
        }
        return map;
    }
}

