/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.renderer;

import com.vividsolutions.jump.workbench.model.Layerable;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import com.vividsolutions.jump.workbench.ui.LayerViewPanel;
import com.vividsolutions.jump.workbench.ui.renderer.FeatureSelectionRenderer;
import com.vividsolutions.jump.workbench.ui.renderer.LineStringSelectionRenderer;
import com.vividsolutions.jump.workbench.ui.renderer.PartSelectionRenderer;
import com.vividsolutions.jump.workbench.ui.renderer.Renderer;
import com.vividsolutions.jump.workbench.ui.renderer.RendererFactory;
import com.vividsolutions.jump.workbench.ui.renderer.SelectionBackgroundRenderer;
import com.vividsolutions.jump.workbench.ui.renderer.ThreadQueue;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Timer;

public class RenderingManager {
    protected static HashMap layerableClassToRendererFactoryMap = new HashMap();
    private static final Map<Class, RendererFactory> CLASS_RENDERER_FACTORY_MAP = new HashMap<Class, RendererFactory>();
    private LayerViewPanel panel;
    private int maxFeatures = 100;
    public static final String USE_MULTI_RENDERING_THREAD_QUEUE_KEY = RenderingManager.class.getName() + " - USE MULTI RENDERING THREAD QUEUE";
    private Map<Object, Renderer> contentIDToRendererMap = new LinkedHashMap<Object, Renderer>();
    private Map<Object, Renderer.Factory> contentIDToLowRendererFactoryMap = new LinkedHashMap<Object, Renderer.Factory>();
    private Map<Object, Renderer.Factory> contentIDToHighRendererFactoryMap = new LinkedHashMap<Object, Renderer.Factory>();
    private ThreadQueue defaultRendererThreadQueue = new ThreadQueue(1);
    private ThreadQueue multiRendererThreadQueue = new ThreadQueue(20);
    private Timer repaintTimer = new Timer(800, new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            for (Renderer renderer : RenderingManager.this.contentIDToRendererMap.values()) {
                if (!renderer.isRendering()) continue;
                RenderingManager.this.repaintPanel();
                return;
            }
            RenderingManager.this.repaintTimer.stop();
            RenderingManager.this.repaintPanel();
        }
    });
    private boolean paintingEnabled = true;
    public static final int INTERACTIVE = 0;
    public static final int SINGLE_THREAD_QUEUE = 1;
    public static final int EXECUTE_ON_EVENT_THREAD = 2;
    private int renderingMode = 0;
    private Runnable notifyWhenDone = null;

    public void setRenderingMode(int mode) {
        this.renderingMode = mode;
        this.notifyWhenDone = null;
    }

    public void setRenderingMode(Runnable notify, int mode) {
        this.renderingMode = mode;
        this.notifyWhenDone = notify;
    }

    public int getRenderingMode() {
        return this.renderingMode;
    }

    public RenderingManager(final LayerViewPanel panel) {
        this.panel = panel;
        this.repaintTimer.setCoalesce(true);
        this.putAboveLayerables("SELECTION_BACKGROUND", new Renderer.Factory(){

            @Override
            public Renderer create() {
                return new SelectionBackgroundRenderer(panel);
            }
        });
        this.putAboveLayerables("SELECTED_FEATURES", new Renderer.Factory(){

            @Override
            public Renderer create() {
                return new FeatureSelectionRenderer(panel);
            }
        });
        this.putAboveLayerables("SELECTED_LINESTRINGS", new Renderer.Factory(){

            @Override
            public Renderer create() {
                return new LineStringSelectionRenderer(panel);
            }
        });
        this.putAboveLayerables("SELECTED_PARTS", new Renderer.Factory(){

            @Override
            public Renderer create() {
                return new PartSelectionRenderer(panel);
            }
        });
    }

    public void putBelowLayerables(Object contentID, Renderer.Factory factory) {
        this.contentIDToLowRendererFactoryMap.put(contentID, factory);
    }

    public void putAboveLayerables(Object contentID, Renderer.Factory factory) {
        this.contentIDToHighRendererFactoryMap.put(contentID, factory);
    }

    public void renderAll() {
        this.defaultRendererThreadQueue.clear();
        this.multiRendererThreadQueue.clear();
        for (Object contentID : this.contentIDs()) {
            this.render(contentID);
        }
        if (this.notifyWhenDone != null) {
            this.defaultRendererThreadQueue.add(this.notifyWhenDone);
        }
    }

    protected List<Object> contentIDs() {
        ArrayList<Object> contentIDs = new ArrayList<Object>();
        contentIDs.addAll(this.contentIDToLowRendererFactoryMap.keySet());
        Iterator<Layerable> i = this.panel.getLayerManager().reverseIterator(Layerable.class);
        while (i.hasNext()) {
            Layerable layerable = i.next();
            contentIDs.add(layerable);
        }
        contentIDs.addAll(this.contentIDToHighRendererFactoryMap.keySet());
        return contentIDs;
    }

    public Renderer getRenderer(Object contentID) {
        return this.contentIDToRendererMap.get(contentID);
    }

    private void setRenderer(Object contentID, Renderer renderer) {
        this.contentIDToRendererMap.put(contentID, renderer);
    }

    public void render(Object contentID) {
        this.render(contentID, true);
    }

    public void render(Object contentID, boolean clearImageCache) {
        Runnable runnable;
        if (this.getRenderer(contentID) == null) {
            this.setRenderer(contentID, this.createRenderer(contentID));
        }
        if (this.getRenderer(contentID).isRendering()) {
            this.getRenderer(contentID).cancel();
            this.setRenderer(contentID, this.createRenderer(contentID));
        }
        if (clearImageCache) {
            this.getRenderer(contentID).clearImageCache();
        }
        if ((runnable = this.getRenderer(contentID).createRunnable()) != null) {
            if (this.getRenderingMode() == 0) {
                (contentID instanceof Layerable && ((Layerable)contentID).getBlackboard().get(USE_MULTI_RENDERING_THREAD_QUEUE_KEY, false) ? this.multiRendererThreadQueue : this.defaultRendererThreadQueue).add(runnable);
            } else if (this.getRenderingMode() == 1) {
                this.defaultRendererThreadQueue.add(runnable);
            } else {
                try {
                    GUIUtil.invokeOnEventThread(runnable);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
        if (!this.repaintTimer.isRunning()) {
            if (this.getRenderingMode() != 2) {
                this.repaintPanel();
            }
            if (this.getRenderingMode() == 0) {
                this.repaintTimer.start();
            }
        }
    }

    public void repaintPanel() {
        if (!this.paintingEnabled) {
            return;
        }
        this.panel.superRepaint();
    }

    public static Renderer.ContentDependendFactory getRenderFactoryForLayerable(Class clss) {
        if (layerableClassToRendererFactoryMap.containsKey(clss)) {
            return (Renderer.ContentDependendFactory)layerableClassToRendererFactoryMap.get(clss);
        }
        return null;
    }

    public static void putRendererForLayerable(Class clazz, Renderer.ContentDependendFactory rendererFactory) {
        if (!layerableClassToRendererFactoryMap.containsKey(clazz)) {
            layerableClassToRendererFactoryMap.put(clazz, rendererFactory);
        }
    }

    public Renderer createRenderer(Object contentID) {
        RendererFactory rendererFactory = RenderingManager.getRendererFactory(contentID.getClass());
        if (rendererFactory != null) {
            return rendererFactory.create(contentID, this.panel, this.maxFeatures);
        }
        if (RenderingManager.getRenderFactoryForLayerable(contentID.getClass()) != null) {
            return RenderingManager.getRenderFactoryForLayerable(contentID.getClass()).create(contentID);
        }
        if (this.contentIDToLowRendererFactoryMap.containsKey(contentID)) {
            return this.contentIDToLowRendererFactoryMap.get(contentID).create();
        }
        if (this.contentIDToHighRendererFactoryMap.containsKey(contentID)) {
            return this.contentIDToHighRendererFactoryMap.get(contentID).create();
        }
        throw new IllegalArgumentException("No renderer defined for layerable: " + contentID);
    }

    public void setPaintingEnabled(boolean paintingEnabled) {
        this.paintingEnabled = paintingEnabled;
    }

    public void copyTo(Graphics2D destination) {
        for (Object contentID : this.contentIDs()) {
            if (this.getRenderer(contentID) == null) continue;
            this.getRenderer(contentID).copyTo(destination);
        }
    }

    public ThreadQueue getDefaultRendererThreadQueue() {
        return this.defaultRendererThreadQueue;
    }

    public void dispose() {
        this.repaintTimer.stop();
        this.defaultRendererThreadQueue.dispose();
        this.multiRendererThreadQueue.dispose();
        this.contentIDToRendererMap.clear();
    }

    public LayerViewPanel getPanel() {
        return this.panel;
    }

    public int getMaxFeatures() {
        return this.maxFeatures;
    }

    public void setMaxFeatures(int maxFeatures) {
        this.maxFeatures = maxFeatures;
    }

    public void removeLayerRenderer(Object contentID) {
        this.contentIDToRendererMap.remove(contentID);
    }

    public static RendererFactory getRendererFactory(Class clazz) {
        if (clazz == null) {
            return null;
        }
        RendererFactory factory = CLASS_RENDERER_FACTORY_MAP.get(clazz);
        if (factory == null) {
            return RenderingManager.getRendererFactory(clazz.getSuperclass());
        }
        return factory;
    }

    public static void setRendererFactory(Class clazz, RendererFactory factory) {
        CLASS_RENDERER_FACTORY_MAP.put(clazz, factory);
    }
}

