/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin.wms;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.ui.InputChangedFirer;
import com.vividsolutions.jump.workbench.ui.InputChangedListener;
import com.vividsolutions.jump.workbench.ui.wizard.WizardPanel;
import com.vividsolutions.wms.MapStyle;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class SRSWizardPanel
extends JPanel
implements WizardPanel {
    public static final String SRS_KEY = "SRS";
    public static final String FORMAT_KEY = "FORMAT";
    public static final String STYLE_KEY = "STYLE";
    public static final String ADDITIONAL_PARAMETERS_KEY = "ADDITIONAL_PARAMETERS";
    private final InputChangedFirer inputChangedFirer = new InputChangedFirer();
    private final DefaultComboBoxModel<String> srsBoxModel = new DefaultComboBoxModel();
    private final DefaultComboBoxModel<String> formatBoxModel = new DefaultComboBoxModel();
    private final DefaultComboBoxModel<MapStyle> styleBoxModel = new DefaultComboBoxModel();
    private final JComboBox<String> srsComboBox = new JComboBox();
    private final JComboBox<String> formatComboBox = new JComboBox();
    private final JComboBox<MapStyle> styleComboBox = new JComboBox();
    private final JTextField moreParametersTextField = new JTextField(24);
    private Map<String, Object> dataMap = new HashMap<String, Object>();
    private static final Pattern NB = Pattern.compile("^(.*):0*(\\d+)$");
    private static final Comparator<String> cleverStringComparator = (o1, o2) -> {
        Matcher m1 = NB.matcher((CharSequence)o1);
        Matcher m2 = NB.matcher((CharSequence)o2);
        if (m1.matches() && m2.matches() && m1.group(1).equals(m2.group(1))) {
            return Integer.valueOf(m1.group(2)).compareTo(Integer.valueOf(m2.group(2)));
        }
        return o1.compareTo((String)o2);
    };

    public SRSWizardPanel() {
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public void add(InputChangedListener listener) {
        this.inputChangedFirer.add(listener);
    }

    @Override
    public void remove(InputChangedListener listener) {
        this.inputChangedFirer.remove(listener);
    }

    @Override
    public String getInstructions() {
        return I18N.getInstance().get("ui.plugin.wms.SRSWizardPanel.the-layers-you-chosen-support-more-than-one-coordinate-reference");
    }

    void jbInit() {
        JLabel srsLabel = new JLabel(I18N.getInstance().get("ui.plugin.wms.SRSWizardPanel.coordinate-reference-system"));
        JLabel formatLabel = new JLabel(I18N.getInstance().get("ui.plugin.wms.SRSWizardPanel.image-format"));
        JLabel styleLabel = new JLabel(I18N.getInstance().get("ui.plugin.wms.SRSWizardPanel.style"));
        JLabel moreParamLabel = new JLabel(I18N.getInstance().get("ui.plugin.wms.SRSWizardPanel.more-parameters"));
        GridBagLayout gridBagLayout1 = new GridBagLayout();
        this.setLayout(gridBagLayout1);
        GridBagConstraints gb = new GridBagConstraints();
        gb.anchor = 17;
        gb.gridx = 0;
        gb.gridy = 0;
        gb.insets = new Insets(5, 5, 5, 5);
        this.add((Component)srsLabel, gb);
        ++gb.gridx;
        this.add(this.srsComboBox, gb);
        ++gb.gridy;
        gb.gridx = 0;
        this.add((Component)formatLabel, gb);
        ++gb.gridx;
        this.add(this.formatComboBox, gb);
        ++gb.gridy;
        gb.gridx = 0;
        this.add((Component)styleLabel, gb);
        ++gb.gridx;
        this.add(this.styleComboBox, gb);
        ++gb.gridy;
        gb.gridx = 0;
        this.add((Component)moreParamLabel, gb);
        ++gb.gridx;
        this.add((Component)this.moreParametersTextField, gb);
    }

    @Override
    public void exitingToRight() {
        int index = this.srsComboBox.getSelectedIndex();
        String srsCode = this.getCommonSrsList().get(index);
        this.dataMap.put(SRS_KEY, srsCode);
        this.dataMap.put(FORMAT_KEY, this.formatComboBox.getSelectedItem());
        this.dataMap.put(STYLE_KEY, this.styleComboBox.getSelectedItem());
        this.dataMap.put(ADDITIONAL_PARAMETERS_KEY, this.moreParametersTextField.getText());
    }

    private List<String> getCommonSrsList() {
        List list = (List)this.dataMap.get("SRS_LIST");
        String first = list.isEmpty() ? null : (String)list.get(0);
        list.sort(cleverStringComparator);
        if (first != null) {
            list.remove(first);
            list.add(0, first);
        }
        return list;
    }

    public void enteredFromLeft(Map dataMap) {
        this.dataMap = dataMap;
        this.srsBoxModel.removeAllElements();
        for (String string : this.getCommonSrsList()) {
            this.srsBoxModel.addElement(string);
        }
        this.srsComboBox.setModel(this.srsBoxModel);
        String[] formats = (String[])dataMap.get("FORMAT_LIST");
        this.formatBoxModel.removeAllElements();
        for (String f : formats) {
            this.formatBoxModel.addElement(f);
        }
        this.formatComboBox.setModel(this.formatBoxModel);
        List list = (List)dataMap.get("STYLE_LIST");
        this.styleBoxModel.removeAllElements();
        for (MapStyle f : list) {
            this.styleBoxModel.addElement(f);
        }
        this.styleComboBox.setModel(this.styleBoxModel);
        this.moreParametersTextField.setText("");
    }

    @Override
    public String getTitle() {
        return I18N.getInstance().get("ui.plugin.wms.SRSWizardPanel.select-coordinate-reference-system");
    }

    @Override
    public String getID() {
        return this.getClass().getName();
    }

    @Override
    public boolean isInputValid() {
        return true;
    }

    @Override
    public String getNextID() {
        return null;
    }
}

