/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin.generate;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.plugin.AbstractPlugIn;
import com.vividsolutions.jump.workbench.plugin.PlugIn;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import com.vividsolutions.jump.workbench.ui.MultiInputDialog;
import com.vividsolutions.jump.workbench.ui.plugin.generate.BoundaryMatchDataEngine;
import javax.swing.ImageIcon;
import org.locationtech.jts.geom.Coordinate;

public class BoundaryMatchDataPlugIn
extends AbstractPlugIn {
    private BoundaryMatchDataEngine engine = new BoundaryMatchDataEngine();

    @Override
    public void initialize(PlugInContext context) throws Exception {
        super.initialize(context);
        context.getFeatureInstaller().addLayerViewMenuItem((PlugIn)this, new String[]{I18N.getInstance().get("ui.plugin.generate.BoundaryMatchDataPlugIn.tools"), I18N.getInstance().get("ui.plugin.generate.BoundaryMatchDataPlugIn.generate")}, this.getName() + "...");
    }

    @Override
    public boolean execute(PlugInContext context) throws Exception {
        MultiInputDialog dialog = new MultiInputDialog(context.getWorkbenchFrame(), I18N.getInstance().get("ui.plugin.generate.BoundaryMatchDataPlugIn.generate-boundary-match-data"), true);
        this.setDialogValues(dialog);
        GUIUtil.centreOnWindow(dialog);
        dialog.setVisible(true);
        if (!dialog.wasOKPressed()) {
            return false;
        }
        this.getDialogValues(dialog);
        this.engine.execute(context);
        return true;
    }

    private void setDialogValues(MultiInputDialog dialog) {
        dialog.setTitle(I18N.getInstance().get("ui.plugin.generate.BoundaryMatchDataPlugIn.generate-boundary-match-data"));
        dialog.setSideBarImage(new ImageIcon(this.getClass().getResource("GenerateBdyMatchData.gif")));
        dialog.setSideBarDescription(I18N.getInstance().get("ui.plugin.generate.BoundaryMatchDataPlugIn.generates-two-sample-datasets-containing-random-boundary-perturbations"));
        dialog.addPositiveIntegerField(I18N.getInstance().get("ui.plugin.generate.BoundaryMatchDataPlugIn.layer-width-cells"), this.engine.getLayerWidthInCells(), 5);
        dialog.addPositiveIntegerField(I18N.getInstance().get("ui.plugin.generate.BoundaryMatchDataPlugIn.layer-height-cells"), this.engine.getLayerHeightInCells(), 5);
        dialog.addPositiveDoubleField(I18N.getInstance().get("ui.plugin.generate.BoundaryMatchDataPlugIn.cells-side-length"), this.engine.getCellSideLength(), 5);
        dialog.addPositiveIntegerField(I18N.getInstance().get("ui.plugin.generate.BoundaryMatchDataPlugIn.vertices-per-cell-side"), this.engine.getVerticesPerCellSide(), 5);
        dialog.addPositiveIntegerField(I18N.getInstance().get("ui.plugin.generate.BoundaryMatchDataPlugIn.vertices-per-boundary-side"), this.engine.getVerticesPerBoundarySide(), 5);
        dialog.addNonNegativeDoubleField(I18N.getInstance().get("ui.plugin.generate.BoundaryMatchDataPlugIn.boundary-amplitude"), this.engine.getBoundaryAmplitude(), 5);
        dialog.addPositiveDoubleField(I18N.getInstance().get("ui.plugin.generate.BoundaryMatchDataPlugIn.boundary-period"), this.engine.getBoundaryPeriod(), 5);
        dialog.addNonNegativeDoubleField(I18N.getInstance().get("ui.plugin.generate.BoundaryMatchDataPlugIn.max-boundary-perturbation"), this.engine.getMaxBoundaryPerturbation(), 5);
        dialog.addNonNegativeDoubleField(I18N.getInstance().get("ui.plugin.generate.BoundaryMatchDataPlugIn.perturbation-probability"), this.engine.getPerturbationProbability(), 5);
        dialog.addDoubleField("Min X", this.engine.getSouthwestCornerOfLeftLayer().x, 5);
        dialog.addDoubleField("Min Y", this.engine.getSouthwestCornerOfLeftLayer().y, 5);
    }

    private void getDialogValues(MultiInputDialog dialog) {
        this.engine.setSouthwestCornerOfLeftLayer(new Coordinate(dialog.getDouble("Min X"), dialog.getDouble("Min Y")));
        this.engine.setLayerHeightInCells(dialog.getInteger(I18N.getInstance().get("ui.plugin.generate.BoundaryMatchDataPlugIn.layer-height-cells")));
        this.engine.setLayerWidthInCells(dialog.getInteger(I18N.getInstance().get("ui.plugin.generate.BoundaryMatchDataPlugIn.layer-width-cells")));
        this.engine.setCellSideLength(dialog.getDouble(I18N.getInstance().get("ui.plugin.generate.BoundaryMatchDataPlugIn.cells-side-length")));
        this.engine.setVerticesPerCellSide(dialog.getInteger(I18N.getInstance().get("ui.plugin.generate.BoundaryMatchDataPlugIn.vertices-per-cell-side")));
        this.engine.setBoundaryAmplitude(dialog.getDouble(I18N.getInstance().get("ui.plugin.generate.BoundaryMatchDataPlugIn.boundary-amplitude")));
        this.engine.setBoundaryPeriod(dialog.getDouble(I18N.getInstance().get("ui.plugin.generate.BoundaryMatchDataPlugIn.boundary-period")));
        this.engine.setVerticesPerBoundarySide(dialog.getInteger(I18N.getInstance().get("ui.plugin.generate.BoundaryMatchDataPlugIn.vertices-per-boundary-side")));
        this.engine.setMaxBoundaryPerturbation(dialog.getDouble(I18N.getInstance().get("ui.plugin.generate.BoundaryMatchDataPlugIn.max-boundary-perturbation")));
        this.engine.setPerturbationProbability(dialog.getDouble(I18N.getInstance().get("ui.plugin.generate.BoundaryMatchDataPlugIn.perturbation-probability")));
    }
}

