/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin;

import com.vividsolutions.jump.util.Blackboard;
import com.vividsolutions.jump.util.java2xml.Java2XML;
import com.vividsolutions.jump.util.java2xml.XML2Java;
import com.vividsolutions.jump.workbench.JUMPWorkbench;
import com.vividsolutions.jump.workbench.Logger;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.plugin.AbstractPlugIn;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.nio.charset.StandardCharsets;

public class PersistentBlackboardPlugIn
extends AbstractPlugIn {
    private static String persistenceDirectory = ".";
    private static String fileName = "workbench-state.xml";
    private static final String BLACKBOARD_KEY = PersistentBlackboardPlugIn.class.getName() + " - BLACKBOARD";

    public static Blackboard get(WorkbenchContext context) {
        Blackboard blackboard = context.getBlackboard();
        return PersistentBlackboardPlugIn.get(blackboard);
    }

    public static Blackboard getInstance() {
        return PersistentBlackboardPlugIn.get(JUMPWorkbench.getInstance().getContext());
    }

    public static Blackboard get(Blackboard blackboard) {
        if (blackboard.get(BLACKBOARD_KEY) == null) {
            blackboard.put(BLACKBOARD_KEY, new Blackboard());
        }
        return (Blackboard)blackboard.get(BLACKBOARD_KEY);
    }

    public static void setPersistenceDirectory(String value) {
        persistenceDirectory = value;
    }

    public static void setFileName(String value) {
        fileName = value;
    }

    public String getFilePath() {
        return persistenceDirectory + "/" + fileName;
    }

    @Override
    public void initialize(final PlugInContext context) throws Exception {
        super.initialize(context);
        this.restoreState(context.getWorkbenchContext());
        context.getWorkbenchFrame().addComponentListener(new ComponentAdapter(){

            @Override
            public void componentHidden(ComponentEvent e) {
                PersistentBlackboardPlugIn.this.saveState(context.getWorkbenchContext());
            }
        });
    }

    private void restoreState(WorkbenchContext workbenchContext) {
        File curState = new File(this.getFilePath());
        Logger.info("Restore state from " + curState.getAbsolutePath());
        try {
            this.load(workbenchContext, curState);
        }
        catch (Exception e) {
            Logger.error(e);
            File bkpState = new File(this.getBKPFilePath());
            if (!bkpState.exists()) {
                return;
            }
            workbenchContext.getWorkbench().getFrame().log("try to restore from '" + this.getBKPFilePath() + "'.");
            try {
                PersistentBlackboardPlugIn.copyFileUsingChannel(bkpState, curState);
                this.load(workbenchContext, curState);
                workbenchContext.getWorkbench().getFrame().log("restore/load successful.");
            }
            catch (Exception e2) {
                Logger.error(e2);
            }
        }
    }

    private String getBKPFilePath() {
        return this.getFilePath() + ".bkp";
    }

    private String getNEWFilePath() {
        return this.getFilePath() + ".new";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveState(WorkbenchContext workbenchContext) {
        try {
            String newPath = this.getNEWFilePath();
            String oldPath = this.getBKPFilePath();
            String curPath = this.getFilePath();
            Logger.info("Save state to " + curPath);
            FileOutputStream fos = new FileOutputStream(newPath, false);
            OutputStreamWriter osw = new OutputStreamWriter((OutputStream)fos, StandardCharsets.UTF_8);
            try (BufferedWriter bufferedWriter = new BufferedWriter(osw);){
                new Java2XML().write((Object)PersistentBlackboardPlugIn.get(workbenchContext), "workbench-state", bufferedWriter);
                bufferedWriter.flush();
                fos.flush();
            }
            finally {
                fos.close();
            }
            File oldState = new File(oldPath);
            File curState = new File(curPath);
            File newState = new File(newPath);
            boolean success = false;
            if (!(oldState.exists() && !oldState.delete() || curState.exists() && !curState.renameTo(oldState) || !newState.renameTo(curState))) {
                success = true;
            }
            if (!success) {
                workbenchContext.getWorkbench().getFrame().log("failed to write workbench state");
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void load(WorkbenchContext workbenchContext, File file) throws Exception {
        FileInputStream fis = new FileInputStream(file);
        InputStreamReader isr = new InputStreamReader((InputStream)fis, StandardCharsets.UTF_8);
        try (BufferedReader bufferedReader = new BufferedReader(isr);){
            PersistentBlackboardPlugIn.get(workbenchContext).putAll(((Blackboard)new XML2Java(workbenchContext.getWorkbench().getPlugInManager().getClassLoader()).read(bufferedReader, Blackboard.class)).getProperties());
        }
        finally {
            isr.close();
            fis.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void copyFileUsingChannel(File source, File dest) throws IOException {
        AbstractInterruptibleChannel sourceChannel = null;
        AbstractInterruptibleChannel destChannel = null;
        try {
            sourceChannel = new FileInputStream(source).getChannel();
            destChannel = new FileOutputStream(dest).getChannel();
            ((FileChannel)destChannel).transferFrom((ReadableByteChannel)((Object)sourceChannel), 0L, ((FileChannel)sourceChannel).size());
        }
        finally {
            sourceChannel.close();
            destChannel.close();
        }
    }
}

