/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.feature.AttributeType;
import com.vividsolutions.jump.feature.FeatureSchema;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.plugin.AbstractPlugIn;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.plugin.MultiEnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.TitledPopupMenu;
import com.vividsolutions.jump.workbench.ui.images.IconLoader;
import com.vividsolutions.jump.workbench.ui.plugin.FeatureInstaller;
import com.vividsolutions.jump.workbench.ui.plugin.clipboard.AbstractTransferable;
import com.vividsolutions.jump.workbench.ui.plugin.clipboard.DummyClipboardOwner;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.Collection;
import javax.swing.ImageIcon;

public class CopySchemaPlugIn
extends AbstractPlugIn {
    public static ImageIcon ICON = IconLoader.icon("schema_copy.png");

    @Override
    public void initialize(PlugInContext context) throws Exception {
        super.initialize(context);
        WorkbenchContext workbenchContext = context.getWorkbenchContext();
        FeatureInstaller featureInstaller = context.getFeatureInstaller();
        TitledPopupMenu layerNamePopupMenu = context.getWorkbenchContext().getWorkbench().getFrame().getLayerNamePopupMenu();
        featureInstaller.addPopupMenuItem(layerNamePopupMenu, this, new String[]{I18N.getInstance().get("ui.MenuNames.SCHEMA")}, this.getName(), false, this.getIcon(), CopySchemaPlugIn.createEnableCheck(workbenchContext));
    }

    @Override
    public boolean execute(PlugInContext context) throws Exception {
        String schemaString = "";
        Collection<Layer> layerCollection = context.getWorkbenchContext().getLayerableNamePanel().selectedNodes(Layer.class);
        Layer layer = layerCollection.iterator().next();
        FeatureSchema featureSchema = layer.getFeatureCollectionWrapper().getFeatureSchema();
        int numAttributes = featureSchema.getAttributeCount();
        for (int index = 0; index < numAttributes; ++index) {
            String name = featureSchema.getAttributeName(index);
            AttributeType type = featureSchema.getAttributeType(index);
            schemaString = schemaString + name + "\t" + type + "\n";
        }
        final String clipString = schemaString;
        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new AbstractTransferable(new DataFlavor[]{DataFlavor.stringFlavor}){

            @Override
            public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
                return clipString;
            }
        }, new DummyClipboardOwner());
        return true;
    }

    public static MultiEnableCheck createEnableCheck(WorkbenchContext workbenchContext) {
        EnableCheckFactory checkFactory = EnableCheckFactory.getInstance(workbenchContext);
        return new MultiEnableCheck().add(checkFactory.createWindowWithSelectionManagerMustBeActiveCheck()).add(checkFactory.createExactlyNLayersMustBeSelectedCheck(1));
    }

    @Override
    public ImageIcon getIcon() {
        return ICON;
    }
}

