/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.network;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.util.Blackboard;
import com.vividsolutions.jump.util.StringUtil;
import com.vividsolutions.jump.workbench.JUMPWorkbench;
import com.vividsolutions.jump.workbench.Logger;
import com.vividsolutions.jump.workbench.ui.OptionsPanelV2;
import com.vividsolutions.jump.workbench.ui.images.IconLoader;
import com.vividsolutions.jump.workbench.ui.network.DNSResolver;
import com.vividsolutions.jump.workbench.ui.plugin.PersistentBlackboardPlugIn;
import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.Method;
import java.net.Authenticator;
import java.net.InetAddress;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownHostException;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeSet;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.InputVerifier;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.NumberFormatter;
import org.apache.commons.lang3.StringUtils;
import org.saig.core.gui.swing.sldeditor.util.FormUtils;
import org.saig.jump.widgets.config.HTTPProxySettings;
import org.saig.jump.widgets.config.ProxyAuth;
import org.saig.jump.widgets.util.AbstractWaitDialog;

public class ProxySettingsOptionsPanel
extends OptionsPanelV2 {
    private static final long serialVersionUID = 1L;
    public static final Icon ICON = IconLoader.icon("fugue/globe-network.png");
    public static final String HTTP_PROXY_SETTINGS_ENABLED = ProxySettingsOptionsPanel.class.getName() + "-Enabled";
    public static final String HTTP_PROXY_SETTINGS_KEY = ProxySettingsOptionsPanel.class.getName() + "-Settings";
    public static final String TEST_URL_KEY = ProxySettingsOptionsPanel.class.getName() + "-TestUrl";
    public static final String READ_TIMEOUT_KEY = ProxySettingsOptionsPanel.class.getName() + "-ReadTimeout";
    public static final String OPEN_TIMEOUT_KEY = ProxySettingsOptionsPanel.class.getName() + "-ConnectionTimeout";
    private static HashMap defaultValues = new HashMap();
    public static final Icon SUCCESSFULL_CONNECTION_ICON;
    public static final Icon FAILED_CONNECTION_ICON;
    public static final String SUCCESSFULL_CONNECTION_LABEL;
    public static final String FAILED_CONNECTION_LABEL;
    public static final String NAME;
    private static final String DEFAULT_TEST_URL = "http://www.osgeo.org/";
    private static final String DEFAULT_TEST_URL_REGEX = "^https?://www.osgeo.org/?$";
    private static final String[] uservars;
    private static final String[] passvars;
    private static ProxySettingsOptionsPanel instance;
    private JPanel testConnectionPanel;
    private JButton testConnectionButton;
    private JLabel connectionResultsLabel;
    private JTextArea connectionErrorText;
    private JPanel proxySettingsPanel;
    private JCheckBox proxyHTTPEnabledCheckBox;
    private JTextField proxyHostTextField;
    private JTextField proxyPortTextField;
    private JTextField proxyUserTextField;
    private JPasswordField proxyPasswordTextField;
    private JPanel timeoutSettingsPanel;
    private JFormattedTextField connectionTimeoutTextField;
    private JFormattedTextField readTimeoutTextField;
    private JTextField directConnectToTextField;
    private JTextField testUrlTextField;
    JScrollPane scroller;
    protected Blackboard blackboard;

    private ProxySettingsOptionsPanel(Blackboard bb) {
        this.blackboard = bb;
        this.setLayout(new GridBagLayout());
        FormUtils.addRowInGBL(this, 0, 0, this.getProxySettingsPanel());
        FormUtils.addRowInGBL(this, 1, 0, this.getTestConnectionPanel());
        FormUtils.addRowInGBL(this, 2, 0, this.getTimeoutSettingsPanel());
        FormUtils.addFiller(this, 3, 0);
    }

    private JPanel getTestConnectionPanel() {
        if (this.testConnectionPanel == null) {
            this.testConnectionPanel = new JPanel(new GridBagLayout());
            this.testConnectionPanel.setBorder(BorderFactory.createTitledBorder(ProxySettingsOptionsPanel.getMessage("connection-status")));
            JLabel testUrlLabel = new JLabel(ProxySettingsOptionsPanel.getMessage("test-url"));
            this.testUrlTextField = new JTextField();
            this.testUrlTextField.getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void changedUpdate(DocumentEvent e) {
                    this.reset(e);
                }

                @Override
                public void removeUpdate(DocumentEvent e) {
                    this.reset(e);
                }

                @Override
                public void insertUpdate(DocumentEvent e) {
                    this.reset(e);
                }

                public void reset(DocumentEvent e) {
                    String testUrl = ProxySettingsOptionsPanel.this.testUrlTextField.getText();
                    if (testUrl.isEmpty()) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                if (ProxySettingsOptionsPanel.this.testUrlTextField.getText().isEmpty()) {
                                    ProxySettingsOptionsPanel.this.testUrlTextField.setText(ProxySettingsOptionsPanel.DEFAULT_TEST_URL);
                                }
                            }
                        });
                    }
                    boolean defValue = ProxySettingsOptionsPanel.this.isDefaultTestUrl(testUrl);
                    ProxySettingsOptionsPanel.this.testUrlTextField.setForeground(defValue ? Color.gray : Color.black);
                }
            });
            JPanel buttonPanel = new JPanel(new FlowLayout());
            this.testConnectionButton = new JButton(ProxySettingsOptionsPanel.getMessage("check-internet-connection"));
            this.testConnectionButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    String errorMessage = ProxySettingsOptionsPanel.this.validateInput();
                    if (StringUtils.isNotEmpty((CharSequence)errorMessage)) {
                        JOptionPane.showConfirmDialog(null, errorMessage, ProxySettingsOptionsPanel.getMessage("config-error"), 0);
                        return;
                    }
                    new AbstractWaitDialog(JUMPWorkbench.getInstance().getFrame(), ProxySettingsOptionsPanel.getMessage("checking-internet-connection")){

                        @Override
                        protected void methodToPerform() {
                            String result;
                            try {
                                result = ProxySettingsOptionsPanel.this.isConnected();
                                if (!result.matches("^(?i)HTTP/[0-9\\.]+\\s+[123].*")) {
                                    throw new Exception(result);
                                }
                                ProxySettingsOptionsPanel.this.connectionResultsLabel.setText(SUCCESSFULL_CONNECTION_LABEL);
                                ProxySettingsOptionsPanel.this.connectionResultsLabel.setIcon(SUCCESSFULL_CONNECTION_ICON);
                            }
                            catch (Exception e) {
                                ProxySettingsOptionsPanel.this.connectionResultsLabel.setText(FAILED_CONNECTION_LABEL);
                                ProxySettingsOptionsPanel.this.connectionResultsLabel.setIcon(FAILED_CONNECTION_ICON);
                                result = e.getClass().getName() + " -> " + e.getMessage();
                                JUMPWorkbench.getInstance().getFrame().log(Arrays.toString(e.getStackTrace()));
                            }
                            ProxySettingsOptionsPanel.this.connectionErrorText.setText(result);
                            ProxySettingsOptionsPanel.this.scroller.setVisible(!result.isEmpty());
                            ProxySettingsOptionsPanel.this.testConnectionPanel.revalidate();
                        }
                    }.setVisible(true);
                }
            });
            JPanel connectionResultsPanel = new JPanel(new FlowLayout());
            this.connectionResultsLabel = new JLabel();
            this.connectionResultsLabel.setAlignmentX(0.5f);
            this.connectionResultsLabel.setAlignmentY(0.5f);
            this.connectionErrorText = new JTextArea(5, 5);
            this.connectionErrorText.setEditable(false);
            this.connectionErrorText.setLineWrap(true);
            this.connectionErrorText.setFont(this.connectionResultsLabel.getFont());
            this.scroller = new JScrollPane(this.connectionErrorText);
            this.scroller.setMinimumSize(this.connectionErrorText.getPreferredScrollableViewportSize());
            this.scroller.setVisible(false);
            buttonPanel.add(this.testConnectionButton);
            connectionResultsPanel.add(this.connectionResultsLabel);
            FormUtils.addRowInGBL((JComponent)this.testConnectionPanel, 0, 0, testUrlLabel, (JComponent)this.testUrlTextField);
            FormUtils.addRowInGBL(this.testConnectionPanel, 1, 0, connectionResultsPanel);
            FormUtils.addRowInGBL(this.testConnectionPanel, 2, 0, buttonPanel);
            FormUtils.addRowInGBL(this.testConnectionPanel, 3, 0, this.scroller);
        }
        return this.testConnectionPanel;
    }

    private JPanel getProxySettingsPanel() {
        if (this.proxySettingsPanel == null) {
            this.proxySettingsPanel = new JPanel(new GridBagLayout());
            this.proxySettingsPanel.setBorder(BorderFactory.createTitledBorder(ProxySettingsOptionsPanel.getMessage("proxy")));
            this.proxyHTTPEnabledCheckBox = new JCheckBox(ProxySettingsOptionsPanel.getMessage("enable-proxy-connection-through-http(s)"));
            this.proxyHTTPEnabledCheckBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ProxySettingsOptionsPanel.this.refreshEditability();
                }
            });
            JLabel proxyHostLabel = new JLabel(ProxySettingsOptionsPanel.getMessage("proxy-server"));
            this.proxyHostTextField = new JTextField();
            JLabel proxyPortLabel = new JLabel(ProxySettingsOptionsPanel.getMessage("proxy-port"));
            this.proxyPortTextField = new JTextField();
            this.proxyPortTextField.setInputVerifier(new InputVerifier(){

                @Override
                public boolean verify(JComponent input) {
                    try {
                        int port = Integer.parseInt(ProxySettingsOptionsPanel.this.proxyPortTextField.getText().trim());
                        return port > 0 && port <= 65535;
                    }
                    catch (Exception exception) {
                        return false;
                    }
                }
            });
            JLabel proxyUserLabel = new JLabel(ProxySettingsOptionsPanel.getMessage("user"));
            this.proxyUserTextField = new JTextField();
            JLabel proxyPasswordLabel = new JLabel(ProxySettingsOptionsPanel.getMessage("password"));
            this.proxyPasswordTextField = new JPasswordField();
            JLabel directConnectToLabel = new JLabel(ProxySettingsOptionsPanel.getMessage("direct-connection"));
            this.directConnectToTextField = new JTextField();
            FormUtils.addRowInGBL(this.proxySettingsPanel, 0, 0, this.proxyHTTPEnabledCheckBox);
            FormUtils.addRowInGBL((JComponent)this.proxySettingsPanel, 1, 0, proxyHostLabel, (JComponent)this.proxyHostTextField);
            FormUtils.addRowInGBL((JComponent)this.proxySettingsPanel, 2, 0, proxyPortLabel, (JComponent)this.proxyPortTextField);
            FormUtils.addRowInGBL((JComponent)this.proxySettingsPanel, 3, 0, proxyUserLabel, (JComponent)this.proxyUserTextField);
            FormUtils.addRowInGBL((JComponent)this.proxySettingsPanel, 4, 0, proxyPasswordLabel, (JComponent)this.proxyPasswordTextField);
            FormUtils.addRowInGBL((JComponent)this.proxySettingsPanel, 5, 0, directConnectToLabel, (JComponent)this.directConnectToTextField);
        }
        return this.proxySettingsPanel;
    }

    private JPanel getTimeoutSettingsPanel() {
        if (this.timeoutSettingsPanel == null) {
            this.timeoutSettingsPanel = new JPanel(new GridBagLayout());
            this.timeoutSettingsPanel.setBorder(BorderFactory.createTitledBorder(ProxySettingsOptionsPanel.getMessage("timeout")));
            JLabel readTimeoutLabel = new JLabel(ProxySettingsOptionsPanel.getMessage("read-timeout"));
            NumberFormatter readFormatter = this.getIntegerFormatter(false, false);
            this.readTimeoutTextField = new JFormattedTextField(readFormatter);
            JLabel connectionTimeoutLabel = new JLabel(ProxySettingsOptionsPanel.getMessage("connection-timeout"));
            NumberFormatter cnxFormatter = this.getIntegerFormatter(false, false);
            this.connectionTimeoutTextField = new JFormattedTextField(cnxFormatter);
            FormUtils.addRowInGBL((JComponent)this.timeoutSettingsPanel, 0, 0, readTimeoutLabel, (JComponent)this.readTimeoutTextField);
            FormUtils.addRowInGBL((JComponent)this.timeoutSettingsPanel, 1, 0, connectionTimeoutLabel, (JComponent)this.connectionTimeoutTextField);
        }
        return this.timeoutSettingsPanel;
    }

    protected void refreshEditability() {
        boolean isHTTPProxyEnabled = this.proxyHTTPEnabledCheckBox.isSelected();
        this.proxyHostTextField.setEnabled(isHTTPProxyEnabled);
        this.proxyPortTextField.setEnabled(isHTTPProxyEnabled);
        this.proxyUserTextField.setEnabled(isHTTPProxyEnabled);
        this.proxyPasswordTextField.setEnabled(isHTTPProxyEnabled);
        this.directConnectToTextField.setEnabled(isHTTPProxyEnabled);
    }

    @Override
    public Icon getIcon() {
        return ICON;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public void init() {
        String testUrl;
        this.connectionResultsLabel.setIcon(null);
        HTTPProxySettings settings = (HTTPProxySettings)this.blackboard.get(HTTP_PROXY_SETTINGS_KEY);
        this.proxyHTTPEnabledCheckBox.setSelected(settings != null && settings.isEnabled());
        if (settings != null) {
            this.proxyHostTextField.setText(settings.getHost());
            this.proxyPortTextField.setText("" + settings.getPort());
            this.proxyUserTextField.setText(settings.getUserName());
            this.proxyPasswordTextField.setText(settings.getPassword());
            this.directConnectToTextField.setText(settings.getDirectConnectionTo());
        }
        if ((testUrl = (String)this.blackboard.get(TEST_URL_KEY)) != null) {
            this.testUrlTextField.setText(testUrl);
        } else {
            this.testUrlTextField.setText(DEFAULT_TEST_URL);
        }
        this.connectionTimeoutTextField.setText(this.getSetting(OPEN_TIMEOUT_KEY).toString());
        this.readTimeoutTextField.setText(this.getSetting(READ_TIMEOUT_KEY).toString());
        this.refreshEditability();
    }

    @Override
    public void okPressed() {
        HTTPProxySettings settings = this.buildSettingsFromUserParameters();
        ProxySettingsOptionsPanel.applySettingsToSystem(settings);
        this.blackboard.put(HTTP_PROXY_SETTINGS_KEY, settings);
        this.blackboard.put(HTTP_PROXY_SETTINGS_ENABLED, settings.isEnabled());
        String testUrl = this.testUrlTextField.getText().trim();
        if (!testUrl.isEmpty() && !this.isDefaultTestUrl(testUrl)) {
            this.blackboard.put(TEST_URL_KEY, testUrl);
        } else {
            this.blackboard.remove(TEST_URL_KEY);
        }
        Integer readTimeout = null;
        Integer cnxTimeout = null;
        try {
            readTimeout = NumberFormat.getInstance().parse(this.readTimeoutTextField.getText().trim()).intValue();
        }
        catch (ParseException pe) {
            readTimeout = Integer.parseInt(defaultValues.get(READ_TIMEOUT_KEY).toString());
        }
        try {
            cnxTimeout = NumberFormat.getInstance().parse(this.connectionTimeoutTextField.getText().trim()).intValue();
        }
        catch (ParseException pe) {
            cnxTimeout = Integer.parseInt(defaultValues.get(OPEN_TIMEOUT_KEY).toString());
        }
        this.blackboard.put(READ_TIMEOUT_KEY, readTimeout);
        this.blackboard.put(OPEN_TIMEOUT_KEY, cnxTimeout);
    }

    private HTTPProxySettings buildSettingsFromUserParameters() {
        HTTPProxySettings settings = new HTTPProxySettings(this.proxyHTTPEnabledCheckBox.isSelected());
        settings.setHost(StringUtils.trim((String)this.proxyHostTextField.getText()));
        settings.setPort(StringUtils.trim((String)this.proxyPortTextField.getText()));
        settings.setUserName(StringUtils.trim((String)this.proxyUserTextField.getText()));
        settings.setPassword(StringUtils.trim((String)new String(this.proxyPasswordTextField.getPassword())));
        String directConnectTo = this.directConnectToTextField.getText().replaceAll("[,;]+", "|").replaceAll("\\s", "");
        settings.setDirectConnectionTo(directConnectTo);
        settings.setEnabled(this.proxyHTTPEnabledCheckBox.isSelected());
        return settings;
    }

    @Override
    public String validateInput() {
        String errorMessage = null;
        if (this.proxyHTTPEnabledCheckBox.isSelected()) {
            String host = StringUtils.trim((String)this.proxyHostTextField.getText());
            String port = StringUtils.trim((String)this.proxyPortTextField.getText());
            if (!this.proxyPortTextField.getInputVerifier().verify(this.proxyPortTextField) || StringUtils.isEmpty((CharSequence)host) || StringUtils.isEmpty((CharSequence)port) || !StringUtil.isNumber(port)) {
                errorMessage = ProxySettingsOptionsPanel.getMessage("server-or-proxy-port-is-not-correct-check-provided-parameters");
            } else {
                try {
                    StringBuffer strUrl = new StringBuffer();
                    strUrl.append(host.startsWith("http://") ? host.toLowerCase() : "http://" + host.toLowerCase());
                    strUrl.append(StringUtils.isNotEmpty((CharSequence)port) ? ":" + port : "");
                    URL url = new URL(strUrl.toString());
                    String urlHost = url.getHost();
                    DNSResolver dnsRes = new DNSResolver(host);
                    Thread t = new Thread(dnsRes);
                    t.start();
                    t.join(2000L);
                    InetAddress inetAddr = dnsRes.get();
                    if (inetAddr == null) {
                        throw new UnknownHostException(urlHost);
                    }
                }
                catch (Exception e) {
                    Logger.error(e);
                    errorMessage = ProxySettingsOptionsPanel.getMessage("server-or-proxy-port-is-not-correct-check-provided-parameters");
                    errorMessage = errorMessage + "\n " + e.getClass().getName() + " -> " + e.getMessage();
                }
            }
        }
        return errorMessage;
    }

    private boolean isDefaultTestUrl(String urlString) {
        return urlString.matches(DEFAULT_TEST_URL_REGEX);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String isConnected() throws Exception {
        Properties systemProperties = System.getProperties();
        ArrayList<String> backupVars = new ArrayList<String>(Arrays.asList("http.proxyHost", "https.proxyHost", "http.proxyPort", "https.proxyPort", "http.nonProxyHosts"));
        ArrayList<String> authVars = new ArrayList<String>(Arrays.asList(uservars));
        authVars.addAll(Arrays.asList(passvars));
        for (String string : authVars) {
            backupVars.add("http.proxy" + string);
            backupVars.add("https.proxy" + string);
        }
        HashMap<String, Object> backupSettings = new HashMap<String, Object>();
        for (String key : backupVars) {
            Object value = systemProperties.get(key);
            if (value == null) continue;
            backupSettings.put(key, value);
        }
        try {
            HTTPProxySettings settings = this.buildSettingsFromUserParameters();
            ProxySettingsOptionsPanel.applySettingsToSystem(settings);
            String testUrl = this.testUrlTextField.getText().trim();
            URL url = new URL(testUrl);
            URLConnection uRLConnection = url.openConnection();
            this.tuneConnection(uRLConnection);
            Map<String, List<String>> map = uRLConnection.getHeaderFields();
            if (map.values().isEmpty()) {
                this.readConnection(uRLConnection);
                throw new Exception("empty document");
            }
            String value = "";
            for (Map.Entry<String, List<String>> entry : map.entrySet()) {
                if (entry.getKey() != null || entry.getValue() == null || entry.getValue().size() != 1 || !entry.getValue().get(0).matches("^(?i)HTTP/[0-9\\.]+.*")) continue;
                value = entry.getValue().get(0);
            }
            String string = value;
            return string;
        }
        finally {
            for (String key : backupVars) {
                Object value = backupSettings.get(key);
                if (value != null) {
                    systemProperties.put(key, value);
                    continue;
                }
                systemProperties.remove(key);
            }
        }
    }

    private void readConnection(URLConnection con) throws IOException {
        String inputLine;
        BufferedReader in = new BufferedReader(new InputStreamReader(con.getInputStream()));
        while ((inputLine = in.readLine()) != null) {
        }
        in.close();
    }

    private void tuneConnection(URLConnection con) {
        con.setConnectTimeout(Integer.parseInt(ProxySettingsOptionsPanel.getInstance().getSetting(OPEN_TIMEOUT_KEY).toString()));
        con.setReadTimeout(Integer.parseInt(ProxySettingsOptionsPanel.getInstance().getSetting(READ_TIMEOUT_KEY).toString()));
        con.setUseCaches(false);
    }

    private static String getMessage(String id) {
        return I18N.getInstance().get(ProxySettingsOptionsPanel.class.getName() + "." + id);
    }

    private static void applySettingsToSystem(HTTPProxySettings settings) {
        Properties systemSettings = System.getProperties();
        if (settings != null && settings.isEnabled()) {
            systemSettings.put("http.proxyHost", settings.getHost());
            systemSettings.put("https.proxyHost", settings.getHost());
            systemSettings.put("http.proxyPort", settings.getPort() + "");
            systemSettings.put("https.proxyPort", settings.getPort() + "");
            if (StringUtils.isNotEmpty((CharSequence)settings.getUserName())) {
                for (String id : uservars) {
                    systemSettings.put("http.proxy" + id, settings.getUserName());
                    systemSettings.put("https.proxy" + id, settings.getUserName());
                }
            } else {
                for (String id : uservars) {
                    systemSettings.remove("http.proxy" + id);
                    systemSettings.remove("https.proxy" + id);
                }
            }
            if (StringUtils.isNotEmpty((CharSequence)settings.getPassword())) {
                for (String id : passvars) {
                    systemSettings.put("http.proxy" + id, settings.getPassword());
                    systemSettings.put("https.proxy" + id, settings.getPassword());
                }
            } else {
                for (String id : passvars) {
                    systemSettings.remove("http.proxy" + id);
                    systemSettings.remove("https.proxy" + id);
                }
            }
            if (StringUtils.isNotEmpty((CharSequence)settings.getDirectConnectionTo())) {
                systemSettings.put("http.nonProxyHosts", settings.getDirectConnectionTo());
            } else {
                systemSettings.remove("http.nonProxyHosts");
            }
            try {
                Class<?> clazzParam = Class.forName("sun.net.www.protocol.http.AuthCache");
                Class<?> clazzParamImpl = Class.forName("sun.net.www.protocol.http.AuthCacheImpl");
                Object cache = clazzParamImpl.newInstance();
                Class<?> clazz = Class.forName("sun.net.www.protocol.http.AuthCacheValue");
                Method method = clazz.getDeclaredMethod("setAuthCache", clazzParam);
                method.setAccessible(true);
                Object object = method.invoke(null, cache);
            }
            catch (Exception e) {
                Logger.error(e);
            }
            if (!settings.getUserName().isEmpty()) {
                Authenticator.setDefault(new ProxyAuth(settings.getUserName(), settings.getPassword()));
            }
        } else {
            systemSettings.remove("http.proxyHost");
            systemSettings.remove("https.proxyHost");
            systemSettings.remove("http.proxyPort");
            systemSettings.remove("https.proxyPort");
            ArrayList<String> authVars = new ArrayList<String>(Arrays.asList(uservars));
            authVars.addAll(Arrays.asList(passvars));
            for (String string : authVars) {
                systemSettings.remove("http.proxy" + string);
                systemSettings.remove("https.proxy" + string);
            }
            systemSettings.remove("http.nonProxyHosts");
        }
    }

    public static void restoreSystemSettings(Blackboard blackboard) {
        HTTPProxySettings settings = (HTTPProxySettings)blackboard.get(HTTP_PROXY_SETTINGS_KEY);
        if (settings != null) {
            boolean enabled = blackboard.get(HTTP_PROXY_SETTINGS_ENABLED, true);
            settings.setEnabled(enabled);
            ProxySettingsOptionsPanel.applySettingsToSystem(settings);
        }
    }

    private static void printProps(String title) {
        Properties ps = System.getProperties();
        TreeSet<Object> v = new TreeSet<Object>(ps.keySet());
        String out = title + "\n";
        for (String string : v) {
            if (!string.matches("^http.*")) continue;
            out = out + string + "=" + ps.getProperty(string) + "\n";
        }
        System.out.println(out);
    }

    private NumberFormatter getIntegerFormatter(boolean allowInvalid, boolean commitsOnValidEdit) {
        NumberFormat format = NumberFormat.getInstance();
        NumberFormatter formatter = new NumberFormatter(format);
        formatter.setValueClass(Integer.class);
        formatter.setMinimum(Integer.valueOf(0));
        formatter.setMaximum(Integer.valueOf(Integer.MAX_VALUE));
        formatter.setAllowsInvalid(allowInvalid);
        formatter.setCommitsOnValidEdit(commitsOnValidEdit);
        return formatter;
    }

    public static ProxySettingsOptionsPanel getInstance() {
        if (instance == null) {
            instance = new ProxySettingsOptionsPanel(PersistentBlackboardPlugIn.get(JUMPWorkbench.getInstance().getBlackboard()));
        }
        return instance;
    }

    public Object getSetting(String key) {
        return this.blackboard.get(key, defaultValues.get(key));
    }

    static {
        defaultValues.put(READ_TIMEOUT_KEY, 5000);
        defaultValues.put(OPEN_TIMEOUT_KEY, 20000);
        SUCCESSFULL_CONNECTION_ICON = IconLoader.icon("saig/internet_connection_ok.png");
        FAILED_CONNECTION_ICON = IconLoader.icon("saig/internet_connection_failed.png");
        SUCCESSFULL_CONNECTION_LABEL = ProxySettingsOptionsPanel.getMessage("connected");
        FAILED_CONNECTION_LABEL = ProxySettingsOptionsPanel.getMessage("not-connected");
        NAME = ProxySettingsOptionsPanel.getMessage("network-properties");
        uservars = new String[]{"User", "user", "UserName", "Username", "username"};
        passvars = new String[]{"Pass", "pass", "PassWord", "Password", "password"};
        instance = null;
        boolean newCiphers = false;
        try {
            newCiphers = Double.parseDouble(System.getProperty("java.version").substring(0, 3)) > 1.6;
        }
        catch (Exception exception) {
            // empty catch block
        }
        System.setProperty("https.protocols", "SSLv3,TLSv1" + (newCiphers ? ",TLSv1.1,TLSv1.2" : ""));
    }
}

