/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.cursortool.editing;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.plugin.EnableCheck;
import com.vividsolutions.jump.workbench.ui.cursortool.AbstractCursorTool;
import com.vividsolutions.jump.workbench.ui.cursortool.DrawRectangleFenceTool;
import com.vividsolutions.jump.workbench.ui.cursortool.QuasimodeTool;
import com.vividsolutions.jump.workbench.ui.cursortool.editing.SnapVerticesToSelectedVertexClickTool;
import com.vividsolutions.jump.workbench.ui.images.IconLoader;
import java.awt.Cursor;
import java.awt.event.MouseEvent;
import javax.swing.Icon;
import javax.swing.JComponent;

public class SnapVerticesToSelectedVertexTool
extends QuasimodeTool {
    private static final Cursor SHIFT_DOWN_CURSOR = AbstractCursorTool.createCursor(IconLoader.icon("SnapVerticesTogetherCursor3.gif").getImage());
    private static final Cursor SHIFT_NOT_DOWN_CURSOR = AbstractCursorTool.createCursor(IconLoader.icon("SnapVerticesTogetherCursor4.gif").getImage());
    private static final String NAME = I18N.getInstance().get("com.vividsolutions.jump.workbench.ui.cursortool.editing.SnapVerticesToSelectedVertexTool");

    @Override
    public String getName() {
        return NAME;
    }

    public SnapVerticesToSelectedVertexTool(WorkbenchContext context) {
        super(new DrawRectangleFenceTool(context){

            @Override
            public String getName() {
                return NAME;
            }

            @Override
            public void mouseClicked(final MouseEvent e) {
                if (!this.check(new EnableCheck(){

                    @Override
                    public String check(JComponent component) {
                        return !e.isShiftDown() ? I18N.getInstance().get("ui.cursortool.editing.SnapVerticesToSelectedVertexTool.shift-click-the-vertex-to-snap-to") : null;
                    }
                })) {
                    return;
                }
                super.mouseClicked(e);
            }

            @Override
            public Cursor getCursor() {
                return SHIFT_NOT_DOWN_CURSOR;
            }
        });
        this.add(new QuasimodeTool.ModifierKeySpec(false, true, false), new SnapVerticesToSelectedVertexClickTool(context){

            @Override
            public Cursor getCursor() {
                return SHIFT_DOWN_CURSOR;
            }

            @Override
            public String getName() {
                return NAME;
            }
        });
    }

    @Override
    public Icon getIcon() {
        return IconLoader.icon("SnapVerticesTogether.gif");
    }
}

