/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.cursortool.editing;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.feature.FeatureUtil;
import com.vividsolutions.jump.workbench.JUMPWorkbench;
import com.vividsolutions.jump.workbench.Logger;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.model.StandardCategoryNames;
import com.vividsolutions.jump.workbench.model.UndoableCommand;
import com.vividsolutions.jump.workbench.plugin.AbstractPlugIn;
import com.vividsolutions.jump.workbench.ui.EditOptionsPanel;
import com.vividsolutions.jump.workbench.ui.EditTransaction;
import com.vividsolutions.jump.workbench.ui.GeometryEditor;
import com.vividsolutions.jump.workbench.ui.InfoFrame;
import com.vividsolutions.jump.workbench.ui.LayerNamePanelProxy;
import com.vividsolutions.jump.workbench.ui.LayerViewPanel;
import com.vividsolutions.jump.workbench.ui.SelectionManager;
import com.vividsolutions.jump.workbench.ui.WorkbenchFrame;
import com.vividsolutions.jump.workbench.ui.cursortool.AbstractCursorTool;
import com.vividsolutions.jump.workbench.ui.cursortool.CursorTool;
import com.vividsolutions.jump.workbench.ui.cursortool.DelegatingTool;
import com.vividsolutions.jump.workbench.ui.images.IconLoader;
import com.vividsolutions.jump.workbench.ui.plugin.AddNewLayerPlugIn;
import com.vividsolutions.jump.workbench.ui.plugin.PersistentBlackboardPlugIn;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Point;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.swing.JInternalFrame;
import org.locationtech.jts.geom.CoordinateList;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.util.Assert;

public class FeatureDrawingUtil {
    protected List<Feature> featsToAdd;
    private final LayerNamePanelProxy layerNamePanelProxy;
    private final GeometryEditor editor = new GeometryEditor();

    private Collection<Feature> selectedFeaturesContaining(Polygon polygon, LayerViewPanel panel) {
        if (this.layerNamePanelProxy.getLayerNamePanel().chooseEditableLayer() == null) {
            return new ArrayList<Feature>();
        }
        ArrayList<Feature> selectedFeaturesContainingPolygon = new ArrayList<Feature>();
        for (Feature feature : panel.getSelectionManager().getFeaturesWithSelectedItems(this.layerNamePanelProxy.getLayerNamePanel().chooseEditableLayer())) {
            if (feature.getGeometry().getClass() == GeometryCollection.class || !feature.getGeometry().getEnvelopeInternal().contains(polygon.getEnvelopeInternal()) || !feature.getGeometry().contains((Geometry)polygon)) continue;
            selectedFeaturesContainingPolygon.add(feature);
        }
        return selectedFeaturesContainingPolygon;
    }

    private void createHole(Polygon hole, Collection<Feature> features, Layer layer, LayerViewPanel panel, boolean rollingBackInvalidEdits, String transactionName) {
        Assert.isTrue((hole.getNumInteriorRing() == 0 ? 1 : 0) != 0);
        EditTransaction transaction = new EditTransaction(features, transactionName, layer, rollingBackInvalidEdits, false, panel);
        for (Feature feature : transaction.getFeatures()) {
            transaction.setGeometry(feature, transaction.getGeometry(feature).difference((Geometry)hole));
        }
        transaction.commit();
    }

    public FeatureDrawingUtil(LayerNamePanelProxy layerNamePanelProxy) {
        this.layerNamePanelProxy = layerNamePanelProxy;
    }

    private Layer layer(LayerViewPanel layerViewPanel) {
        if (this.layerNamePanelProxy.getLayerNamePanel().chooseEditableLayer() == null) {
            Layer layer = layerViewPanel.getLayerManager().addLayer(StandardCategoryNames.WORKING, I18N.getInstance().get("ui.cursortool.editing.FeatureDrawingUtil.new"), AddNewLayerPlugIn.createBlankFeatureCollection());
            layer.setEditable(true);
            layerViewPanel.getContext().warnUser(I18N.getInstance().get("ui.cursortool.editing.FeatureDrawingUtil.no-layer-is-editable-creating-new-editable-layer"));
        }
        return this.layerNamePanelProxy.getLayerNamePanel().chooseEditableLayer();
    }

    public UndoableCommand createAddCommand(Geometry geometry, boolean rollingBackInvalidEdits, final LayerViewPanel layerViewPanel, AbstractCursorTool tool) {
        if (rollingBackInvalidEdits && !geometry.isValid()) {
            layerViewPanel.getContext().warnUser(I18N.getInstance().get("ui.cursortool.editing.FeatureDrawingUtil.draw-feature-tool-topology-error"));
            Logger.error(new InvalidParameterException("Parameter geometry is not valid according to jts."));
            return null;
        }
        layerViewPanel.setViewportInitialized(true);
        Layer layer = this.layer(layerViewPanel);
        final Feature feature = FeatureUtil.toFeature(this.editor.removeRepeatedPoints(geometry), layer.getFeatureCollectionWrapper().getFeatureSchema());
        this.featsToAdd = new ArrayList<Feature>();
        this.featsToAdd.add(feature);
        return new UndoableCommand(tool.getName(), layer){

            @Override
            public void execute() {
                this.getLayer().getFeatureCollectionWrapper().add(feature);
                SelectionManager selectionManager = layerViewPanel.getSelectionManager();
                if (PersistentBlackboardPlugIn.get(layerViewPanel.getWorkBenchFrame().getContext()).get(EditOptionsPanel.SELECT_NEW_GEOMETRY_KEY, false)) {
                    FeatureDrawingUtil.this.featsToAdd = new ArrayList<Feature>();
                    FeatureDrawingUtil.this.featsToAdd.add(feature);
                    selectionManager.clear();
                    selectionManager.getFeatureSelection().selectItems(FeatureDrawingUtil.this.layer(layerViewPanel), FeatureDrawingUtil.this.featsToAdd);
                    if (PersistentBlackboardPlugIn.get(layerViewPanel.getWorkBenchFrame().getContext()).get(EditOptionsPanel.SELECT_INFO_GEOMETRY_KEY, false)) {
                        WorkbenchFrame wFrame = JUMPWorkbench.getInstance().getFrame();
                        for (JInternalFrame iFrame : wFrame.getInternalFrames()) {
                            if (!(iFrame instanceof InfoFrame)) continue;
                            ((InfoFrame)iFrame).getModel().remove(FeatureDrawingUtil.this.layer(layerViewPanel));
                            ((InfoFrame)iFrame).getModel().add(FeatureDrawingUtil.this.layer(layerViewPanel), selectionManager.getFeaturesWithSelectedItems(FeatureDrawingUtil.this.layer(layerViewPanel)));
                            iFrame.toFront();
                            return;
                        }
                        InfoFrame infoFrame = new InfoFrame(wFrame.getContext(), wFrame.getActiveTaskFrame(), wFrame.getActiveTaskFrame().getTaskFrame());
                        infoFrame.setSize(500, 300);
                        infoFrame.getModel().add(FeatureDrawingUtil.this.layer(layerViewPanel), selectionManager.getFeaturesWithSelectedItems(FeatureDrawingUtil.this.layer(layerViewPanel)));
                        wFrame.addInternalFrame(infoFrame);
                    }
                }
            }

            @Override
            public void unexecute() {
                this.getLayer().getFeatureCollectionWrapper().remove(feature);
            }
        };
    }

    public CursorTool prepare(final AbstractCursorTool drawFeatureTool, boolean allowSnapping) {
        drawFeatureTool.setColor(Color.red);
        if (allowSnapping) {
            drawFeatureTool.allowSnapping();
        }
        return new DelegatingTool(drawFeatureTool){
            final Cursor cursor;
            {
                super(cursorTool);
                this.cursor = AbstractCursorTool.createCursor(IconLoader.image("Pen.gif"), new Point(1, 31), drawFeatureTool.getName());
            }

            @Override
            public String getName() {
                return drawFeatureTool.getName();
            }

            @Override
            public Cursor getCursor() {
                return this.cursor;
            }
        };
    }

    public void drawRing(Polygon polygon, boolean rollingBackInvalidEdits, AbstractCursorTool tool, LayerViewPanel panel) {
        Collection<Feature> selectedFeaturesContainingPolygon = this.selectedFeaturesContaining(polygon, panel);
        if (selectedFeaturesContainingPolygon.isEmpty()) {
            UndoableCommand cmd = this.createAddCommand((Geometry)polygon, rollingBackInvalidEdits, panel, tool);
            if (cmd != null) {
                AbstractPlugIn.execute(cmd, panel);
            }
        } else {
            this.createHole(polygon, selectedFeaturesContainingPolygon, this.layer(panel), panel, rollingBackInvalidEdits, tool.getName());
        }
    }

    private Collection<Feature> selectedFeaturesMatchingEndPoint(LineString lineString, LayerViewPanel panel) {
        if (this.layerNamePanelProxy.getLayerNamePanel().chooseEditableLayer() == null) {
            return new ArrayList<Feature>();
        }
        ArrayList<Feature> selectedFeaturesMatchingEndPoints = new ArrayList<Feature>();
        for (Feature feature : panel.getSelectionManager().getFeaturesWithSelectedItems(this.layerNamePanelProxy.getLayerNamePanel().chooseEditableLayer())) {
            LineString lineGeom;
            if (!(feature.getGeometry() instanceof LineString) || !(lineGeom = (LineString)feature.getGeometry()).getCoordinate().equals((Object)lineString.getCoordinate()) && !lineGeom.getCoordinate().equals((Object)lineString.getCoordinateN(lineString.getNumPoints() - 1)) && !lineGeom.getCoordinateN(lineGeom.getNumPoints() - 1).equals((Object)lineString.getCoordinate()) && !lineGeom.getCoordinateN(lineGeom.getNumPoints() - 1).equals((Object)lineString.getCoordinateN(lineString.getNumPoints() - 1))) continue;
            selectedFeaturesMatchingEndPoints.add(feature);
        }
        return selectedFeaturesMatchingEndPoints;
    }

    public LineString reverse(LineString lineString) {
        CoordinateList coordList = new CoordinateList(lineString.getCoordinates());
        Collections.reverse(coordList);
        return new GeometryFactory().createLineString(coordList.toCoordinateArray());
    }

    public LineString concatLineStrings(LineString ls1, LineString ls2) {
        CoordinateList coordList1 = new CoordinateList(ls1.getCoordinates());
        CoordinateList coordList2 = new CoordinateList(ls2.getCoordinates());
        coordList1.remove(coordList1.size() - 1);
        coordList1.addAll((Collection)coordList2);
        return new GeometryFactory().createLineString(coordList1.toCoordinateArray());
    }

    public LineString mergeLineStrings(LineString ls1, LineString ls2) {
        if (ls1.getCoordinateN(ls1.getNumPoints() - 1).equals((Object)ls2.getCoordinate())) {
            return this.concatLineStrings(ls1, ls2);
        }
        if (ls1.getCoordinateN(ls1.getNumPoints() - 1).equals((Object)ls2.getCoordinateN(ls2.getNumPoints() - 1))) {
            return this.concatLineStrings(ls1, this.reverse(ls2));
        }
        if (ls1.getCoordinate().equals((Object)ls2.getCoordinate())) {
            return this.concatLineStrings(this.reverse(ls2), ls1);
        }
        if (ls1.getCoordinate().equals((Object)ls2.getCoordinateN(ls2.getNumPoints() - 1))) {
            return this.concatLineStrings(ls2, ls1);
        }
        return ls2;
    }

    public void drawLineString(LineString newLineString, boolean rollingBackInvalidEdits, AbstractCursorTool tool, LayerViewPanel panel) {
        Collection<Feature> matchingLineStringFeatures = this.selectedFeaturesMatchingEndPoint(newLineString, panel);
        if (matchingLineStringFeatures.size() == 0) {
            AbstractPlugIn.execute(this.createAddCommand((Geometry)newLineString, rollingBackInvalidEdits, panel, tool), panel);
        } else {
            Iterator<Feature> iter = matchingLineStringFeatures.iterator();
            EditTransaction transaction = new EditTransaction(matchingLineStringFeatures, tool.getName(), this.layer(panel), rollingBackInvalidEdits, true, panel);
            int count = 0;
            for (Feature feature : transaction.getFeatures()) {
                LineString oldLineString = (LineString)iter.next().getGeometry();
                newLineString = this.mergeLineStrings(oldLineString, newLineString);
                if (count > 0) {
                    transaction.setGeometry(feature, EditTransaction.EMPTY_GEOMETRY);
                }
                ++count;
            }
            transaction.setGeometry(transaction.getFeatures().iterator().next(), (Geometry)newLineString);
            transaction.commit();
        }
    }

    public void selectGeometry(LayerViewPanel panel, Geometry geom) {
        SelectionManager selectionManager = panel.getSelectionManager();
        if (PersistentBlackboardPlugIn.get(panel.getWorkBenchFrame().getContext()).get(EditOptionsPanel.SELECT_NEW_GEOMETRY_KEY, false)) {
            this.featsToAdd = new ArrayList<Feature>();
            this.featsToAdd.add(FeatureUtil.toFeature(geom, this.layer(panel).getFeatureCollectionWrapper().getFeatureSchema()));
            selectionManager.getFeatureSelection().unselectItems();
            selectionManager.getFeatureSelection().selectItems(this.layer(panel), this.featsToAdd);
        }
    }
}

