/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.cursortool;

import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.util.Block;
import com.vividsolutions.jump.util.CollectionUtil;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.model.UndoableCommand;
import com.vividsolutions.jump.workbench.ui.EditTransaction;
import com.vividsolutions.jump.workbench.ui.LayerViewPanel;
import com.vividsolutions.jump.workbench.ui.SelectionManager;
import com.vividsolutions.jump.workbench.ui.cursortool.Animations;
import java.awt.Color;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.linearref.LengthIndexedLine;
import org.locationtech.jts.util.Assert;

public class SplitLineStringsOp {
    private final Color colour;
    private final Collection<Split> splits = new ArrayList<Split>();

    public SplitLineStringsOp addSplit(Feature feature, Coordinate target, Layer layer, boolean moveSplitToTarget) {
        this.splits.add(new Split(feature, this.split((LineString)feature.getGeometry(), target, moveSplitToTarget), layer));
        return this;
    }

    public SplitLineStringsOp(Color colour) {
        this.colour = colour;
    }

    public void execute(String name, boolean rollingBackInvalidEdits, LayerViewPanel panel) {
        this.execute(this.splits, name, rollingBackInvalidEdits, panel);
    }

    private void assertIndependent(Collection<Split> splits) {
        ArrayList<Split> splitsEncountered = new ArrayList<Split>();
        for (Split split : splits) {
            Assert.isTrue((!splitsEncountered.contains(split) ? 1 : 0) != 0);
            splitsEncountered.add(split);
        }
    }

    private EditTransaction transaction(final Split split, final String name, boolean rollingBackInvalidEdits, LayerViewPanel panel) {
        final SelectionManager selectionManager = panel.getSelectionManager();
        EditTransaction transaction = new EditTransaction(Collections.EMPTY_LIST, name, split.layer, rollingBackInvalidEdits, true, panel){

            @Override
            protected UndoableCommand createCommand() {
                final UndoableCommand command = super.createCommand();
                return new UndoableCommand(name){

                    @Override
                    public void execute() {
                        boolean oldFeatureWasSelected = selectionManager.getFeaturesWithSelectedItems().contains(split.oldFeature);
                        command.execute();
                        if (oldFeatureWasSelected) {
                            selectionManager.getFeatureSelection().selectItems(split.layer, Arrays.asList(split.newFeatures));
                        }
                    }

                    @Override
                    public void unexecute() {
                        boolean newFeatureWasSelected = selectionManager.getFeaturesWithSelectedItems().contains(split.newFeatures[0]) || selectionManager.getFeaturesWithSelectedItems().contains(split.newFeatures[1]);
                        command.unexecute();
                        if (newFeatureWasSelected) {
                            selectionManager.getFeatureSelection().selectItems(split.layer, Collections.singleton(split.oldFeature));
                        }
                    }
                };
            }
        };
        transaction.deleteFeature(split.oldFeature);
        transaction.createFeature(split.newFeatures[0]);
        transaction.createFeature(split.newFeatures[1]);
        return transaction;
    }

    private void execute(final Collection<Split> splits, final String name, final boolean rollingBackInvalidEdits, final LayerViewPanel panel) {
        this.assertIndependent(splits);
        EditTransaction.commit(CollectionUtil.collect(splits, new Block(){

            @Override
            public Object yield(Object split) {
                return SplitLineStringsOp.this.transaction((Split)split, name, rollingBackInvalidEdits, panel);
            }
        }), new EditTransaction.SuccessAction(){

            @Override
            public void run() {
                try {
                    Animations.drawExpandingRings(new HashSet(CollectionUtil.collect(splits, new Block(){

                        @Override
                        public Object yield(Object split) {
                            try {
                                return panel.getViewport().toViewPoint(((Split)split).newLineStrings[0].getEndPoint().getCoordinate());
                            }
                            catch (NoninvertibleTransformException e) {
                                return new Point2D.Double();
                            }
                        }
                    })), true, SplitLineStringsOp.this.colour, panel, new float[]{5.0f, 5.0f});
                }
                catch (Throwable t) {
                    panel.getContext().warnUser(t.toString());
                }
            }
        });
    }

    protected LineString[] split(LineString lineString, Coordinate target, boolean moveSplitToTarget) {
        LengthIndexedLine indexLine = new LengthIndexedLine((Geometry)lineString);
        double splitIndex = indexLine.project(target);
        LineString[] lineStrings = new LineString[]{(LineString)indexLine.extractLine(0.0, splitIndex), (LineString)indexLine.extractLine(splitIndex, indexLine.getEndIndex())};
        if (moveSplitToTarget) {
            this.last(lineStrings[0]).setCoordinate(target);
            this.first(lineStrings[1]).setCoordinate(target);
        }
        if (Double.isNaN(this.last((LineString)lineStrings[0]).z)) {
            this.last((LineString)lineStrings[0]).z = this.interpolateZ(lineStrings);
        }
        if (Double.isNaN(this.first((LineString)lineStrings[1]).z)) {
            this.first((LineString)lineStrings[1]).z = this.interpolateZ(lineStrings);
        }
        return lineStrings;
    }

    private double interpolateZ(LineString[] lineStrings) {
        Coordinate a = this.secondToLast(lineStrings[0]);
        Coordinate b = this.last(lineStrings[0]);
        Coordinate c = this.second(lineStrings[1]);
        if (Double.isNaN(a.z)) {
            return Double.NaN;
        }
        if (Double.isNaN(c.z)) {
            return Double.NaN;
        }
        return a.z + (c.z - a.z) * a.distance(b) / (a.distance(b) + b.distance(c));
    }

    private Coordinate first(LineString lineString) {
        return lineString.getCoordinateN(0);
    }

    private Coordinate second(LineString lineString) {
        return lineString.getCoordinateN(1);
    }

    private Coordinate last(LineString lineString) {
        return lineString.getCoordinateN(lineString.getNumPoints() - 1);
    }

    private Coordinate secondToLast(LineString lineString) {
        return lineString.getCoordinateN(lineString.getNumPoints() - 2);
    }

    private static class Split {
        private final Feature[] newFeatures;
        private final Feature oldFeature;
        private final LineString[] newLineStrings;
        private final Layer layer;

        public Split(Feature oldFeature, LineString[] newLineStrings, Layer layer) {
            this.oldFeature = oldFeature;
            this.newLineStrings = newLineStrings;
            this.layer = layer;
            this.newFeatures = new Feature[]{this.clone(oldFeature, newLineStrings[0]), this.clone(oldFeature, newLineStrings[1])};
        }

        private Feature clone(Feature feature, LineString lineString) {
            Feature clone = feature.clone();
            clone.setGeometry((Geometry)lineString);
            return clone;
        }
    }
}

