/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui;

import com.vividsolutions.jump.util.CollectionUtil;
import com.vividsolutions.jump.util.LangUtil;
import com.vividsolutions.jump.workbench.model.Category;
import com.vividsolutions.jump.workbench.model.CategoryEvent;
import com.vividsolutions.jump.workbench.model.CategoryEventType;
import com.vividsolutions.jump.workbench.model.FeatureEvent;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.model.LayerEvent;
import com.vividsolutions.jump.workbench.model.LayerEventType;
import com.vividsolutions.jump.workbench.model.LayerListener;
import com.vividsolutions.jump.workbench.model.LayerManager;
import com.vividsolutions.jump.workbench.model.LayerManagerProxy;
import com.vividsolutions.jump.workbench.model.LayerTreeModel;
import com.vividsolutions.jump.workbench.model.Layerable;
import com.vividsolutions.jump.workbench.model.WMSLayer;
import com.vividsolutions.jump.workbench.ui.ColorPanel;
import com.vividsolutions.jump.workbench.ui.FirableTreeModelWrapper;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import com.vividsolutions.jump.workbench.ui.LayerNamePanel;
import com.vividsolutions.jump.workbench.ui.LayerNamePanelListener;
import com.vividsolutions.jump.workbench.ui.LayerNamePanelProxy;
import com.vividsolutions.jump.workbench.ui.LayerTreeCellEditor;
import com.vividsolutions.jump.workbench.ui.LayerTreeCellRenderer;
import com.vividsolutions.jump.workbench.ui.LayerableNamePanel;
import com.vividsolutions.jump.workbench.ui.PopupNodeProxy;
import com.vividsolutions.jump.workbench.ui.RasterRampIcon;
import com.vividsolutions.jump.workbench.ui.TreeUtil;
import com.vividsolutions.jump.workbench.ui.ViewportListener;
import com.vividsolutions.jump.workbench.ui.renderer.RenderingManager;
import com.vividsolutions.jump.workbench.ui.renderer.style.BasicStyle;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.util.Assert;
import org.openjump.core.rasterimage.RasterImageLayer;

public class TreeLayerNamePanel
extends JPanel
implements LayerListener,
LayerableNamePanel,
LayerNamePanelProxy,
PopupNodeProxy {
    private final Map<Class<?>, JPopupMenu> nodeClassToPopupMenuMap = new HashMap();
    JTree tree = new JTree(){
        final List<Integer> allowedKeys = Arrays.asList(37, 39, 38, 40);

        @Override
        public boolean isPathEditable(TreePath path) {
            if (!this.isEditable()) {
                return false;
            }
            return path.getLastPathComponent() instanceof Layerable || path.getLastPathComponent() instanceof Category;
        }

        @Override
        protected void processComponentKeyEvent(KeyEvent e) {
            if (e.getModifiersEx() != 0 || !this.allowedKeys.contains(e.getKeyCode())) {
                return;
            }
            super.processComponentKeyEvent(e);
        }

        @Override
        protected void processKeyEvent(KeyEvent e) {
            super.processKeyEvent(e);
        }

        @Override
        protected boolean processKeyBinding(KeyStroke ks, KeyEvent e, int condition, boolean pressed) {
            if (e.getModifiersEx() != 0 || !this.allowedKeys.contains(e.getKeyCode())) {
                return false;
            }
            return super.processKeyBinding(ks, e, condition, pressed);
        }
    };
    private final LayerTreeCellRenderer layerTreeCellRenderer;
    private Object popupNode;
    private final ArrayList<LayerNamePanelListener> listeners = new ArrayList();
    private final LayerManagerProxy layerManagerProxy;
    private final FirableTreeModelWrapper firableTreeModelWrapper;
    private TreePath movingTreePath = null;
    private boolean firstTimeDragging = true;
    private boolean ongoingDragging = false;
    private int lastHoveringRow = -1;

    public TreeLayerNamePanel(LayerManagerProxy layerManagerProxy, TreeModel treeModel, RenderingManager renderingManager, Map<Class<?>, TreeCellRenderer> additionalNodeClassToTreeCellRendererMap) {
        layerManagerProxy.getLayerManager().addLayerListener(this);
        this.layerManagerProxy = layerManagerProxy;
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.firableTreeModelWrapper = new FirableTreeModelWrapper(treeModel);
        this.tree.setModel(this.firableTreeModelWrapper);
        this.layerTreeCellRenderer = new LayerTreeCellRenderer(renderingManager);
        renderingManager.getPanel().getViewport().addListener(new ViewportListener(){

            @Override
            public void zoomChanged(Envelope modelEnvelope) {
                TreeLayerNamePanel.this.repaint();
            }
        });
        this.setCellRenderer(additionalNodeClassToTreeCellRendererMap);
        this.tree.getSelectionModel().setSelectionMode(4);
        this.tree.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                TreeLayerNamePanel.this.handleCheckBoxClick(e);
            }

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.getButton() == 1) {
                    TreeLayerNamePanel.this.ongoingDragging = true;
                    TreeLayerNamePanel.this.movingTreePath = TreeLayerNamePanel.this.tree.getPathForLocation(e.getX(), e.getY());
                    if (TreeLayerNamePanel.this.movingTreePath != null && !(TreeLayerNamePanel.this.movingTreePath.getLastPathComponent() instanceof Layerable)) {
                        TreeLayerNamePanel.this.movingTreePath = null;
                    } else if (TreeLayerNamePanel.this.movingTreePath != null && !TreeLayerNamePanel.this.tree.isRowSelected(TreeLayerNamePanel.this.tree.getClosestRowForLocation(e.getX(), e.getY()))) {
                        TreeLayerNamePanel.this.movingTreePath = null;
                    } else {
                        TreeLayerNamePanel.this.lastHoveringRow = TreeLayerNamePanel.this.tree.getClosestRowForLocation(e.getX(), e.getY());
                    }
                } else {
                    TreeLayerNamePanel.this.movingTreePath = null;
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.getButton() != 1 || TreeLayerNamePanel.this.movingTreePath == null) {
                    return;
                }
                if (!TreeLayerNamePanel.this.ongoingDragging) {
                    return;
                }
                TreeLayerNamePanel.this.ongoingDragging = false;
                if (TreeLayerNamePanel.this.tree.isEditing()) {
                    return;
                }
                Object node = TreeLayerNamePanel.this.movingTreePath.getLastPathComponent();
                TreePath tpDestination = TreeLayerNamePanel.this.tree.getClosestPathForLocation(e.getX(), e.getY());
                TreeLayerNamePanel.this.firstTimeDragging = true;
                TreeLayerNamePanel.this.lastHoveringRow = -1;
                if (tpDestination == null) {
                    return;
                }
                TreeLayerNamePanel.this.tree.repaint();
                if (node instanceof Layerable) {
                    Category cat;
                    Layerable layerable = (Layerable)node;
                    int index = 0;
                    int oldRow = TreeLayerNamePanel.this.tree.getRowForPath(TreeLayerNamePanel.this.movingTreePath);
                    int newRow = TreeLayerNamePanel.this.tree.getRowForPath(tpDestination);
                    Category oldCat = (Category)TreeLayerNamePanel.this.movingTreePath.getParentPath().getLastPathComponent();
                    if (tpDestination.getLastPathComponent() instanceof Layerable) {
                        if (layerable == tpDestination.getLastPathComponent()) {
                            return;
                        }
                        cat = TreeLayerNamePanel.this.getLayerManager().getCategory((Layerable)tpDestination.getLastPathComponent());
                        index = TreeLayerNamePanel.this.tree.getModel().getIndexOfChild(tpDestination.getParentPath().getLastPathComponent(), tpDestination.getLastPathComponent());
                        if (newRow < oldRow && cat.equals(oldCat)) {
                            ++index;
                        } else if (!cat.equals(oldCat)) {
                            ++index;
                        }
                    } else if (tpDestination.getLastPathComponent() instanceof Category) {
                        cat = (Category)tpDestination.getLastPathComponent();
                    } else {
                        return;
                    }
                    TreeLayerNamePanel.this.getLayerManager().fireLayerChanged(layerable, LayerEventType.REMOVED);
                    oldCat.remove(layerable);
                    cat.add(index, layerable);
                    TreeLayerNamePanel.this.getLayerManager().fireLayerChanged(layerable, LayerEventType.ADDED);
                    TreeLayerNamePanel.this.movingTreePath = null;
                }
            }
        });
        this.tree.addMouseMotionListener(new MouseMotionAdapter(){
            int rowNew;
            Rectangle dragBar;

            @Override
            public void mouseDragged(MouseEvent e) {
                if (TreeLayerNamePanel.this.movingTreePath == null) {
                    TreeLayerNamePanel.this.firstTimeDragging = true;
                    return;
                }
                if (TreeLayerNamePanel.this.tree.isEditing()) {
                    return;
                }
                this.rowNew = TreeLayerNamePanel.this.tree.getClosestRowForLocation(e.getX(), e.getY());
                if (!(TreeLayerNamePanel.this.tree.getPathForRow(this.rowNew).getLastPathComponent() instanceof Layer) && !(TreeLayerNamePanel.this.tree.getPathForRow(this.rowNew).getLastPathComponent() instanceof RasterImageLayer)) {
                    TreeLayerNamePanel.this.tree.expandRow(this.rowNew);
                }
                Graphics2D g2 = (Graphics2D)TreeLayerNamePanel.this.tree.getGraphics();
                g2.setColor(Color.RED);
                g2.setXORMode(Color.WHITE);
                if (TreeLayerNamePanel.this.firstTimeDragging) {
                    this.dragBar = new Rectangle(0, 0, TreeLayerNamePanel.this.tree.getWidth(), 3);
                    this.dragBar.setLocation(0, TreeLayerNamePanel.this.tree.getRowBounds((int)((TreeLayerNamePanel)TreeLayerNamePanel.this).lastHoveringRow).y + TreeLayerNamePanel.this.tree.getRowBounds((int)((TreeLayerNamePanel)TreeLayerNamePanel.this).lastHoveringRow).height - 3);
                    g2.fill(this.dragBar);
                    TreeLayerNamePanel.this.firstTimeDragging = false;
                } else if (this.rowNew != TreeLayerNamePanel.this.lastHoveringRow) {
                    g2.setXORMode(Color.WHITE);
                    g2.fill(this.dragBar);
                    this.dragBar.setLocation(0, TreeLayerNamePanel.this.tree.getRowBounds((int)this.rowNew).y + TreeLayerNamePanel.this.tree.getRowBounds((int)this.rowNew).height - 3);
                    g2.fill(this.dragBar);
                    TreeLayerNamePanel.this.lastHoveringRow = this.rowNew;
                }
            }
        });
        this.tree.setCellEditor(new LayerTreeCellEditor());
        this.tree.setInvokesStopCellEditing(true);
        this.tree.setBackground(this.getBackground());
        this.tree.addTreeSelectionListener(e -> this.fireLayerSelectionChanged());
        this.tree.getModel().addTreeModelListener(new TreeModelListener(){

            @Override
            public void treeNodesChanged(TreeModelEvent e) {
            }

            @Override
            public void treeNodesInserted(TreeModelEvent e) {
                for (int i = 0; i < e.getChildren().length; ++i) {
                    TreeUtil.visit(TreeLayerNamePanel.this.tree.getModel(), e.getTreePath().pathByAddingChild(e.getChildren()[i]), path -> {
                        if (path.peek() instanceof LayerTreeModel.SymbolizationLeafNode) {
                            return;
                        }
                        TreeLayerNamePanel.this.tree.makeVisible(new TreePath(path.toArray()));
                    });
                }
            }

            @Override
            public void treeNodesRemoved(TreeModelEvent e) {
            }

            @Override
            public void treeStructureChanged(TreeModelEvent e) {
            }
        });
        TreeUtil.expandAll(this.tree, new TreePath(this.tree.getModel().getRoot()));
    }

    public void addPopupMenu(Class<?> nodeClass, JPopupMenu popupMenu) {
        this.nodeClassToPopupMenuMap.put(nodeClass, popupMenu);
    }

    private void setCellRenderer(Map<Class<?>, TreeCellRenderer> additionalNodeClassToTreeCellRendererMap) {
        final Map<Class<?>, TreeCellRenderer> treeCellRendererMap = this.createNodeClassToTreeCellRendererMap();
        treeCellRendererMap.putAll(additionalNodeClassToTreeCellRendererMap);
        this.tree.setCellRenderer(new TreeCellRenderer(){
            private final DefaultTreeCellRenderer defaultRenderer = new DefaultTreeCellRenderer(){
                {
                    this.setBackgroundNonSelectionColor(new Color(0, 0, 0, 0));
                }
            };

            @Override
            public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                return ((TreeCellRenderer)LangUtil.ifNull(CollectionUtil.get(value.getClass(), treeCellRendererMap), this.defaultRenderer)).getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
            }
        });
    }

    private Map<Class<?>, TreeCellRenderer> createNodeClassToTreeCellRendererMap() {
        HashMap map = new HashMap();
        map.put(Layer.class, this.layerTreeCellRenderer);
        map.put(WMSLayer.class, this.layerTreeCellRenderer);
        map.put(Category.class, this.layerTreeCellRenderer);
        map.put(RasterImageLayer.class, this.layerTreeCellRenderer);
        map.put(LayerTreeModel.ColorThemingValue.class, this.createColorThemingValueRenderer());
        map.put(LayerTreeModel.RasterStyleValueIntv.class, this.createRasterStyleValueIntvRenderer());
        map.put(LayerTreeModel.RasterStyleValueRamp.class, this.createRasterStyleValueRampRenderer());
        return map;
    }

    private TreeCellRenderer createColorThemingValueRenderer() {
        return new TreeCellRenderer(){
            private final JPanel panel = new JPanel(new GridBagLayout());
            private final ColorPanel colorPanel = new ColorPanel();
            private final JLabel label = new JLabel();
            {
                this.panel.add((Component)this.colorPanel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
                this.panel.add((Component)this.label, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
            }

            @Override
            public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                this.label.setText(value.toString());
                BasicStyle style = ((LayerTreeModel.ColorThemingValue)value).getStyle();
                this.colorPanel.setLineColor(style.isRenderingLine() ? GUIUtil.alphaColor(style.getLineColor(), style.getAlpha()) : GUIUtil.alphaColor(Color.BLACK, 0));
                this.colorPanel.setFillColor(style.isRenderingFill() ? GUIUtil.alphaColor(style.getFillColor(), style.getAlpha()) : GUIUtil.alphaColor(Color.BLACK, 0));
                return this.panel;
            }
        };
    }

    private TreeCellRenderer createRasterStyleValueIntvRenderer() {
        return new TreeCellRenderer(){
            private final JPanel panel = new JPanel(new GridBagLayout());
            private final ColorPanel colorPanel = new ColorPanel();
            private final JLabel label = new JLabel();
            {
                this.panel.add((Component)this.colorPanel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
                this.panel.add((Component)this.label, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
            }

            @Override
            public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                LayerTreeModel.RasterStyleValueIntv rasterStyleValue = (LayerTreeModel.RasterStyleValueIntv)value;
                if (rasterStyleValue.getColorMapType().equals("INTERVALS")) {
                    this.label.setText(rasterStyleValue.getValue().floatValue() + "-" + rasterStyleValue.getNextValue().floatValue());
                } else if (rasterStyleValue.getColorMapType().equals("SINGLE")) {
                    this.label.setText(String.valueOf(rasterStyleValue.getValue().intValue()));
                }
                this.colorPanel.setLineColor(Color.BLACK);
                this.colorPanel.setFillColor(rasterStyleValue.getColor());
                return this.panel;
            }
        };
    }

    private TreeCellRenderer createRasterStyleValueRampRenderer() {
        return new TreeCellRenderer(){
            private final JPanel panel = new JPanel(new GridBagLayout());
            private final JLabel labelTop = new JLabel();
            private final JLabel labelMiddle = new JLabel();
            private final JLabel labelBottom = new JLabel();
            private final JLabel labelImg = new JLabel();
            {
                this.panel.add((Component)this.labelImg, new GridBagConstraints(0, 0, 1, 3, 0.0, 1.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
                this.panel.add((Component)this.labelTop, new GridBagConstraints(1, 0, 1, 1, 0.0, 1.0, 17, 3, new Insets(0, 5, 0, 0), 0, 0));
                this.panel.add((Component)this.labelMiddle, new GridBagConstraints(1, 1, 1, 1, 0.0, 1.0, 17, 3, new Insets(0, 5, 0, 0), 0, 0));
                this.panel.add((Component)this.labelBottom, new GridBagConstraints(1, 2, 1, 1, 0.0, 1.0, 25, 3, new Insets(0, 5, 0, 0), 0, 0));
                this.labelTop.setVerticalAlignment(1);
                this.labelBottom.setVerticalAlignment(3);
            }

            @Override
            public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                LayerTreeModel.RasterStyleValueRamp rasterStyleValue = (LayerTreeModel.RasterStyleValueRamp)value;
                this.labelTop.setText(String.valueOf(rasterStyleValue.getTopValue().floatValue()));
                this.labelMiddle.setText(String.valueOf((rasterStyleValue.getTopValue().floatValue() + rasterStyleValue.getBottomValue().floatValue()) / 2.0f));
                this.labelBottom.setText(String.valueOf(rasterStyleValue.getBottomValue().floatValue()));
                this.labelImg.setIcon(new RasterRampIcon(rasterStyleValue.getColors()));
                return this.panel;
            }
        };
    }

    void jbInit() throws Exception {
        this.setLayout(new BorderLayout());
        JScrollPane scrollPane = new JScrollPane();
        this.tree.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    TreeLayerNamePanel.this.tree_mouseReleased(e);
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                TreeLayerNamePanel.this.tree_mouseReleased(e);
            }
        });
        ToolTipManager.sharedInstance().registerComponent(this.tree);
        this.tree.setEditable(true);
        this.tree.setRootVisible(false);
        this.tree.setRowHeight(-1);
        scrollPane.getVerticalScrollBar().setUnitIncrement(20);
        this.tree.setShowsRootHandles(true);
        scrollPane.setHorizontalScrollBarPolicy(31);
        scrollPane.setBorder(BorderFactory.createEtchedBorder());
        scrollPane.getViewport().add(this.tree);
        this.add((Component)scrollPane, "Center");
        this.tree.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent e) {
                Rectangle r = new Rectangle(e.getX(), e.getY(), 1, 1);
                ((JComponent)e.getSource()).scrollRectToVisible(r);
            }
        });
    }

    void tree_mouseReleased(MouseEvent e) {
        if (!e.isPopupTrigger()) {
            return;
        }
        TreePath popupPath = this.tree.getPathForLocation(e.getX(), e.getY());
        if (popupPath == null) {
            return;
        }
        this.popupNode = popupPath.getLastPathComponent();
        if (e.isPopupTrigger() && !this.selectedNodes(Object.class).contains(this.popupNode)) {
            this.tree.getSelectionModel().clearSelection();
        }
        this.tree.getSelectionModel().addSelectionPath(popupPath);
        if (this.getPopupMenu(this.popupNode.getClass()) != null) {
            this.getPopupMenu(this.popupNode.getClass()).show(e.getComponent(), e.getX() + 10, e.getY());
        }
    }

    private JPopupMenu getPopupMenu(Class<?> nodeClass) {
        return (JPopupMenu)CollectionUtil.get(nodeClass, this.nodeClassToPopupMenuMap);
    }

    private void handleCheckBoxClick(MouseEvent e) {
        if (!SwingUtilities.isLeftMouseButton(e)) {
            return;
        }
        TreePath path = this.tree.getPathForLocation(e.getX(), e.getY());
        if (path == null) {
            return;
        }
        Object node = path.getLastPathComponent();
        if (!(node instanceof Layerable)) {
            return;
        }
        Layerable layerable = (Layerable)node;
        Point layerNodeLocation = this.tree.getUI().getPathBounds(this.tree, path).getLocation();
        this.layerTreeCellRenderer.getLayerNameRenderer().getTreeCellRendererComponent(this.tree, path.getLastPathComponent(), false, false, false, 0, false);
        Rectangle checkBoxBounds = this.layerTreeCellRenderer.getLayerNameRenderer().getCheckBoxBounds();
        checkBoxBounds.translate((int)layerNodeLocation.getX(), (int)layerNodeLocation.getY());
        if (checkBoxBounds.contains(e.getPoint())) {
            layerable.setVisible(!layerable.isVisible());
        }
    }

    @Override
    public Layer[] getSelectedLayers() {
        return TreeLayerNamePanel.selectedLayers(this);
    }

    public static Layer[] selectedLayers(LayerNamePanel layerNamePanel) {
        return layerNamePanel.selectedNodes(Layer.class).toArray(new Layer[0]);
    }

    public static Layerable[] selectedLayerables(LayerNamePanel layerNamePanel) {
        return layerNamePanel.selectedNodes(Layer.class).toArray(new Layerable[0]);
    }

    @Override
    public Collection<Layerable> getSelectedLayerables() {
        return this.selectedNodes(Layerable.class);
    }

    @Override
    public Collection<Category> getSelectedCategories() {
        return this.selectedNodes(Category.class);
    }

    @Override
    public <T> Collection<T> selectedNodes(Class<T> c) {
        return TreeLayerNamePanel.selectedNodes(c, this.tree);
    }

    public static <T> Collection<T> selectedNodes(Class<T> c, JTree tree) {
        ArrayList<Object> selectedNodes = new ArrayList<Object>();
        TreePath[] selectionPaths = tree.getSelectionPaths();
        if (selectionPaths == null) {
            return new ArrayList();
        }
        for (TreePath path : selectionPaths) {
            Object node = path.getLastPathComponent();
            if (!c.isInstance(node)) continue;
            selectedNodes.add(node);
        }
        return selectedNodes;
    }

    @Deprecated
    public void setSelectedLayers(Layer[] layers) {
        this.setSelectedLayerables(layers);
    }

    public void setSelectedLayerables(Layerable[] layerables) {
        this.tree.getSelectionModel().clearSelection();
        this.addSelectedLayerables(layerables);
    }

    protected void addSelectedLayerable(Layerable layerable) {
        this.addSelectedLayerables(new Layerable[]{layerable});
    }

    protected void addSelectedLayerables(Layerable[] layerables) {
        this.tree.addSelectionPaths(TreeUtil.findTreePaths(layerables, this.tree.getModel(), new TreeUtil.RecurseValidator(){

            @Override
            public boolean recurseAllowed(Object o) {
                return o instanceof LayerTreeModel.Root || o instanceof Category;
            }
        }));
    }

    @Override
    public void layerChanged(final LayerEvent e) {
        TreeModelEvent treeModelEvent = new TreeModelEvent((Object)this, new Object[]{this.tree.getModel().getRoot(), e.getCategory()}, new int[]{e.getLayerableIndex()}, new Object[]{e.getLayerable()});
        if (e.getType() == LayerEventType.ADDED) {
            this.firableTreeModelWrapper.fireTreeNodesInserted(treeModelEvent);
            this.firableTreeModelWrapper.fireTreeStructureChanged(treeModelEvent);
            if (this.selectedNodes(Layerable.class).size() == 0 && e.getLayerable() instanceof Layer) {
                this.addSelectedLayerable(e.getLayerable());
            }
            return;
        }
        if (e.getType() == LayerEventType.REMOVED) {
            this.firableTreeModelWrapper.fireTreeNodesRemoved(treeModelEvent);
            return;
        }
        if (e.getType() == LayerEventType.APPEARANCE_CHANGED) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    TreeLayerNamePanel.this.firableTreeModelWrapper.fireTreeStructureChanged(new TreeModelEvent((Object)this, new Object[]{TreeLayerNamePanel.this.tree.getModel().getRoot(), e.getCategory(), e.getLayerable()}));
                }
            });
            return;
        }
        if (e.getType() == LayerEventType.METADATA_CHANGED) {
            this.firableTreeModelWrapper.fireTreeNodesChanged(treeModelEvent);
            return;
        }
        if (e.getType() == LayerEventType.VISIBILITY_CHANGED) {
            this.firableTreeModelWrapper.fireTreeNodesChanged(treeModelEvent);
            return;
        }
        Assert.shouldNeverReachHere();
    }

    @Override
    public void categoryChanged(CategoryEvent e) {
        TreeModelEvent treeModelEvent = new TreeModelEvent((Object)this, new Object[]{this.tree.getModel().getRoot()}, new int[]{e.getCategoryIndex() + this.indexOfFirstCategoryInTree()}, new Object[]{e.getCategory()});
        if (e.getType() == CategoryEventType.ADDED) {
            this.firableTreeModelWrapper.fireTreeNodesInserted(treeModelEvent);
            return;
        }
        if (e.getType() == CategoryEventType.REMOVED) {
            this.firableTreeModelWrapper.fireTreeNodesRemoved(treeModelEvent);
            return;
        }
        if (e.getType() == CategoryEventType.METADATA_CHANGED) {
            this.firableTreeModelWrapper.fireTreeNodesChanged(treeModelEvent);
            return;
        }
        Assert.shouldNeverReachHere();
    }

    private int indexOfFirstCategoryInTree() {
        for (int i = 0; i < this.tree.getModel().getChildCount(this.tree.getModel().getRoot()); ++i) {
            if (!(this.tree.getModel().getChild(this.tree.getModel().getRoot(), i) instanceof Category)) continue;
            return i;
        }
        Assert.shouldNeverReachHere();
        return -1;
    }

    @Override
    public void featuresChanged(FeatureEvent e) {
    }

    @Override
    public void dispose() {
        this.layerManagerProxy.getLayerManager().removeLayerListener(this);
    }

    public JTree getTree() {
        return this.tree;
    }

    @Override
    public synchronized void addListener(LayerNamePanelListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public synchronized void removeListener(LayerNamePanelListener listener) {
        this.listeners.remove(listener);
    }

    public synchronized void fireLayerSelectionChanged() {
        for (LayerNamePanelListener listener : this.listeners) {
            listener.layerSelectionChanged();
        }
    }

    @Override
    public LayerManager getLayerManager() {
        return this.layerManagerProxy.getLayerManager();
    }

    public static Layer chooseEditableLayer(LayerNamePanel panel) {
        for (Layer layer : panel.getSelectedLayers()) {
            if (!layer.isEditable() || !layer.isVisible()) continue;
            return layer;
        }
        for (Layer layer : panel.getLayerManager().getEditableLayers()) {
            if (!layer.isVisible()) continue;
            return layer;
        }
        return null;
    }

    @Override
    public Layer chooseEditableLayer() {
        return TreeLayerNamePanel.chooseEditableLayer(this);
    }

    @Override
    public LayerNamePanel getLayerNamePanel() {
        return this;
    }

    protected FirableTreeModelWrapper getFirableTreeModelWrapper() {
        return this.firableTreeModelWrapper;
    }

    @Override
    public Object getPopupNode() {
        return this.popupNode;
    }

    protected LayerTreeCellRenderer getLayerTreeCellRenderer() {
        return this.layerTreeCellRenderer;
    }
}

