/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.ui.OKCancelApplyPanel;
import com.vividsolutions.jump.workbench.ui.images.IconLoader;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GraphicsEnvironment;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;

public class TextEditor
extends JComponent {
    private static final long serialVersionUID = 1L;
    public static final int OK_OPTION = 0;
    public static final int CANCEL_OPTION = 1;
    public static final int ERROR_OPTION = -1;
    private static final Font DEFAULT_SELECTED_FONT = new Font("Serif", 0, 12);
    private static final JLabel label = new JLabel();
    private static final Font DEFAULT_FONT = new Font(label.getFont().getName(), 0, label.getFont().getSize());
    private static final int[] FONT_STYLE_CODES = new int[]{0, 1, 2, 3};
    private static final String[] DEFAULT_FONT_SIZE_STRINGS = new String[]{"8", "9", "10", "11", "12", "14", "16", "18", "20", "22", "24", "26", "28", "36", "48", "72"};
    protected int dialogResultValue = -1;
    private String[] fontStyleNames = null;
    private String[] fontFamilyNames = null;
    private String[] fontSizeStrings = null;
    private JTextField fontFamilyTextField = null;
    private JTextField fontStyleTextField = null;
    private JTextField fontSizeTextField = null;
    private JList<String> fontNameList = null;
    private JList<String> fontStyleList = null;
    private JList<String> fontSizeList = null;
    private JPanel fontNamePanel = null;
    private JPanel fontStylePanel = null;
    private JPanel fontSizePanel = null;
    private JPanel samplePanel = null;
    private JTextArea sampleText = null;
    protected final OKCancelApplyPanel okCancelApplyPanel = new OKCancelApplyPanel();

    public TextEditor() {
        this(DEFAULT_FONT_SIZE_STRINGS);
    }

    public TextEditor(String[] fontSizeStrings) {
        if (fontSizeStrings == null) {
            fontSizeStrings = DEFAULT_FONT_SIZE_STRINGS;
        }
        this.fontSizeStrings = fontSizeStrings;
        JPanel selectPanel = new JPanel();
        selectPanel.setLayout(new BoxLayout(selectPanel, 0));
        selectPanel.add(this.getFontFamilyPanel());
        selectPanel.add(this.getFontStylePanel());
        selectPanel.add(this.getFontSizePanel());
        JPanel contentsPanel = new JPanel();
        contentsPanel.setLayout(new GridLayout(2, 1));
        contentsPanel.add((Component)selectPanel, "North");
        contentsPanel.add((Component)this.getSamplePanel(), "Center");
        this.setLayout(new BoxLayout(this, 0));
        this.add(contentsPanel);
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.setSelectedFont(DEFAULT_SELECTED_FONT);
    }

    public JTextField getFontFamilyTextField() {
        if (this.fontFamilyTextField == null) {
            this.fontFamilyTextField = new JTextField();
            this.fontFamilyTextField.setEditable(true);
            this.fontFamilyTextField.addFocusListener(new TextFieldFocusHandlerForTextSelection(this.fontFamilyTextField));
            this.fontFamilyTextField.addKeyListener(new TextFieldKeyHandlerForListSelectionUpDown(this.getFontFamilyList()));
            this.fontFamilyTextField.getDocument().addDocumentListener(new ListSearchTextFieldDocumentHandler(this.getFontFamilyList()));
            this.fontFamilyTextField.setFont(DEFAULT_FONT);
        }
        return this.fontFamilyTextField;
    }

    public JTextField getFontStyleTextField() {
        if (this.fontStyleTextField == null) {
            this.fontStyleTextField = new JTextField();
            this.fontStyleTextField.setEditable(true);
            this.fontStyleTextField.addFocusListener(new TextFieldFocusHandlerForTextSelection(this.fontStyleTextField));
            this.fontStyleTextField.addKeyListener(new TextFieldKeyHandlerForListSelectionUpDown(this.getFontStyleList()));
            this.fontStyleTextField.getDocument().addDocumentListener(new ListSearchTextFieldDocumentHandler(this.getFontStyleList()));
            this.fontStyleTextField.setFont(DEFAULT_FONT);
        }
        return this.fontStyleTextField;
    }

    public JTextField getFontSizeTextField() {
        if (this.fontSizeTextField == null) {
            this.fontSizeTextField = new JTextField();
            this.fontSizeTextField.addFocusListener(new TextFieldFocusHandlerForTextSelection(this.fontSizeTextField));
            this.fontSizeTextField.addKeyListener(new TextFieldKeyHandlerForListSelectionUpDown(this.getFontSizeList()));
            this.fontSizeTextField.getDocument().addDocumentListener(new ListSearchTextFieldDocumentHandler(this.getFontSizeList()));
            this.fontSizeTextField.setFont(DEFAULT_FONT);
        }
        return this.fontSizeTextField;
    }

    public JList<String> getFontFamilyList() {
        if (this.fontNameList == null) {
            this.fontNameList = new JList<String>(this.getFontFamilies());
            this.fontNameList.setSelectionMode(0);
            this.fontNameList.addListSelectionListener(new ListSelectionHandler(this.getFontFamilyTextField()));
            this.fontNameList.setSelectedIndex(0);
            this.fontNameList.setFont(DEFAULT_FONT);
            this.fontNameList.setFocusable(false);
        }
        return this.fontNameList;
    }

    public JList<String> getFontStyleList() {
        if (this.fontStyleList == null) {
            this.fontStyleList = new JList<String>(this.getFontStyleNames());
            this.fontStyleList.setSelectionMode(0);
            this.fontStyleList.addListSelectionListener(new ListSelectionHandler(this.getFontStyleTextField()));
            this.fontStyleList.setSelectedIndex(0);
            this.fontStyleList.setFont(DEFAULT_FONT);
            this.fontStyleList.setFocusable(false);
        }
        return this.fontStyleList;
    }

    public JList<String> getFontSizeList() {
        if (this.fontSizeList == null) {
            this.fontSizeList = new JList<String>(this.fontSizeStrings);
            this.fontSizeList.setSelectionMode(0);
            this.fontSizeList.addListSelectionListener(new ListSelectionHandler(this.getFontSizeTextField()));
            this.fontSizeList.setSelectedIndex(0);
            this.fontSizeList.setFont(DEFAULT_FONT);
            this.fontSizeList.setFocusable(false);
        }
        return this.fontSizeList;
    }

    public String getSelectedFontFamily() {
        String fontName = this.getFontFamilyList().getSelectedValue();
        return fontName;
    }

    public int getSelectedFontStyle() {
        int index = this.getFontStyleList().getSelectedIndex();
        return FONT_STYLE_CODES[index];
    }

    public int getSelectedFontSize() {
        int fontSize = 1;
        String fontSizeString = this.getFontSizeTextField().getText();
        while (true) {
            try {
                fontSize = Integer.parseInt(fontSizeString);
            }
            catch (NumberFormatException e) {
                fontSizeString = this.getFontSizeList().getSelectedValue();
                this.getFontSizeTextField().setText(fontSizeString);
                continue;
            }
            break;
        }
        return fontSize;
    }

    public Font getSelectedFont() {
        Font font = new Font(this.getSelectedFontFamily(), this.getSelectedFontStyle(), this.getSelectedFontSize());
        return font;
    }

    public void setSelectedFontFamily(String name) {
        String[] names = this.getFontFamilies();
        for (int i = 0; i < names.length; ++i) {
            if (!names[i].toLowerCase().equals(name.toLowerCase())) continue;
            this.getFontFamilyList().setSelectedIndex(i);
            break;
        }
        this.updateSampleFont();
    }

    public void setSelectedFontStyle(int style) {
        for (int i = 0; i < FONT_STYLE_CODES.length; ++i) {
            if (FONT_STYLE_CODES[i] != style) continue;
            this.getFontStyleList().setSelectedIndex(i);
            break;
        }
        this.updateSampleFont();
    }

    public void setSampleTextField(String a) {
        if (this.sampleText == null) {
            Border lowered = BorderFactory.createLoweredBevelBorder();
            this.sampleText = new JTextArea(5, 30);
            this.sampleText.setText(a);
            this.sampleText.setBorder(lowered);
        }
        this.getSampleTextField().setText(a);
        this.updateSampleFont();
    }

    public void setSelectedSampleTextField(int size) {
        String sizeString = String.valueOf(size);
        for (int i = 0; i < this.fontSizeStrings.length; ++i) {
            if (!this.fontSizeStrings[i].equals(sizeString)) continue;
            this.getFontSizeList().setSelectedIndex(i);
            break;
        }
        this.getSampleTextField().setText(sizeString);
        this.updateSampleFont();
    }

    public void setSelectedFontSize(int size) {
        String sizeString = String.valueOf(size);
        for (int i = 0; i < this.fontSizeStrings.length; ++i) {
            if (!this.fontSizeStrings[i].equals(sizeString)) continue;
            this.getFontSizeList().setSelectedIndex(i);
            break;
        }
        this.getFontSizeTextField().setText(sizeString);
        this.updateSampleFont();
    }

    public void setSelectedFont(Font font) {
        this.setSelectedFontFamily(font.getFamily());
        this.setSelectedFontStyle(font.getStyle());
        this.setSelectedFontSize(font.getSize());
    }

    public String getVersionString() {
        return "Version";
    }

    public int showDialog(Component parent, String title) {
        this.dialogResultValue = -1;
        final JDialog dialog = this.createDialog(parent, title);
        dialog.setIconImage(IconLoader.image("oj_16_Kplain2oj.png"));
        dialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                TextEditor.this.dialogResultValue = 1;
            }
        });
        this.okCancelApplyPanel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (TextEditor.this.okCancelApplyPanel.wasApplyPressed()) {
                    return;
                }
                dialog.dispose();
            }
        });
        dialog.setVisible(true);
        dialog.dispose();
        return this.dialogResultValue;
    }

    public void addOKCancelApplyPanelActionListener(ActionListener actionListener) {
        this.okCancelApplyPanel.addActionListener(actionListener);
    }

    void okCancelApplyPanel_actionPerformed(ActionEvent e) {
        if (this.okCancelApplyPanel.wasApplyPressed()) {
            return;
        }
        if (!this.okCancelApplyPanel.wasOKPressed()) {
            this.setVisible(false);
            return;
        }
    }

    public void setApplyVisible(boolean applyVisible) {
        this.okCancelApplyPanel.setApplyVisible(applyVisible);
    }

    public void setCancelVisible(boolean cancelVisible) {
        this.okCancelApplyPanel.setCancelVisible(cancelVisible);
    }

    public void setOKVisible(boolean okVisible) {
        this.okCancelApplyPanel.setOKVisible(okVisible);
    }

    public void setApplyEnabled(boolean applyEnabled) {
        this.okCancelApplyPanel.setApplyEnabled(applyEnabled);
    }

    public void setCancelEnabled(boolean cancelEnabled) {
        this.okCancelApplyPanel.setCancelEnabled(cancelEnabled);
    }

    public void setOKEnabled(boolean okEnabled) {
        this.okCancelApplyPanel.setOKEnabled(okEnabled);
    }

    public boolean wasApplyPressed() {
        return this.okCancelApplyPanel.wasApplyPressed();
    }

    public boolean wasOKPressed() {
        return this.okCancelApplyPanel.wasOKPressed();
    }

    protected JDialog createDialog(Component parent, String title) {
        Frame frame = parent instanceof Frame ? (Frame)parent : (Frame)SwingUtilities.getAncestorOfClass(Frame.class, parent);
        JDialog dialog = new JDialog(frame, title, true);
        dialog.getContentPane().add((Component)this, "Center");
        dialog.getContentPane().add((Component)this.okCancelApplyPanel, "South");
        dialog.pack();
        dialog.setLocationRelativeTo(frame);
        return dialog;
    }

    protected void updateSampleFont() {
        Font font = this.getSelectedFont();
        this.getSampleTextField().setFont(font);
    }

    protected JPanel getFontFamilyPanel() {
        if (this.fontNamePanel == null) {
            this.fontNamePanel = new JPanel();
            this.fontNamePanel.setLayout(new BorderLayout());
            this.fontNamePanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            this.fontNamePanel.setPreferredSize(new Dimension(180, 130));
            JScrollPane scrollPane = new JScrollPane(this.getFontFamilyList());
            scrollPane.getVerticalScrollBar().setFocusable(false);
            scrollPane.setVerticalScrollBarPolicy(22);
            JPanel p = new JPanel();
            p.setLayout(new BorderLayout());
            p.add((Component)this.getFontFamilyTextField(), "North");
            p.add((Component)scrollPane, "Center");
            JLabel label = new JLabel(I18N.getInstance().get("ui.FontChooser.font"));
            label.setHorizontalAlignment(2);
            label.setHorizontalTextPosition(2);
            label.setLabelFor(this.getFontFamilyTextField());
            label.setDisplayedMnemonic('F');
            this.fontNamePanel.setBorder(new TitledBorder(new EtchedBorder(), " " + I18N.getInstance().get("ui.FontChooser.font") + " "));
            this.fontNamePanel.add((Component)p, "Center");
        }
        return this.fontNamePanel;
    }

    protected JPanel getFontStylePanel() {
        if (this.fontStylePanel == null) {
            this.fontStylePanel = new JPanel();
            this.fontStylePanel.setLayout(new BorderLayout());
            this.fontStylePanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            this.fontStylePanel.setPreferredSize(new Dimension(140, 130));
            JScrollPane scrollPane = new JScrollPane(this.getFontStyleList());
            scrollPane.getVerticalScrollBar().setFocusable(false);
            scrollPane.setVerticalScrollBarPolicy(22);
            JPanel p = new JPanel();
            p.setLayout(new BorderLayout());
            p.add((Component)this.getFontStyleTextField(), "North");
            p.add((Component)scrollPane, "Center");
            JLabel label = new JLabel(I18N.getInstance().get("ui.FontChooser.style"));
            label.setHorizontalAlignment(2);
            label.setHorizontalTextPosition(2);
            label.setLabelFor(this.getFontStyleTextField());
            label.setDisplayedMnemonic('Y');
            this.fontStylePanel.setBorder(new TitledBorder(new EtchedBorder(), " " + I18N.getInstance().get("ui.FontChooser.style") + " "));
            this.fontStylePanel.add((Component)p, "Center");
        }
        return this.fontStylePanel;
    }

    protected JPanel getFontSizePanel() {
        if (this.fontSizePanel == null) {
            this.fontSizePanel = new JPanel();
            this.fontSizePanel.setLayout(new BorderLayout());
            this.fontSizePanel.setPreferredSize(new Dimension(120, 130));
            this.fontSizePanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            JScrollPane scrollPane = new JScrollPane(this.getFontSizeList());
            scrollPane.getVerticalScrollBar().setFocusable(false);
            scrollPane.setVerticalScrollBarPolicy(22);
            JPanel p = new JPanel();
            p.setLayout(new BorderLayout());
            p.add((Component)this.getFontSizeTextField(), "North");
            p.add((Component)scrollPane, "Center");
            JLabel label = new JLabel(I18N.getInstance().get("ui.style.LabelStylePanel.height"));
            label.setHorizontalAlignment(2);
            label.setHorizontalTextPosition(2);
            label.setLabelFor(this.getFontSizeTextField());
            label.setDisplayedMnemonic('S');
            this.fontSizePanel.setBorder(new TitledBorder(new EtchedBorder(), " " + I18N.getInstance().get("ui.FontChooser.size") + " "));
            this.fontSizePanel.add((Component)p, "Center");
        }
        return this.fontSizePanel;
    }

    protected JPanel getSamplePanel() {
        if (this.samplePanel == null) {
            this.samplePanel = new JPanel();
            this.samplePanel.setLayout(new BorderLayout());
            this.samplePanel.setBorder(new TitledBorder(new EtchedBorder(), " " + I18N.getInstance().get("org.openjump.core.ui.plugin.queries.SimpleQuery.string") + " "));
            JScrollPane scroll = new JScrollPane(this.getSampleTextField());
            scroll.setPreferredSize(new Dimension(220, 110));
            this.samplePanel.add((Component)scroll, "Center");
        }
        return this.samplePanel;
    }

    public JTextArea getSampleTextField() {
        if (this.sampleText == null) {
            Border lowered = BorderFactory.createLoweredBevelBorder();
            this.sampleText = new JTextArea(5, 30);
            this.sampleText.setLineWrap(true);
            this.sampleText.setWrapStyleWord(true);
            this.sampleText.setText(I18N.getInstance().get("ui.FontChooser.sampletext"));
            this.sampleText.setBorder(lowered);
        }
        return this.sampleText;
    }

    protected String[] getFontFamilies() {
        if (this.fontFamilyNames == null) {
            GraphicsEnvironment env = GraphicsEnvironment.getLocalGraphicsEnvironment();
            this.fontFamilyNames = env.getAvailableFontFamilyNames();
        }
        return this.fontFamilyNames;
    }

    protected String[] getFontStyleNames() {
        if (this.fontStyleNames == null) {
            int i = 0;
            this.fontStyleNames = new String[4];
            this.fontStyleNames[i++] = "Plain";
            this.fontStyleNames[i++] = "Bold";
            this.fontStyleNames[i++] = "Italic";
            this.fontStyleNames[i++] = "BoldItalic";
        }
        return this.fontStyleNames;
    }

    protected class ListSearchTextFieldDocumentHandler
    implements DocumentListener {
        JList targetList;

        public ListSearchTextFieldDocumentHandler(JList targetList) {
            this.targetList = targetList;
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.update(e);
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.update(e);
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.update(e);
        }

        private void update(DocumentEvent event) {
            String newValue = "";
            try {
                Document doc = event.getDocument();
                newValue = doc.getText(0, doc.getLength());
            }
            catch (BadLocationException e) {
                e.printStackTrace();
            }
            if (newValue.length() > 0) {
                int index = this.targetList.getNextMatch(newValue, 0, Position.Bias.Forward);
                if (index < 0) {
                    index = 0;
                }
                this.targetList.ensureIndexIsVisible(index);
                String matchedName = this.targetList.getModel().getElementAt(index).toString();
                if (newValue.equalsIgnoreCase(matchedName) && index != this.targetList.getSelectedIndex()) {
                    SwingUtilities.invokeLater(new ListSelector(index));
                }
            }
        }

        public class ListSelector
        implements Runnable {
            private final int index;

            public ListSelector(int index) {
                this.index = index;
            }

            @Override
            public void run() {
                ListSearchTextFieldDocumentHandler.this.targetList.setSelectedIndex(this.index);
            }
        }
    }

    protected class TextFieldKeyHandlerForListSelectionUpDown
    extends KeyAdapter {
        private final JList targetList;

        public TextFieldKeyHandlerForListSelectionUpDown(JList list) {
            this.targetList = list;
        }

        @Override
        public void keyPressed(KeyEvent e) {
            int i = this.targetList.getSelectedIndex();
            switch (e.getKeyCode()) {
                case 38: {
                    i = this.targetList.getSelectedIndex() - 1;
                    if (i < 0) {
                        i = 0;
                    }
                    this.targetList.setSelectedIndex(i);
                    break;
                }
                case 40: {
                    int listSize = this.targetList.getModel().getSize();
                    i = this.targetList.getSelectedIndex() + 1;
                    if (i >= listSize) {
                        i = listSize - 1;
                    }
                    this.targetList.setSelectedIndex(i);
                    break;
                }
            }
        }
    }

    protected class TextFieldFocusHandlerForTextSelection
    extends FocusAdapter {
        private final JTextComponent textComponent;

        public TextFieldFocusHandlerForTextSelection(JTextComponent textComponent) {
            this.textComponent = textComponent;
        }

        @Override
        public void focusGained(FocusEvent e) {
            this.textComponent.selectAll();
        }

        @Override
        public void focusLost(FocusEvent e) {
            this.textComponent.select(0, 0);
            TextEditor.this.updateSampleFont();
        }
    }

    protected class ListSelectionHandler
    implements ListSelectionListener {
        private final JTextComponent textComponent;

        ListSelectionHandler(JTextComponent textComponent) {
            this.textComponent = textComponent;
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (!e.getValueIsAdjusting()) {
                JList list = (JList)e.getSource();
                String selectedValue = (String)list.getSelectedValue();
                String oldValue = this.textComponent.getText();
                this.textComponent.setText(selectedValue);
                if (!oldValue.equalsIgnoreCase(selectedValue)) {
                    this.textComponent.selectAll();
                    this.textComponent.requestFocus();
                }
                TextEditor.this.updateSampleFont();
            }
        }
    }
}

