/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui;

import com.vividsolutions.jump.feature.AttributeType;
import com.vividsolutions.jump.feature.FeatureSchema;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.model.LayerManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class AttributeTypeFilter {
    public static final int GEOMETRY = 1;
    public static final int STRING = 2;
    public static final int INTEGER = 4;
    public static final int DOUBLE = 8;
    public static final int DATE = 16;
    public static final int OBJECT = 32;
    public static final int BOOLEAN = 64;
    public static final int LONG = 128;
    public static final AttributeTypeFilter GEOMETRY_FILTER = new AttributeTypeFilter(1);
    public static final AttributeTypeFilter STRING_FILTER = new AttributeTypeFilter(2);
    public static final AttributeTypeFilter INTEGER_FILTER = new AttributeTypeFilter(4);
    public static final AttributeTypeFilter DOUBLE_FILTER = new AttributeTypeFilter(8);
    public static final AttributeTypeFilter DATE_FILTER = new AttributeTypeFilter(16);
    public static final AttributeTypeFilter OBJECT_FILTER = new AttributeTypeFilter(32);
    public static final AttributeTypeFilter BOOLEAN_FILTER = new AttributeTypeFilter(64);
    public static final AttributeTypeFilter LONG_FILTER = new AttributeTypeFilter(128);
    public static final AttributeTypeFilter NO_GEOMETRY_FILTER = new AttributeTypeFilter(254);
    public static final AttributeTypeFilter NUMERIC_FILTER = new AttributeTypeFilter(140);
    public static final AttributeTypeFilter NUMSTRING_FILTER = new AttributeTypeFilter(142);
    public static final AttributeTypeFilter ALL_FILTER = new AttributeTypeFilter(255);
    private int filterType = 0;

    public AttributeTypeFilter(int filterType) {
        this.filterType = filterType;
    }

    public AttributeTypeFilter getInverseFilter() {
        return new AttributeTypeFilter(~this.filterType);
    }

    public List<Layer> filter(LayerManager layerManager) {
        ArrayList<Layer> layerList = new ArrayList<Layer>();
        for (Layer layer : layerManager.getLayers()) {
            FeatureSchema schema = layer.getFeatureCollectionWrapper().getFeatureSchema();
            if (this.filter(schema).size() <= 0) continue;
            layerList.add(layer);
        }
        return layerList;
    }

    public List<Layer> filter(Collection<Layer> layers) {
        ArrayList<Layer> layerList = new ArrayList<Layer>();
        for (Layer layer : layers) {
            FeatureSchema schema = layer.getFeatureCollectionWrapper().getFeatureSchema();
            if (this.filter(schema).size() <= 0) continue;
            layerList.add(layer);
        }
        return layerList;
    }

    public List<String> filter(FeatureSchema schema) {
        ArrayList<String> attributes = new ArrayList<String>();
        for (int i = 0; i < schema.getAttributeCount(); ++i) {
            AttributeType type = schema.getAttributeType(i);
            if (!(type == AttributeType.GEOMETRY && (this.filterType & 1) == 1 || type == AttributeType.STRING && (this.filterType & 2) == 2 || type == AttributeType.INTEGER && (this.filterType & 4) == 4 || type == AttributeType.DOUBLE && (this.filterType & 8) == 8 || type == AttributeType.DATE && (this.filterType & 0x10) == 16 || type == AttributeType.OBJECT && (this.filterType & 0x20) == 32 || type == AttributeType.BOOLEAN && (this.filterType & 0x40) == 64) && (type != AttributeType.LONG || (this.filterType & 0x80) != 128)) continue;
            attributes.add(schema.getAttributeName(i));
        }
        return attributes;
    }

    public List<String> filter(Layer layer) {
        return this.filter(layer.getFeatureCollectionWrapper().getFeatureSchema());
    }

    public String toString() {
        if (this.filterType == 1) {
            return "Geometry filter";
        }
        if (this.filterType == 2) {
            return "String filter";
        }
        if (this.filterType == 4) {
            return "Integer filter";
        }
        if (this.filterType == 8) {
            return "Double filter";
        }
        if (this.filterType == 16) {
            return "Date filter";
        }
        if (this.filterType == 32) {
            return "Object filter";
        }
        if (this.filterType == 64) {
            return "Boolean filter";
        }
        if (this.filterType == 128) {
            return "Long filter";
        }
        if (this.filterType == AttributeTypeFilter.NUMERIC_FILTER.filterType) {
            return "Numeric filter";
        }
        if (this.filterType == AttributeTypeFilter.NUMSTRING_FILTER.filterType) {
            return "String or Numeric filter";
        }
        if (this.filterType == AttributeTypeFilter.NO_GEOMETRY_FILTER.filterType) {
            return "No Geometry filter";
        }
        if (this.filterType == AttributeTypeFilter.ALL_FILTER.filterType) {
            return "All filter";
        }
        return "\"" + this.filterType + "\" filter";
    }
}

