/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui;

import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.feature.FeatureUtil;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.model.LayerManagerProxy;
import com.vividsolutions.jump.workbench.model.Layerable;
import com.vividsolutions.jump.workbench.ui.AttributeTablePanel;
import com.vividsolutions.jump.workbench.ui.InfoModel;
import com.vividsolutions.jump.workbench.ui.InfoModelListener;
import com.vividsolutions.jump.workbench.ui.LayerTableModel;
import com.vividsolutions.jump.workbench.ui.SelectionManager;
import com.vividsolutions.jump.workbench.ui.TaskFrame;
import com.vividsolutions.jump.workbench.ui.zoom.PanToSelectedItemsPlugIn;
import com.vividsolutions.jump.workbench.ui.zoom.ZoomToSelectedItemsPlugIn;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.NoninvertibleTransformException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import javax.swing.JPanel;
import org.locationtech.jts.util.Assert;

public class AttributePanel
extends JPanel
implements InfoModelListener {
    private GridBagLayout gridBagLayout1 = new GridBagLayout();
    private HashMap<Layerable, AttributeTablePanel> layerToTablePanelMap = new HashMap();
    private InfoModel model;
    private WorkbenchContext workbenchContext;
    private ZoomToSelectedItemsPlugIn zoomToSelectedItemsPlugIn = new ZoomToSelectedItemsPlugIn();
    private PanToSelectedItemsPlugIn panToSelectedItemsPlugIn = new PanToSelectedItemsPlugIn();
    private Row nullRow = new Row(){

        @Override
        public boolean isFirstRow() {
            return AttributePanel.this.rowCount() == 0;
        }

        @Override
        public boolean isLastRow() {
            return AttributePanel.this.rowCount() == 0;
        }

        @Override
        public AttributeTablePanel getPanel() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int getIndex() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Row nextRow() {
            return this.firstRow();
        }

        @Override
        public Row previousRow() {
            return this.firstRow();
        }

        private Row firstRow() {
            return new BasicRow(AttributePanel.this.getTablePanel(AttributePanel.this.getModel().getLayers().get(0)), 0);
        }

        @Override
        public Feature getFeature() {
            throw new UnsupportedOperationException();
        }
    };
    private TaskFrame taskFrame;
    private LayerManagerProxy layerManagerProxy;
    private boolean addScrollPanesToChildren;

    protected AttributePanel(InfoModel model, WorkbenchContext workbenchContext, TaskFrame taskFrame, LayerManagerProxy layerManagerProxy, boolean addScrollPanesToChildren) {
        this.addScrollPanesToChildren = addScrollPanesToChildren;
        this.taskFrame = taskFrame;
        this.workbenchContext = workbenchContext;
        this.layerManagerProxy = layerManagerProxy;
        this.setModel(model);
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public AttributeTablePanel getTablePanel(Layer layer) {
        return this.layerToTablePanelMap.get(layer);
    }

    public InfoModel getModel() {
        return this.model;
    }

    public void setModel(InfoModel model) {
        this.model = model;
        model.addListener(this);
    }

    @Override
    public void layerAdded(LayerTableModel layerTableModel) {
        this.addTablePanel(layerTableModel);
    }

    @Override
    public void layerRemoved(LayerTableModel layerTableModel) {
        this.removeTablePanel(layerTableModel);
    }

    void jbInit() throws Exception {
        this.setLayout(this.gridBagLayout1);
        if (!this.addScrollPanesToChildren) {
            JPanel fillPanel = new JPanel();
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 999;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.weighty = 0.5;
            this.add((Component)fillPanel, gridBagConstraints);
        }
    }

    private void removeTablePanel(LayerTableModel layerTableModel) {
        Assert.isTrue((boolean)this.layerToTablePanelMap.containsKey(layerTableModel.getLayer()));
        AttributeTablePanel attributeTablePanel = this.getTablePanel(layerTableModel.getLayer());
        this.layerManagerProxy.getLayerManager().removeLayerListener(attributeTablePanel.layerListener);
        this.remove(this.getTablePanel(layerTableModel.getLayer()));
        this.layerToTablePanelMap.remove(layerTableModel.getLayer());
        this.revalidate();
        this.repaint();
    }

    private void addTablePanel(final LayerTableModel layerTableModel) {
        Assert.isTrue((!this.layerToTablePanelMap.containsKey(layerTableModel.getLayer()) ? 1 : 0) != 0);
        final AttributeTablePanel tablePanel = new AttributeTablePanel(layerTableModel, this.addScrollPanesToChildren, this.workbenchContext);
        this.layerToTablePanelMap.put(layerTableModel.getLayer(), tablePanel);
        int topInset = this.layerToTablePanelMap.size() > 1 ? 10 : 0;
        this.add((Component)tablePanel, new GridBagConstraints(0, this.getComponentCount(), 1, 1, 1.0, this.addScrollPanesToChildren ? 1.0 : 0.0, 10, 1, new Insets(topInset, 0, 0, 0), 0, 0));
        this.revalidate();
        this.repaint();
        tablePanel.getTable().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                try {
                    int row = tablePanel.getTable().rowAtPoint(e.getPoint());
                    if (row == -1) {
                        return;
                    }
                    ArrayList<Feature> features = new ArrayList<Feature>();
                    features.add(layerTableModel.getFeature(row));
                    if (AttributePanel.this.taskFrame.isVisible()) {
                        AttributePanel.this.zoomToSelectedItemsPlugIn.flash(FeatureUtil.toGeometries(features), AttributePanel.this.taskFrame.getLayerViewPanel());
                    }
                }
                catch (Throwable t) {
                    AttributePanel.this.workbenchContext.getErrorHandler().handleThrowable(t);
                }
            }
        });
    }

    public int rowCount() {
        int rowCount = 0;
        for (AttributeTablePanel tablePanel : this.layerToTablePanelMap.values()) {
            rowCount += tablePanel.getTable().getRowCount();
        }
        return rowCount;
    }

    public void flashSelectedFeatures() throws NoninvertibleTransformException {
        this.zoomToSelectedItemsPlugIn.flash(FeatureUtil.toGeometries(this.selectedFeatures()), this.taskFrame.getLayerViewPanel());
    }

    public void zoom(Collection features) throws NoninvertibleTransformException {
        this.zoomToSelectedItemsPlugIn.zoom(FeatureUtil.toGeometries(features), this.taskFrame.getLayerViewPanel());
    }

    public void pan(Collection features) throws NoninvertibleTransformException {
        this.panToSelectedItemsPlugIn.pan(FeatureUtil.toGeometries(features), this.taskFrame.getLayerViewPanel());
    }

    public Collection<Feature> selectedFeatures() {
        ArrayList<Feature> selectedFeatures = new ArrayList<Feature>();
        for (AttributeTablePanel tablePanel : this.layerToTablePanelMap.values()) {
            int[] selectedRows;
            if (tablePanel.getModel().getRowCount() == 0) continue;
            for (int j : selectedRows = tablePanel.getTable().getSelectedRows()) {
                selectedFeatures.add(tablePanel.getModel().getFeature(j));
            }
        }
        return selectedFeatures;
    }

    public void selectInLayerViewPanel() {
        this.taskFrame.getLayerViewPanel().getSelectionManager().clear();
        for (AttributeTablePanel tablePanel : this.layerToTablePanelMap.values()) {
            int[] selectedRows = tablePanel.getTable().getSelectedRows();
            ArrayList<Feature> selectedFeatures = new ArrayList<Feature>();
            for (int j : selectedRows) {
                selectedFeatures.add(tablePanel.getModel().getFeature(j));
            }
            this.taskFrame.getLayerViewPanel().getSelectionManager().getFeatureSelection().selectItems(tablePanel.getModel().getLayer(), selectedFeatures);
        }
    }

    public Row topSelectedRow() {
        for (AttributeTablePanel panel : this.layerToTablePanelMap.values()) {
            int selectedRow = panel.getTable().getSelectedRow();
            if (selectedRow == -1) continue;
            return new BasicRow(panel, selectedRow);
        }
        return this.nullRow;
    }

    public SelectionManager getSelectionManager() {
        return this.workbenchContext.getLayerViewPanel().getSelectionManager();
    }

    private class BasicRow
    implements Row {
        private AttributeTablePanel panel;
        private int index;

        public BasicRow(AttributeTablePanel panel, int index) {
            this.panel = panel;
            this.index = index;
        }

        @Override
        public boolean isFirstRow() {
            return this.panel.getModel().getLayer() == AttributePanel.this.getModel().getLayers().get(0) && this.index == 0;
        }

        @Override
        public boolean isLastRow() {
            return this.panel.getModel().getLayer() == AttributePanel.this.getModel().getLayers().get(AttributePanel.this.getModel().getLayers().size() - 1) && this.index == this.panel.getTable().getRowCount() - 1;
        }

        @Override
        public AttributeTablePanel getPanel() {
            return this.panel;
        }

        @Override
        public int getIndex() {
            return this.index;
        }

        @Override
        public Row previousRow() {
            if (this.isFirstRow()) {
                return this;
            }
            if (this.index > 0) {
                return new BasicRow(this.panel, this.index - 1);
            }
            return new BasicRow(this.previousPanel(), this.previousPanel().getTable().getRowCount() - 1);
        }

        @Override
        public Row nextRow() {
            if (this.isLastRow()) {
                return this;
            }
            if (this.index < this.panel.getTable().getRowCount() - 1) {
                return new BasicRow(this.panel, this.index + 1);
            }
            return new BasicRow(this.nextPanel(), 0);
        }

        private AttributeTablePanel previousPanel() {
            return AttributePanel.this.getTablePanel(this.previousLayer());
        }

        private AttributeTablePanel nextPanel() {
            return AttributePanel.this.getTablePanel(this.nextLayer());
        }

        private Layer previousLayer() {
            return AttributePanel.this.getModel().getLayers().get(AttributePanel.this.getModel().getLayers().indexOf(this.panel.getModel().getLayer()) - 1);
        }

        private Layer nextLayer() {
            return AttributePanel.this.getModel().getLayers().get(AttributePanel.this.getModel().getLayers().indexOf(this.panel.getModel().getLayer()) + 1);
        }

        @Override
        public Feature getFeature() {
            return this.panel.getModel().getFeature(this.index);
        }
    }

    public static interface Row {
        public boolean isFirstRow();

        public boolean isLastRow();

        public AttributeTablePanel getPanel();

        public int getIndex();

        public Row nextRow();

        public Row previousRow();

        public Feature getFeature();
    }
}

