/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.JUMPVersion;
import com.vividsolutions.jump.workbench.JUMPWorkbench;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.ui.ExtensionsAboutPanel;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import com.vividsolutions.jump.workbench.ui.SplashPanelV2;
import com.vividsolutions.jump.workbench.ui.WorkbenchFrame;
import com.vividsolutions.jump.workbench.ui.plugin.AboutPlugIn;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.text.DecimalFormat;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.input.BOMInputStream;

public class AboutDialog
extends JDialog {
    private static final String FILESEP = System.getProperty("file.separator");
    private static AboutDialog aboutDialog;
    JPanel buttonPanel = new JPanel();
    JButton okButton = new JButton();
    private JTabbedPane jTabbedPane1 = new JTabbedPane();
    private JPanel infoPanel = new JPanel();
    private JScrollPane aboutScroll;
    private JScrollPane extScroll;
    private JLabel lblJavaVersion = new JLabel();
    private JLabel lblOSVersion = new JLabel();
    private JLabel lblMaxMemory = new JLabel();
    private JLabel lblTotalMemory = new JLabel();
    private JLabel lblCommittedMemory = new JLabel();
    private JLabel lblUserDir = new JLabel();
    private JPanel pnlButtons = new JPanel();
    private JButton btnGC = new JButton();
    private JButton btnCopyCB = new JButton();
    private String userDir = System.getProperty("user.dir");
    private WorkbenchContext wbc;
    private ExtensionsAboutPanel extensionsAboutPanel;

    public static AboutDialog instance(WorkbenchContext context) {
        String INSTANCE_KEY = AboutDialog.class.getName() + " - INSTANCE";
        if (context.getWorkbench().getBlackboard().get(INSTANCE_KEY) == null) {
            aboutDialog = new AboutDialog(context.getWorkbench().getFrame());
            context.getWorkbench().getBlackboard().put(INSTANCE_KEY, aboutDialog);
        }
        aboutDialog = (AboutDialog)context.getWorkbench().getBlackboard().get(INSTANCE_KEY);
        return aboutDialog;
    }

    private AboutDialog(WorkbenchFrame frame) {
        super(frame, I18N.getInstance().get("ui.AboutDialog.about-jump"), true);
        try {
            this.setIconImage(AboutPlugIn.ICON.getImage());
        }
        catch (NoSuchMethodError noSuchMethodError) {
            // empty catch block
        }
        this.wbc = frame.getContext().getWorkbench().getContext();
        this.extensionsAboutPanel = new ExtensionsAboutPanel(frame.getContext().getWorkbench().getPlugInManager());
        try {
            this.jbInit();
            this.pack();
            this.setPreferredSize(new Dimension(this.getWidth(), frame.getHeight() - 200));
            GUIUtil.centreOnWindow(this);
            this.addComponentListener(new ResizeMe());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    void jbInit() throws Exception {
        String result;
        this.setLayout(new BorderLayout());
        JPanel aboutPanel = new JPanel(new GridBagLayout());
        ImageIcon splash = JUMPWorkbench.splashImage();
        SplashPanelV2 splashPanel = new SplashPanelV2(splash, I18N.getInstance().get("ui.AboutDialog.version") + " " + JUMPVersion.CURRENT_VERSION);
        aboutPanel.add((Component)splashPanel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 11, 0, new Insets(0, 0, 0, 0), 0, 0));
        String urlstring = "";
        try {
            File readmeFile = null;
            for (String candidatePath : new String[]{"Readme.txt", "target/res/Readme.txt", "etc/Readme.txt"}) {
                File candidateFile = new File(this.userDir, candidatePath);
                if (!candidateFile.exists()) continue;
                readmeFile = candidateFile;
                break;
            }
            if (readmeFile == null) {
                throw new FileNotFoundException("Readme.txt missing in OJ working dir.");
            }
            FileInputStream fis = new FileInputStream(readmeFile);
            BOMInputStream bis = new BOMInputStream((InputStream)fis);
            Charset cs = Charset.forName("UTF-8");
            if (bis.hasBOM()) {
                cs = Charset.forName(bis.getBOMCharsetName());
            }
            result = IOUtils.toString((InputStream)bis, (Charset)cs);
        }
        catch (Exception e) {
            StringBuffer buf = new StringBuffer();
            for (int i = 0; i < e.getStackTrace().length; ++i) {
                buf.append(e.getStackTrace()[i] + "\n");
            }
            result = e + "\n\n" + buf;
        }
        JTextArea readme = new JTextArea(result);
        readme.setFont(new Font("Monospaced", 0, 12));
        readme.setEditable(false);
        readme.setBorder(BorderFactory.createEmptyBorder(20, 20, 20, 20));
        JPanel readmeP = new JPanel();
        readmeP.add(readme);
        aboutPanel.add((Component)readmeP, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(20, 0, 5, 0), 0, 0));
        JPanel aboutP2 = new JPanel(new BorderLayout());
        aboutP2.add((Component)aboutPanel, "Center");
        this.aboutScroll = new JScrollPane(aboutP2);
        this.aboutScroll.setBorder(BorderFactory.createEmptyBorder());
        int min_h = splashPanel.getPreferredSize().height + 60;
        int pref_h = this.aboutScroll.getPreferredSize().height;
        pref_h = pref_h < min_h ? min_h : pref_h;
        this.aboutScroll.setMinimumSize(new Dimension(splash.getIconWidth() + 25, min_h));
        this.jTabbedPane1.addTab(I18N.getInstance().get("ui.AboutDialog.about"), this.aboutScroll);
        this.infoPanel.setLayout(new GridBagLayout());
        JLabel lbl_sysinfo = this.createLabel(I18N.getInstance().get("ui.AboutDialog.system-info"));
        lbl_sysinfo.setFont(lbl_sysinfo.getFont().deriveFont(3, 12.0f));
        lbl_sysinfo.setHorizontalAlignment(2);
        this.panelAdd(lbl_sysinfo, this.infoPanel, 0, 0, 10);
        JLabel lbl_java = this.createLabel(I18N.getInstance().get("ui.AboutDialog.java-version"));
        lbl_java.setFont(lbl_java.getFont().deriveFont(2));
        this.panelAdd(lbl_java, this.infoPanel, 1, 0, 17);
        JLabel lbl_os = this.createLabel(I18N.getInstance().get("ui.AboutDialog.os"));
        lbl_os.setFont(lbl_java.getFont());
        this.panelAdd(lbl_os, this.infoPanel, 1, 1, 17);
        JLabel lbl_memmax = this.createLabel(I18N.getInstance().get("ui.AboutDialog.maximum-memory"));
        lbl_memmax.setFont(lbl_java.getFont());
        this.panelAdd(lbl_memmax, this.infoPanel, 1, 2, 17);
        JLabel lbl_memtotal = this.createLabel(I18N.getInstance().get("ui.AboutDialog.total-memory"));
        lbl_memtotal.setFont(lbl_java.getFont());
        this.panelAdd(lbl_memtotal, this.infoPanel, 1, 3, 17);
        JLabel lbl_memcom = this.createLabel(I18N.getInstance().get("ui.AboutDialog.comitted-memory"));
        lbl_memcom.setFont(lbl_java.getFont());
        this.panelAdd(lbl_memcom, this.infoPanel, 1, 4, 17);
        this.panelAdd(Box.createRigidArea(new Dimension(10, 10)), this.infoPanel, 1, 6, 17);
        JLabel lbl_userdir = this.createLabel(I18N.getInstance().get("ui.AboutDialog.user-dir"));
        lbl_userdir.setFont(lbl_java.getFont());
        this.panelAdd(lbl_userdir, this.infoPanel, 1, 7, 17);
        this.panelAdd(Box.createRigidArea(new Dimension(10, 10)), this.infoPanel, 1, 8, 17);
        this.lblJavaVersion.setToolTipText("");
        this.lblJavaVersion.setText("x");
        this.panelAdd(this.lblJavaVersion, this.infoPanel, 2, 0, 17);
        this.lblOSVersion.setText("x");
        this.panelAdd(this.lblOSVersion, this.infoPanel, 2, 1, 17);
        this.lblMaxMemory.setText("x");
        this.panelAdd(this.lblMaxMemory, this.infoPanel, 2, 2, 17);
        this.lblTotalMemory.setText("x");
        this.panelAdd(this.lblTotalMemory, this.infoPanel, 2, 3, 17);
        this.lblCommittedMemory.setText("x");
        this.panelAdd(this.lblCommittedMemory, this.infoPanel, 2, 4, 17);
        this.lblUserDir.setText("x");
        this.panelAdd(this.lblUserDir, this.infoPanel, 2, 7, 17);
        this.btnGC.setText(I18N.getInstance().get("ui.AboutDialog.garbage-collect"));
        this.btnGC.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AboutDialog.this.btnGC_actionPerformed(e);
            }
        });
        this.btnCopyCB.setText(I18N.getInstance().get("ui.AboutDialog.copy-clipboard"));
        this.btnCopyCB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AboutDialog.this.btnCopyCB_actionPerformed(e);
            }
        });
        this.infoPanel.add((Component)this.pnlButtons, new GridBagConstraints(0, 9, 3, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.pnlButtons.add((Component)this.btnGC, null);
        this.pnlButtons.add((Component)this.btnCopyCB, null);
        this.jTabbedPane1.addTab(I18N.getInstance().get("ui.AboutDialog.info"), this.infoPanel);
        this.extScroll = new JScrollPane(this.extensionsAboutPanel);
        this.extScroll.setHorizontalScrollBarPolicy(31);
        this.extScroll.setBorder(BorderFactory.createEmptyBorder());
        this.jTabbedPane1.addTab(I18N.getInstance().get("ui.AboutDialog.Extensions"), this.extScroll);
        this.extScroll.addAncestorListener(new AncestorListener(){
            int h = 0;
            int v = 0;

            @Override
            public void ancestorRemoved(AncestorEvent event) {
                this.h = AboutDialog.this.extScroll.getHorizontalScrollBar().getValue();
                this.v = AboutDialog.this.extScroll.getVerticalScrollBar().getValue();
            }

            @Override
            public void ancestorMoved(AncestorEvent event) {
                this.h = AboutDialog.this.extScroll.getHorizontalScrollBar().getValue();
                this.v = AboutDialog.this.extScroll.getVerticalScrollBar().getValue();
            }

            @Override
            public void ancestorAdded(AncestorEvent event) {
                AboutDialog.this.extensionsAboutPanel.refresh();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        AboutDialog.this.extScroll.getHorizontalScrollBar().setValue(h);
                        AboutDialog.this.extScroll.getVerticalScrollBar().setValue(v);
                    }
                });
            }
        });
        this.add((Component)this.jTabbedPane1, "Center");
        this.okButton.setText(I18N.getInstance().get("ui.OKCancelPanel.ok"));
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AboutDialog.this.okButton_actionPerformed(e);
            }
        });
        this.getContentPane().add((Component)this.buttonPanel, "South");
        this.buttonPanel.add((Component)this.okButton, null);
        this.jTabbedPane1.setBounds(0, 0, 0, 0);
    }

    private void panelAdd(Component comp, JPanel panel, int cellx, int celly, int position) {
        panel.add(comp, new GridBagConstraints(cellx, celly, 1, 1, 0.0, 0.0, position, 1, new Insets(0, 10, 0, 10), 0, 0));
    }

    private JLabel createLabel(String text) {
        JLabel label = new JLabel(text);
        label.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        return label;
    }

    @Override
    public void setVisible(boolean b) {
        if (b) {
            DecimalFormat format = new DecimalFormat("###,###");
            this.lblJavaVersion.setText(System.getProperty("java.vm.name") + " " + System.getProperty("java.version") + " (" + System.getProperty("os.arch") + ")");
            this.lblOSVersion.setText(System.getProperty("os.name") + " (" + System.getProperty("os.version") + ")");
            long maxMem = Runtime.getRuntime().maxMemory();
            long totalMem = Runtime.getRuntime().totalMemory();
            long freeMem = Runtime.getRuntime().freeMemory();
            this.lblMaxMemory.setText(format.format(maxMem - 1L) + " bytes (" + AboutDialog.humanReadableByteCount(maxMem, false) + ")");
            this.lblTotalMemory.setText(format.format(totalMem) + " bytes (" + AboutDialog.humanReadableByteCount(totalMem, false) + ")");
            this.lblCommittedMemory.setText(format.format(totalMem - freeMem) + " bytes (" + AboutDialog.humanReadableByteCount(totalMem - freeMem, false) + ")");
            this.lblUserDir.setText(AboutDialog.formatDirNameForHtml(this.userDir, 40));
        }
        super.setVisible(b);
    }

    void okButton_actionPerformed(ActionEvent e) {
        this.setVisible(false);
    }

    void btnGC_actionPerformed(ActionEvent e) {
        Runtime.getRuntime().gc();
        this.setVisible(true);
    }

    void btnCopyCB_actionPerformed(ActionEvent e) {
        String info = I18N.getInstance().get("ui.AboutDialog.java-version") + (":\t" + this.lblJavaVersion.getText() + "\n") + I18N.getInstance().get("ui.AboutDialog.os") + (":\t" + this.lblOSVersion.getText() + "\n") + I18N.getInstance().get("ui.AboutDialog.maximum-memory") + (":\t" + this.lblMaxMemory.getText() + "\n") + I18N.getInstance().get("ui.AboutDialog.total-memory") + (":\t" + this.lblTotalMemory.getText() + "\n") + I18N.getInstance().get("ui.AboutDialog.comitted-memory") + (":\t" + this.lblCommittedMemory.getText() + "\n") + I18N.getInstance().get("ui.AboutDialog.user-dir") + (":\t" + System.getProperty("user.dir") + "\n\n");
        StringSelection selection = new StringSelection(info);
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        clipboard.setContents(selection, selection);
    }

    public static String formatDirNameForHtml(String dir, int maxLength) {
        String filesep_regex = FILESEP.replaceAll("\\\\", "\\\\\\\\");
        String[] path = dir.split(filesep_regex);
        StringBuilder multiline = new StringBuilder("<html><body>");
        StringBuilder line = new StringBuilder(path[0]);
        for (int i = 1; i < path.length; ++i) {
            if (line.length() + path[i].length() > maxLength) {
                multiline.append((CharSequence)line).append(FILESEP + "<br>");
                line = new StringBuilder(path[i]);
                continue;
            }
            line.append(FILESEP).append(path[i]);
        }
        multiline.append((CharSequence)line);
        return multiline.append("</body></html>").toString();
    }

    public static String humanReadableByteCount(long bytes, boolean si) {
        int unit;
        int n = unit = si ? 1000 : 1024;
        if (bytes < (long)unit) {
            return bytes + " B";
        }
        int exp = (int)(Math.log(bytes) / Math.log(unit));
        String pre = (si ? "kMGTPE" : "KMGTPE").charAt(exp - 1) + (si ? "" : "i");
        return String.format("%.1f %sB", (double)bytes / Math.pow(unit, exp), pre);
    }

    class ResizeMe
    extends ComponentAdapter {
        Dimension minSize;
        Rectangle bounds;
        int last_x;
        int last_y;
        int last_w;
        int last_h;
        boolean initialized;

        ResizeMe() {
            this.minSize = AboutDialog.this.getMinimumSize();
            this.bounds = AboutDialog.this.getBounds();
            this.last_x = AboutDialog.this.getX();
            this.last_y = AboutDialog.this.getY();
            this.last_w = AboutDialog.this.getWidth();
            this.last_h = AboutDialog.this.getHeight();
            this.initialized = false;
        }

        @Override
        public void componentResized(ComponentEvent evt) {
            int oldX = this.last_x;
            int oldY = this.last_y;
            int oldHeight = this.last_h;
            int oldWidth = AboutDialog.this.getMinimumSize().width;
            int newX = AboutDialog.this.getX();
            int newY = AboutDialog.this.getY();
            int newWidth = AboutDialog.this.getWidth();
            int newHeight = AboutDialog.this.getHeight();
            if (newHeight < this.minSize.height || AboutDialog.this.getWidth() != oldWidth) {
                int diff = this.minSize.height - newHeight;
                if (diff > 0 && newY != oldY) {
                    newY -= diff;
                }
                newX = newX < 0 ? 0 : (oldX > 0 ? oldX : newX);
                newY = newY < 0 ? 0 : newY;
                AboutDialog.this.setBounds(oldX, newY, oldWidth, newHeight += Math.max(0, diff));
            } else {
                newX = newX <= 0 ? 0 : newX;
                newY = newY <= 0 ? 0 : newY;
                AboutDialog.this.setLocation(newX, newY);
            }
            this.memorize();
        }

        @Override
        public void componentMoved(ComponentEvent evt) {
            if (AboutDialog.this.getWidth() != this.last_w) {
                AboutDialog.this.setLocation(this.last_x, AboutDialog.this.getY());
            }
            this.memorize();
        }

        private void resetScrollPositions(JScrollPane sp) {
            JScrollBar verticalScrollBar = sp.getVerticalScrollBar();
            JScrollBar horizontalScrollBar = sp.getHorizontalScrollBar();
            verticalScrollBar.setValue(verticalScrollBar.getMinimum());
            horizontalScrollBar.setValue(horizontalScrollBar.getMinimum());
        }

        @Override
        public void componentShown(ComponentEvent e) {
            this.resetScrollPositions(AboutDialog.this.aboutScroll);
            this.resetScrollPositions(AboutDialog.this.extScroll);
            if (this.initialized) {
                AboutDialog.this.setPreferredSize(new Dimension(this.last_w, AboutDialog.this.wbc.getWorkbench().getFrame().getHeight() - 200));
                AboutDialog.this.pack();
            } else {
                this.initialized = true;
            }
            this.memorize();
        }

        private void memorize() {
            this.last_x = AboutDialog.this.getX();
            this.last_y = AboutDialog.this.getY();
            this.last_w = AboutDialog.this.getWidth();
            this.last_h = AboutDialog.this.getHeight();
        }
    }
}

