/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.plugin;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.JUMPException;
import com.vividsolutions.jump.task.TaskMonitor;
import com.vividsolutions.jump.util.FileUtil;
import com.vividsolutions.jump.util.StringUtil;
import com.vividsolutions.jump.util.Timer;
import com.vividsolutions.jump.workbench.Logger;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.WorkbenchProperties;
import com.vividsolutions.jump.workbench.plugin.Configuration;
import com.vividsolutions.jump.workbench.plugin.Extension;
import com.vividsolutions.jump.workbench.plugin.PlugIn;
import com.vividsolutions.jump.workbench.plugin.PlugInClassLoader;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.cursortool.CursorTool;
import com.vividsolutions.jump.workbench.ui.cursortool.CursorToolPluginWrapper;
import com.vividsolutions.jump.workbench.ui.plugin.FeatureInstaller;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.locationtech.jts.util.Assert;

public class PlugInManager {
    private static final String NOT_INITIALIZED = "com.vividsolutions.jump.workbench.plugin.PlugInManager.could-not-be-initialized";
    private static final String LOADING = "com.vividsolutions.jump.workbench.plugin.PlugInManager.loading";
    private static final String LOADING_ERROR = "com.vividsolutions.jump.workbench.plugin.PlugInManager.throwable-encountered-loading";
    private TaskMonitor monitor;
    private WorkbenchContext context;
    private ArrayList<Configuration> configurations = new ArrayList();
    private List<File> extensionDirs = new ArrayList<File>();
    private boolean limitExtensionLookup = true;
    private PlugInClassLoader classLoader;
    static Pattern jarFilePattern = Pattern.compile(".*\\.(?i:jar|zip)$");
    static FileFilter jarOrFolderFilter = new FileFilter(){

        @Override
        public boolean accept(File f) {
            return jarFilePattern.matcher(f.getName()).matches() || f.isDirectory();
        }
    };
    static FileFilter extensionClassOrFolderFilter = new FileFilter(){

        @Override
        public boolean accept(File f) {
            return PlugInManager.isExtensionClassByName(f.getName()) || f.isDirectory();
        }
    };
    static Pattern extensionClassPattern = Pattern.compile("[^$]+(Extension|Configuration)\\.class");

    public PlugInManager(WorkbenchContext context, TaskMonitor monitor) throws Exception {
        this.monitor = monitor;
        try {
            this.classLoader = (PlugInClassLoader)ClassLoader.getSystemClassLoader();
        }
        catch (ClassCastException e) {
            JUMPException je = new JUMPException("Wrong classloader. Make sure to run JRE with property -Djava.system.class.loader=com.vividsolutions.jump.workbench.plugin.PlugInClassLoader set!", e);
            throw je;
        }
        this.context = context;
        this.configurations.addAll(this.findConfigurations(context.getWorkbench().getProperties().getConfigurationClassNames()));
    }

    public void setLimitExtensionLookup(boolean limitExtensionLookup) {
        this.limitExtensionLookup = limitExtensionLookup;
    }

    public void addExtensionsFolder(File dir) {
        if (this.extensionDirs.contains(dir)) {
            Logger.error("extensions-dir '" + dir + "' was already added before!");
            return;
        }
        if (!dir.exists()) {
            Logger.error("given extensions-dir '" + dir + "' does not exist!");
            return;
        }
        ArrayList<File> files = new ArrayList<File>();
        files.add(dir);
        files.addAll(this.findFilesRecursively(dir, jarOrFolderFilter, true));
        this.classLoader.addUrls(this.toURLs(files));
        I18N.reset();
        this.extensionDirs.add(dir);
        this.configurations.addAll(this.findConfigurations(dir));
    }

    public void addJarsFolder(File dir) {
        ArrayList<File> files = new ArrayList<File>();
        files.addAll(this.findFilesRecursively(dir, jarOrFolderFilter, true));
        this.classLoader.addUrls(this.toURLs(files));
        I18N.reset();
    }

    public File findFileOrFolderInExtensionDirs(String fileOrFolder) {
        for (File extDir : this.extensionDirs) {
            File candidate = new File(extDir, fileOrFolder);
            if (!candidate.exists()) continue;
            return candidate;
        }
        return null;
    }

    public void load() throws Exception {
        if (Logger.isDebugEnabled()) {
            Logger.debug("Pluginclassloader contains the folowing urls ->\n" + Arrays.asList(this.classLoader.getURLs()).stream().map(Object::toString).collect(Collectors.joining("\n")).toString());
        }
        this.loadPlugIns(this.context.getWorkbench().getProperties());
        if (Logger.isDebugEnabled()) {
            Logger.debug("The following extensions were found and are about to be loaded ->\n" + this.configurations.stream().map(Object::toString).collect(Collectors.joining("\n")).toString());
        }
        long start = Timer.milliSecondsSince(0L);
        this.loadConfigurations();
        Logger.info("Loading all OJ extensions took " + Timer.secondsSinceString(start) + "s");
        FeatureInstaller f = FeatureInstaller.getInstance(this.context);
        f.setSeparatingEnabled(true);
        f.updateSeparatorsInAllMenus();
    }

    private void loadConfigurations() {
        PlugInContext pc = this.context.createPlugInContext();
        for (Configuration configuration : this.configurations) {
            long start = Timer.milliSecondsSince(0L);
            try {
                this.monitor.report(I18N.getInstance().get(LOADING) + " " + PlugInManager.name(configuration) + " " + PlugInManager.version(configuration));
                configuration.configure(pc);
                Logger.info("Loading Config " + PlugInManager.name(configuration) + " " + PlugInManager.version(configuration) + " took " + Timer.secondsSinceString(start) + "s");
            }
            catch (Throwable e) {
                this.context.getErrorHandler().handleThrowable(e);
                this.context.getWorkbench().getFrame().log(configuration.getClass().getName() + " " + I18N.getInstance().get(NOT_INITIALIZED), this.getClass());
            }
        }
    }

    private void loadPlugIns(WorkbenchProperties props) {
        PlugInContext pc = this.context.createPlugInContext();
        Map pluginSettings = props.getSettings(new String[]{"plug-in"});
        for (String className : pluginSettings.keySet()) {
            String initSetting = (String)((Map)pluginSettings.get(className)).get("initialize");
            if (initSetting instanceof String && initSetting.equals("false")) continue;
            this.monitor.report(I18N.getInstance().get(LOADING) + " " + className);
            Class<?> plugInClass = null;
            try {
                long start = Timer.milliSecondsSince(0L);
                plugInClass = this.classLoader.loadClass(className);
                if (plugInClass == null) {
                    throw new JUMPException("class '" + className + "' is not available in the class path!");
                }
                Object o = plugInClass.newInstance();
                PlugIn plugIn = o instanceof CursorTool ? new CursorToolPluginWrapper((CursorTool)o) : (PlugIn)o;
                plugIn.initialize(pc);
                Map menuSettings = props.getSettings(new String[]{"plug-in", className, "menus"});
                for (Map.Entry entry : menuSettings.entrySet()) {
                    String menuKey = (String)entry.getKey();
                    if (pc.getFeatureInstaller().fetchMenuForKey(menuKey) == null) {
                        if (menuKey == "order_id") continue;
                        Logger.error("'" + menuKey + "' is an invalid menu handle.");
                        continue;
                    }
                    String installSetting = props.getSetting(new String[]{"plug-in", className, "menus", menuKey, "install"});
                    if (!installSetting.equals("true")) continue;
                    pc.getFeatureInstaller().addMenuPlugin(menuKey, plugIn);
                }
                pc.getFeatureInstaller().registerShortcuts(plugIn);
                this.context.getWorkbench().getFrame().log("Loading Plugin " + className + " took " + Timer.secondsSinceString(start) + "s ");
            }
            catch (Throwable e) {
                this.context.getErrorHandler().handleThrowable(e);
                this.context.getWorkbench().getFrame().log(className + " " + I18N.getInstance().get(NOT_INITIALIZED), this.getClass());
            }
        }
    }

    public static String name(Configuration configuration) {
        if (configuration instanceof Extension) {
            return ((Extension)configuration).getName();
        }
        return StringUtil.toFriendlyName(configuration.getClass().getName(), "Configuration") + " (" + configuration.getClass().getPackage().getName() + ")";
    }

    public static String version(Configuration configuration) {
        if (configuration instanceof Extension) {
            return ((Extension)configuration).getVersion();
        }
        return "";
    }

    public static String message(Configuration configuration) {
        if (configuration instanceof Extension) {
            return ((Extension)configuration).getMessage();
        }
        return "";
    }

    private Collection<Configuration> findConfigurations(List<String> classNames) {
        ArrayList<Configuration> configurations = new ArrayList<Configuration>();
        for (String name : classNames) {
            try {
                Class<?> clazz = Class.forName(name, false, this.classLoader);
                if (!Configuration.class.isAssignableFrom(clazz)) continue;
                Configuration configuration = (Configuration)clazz.newInstance();
                configurations.add(configuration);
            }
            catch (Throwable t) {
                this.context.getErrorHandler().handleThrowable(t);
            }
        }
        return configurations;
    }

    private static boolean isExtensionClassByName(String name) {
        return extensionClassPattern.matcher(name).matches();
    }

    private Collection<File> findFilesRecursively(File directory, FileFilter filter, boolean recursive) {
        ArrayList<File> filesFiltered = new ArrayList<File>();
        File[] files = directory.listFiles(filter);
        if (files == null) {
            files = new File[]{};
        }
        for (File file : files) {
            if (file.isDirectory() && recursive) {
                filesFiltered.addAll(this.findFilesRecursively(file, filter, recursive));
                continue;
            }
            if (!file.isFile()) continue;
            filesFiltered.add(file);
        }
        return filesFiltered;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection<Configuration> findConfigurations(File plugInDirectory) {
        ArrayList<Configuration> configurations = new ArrayList<Configuration>();
        long start = Timer.milliSecondsSince(0L);
        String folder = plugInDirectory.getPath();
        String msg = I18N.getInstance().get("com.vividsolutions.jump.workbench.plugin.PlugInManager.scan", folder);
        this.monitor.report(msg);
        Iterator<File> i = this.findFilesRecursively(plugInDirectory, extensionClassOrFolderFilter, true).iterator();
        while (!this.limitExtensionLookup && i.hasNext()) {
            File file = i.next();
            String relativePath = plugInDirectory.toURI().relativize(file.toURI()).getPath();
            Configuration c = this.toConfiguration(relativePath);
            if (c == null) continue;
            configurations.add(c);
        }
        for (File file : this.findFilesRecursively(plugInDirectory, jarOrFolderFilter, !this.limitExtensionLookup)) {
            ZipFile zipFile = null;
            try {
                zipFile = new ZipFile(file);
                Enumeration<? extends ZipEntry> e = zipFile.entries();
                while (e.hasMoreElements()) {
                    Configuration c;
                    ZipEntry entry = e.nextElement();
                    if (!PlugInManager.isExtensionClassByName(entry.getName()) || entry.isDirectory() || (c = this.toConfiguration(entry.getName())) == null) continue;
                    configurations.add(c);
                }
            }
            catch (IOException e) {
                try {
                    Logger.error("Configuration failed for " + file.getPath());
                    Logger.error(e);
                }
                catch (Throwable throwable) {
                    FileUtil.close(zipFile);
                    throw throwable;
                }
                FileUtil.close(zipFile);
                continue;
            }
            FileUtil.close(zipFile);
        }
        Logger.info("Scanning " + folder + " took " + Timer.secondsSinceString(start) + "s. Found " + configurations.size() + " configurations.");
        return configurations;
    }

    private URL[] toURLs(Collection<File> files) {
        URL[] urls = new URL[files.size()];
        int i = 0;
        for (File file : files) {
            try {
                urls[i++] = file.toURI().toURL();
            }
            catch (MalformedURLException e) {
                Assert.shouldNeverReachHere((String)e.toString());
            }
        }
        return urls;
    }

    private Configuration toConfiguration(String fileName) {
        String className = this.toClassName(fileName);
        try {
            Class<?> candidate = Class.forName(className, false, this.classLoader);
            if (Configuration.class.isAssignableFrom(candidate)) {
                return (Configuration)candidate.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("This should never happen. Check classpath!", e);
        }
        catch (Throwable t) {
            throw new RuntimeException(I18N.getInstance().get(LOADING_ERROR) + " " + className, t);
        }
        return null;
    }

    private String toClassName(String className) {
        className = className.substring(0, className.length() - ".class".length());
        className = StringUtil.replaceAll(className, "/", ".");
        return className;
    }

    public Collection<Configuration> getConfigurations() {
        return Collections.unmodifiableCollection(this.configurations);
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public PlugInClassLoader getPlugInClassLoader() {
        return this.classLoader;
    }

    public List<File> getExtensionDirs() {
        return Collections.unmodifiableList(this.extensionDirs);
    }

    @Deprecated
    public File getPlugInDirectory() {
        return this.extensionDirs.isEmpty() ? null : new File(this.extensionDirs.get(0).toURI());
    }
}

