/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.model;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.feature.AttributeType;
import com.vividsolutions.jump.feature.BasicFeature;
import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.feature.FeatureSchema;
import com.vividsolutions.jump.util.Blackboard;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.FeatureEvent;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.model.LayerAdapter;
import com.vividsolutions.jump.workbench.model.LayerManagerProxy;
import com.vividsolutions.jump.workbench.model.SystemLayerFinder;
import com.vividsolutions.jump.workbench.ui.plugin.PersistentBlackboardPlugIn;
import com.vividsolutions.jump.workbench.ui.renderer.style.BasicStyle;
import java.awt.Color;
import java.awt.Font;
import java.util.Collection;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.Polygon;
import org.openjump.core.ui.plugin.tools.AdvancedMeasureOptionsPanel;
import org.openjump.core.ui.plugin.tools.MeasurementStyle;

public class MeasureLayerFinder
extends SystemLayerFinder {
    public static final String FEATURE_ATTRIBUTE_AREA = "area";
    public static final String FEATURE_ATTRIBUTE_LENGTH = "length";
    private static final String FEATURE_ATTRIBUTE_POINTS = "points";
    public static final String LAYER_NAME = I18N.getInstance().get("model.MeasureLayerFinder.measure");
    private static Layer measureLayer = null;
    private WorkbenchContext context = null;

    public MeasureLayerFinder(LayerManagerProxy layerManagerProxy, WorkbenchContext context) {
        super(LAYER_NAME, layerManagerProxy);
        this.context = context;
    }

    @Override
    protected void applyStyles(Layer layer) {
        Object string;
        Blackboard blackboard = PersistentBlackboardPlugIn.get(this.context);
        BasicStyle basicStyle = layer.getBasicStyle();
        Object color = blackboard.get(AdvancedMeasureOptionsPanel.BB_LINE_COLOR, AdvancedMeasureOptionsPanel.DEFAULT_LINE_COLOR);
        if (color instanceof Color) {
            basicStyle.setLineColor((Color)color);
        }
        basicStyle.setAlpha(100);
        basicStyle.setLineWidth(2);
        basicStyle.setRenderingLine(blackboard.get(AdvancedMeasureOptionsPanel.BB_LINE_PAINT, true));
        color = blackboard.get(AdvancedMeasureOptionsPanel.BB_FILL_COLOR, AdvancedMeasureOptionsPanel.DEFAULT_FILL_COLOR);
        if (color instanceof Color) {
            basicStyle.setFillColor((Color)color);
        }
        basicStyle.setRenderingFill(blackboard.get(AdvancedMeasureOptionsPanel.BB_FILL_PAINT, true));
        layer.setDrawingLast(true);
        MeasurementStyle measurementStyle = new MeasurementStyle();
        measurementStyle.setEnabled(true);
        measurementStyle.setPaintSummaryLength(blackboard.get(AdvancedMeasureOptionsPanel.BB_SUMMARY_PAINT_LENGTH, true));
        measurementStyle.setPaintSummaryArea(blackboard.get(AdvancedMeasureOptionsPanel.BB_SUMMARY_PAINT_AREA, true));
        Object font = blackboard.get(AdvancedMeasureOptionsPanel.BB_SUMMARY_FONT, AdvancedMeasureOptionsPanel.DEFAULT_SUMMARY_FONT);
        if (font instanceof Font) {
            measurementStyle.setSummaryFont((Font)font);
        }
        if ((color = blackboard.get(AdvancedMeasureOptionsPanel.BB_SUMMARY_FONT_COLOR, AdvancedMeasureOptionsPanel.DEFAULT_SUMMARY_COLOR)) instanceof Color) {
            measurementStyle.setSummaryColor((Color)color);
        }
        measurementStyle.setVertexPaintDistance(blackboard.get(AdvancedMeasureOptionsPanel.BB_VERTEX_PAINT_DISTANCE, true));
        measurementStyle.setVertexPaintDistanceRelative(blackboard.get(AdvancedMeasureOptionsPanel.BB_VERTEX_PAINT_DISTANCE_RELATIVE, false));
        font = blackboard.get(AdvancedMeasureOptionsPanel.BB_VERTEX_FONT, AdvancedMeasureOptionsPanel.DEFAULT_VERTEX_FONT);
        if (font instanceof Font) {
            measurementStyle.setVertexFont((Font)font);
        }
        if ((color = blackboard.get(AdvancedMeasureOptionsPanel.BB_VERTEX_FONT_COLOR, AdvancedMeasureOptionsPanel.DEFAULT_VERTEX_FONT_COLOR)) instanceof Color) {
            measurementStyle.setVertexFontColor((Color)color);
        }
        measurementStyle.setVertexPaint(blackboard.get(AdvancedMeasureOptionsPanel.BB_VERTEX_PAINT, true));
        color = blackboard.get(AdvancedMeasureOptionsPanel.BB_VERTEX_FIRST_COLOR, AdvancedMeasureOptionsPanel.DEFAULT_VERTEX_FIRST_COLOR);
        if (color instanceof Color) {
            measurementStyle.setVertexFirstColor((Color)color);
        }
        if ((string = blackboard.get(AdvancedMeasureOptionsPanel.BB_VERTEX_FIRST_FORM, "SQUARE")) instanceof String) {
            measurementStyle.setVertexFirstForm((String)string);
        }
        measurementStyle.setVertexFirstSize(blackboard.get(AdvancedMeasureOptionsPanel.BB_VERTEX_FIRST_SIZE, 10));
        color = blackboard.get(AdvancedMeasureOptionsPanel.BB_VERTEX_FOLLOWING_COLOR, AdvancedMeasureOptionsPanel.DEFAULT_VERTEX_FOLLOWING_COLOR);
        if (color instanceof Color) {
            measurementStyle.setVertexFollowingColor((Color)color);
        }
        if ((string = blackboard.get(AdvancedMeasureOptionsPanel.BB_VERTEX_FOLLOWING_FORM, "SQUARE")) instanceof String) {
            measurementStyle.setVertexFollowingForm((String)string);
        }
        measurementStyle.setVertexFollowingSize(blackboard.get(AdvancedMeasureOptionsPanel.BB_VERTEX_FOLLOWING_SIZE, 5));
        layer.addStyle(measurementStyle);
    }

    private Feature toFeature(Geometry measureGeometry, FeatureSchema schema) {
        BasicFeature feature = new BasicFeature(schema);
        feature.setGeometry(measureGeometry);
        feature.setAttribute(FEATURE_ATTRIBUTE_LENGTH, (Object)measureGeometry.getLength());
        feature.setAttribute(FEATURE_ATTRIBUTE_AREA, (Object)(measureGeometry instanceof Polygon ? measureGeometry.getArea() : 0.0));
        feature.setAttribute(FEATURE_ATTRIBUTE_POINTS, (Object)measureGeometry.getNumPoints());
        return feature;
    }

    public void setMeasure(Geometry measureGeometry) {
        if (this.getLayer() == null) {
            this.initLayer();
        }
        if (measureGeometry != null) {
            this.getLayer().getFeatureCollectionWrapper().add(this.toFeature(measureGeometry, this.getLayer().getFeatureCollectionWrapper().getFeatureSchema()));
        }
    }

    public Layer getMeasureLayer() {
        if (this.getLayer() == null) {
            this.initLayer();
        }
        return measureLayer;
    }

    private void initLayer() {
        measureLayer = this.createLayer();
        measureLayer.setSelectable(false);
        measureLayer.getLayerManager().addLayerListener(new LayerAdapter(){

            @Override
            public void featuresChanged(FeatureEvent e) {
                super.featuresChanged(e);
                if (e.getLayer().equals(measureLayer)) {
                    Collection<Feature> features = e.getFeatures();
                    for (Feature feature : features) {
                        feature.setAttribute(MeasureLayerFinder.FEATURE_ATTRIBUTE_LENGTH, (Object)feature.getGeometry().getLength());
                        feature.setAttribute(MeasureLayerFinder.FEATURE_ATTRIBUTE_AREA, (Object)(feature.getGeometry() instanceof Polygon ? feature.getGeometry().getArea() : 0.0));
                        feature.setAttribute(MeasureLayerFinder.FEATURE_ATTRIBUTE_POINTS, (Object)feature.getGeometry().getNumPoints());
                    }
                }
            }
        });
        measureLayer.getFeatureCollectionWrapper().getFeatureSchema().addAttribute(FEATURE_ATTRIBUTE_AREA, AttributeType.DOUBLE);
        measureLayer.getFeatureCollectionWrapper().getFeatureSchema().addAttribute(FEATURE_ATTRIBUTE_LENGTH, AttributeType.DOUBLE);
        measureLayer.getFeatureCollectionWrapper().getFeatureSchema().addAttribute(FEATURE_ATTRIBUTE_POINTS, AttributeType.INTEGER);
    }
}

