/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.imagery.graphic;

import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.imagery.ReferencedImage;
import com.vividsolutions.jump.workbench.imagery.ReferencedImageFactory;
import com.vividsolutions.jump.workbench.model.Prioritized;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;

public abstract class AbstractGraphicImageFactory
implements ReferencedImageFactory,
Prioritized {
    protected HashSet extensions = new HashSet();

    @Override
    public abstract String getTypeName();

    @Override
    public String getDescription() {
        return "Buffered Image (" + this.getTypeName() + ")";
    }

    @Override
    public abstract ReferencedImage createImage(String var1) throws Exception;

    @Override
    public String[] getExtensions() {
        return this.extensions.toArray(new String[0]);
    }

    @Override
    public boolean isEditableImage(String location) {
        return true;
    }

    @Override
    public abstract boolean isAvailable(WorkbenchContext var1);

    protected void addExtension(String ext) {
        if (ext == null || ext.equals("")) {
            return;
        }
        if ((ext = ext.toLowerCase()).matches("x?tiff?")) {
            this.extensions.addAll(Arrays.asList("tiff", "tif"));
        } else if (ext.matches("jpe?g?")) {
            this.extensions.addAll(Arrays.asList("jpeg", "jpg"));
        } else if (ext.matches("jb(?:ig)2")) {
            this.extensions.addAll(Arrays.asList("jbig2", "jb2"));
        } else if (ext.matches("rgbe")) {
            this.extensions.addAll(Arrays.asList(ext, "hdr"));
        } else if (!ext.matches("\\*")) {
            this.extensions.add(ext);
        }
    }

    protected void addExtensions(Collection<String> exts) {
        for (String ext : exts) {
            this.addExtension(ext);
        }
    }

    @Override
    public int getPriority() {
        return Integer.MAX_VALUE;
    }
}

